Utilities
=========

----------------------------

All the utilities are located in the `bin` subdirectory.

- [**Elements**](elements/) - A [sample utility program](elements/)
  using the Element API of the Rexx Parser to analyze a program
  and display its list of constituting elements.
- [**Elident**](elident/) - [A small self-consistency tool](elident/) that checks
  that a program is identical to the concatenation of the values
  of its parsed element chain.
- [**ERexx**](erexx/) - The [Experimental Rexx compiler](erexx/)
  compiles programs written in Rexx enhanced with
  [Experimental features](../experimental/), translates them to standard
  ooRexx, and executes them.
- [**Highlight**](highlight/) - A [sample utility program](highlight/)
  that displays a highlighted program.
- [**Identtest**](identtest/) - [A self-consistency tool](identtest/) designed to
  run a series of self-consistency checks against the Rexx Parser source
  tree, it also allows to check that [Executor](../executor/) features work as intended,
  and to test against the ooRexx test tree.
- [**md2html**](md2html/) - A batch [utility program](md2html/)
  to transform a set of Markdown files to HTML.
- [**RxCheck**](rxcheck/) - A [utility program](rxcheck/)
  that runs the parser with a selectable number of
  early check options enabled.
- [**Trident**](trident/) - [A small self-consistency tool](trident/) that checks
  that a program is identical its own parse tree.

