/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.common;

import java.util.Random;
import java.util.stream.IntStream;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;

public class Util {
    public static Image createGrayNoise(double WIDTH, double HEIGHT, Color COLOR, int VARIATION) {
        int red = (int)(255.0 * COLOR.getRed());
        int green = (int)(255.0 * COLOR.getRed());
        int blue = (int)(255.0 * COLOR.getRed());
        int variation = Util.clamp(0, 255, VARIATION) / 2;
        Color darkColor = Color.rgb((int)Util.clamp(0, 255, red - variation), (int)Util.clamp(0, 255, green - variation), (int)Util.clamp(0, 255, blue - variation));
        Color brightColor = Color.rgb((int)Util.clamp(0, 255, red + variation), (int)Util.clamp(0, 255, green + variation), (int)Util.clamp(0, 255, blue + variation));
        return Util.createGrayNoise(WIDTH, HEIGHT, darkColor, brightColor);
    }

    public static Image createGrayNoise(double WIDTH, double HEIGHT, Color DARK_COLOR, Color BRIGHT_COLOR) {
        if (WIDTH <= 0.0 || HEIGHT <= 0.0) {
            return null;
        }
        WritableImage IMAGE = new WritableImage((int)WIDTH, (int)HEIGHT);
        PixelWriter PIXEL_WRITER = IMAGE.getPixelWriter();
        Random RND = new Random();
        double redDark = DARK_COLOR.getRed();
        double greenDark = DARK_COLOR.getGreen();
        double blueDark = DARK_COLOR.getBlue();
        double redBright = DARK_COLOR.getRed();
        double greenBright = DARK_COLOR.getGreen();
        double blueBright = DARK_COLOR.getBlue();
        int startRed = (int)(Math.min(redDark, redBright) * 255.0);
        int startGreen = (int)(Math.min(greenDark, greenBright) * 255.0);
        int startBlue = (int)(Math.min(blueDark, blueBright) * 255.0);
        int start = Math.max(Math.max(startRed, startGreen), startBlue);
        int deltaRed = Math.abs((int)((BRIGHT_COLOR.getRed() - DARK_COLOR.getRed()) * 255.0));
        int deltaGreen = Math.abs((int)((BRIGHT_COLOR.getGreen() - DARK_COLOR.getGreen()) * 255.0));
        int deltaBlue = Math.abs((int)((BRIGHT_COLOR.getBlue() - DARK_COLOR.getBlue()) * 255.0));
        int delta = Math.max(Math.max(deltaRed, deltaGreen), deltaBlue);
        int width = (int)WIDTH;
        int height = (int)HEIGHT;
        IntStream.range(0, height).parallel().forEach(y -> IntStream.range(0, width).parallel().forEach(x -> {
            int gray = delta > 0 ? start + RND.nextInt(delta) : start;
            PIXEL_WRITER.setColor(x, y, Color.rgb((int)Util.clamp(0, 255, gray), (int)Util.clamp(0, 255, gray), (int)Util.clamp(0, 255, gray)));
        }));
        return IMAGE;
    }

    public static String colorToCss(Color COLOR) {
        return null == COLOR ? "#000000" : COLOR.toString().replace("0x", "#");
    }

    public static int clamp(int MIN, int MAX, int VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    public static long clamp(long MIN, long MAX, long VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    public static float clamp(float MIN, float MAX, float VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    public static double clamp(double MIN, double MAX, double VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }
}

