/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge;

import eu.hansolo.enzo.common.Marker;
import eu.hansolo.enzo.common.Section;
import eu.hansolo.enzo.gauge.skin.GaugeSkin;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.IntStream;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.event.EventHandler;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.util.Duration;

public class Gauge
extends Control {
    public static final String STYLE_CLASS_NEEDLE_STANDARD = NeedleType.STANDARD.STYLE_CLASS;
    private static final Color DEFAULT_SECTION_FILL_0 = Color.rgb((int)0, (int)0, (int)178, (double)0.5);
    private static final Color DEFAULT_SECTION_FILL_1 = Color.rgb((int)0, (int)128, (int)255, (double)0.5);
    private static final Color DEFAULT_SECTION_FILL_2 = Color.rgb((int)0, (int)255, (int)255, (double)0.5);
    private static final Color DEFAULT_SECTION_FILL_3 = Color.rgb((int)0, (int)255, (int)64, (double)0.5);
    private static final Color DEFAULT_SECTION_FILL_4 = Color.rgb((int)128, (int)255, (int)0, (double)0.5);
    private static final Color DEFAULT_SECTION_FILL_5 = Color.rgb((int)255, (int)255, (int)0, (double)0.5);
    private static final Color DEFAULT_SECTION_FILL_6 = Color.rgb((int)255, (int)191, (int)0, (double)0.5);
    private static final Color DEFAULT_SECTION_FILL_7 = Color.rgb((int)255, (int)128, (int)0, (double)0.5);
    private static final Color DEFAULT_SECTION_FILL_8 = Color.rgb((int)255, (int)64, (int)0, (double)0.5);
    private static final Color DEFAULT_SECTION_FILL_9 = Color.rgb((int)255, (int)0, (int)0, (double)0.5);
    private static final Color DEFAULT_HISTOGRAM_FILL = Color.rgb((int)0, (int)200, (int)0, (double)0.3);
    private static final Color DEFAULT_AREA_FILL_0 = Color.rgb((int)0, (int)0, (int)178, (double)0.5);
    private static final Color DEFAULT_AREA_FILL_1 = Color.rgb((int)0, (int)128, (int)255, (double)0.5);
    private static final Color DEFAULT_AREA_FILL_2 = Color.rgb((int)0, (int)255, (int)255, (double)0.5);
    private static final Color DEFAULT_AREA_FILL_3 = Color.rgb((int)0, (int)255, (int)64, (double)0.5);
    private static final Color DEFAULT_AREA_FILL_4 = Color.rgb((int)128, (int)255, (int)0, (double)0.5);
    private static final Color DEFAULT_AREA_FILL_5 = Color.rgb((int)255, (int)255, (int)0, (double)0.5);
    private static final Color DEFAULT_AREA_FILL_6 = Color.rgb((int)255, (int)191, (int)0, (double)0.5);
    private static final Color DEFAULT_AREA_FILL_7 = Color.rgb((int)255, (int)128, (int)0, (double)0.5);
    private static final Color DEFAULT_AREA_FILL_8 = Color.rgb((int)255, (int)64, (int)0, (double)0.5);
    private static final Color DEFAULT_AREA_FILL_9 = Color.rgb((int)255, (int)0, (int)0, (double)0.5);
    private static final Color DEFAULT_MARKER_FILL_0 = Color.rgb((int)0, (int)200, (int)0, (double)0.5);
    private static final Color DEFAULT_MARKER_FILL_1 = Color.rgb((int)200, (int)200, (int)0, (double)0.5);
    private static final Color DEFAULT_MARKER_FILL_2 = Color.rgb((int)200, (int)0, (int)0, (double)0.5);
    private static final Color DEFAULT_MARKER_FILL_3 = Color.rgb((int)0, (int)0, (int)200, (double)0.5);
    private static final Color DEFAULT_MARKER_FILL_4 = Color.rgb((int)0, (int)200, (int)200, (double)0.5);
    private static final PseudoClass INTERACTIVE_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"interactive");
    private BooleanProperty interactive;
    private DoubleProperty value;
    private DoubleProperty minValue;
    private double exactMinValue;
    private DoubleProperty maxValue;
    private double exactMaxValue;
    private double _threshold;
    private DoubleProperty threshold;
    private boolean _thresholdVisible;
    private BooleanProperty thresholdVisible;
    private double _minMeasuredValue;
    private DoubleProperty minMeasuredValue;
    private boolean _minMeasuredValueVisible;
    private BooleanProperty minMeasuredValueVisible;
    private double _maxMeasuredValue;
    private DoubleProperty maxMeasuredValue;
    private boolean _maxMeasuredValueVisible;
    private BooleanProperty maxMeasuredValueVisible;
    private int _decimals;
    private IntegerProperty decimals;
    private String _title;
    private StringProperty title;
    private String _unit;
    private StringProperty unit;
    private boolean _animated;
    private BooleanProperty animated;
    private double animationDuration;
    private double _startAngle;
    private DoubleProperty startAngle;
    private double _angleRange;
    private DoubleProperty angleRange;
    private boolean _clockwise;
    private BooleanProperty clockwise;
    private boolean _autoScale;
    private BooleanProperty autoScale;
    private NeedleType _needleType;
    private ObjectProperty<NeedleType> needleType;
    private Color _needleColor;
    private ObjectProperty<Color> needleColor;
    private TickLabelOrientation _tickLabelOrientation;
    private ObjectProperty<TickLabelOrientation> tickLabelOrientation;
    private NumberFormat _numberFormat;
    private ObjectProperty<NumberFormat> numberFormat;
    private ObservableList<Section> sections;
    private boolean _sectionsVisible;
    private BooleanProperty sectionsVisible;
    private ObservableList<Section> areas;
    private boolean _areasVisible;
    private BooleanProperty areasVisible;
    private ObservableMap<Marker, Rotate> markers;
    private boolean _markersVisible;
    private BooleanProperty markersVisible;
    private double _majorTickSpace;
    private DoubleProperty majorTickSpace;
    private double _minorTickSpace;
    private DoubleProperty minorTickSpace;
    private boolean _plainValue;
    private BooleanProperty plainValue;
    private boolean _histogramEnabled;
    private BooleanProperty histogramEnabled;
    private boolean _dropShadowEnabled;
    private BooleanProperty dropShadowEnabled;
    private ObjectProperty<Limit> limit;
    private ObjectProperty<EventHandler<MouseEvent>> customKnobClickHandler;
    private ObjectProperty<Paint> tickMarkFill;
    private ObjectProperty<Paint> tickLabelFill;
    private ObjectProperty<Paint> sectionFill0;
    private ObjectProperty<Paint> sectionFill1;
    private ObjectProperty<Paint> sectionFill2;
    private ObjectProperty<Paint> sectionFill3;
    private ObjectProperty<Paint> sectionFill4;
    private ObjectProperty<Paint> sectionFill5;
    private ObjectProperty<Paint> sectionFill6;
    private ObjectProperty<Paint> sectionFill7;
    private ObjectProperty<Paint> sectionFill8;
    private ObjectProperty<Paint> sectionFill9;
    private ObjectProperty<Paint> histogramFill;
    private ObjectProperty<Paint> areaFill0;
    private ObjectProperty<Paint> areaFill1;
    private ObjectProperty<Paint> areaFill2;
    private ObjectProperty<Paint> areaFill3;
    private ObjectProperty<Paint> areaFill4;
    private ObjectProperty<Paint> areaFill5;
    private ObjectProperty<Paint> areaFill6;
    private ObjectProperty<Paint> areaFill7;
    private ObjectProperty<Paint> areaFill8;
    private ObjectProperty<Paint> areaFill9;
    private ObjectProperty<Paint> markerFill0;
    private ObjectProperty<Paint> markerFill1;
    private ObjectProperty<Paint> markerFill2;
    private ObjectProperty<Paint> markerFill3;
    private ObjectProperty<Paint> markerFill4;

    public Gauge() {
        this.getStyleClass().add((Object)"gauge");
        this.minValue = new DoublePropertyBase(0.0){

            public void set(double VALUE) {
                super.set(Gauge.this.clamp(-1.7976931348623157E308, Gauge.this.maxValue.get(), VALUE));
                if (Gauge.this.value.get() < VALUE) {
                    Gauge.this.value.set(VALUE);
                }
            }

            public Object getBean() {
                return Gauge.this;
            }

            public String getName() {
                return "minValue";
            }
        };
        this.maxValue = new DoublePropertyBase(100.0){

            public void set(double VALUE) {
                super.set(Gauge.this.clamp(Gauge.this.minValue.get(), Double.MAX_VALUE, VALUE));
                if (Gauge.this.value.get() > VALUE) {
                    Gauge.this.value.set(VALUE);
                }
            }

            public Object getBean() {
                return Gauge.this;
            }

            public String getName() {
                return "maxValue";
            }
        };
        this.value = new DoublePropertyBase(this.minValue.get()){

            public void set(double VALUE) {
                Gauge.this.limit.set((Object)(VALUE < Gauge.this.minValue.get() ? Limit.UNDERRUN : (VALUE > Gauge.this.maxValue.get() ? Limit.EXCEEDED : Limit.IN_RANGE)));
                super.set(Gauge.this.clamp(Gauge.this.minValue.get(), Gauge.this.maxValue.get(), VALUE));
            }

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "value";
            }
        };
        this._threshold = 50.0;
        this._thresholdVisible = false;
        this._minMeasuredValue = 100.0;
        this._minMeasuredValueVisible = false;
        this._maxMeasuredValue = 0.0;
        this._maxMeasuredValueVisible = false;
        this._decimals = 1;
        this._title = "";
        this._unit = "";
        this._animated = true;
        this._startAngle = 320.0;
        this._angleRange = 280.0;
        this._clockwise = true;
        this._autoScale = false;
        this._needleType = NeedleType.STANDARD;
        this._needleColor = Color.RED;
        this._tickLabelOrientation = TickLabelOrientation.HORIZONTAL;
        this._numberFormat = NumberFormat.STANDARD;
        this.sections = FXCollections.observableArrayList();
        this._sectionsVisible = true;
        this.areas = FXCollections.observableArrayList();
        this._areasVisible = true;
        this.markers = FXCollections.observableHashMap();
        this._markersVisible = true;
        this._majorTickSpace = 10.0;
        this._minorTickSpace = 1.0;
        this.animationDuration = 800.0;
        this._plainValue = true;
        this._histogramEnabled = false;
        this._dropShadowEnabled = true;
        this.limit = new SimpleObjectProperty((Object)this, "limit", (Object)Limit.IN_RANGE);
        this.customKnobClickHandler = new SimpleObjectProperty((Object)this, "customKnobClickHandler", null);
        this.registerListeners();
    }

    private void registerListeners() {
        this.sections.addListener(c -> IntStream.range(0, this.sections.size()).parallel().forEachOrdered(i -> {
            Section section = (Section)this.sections.get(i);
            switch (i) {
                case 0: {
                    this.setSectionFill0((Paint)section.getColor());
                    break;
                }
                case 1: {
                    this.setSectionFill1((Paint)section.getColor());
                    break;
                }
                case 2: {
                    this.setSectionFill2((Paint)section.getColor());
                    break;
                }
                case 3: {
                    this.setSectionFill3((Paint)section.getColor());
                    break;
                }
                case 4: {
                    this.setSectionFill4((Paint)section.getColor());
                    break;
                }
                case 5: {
                    this.setSectionFill5((Paint)section.getColor());
                    break;
                }
                case 6: {
                    this.setSectionFill6((Paint)section.getColor());
                    break;
                }
                case 7: {
                    this.setSectionFill7((Paint)section.getColor());
                    break;
                }
                case 8: {
                    this.setSectionFill8((Paint)section.getColor());
                    break;
                }
                case 9: {
                    this.setSectionFill9((Paint)section.getColor());
                }
            }
        }));
        this.areas.addListener(c -> IntStream.range(0, this.areas.size()).parallel().forEachOrdered(i -> {
            Section area = (Section)this.areas.get(i);
            switch (i) {
                case 0: {
                    this.setAreaFill0((Paint)area.getColor());
                    break;
                }
                case 1: {
                    this.setAreaFill1((Paint)area.getColor());
                    break;
                }
                case 2: {
                    this.setAreaFill2((Paint)area.getColor());
                    break;
                }
                case 3: {
                    this.setAreaFill3((Paint)area.getColor());
                    break;
                }
                case 4: {
                    this.setAreaFill4((Paint)area.getColor());
                    break;
                }
                case 5: {
                    this.setAreaFill4((Paint)area.getColor());
                    break;
                }
                case 6: {
                    this.setAreaFill4((Paint)area.getColor());
                    break;
                }
                case 7: {
                    this.setAreaFill4((Paint)area.getColor());
                    break;
                }
                case 8: {
                    this.setAreaFill4((Paint)area.getColor());
                    break;
                }
                case 9: {
                    this.setAreaFill4((Paint)area.getColor());
                }
            }
        }));
    }

    public final double getValue() {
        return this.value.get();
    }

    public final void setValue(double VALUE) {
        if (this.isInteractive()) {
            return;
        }
        this.value.set(VALUE);
    }

    public final DoubleProperty valueProperty() {
        return this.value;
    }

    public final double getMinValue() {
        return this.minValue.get();
    }

    public final void setMinValue(double MIN_VALUE) {
        this.minValue.set(MIN_VALUE);
    }

    public final DoubleProperty minValueProperty() {
        return this.minValue;
    }

    public final double getMaxValue() {
        return this.maxValue.get();
    }

    public final void setMaxValue(double MAX_VALUE) {
        this.maxValue.set(MAX_VALUE);
    }

    public final DoubleProperty maxValueProperty() {
        return this.maxValue;
    }

    public final double getThreshold() {
        return null == this.threshold ? this._threshold : this.threshold.get();
    }

    public final void setThreshold(double THRESHOLD) {
        if (null == this.threshold) {
            this._threshold = this.clamp(this.getMinValue(), this.getMaxValue(), THRESHOLD);
        } else {
            this.threshold.set(THRESHOLD);
        }
    }

    public final DoubleProperty thresholdProperty() {
        if (null == this.threshold) {
            this.threshold = new DoublePropertyBase(this._threshold){

                public void set(double THRESHOLD) {
                    super.set(Gauge.this.clamp(Gauge.this.getMinValue(), Gauge.this.getMaxValue(), this.get()));
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "threshold";
                }
            };
        }
        return this.threshold;
    }

    public final double getMinMeasuredValue() {
        return null == this.minMeasuredValue ? this._minMeasuredValue : this.minMeasuredValue.get();
    }

    public final void setMinMeasuredValue(double MIN_MEASURED_VALUE) {
        if (null == this.minMeasuredValue) {
            this._minMeasuredValue = MIN_MEASURED_VALUE;
        } else {
            this.minMeasuredValue.set(MIN_MEASURED_VALUE);
        }
    }

    public final ReadOnlyDoubleProperty minMeasuredValueProperty() {
        if (null == this.minMeasuredValue) {
            this.minMeasuredValue = new SimpleDoubleProperty((Object)this, "minMeasuredValue", this._minMeasuredValue);
        }
        return this.minMeasuredValue;
    }

    public final double getMaxMeasuredValue() {
        return null == this.maxMeasuredValue ? this._maxMeasuredValue : this.maxMeasuredValue.get();
    }

    public final void setMaxMeasuredValue(double MAX_MEASURED_VALUE) {
        if (null == this.maxMeasuredValue) {
            this._maxMeasuredValue = MAX_MEASURED_VALUE;
        } else {
            this.maxMeasuredValue.set(MAX_MEASURED_VALUE);
        }
    }

    public final ReadOnlyDoubleProperty maxMeasuredValueProperty() {
        if (null == this.maxMeasuredValue) {
            this.maxMeasuredValue = new SimpleDoubleProperty((Object)this, "maxMeasuredValue", this._maxMeasuredValue);
        }
        return this.maxMeasuredValue;
    }

    public void resetMinMeasuredValue() {
        this.setMinMeasuredValue(this.getValue());
    }

    public void resetMaxMeasuredValue() {
        this.setMaxMeasuredValue(this.getValue());
    }

    public void resetMinAndMaxMeasuredValue() {
        this.setMinMeasuredValue(this.getValue());
        this.setMaxMeasuredValue(this.getValue());
    }

    public final int getDecimals() {
        return null == this.decimals ? this._decimals : this.decimals.get();
    }

    public final void setDecimals(int DECIMALS) {
        if (null == this.decimals) {
            this._decimals = this.clamp(0, 3, DECIMALS);
        } else {
            this.decimals.set(this.clamp(0, 3, DECIMALS));
        }
    }

    public final IntegerProperty decimalsProperty() {
        if (null == this.decimals) {
            this.decimals = new SimpleIntegerProperty((Object)this, "decimals", this._decimals);
        }
        return this.decimals;
    }

    public final String getTitle() {
        return null == this.title ? this._title : (String)this.title.get();
    }

    public final void setTitle(String TITLE) {
        if (null == this.title) {
            this._title = TITLE;
        } else {
            this.title.set((Object)TITLE);
        }
    }

    public final StringProperty titleProperty() {
        if (null == this.title) {
            this.title = new SimpleStringProperty((Object)this, "title", this._title);
        }
        return this.title;
    }

    public final String getUnit() {
        return null == this.unit ? this._unit : (String)this.unit.get();
    }

    public final void setUnit(String UNIT) {
        if (null == this.unit) {
            this._unit = UNIT;
        } else {
            this.unit.set((Object)UNIT);
        }
    }

    public final StringProperty unitProperty() {
        if (null == this.unit) {
            this.unit = new SimpleStringProperty((Object)this, "unit", this._unit);
        }
        return this.unit;
    }

    public final boolean isAnimated() {
        return null == this.animated ? this._animated : this.animated.get();
    }

    public final void setAnimated(boolean ANIMATED) {
        if (null == this.animated) {
            this._animated = ANIMATED;
        } else {
            this.animated.set(ANIMATED);
        }
    }

    public final BooleanProperty animatedProperty() {
        if (null == this.animated) {
            this.animated = new SimpleBooleanProperty((Object)this, "animated", this._animated);
        }
        return this.animated;
    }

    public double getStartAngle() {
        return null == this.startAngle ? this._startAngle : this.startAngle.get();
    }

    public final void setStartAngle(double START_ANGLE) {
        if (null == this.startAngle) {
            this._startAngle = this.clamp(0.0, 360.0, START_ANGLE);
        } else {
            this.startAngle.set(START_ANGLE);
        }
    }

    public final DoubleProperty startAngleProperty() {
        if (null == this.startAngle) {
            this.startAngle = new DoublePropertyBase(this._startAngle){

                public void set(double START_ANGLE) {
                    super.set(Gauge.this.clamp(0.0, 360.0, this.get()));
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "startAngle";
                }
            };
        }
        return this.startAngle;
    }

    public final double getAnimationDuration() {
        return this.animationDuration;
    }

    public final void setAnimationDuration(double ANIMATION_DURATION) {
        this.animationDuration = this.clamp(20.0, 5000.0, ANIMATION_DURATION);
    }

    public final double getAngleRange() {
        return null == this.angleRange ? this._angleRange : this.angleRange.get();
    }

    public final void setAngleRange(double ANGLE_RANGE) {
        if (null == this.angleRange) {
            this._angleRange = this.clamp(0.0, 360.0, ANGLE_RANGE);
        } else {
            this.angleRange.set(ANGLE_RANGE);
        }
    }

    public final DoubleProperty angleRangeProperty() {
        if (null == this.angleRange) {
            this.angleRange = new DoublePropertyBase(this._angleRange){

                public void set(double ANGLE_RANGE) {
                    super.set(Gauge.this.clamp(0.0, 360.0, this.get()));
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "angleRange";
                }
            };
        }
        return this.angleRange;
    }

    public final boolean isClockwise() {
        return null == this.clockwise ? this._clockwise : this.clockwise.get();
    }

    public final void setClockwise(boolean CLOCKWISE) {
        if (null == this.clockwise) {
            this._clockwise = CLOCKWISE;
        } else {
            this.clockwise.set(CLOCKWISE);
        }
    }

    public final BooleanProperty clockwiseProperty() {
        if (null == this.clockwise) {
            this.clockwise = new SimpleBooleanProperty((Object)this, "clockwise", this._clockwise);
        }
        return this.clockwise;
    }

    public final boolean isAutoScale() {
        return null == this.autoScale ? this._autoScale : this.autoScale.get();
    }

    public final void setAutoScale(boolean AUTO_SCALE) {
        if (null == this.autoScale) {
            this._autoScale = AUTO_SCALE;
        } else {
            this.autoScale.set(AUTO_SCALE);
        }
    }

    public final BooleanProperty autoScaleProperty() {
        if (null == this.autoScale) {
            this.autoScale = new BooleanPropertyBase(this._autoScale){

                public void set(boolean AUTO_SCALE) {
                    if (this.get()) {
                        Gauge.this.exactMinValue = Gauge.this.getMinValue();
                        Gauge.this.exactMaxValue = Gauge.this.getMaxValue();
                    } else {
                        Gauge.this.setMinValue(Gauge.this.exactMinValue);
                        Gauge.this.setMaxValue(Gauge.this.exactMaxValue);
                    }
                    super.set(AUTO_SCALE);
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "autoScale";
                }
            };
        }
        return this.autoScale;
    }

    public final NeedleType getNeedleType() {
        return null == this.needleType ? this._needleType : (NeedleType)((Object)this.needleType.get());
    }

    public final void setNeedleType(NeedleType NEEDLE_TYPE) {
        if (null == this.needleType) {
            this._needleType = NEEDLE_TYPE;
        } else {
            this.needleType.set((Object)NEEDLE_TYPE);
        }
    }

    public final ObjectProperty<NeedleType> needleTypeProperty() {
        if (null == this.needleType) {
            this.needleType = new SimpleObjectProperty((Object)this, "needleType", (Object)this._needleType);
        }
        return this.needleType;
    }

    public final Color getNeedleColor() {
        return null == this.needleColor ? this._needleColor : (Color)this.needleColor.get();
    }

    public final void setNeedleColor(Color NEEDLE_COLOR) {
        if (null == this.needleColor) {
            this._needleColor = NEEDLE_COLOR;
        } else {
            this.needleColor.set((Object)NEEDLE_COLOR);
        }
    }

    public final ObjectProperty<Color> needleColorProperty() {
        if (null == this.needleColor) {
            this.needleColor = new SimpleObjectProperty((Object)this, "needleColor", (Object)this._needleColor);
        }
        return this.needleColor;
    }

    public final TickLabelOrientation getTickLabelOrientation() {
        return null == this.tickLabelOrientation ? this._tickLabelOrientation : (TickLabelOrientation)((Object)this.tickLabelOrientation.get());
    }

    public final void setTickLabelOrientation(TickLabelOrientation TICK_LABEL_ORIENTATION) {
        if (null == this.tickLabelOrientation) {
            this._tickLabelOrientation = TICK_LABEL_ORIENTATION;
        } else {
            this.tickLabelOrientation.set((Object)TICK_LABEL_ORIENTATION);
        }
    }

    public final ObjectProperty<TickLabelOrientation> tickLabelOrientationProperty() {
        if (null == this.tickLabelOrientation) {
            this.tickLabelOrientation = new SimpleObjectProperty((Object)this, "tickLabelOrientation", (Object)this._tickLabelOrientation);
        }
        return this.tickLabelOrientation;
    }

    public final NumberFormat getNumberFormat() {
        return null == this.numberFormat ? this._numberFormat : (NumberFormat)((Object)this.numberFormat.get());
    }

    public final void setNumberFormat(NumberFormat NUMBER_FORMAT) {
        if (null == this.numberFormat) {
            this._numberFormat = NUMBER_FORMAT;
        } else {
            this.numberFormat.set((Object)NUMBER_FORMAT);
        }
    }

    public final ObjectProperty<NumberFormat> numberFormatProperty() {
        if (null == this.numberFormat) {
            this.numberFormat = new SimpleObjectProperty((Object)this, "numberFormat", (Object)this._numberFormat);
        }
        return this.numberFormat;
    }

    public final ObservableList<Section> getSections() {
        return this.sections;
    }

    public final void setSections(List<Section> SECTIONS) {
        this.sections.setAll(SECTIONS);
    }

    public final void setSections(Section ... SECTIONS) {
        this.setSections(Arrays.asList(SECTIONS));
    }

    public final void addSection(Section SECTION) {
        if (!this.sections.contains((Object)SECTION)) {
            this.sections.add((Object)SECTION);
        }
    }

    public final void removeSection(Section SECTION) {
        if (this.sections.contains((Object)SECTION)) {
            this.sections.remove((Object)SECTION);
        }
    }

    public final ObservableList<Section> getAreas() {
        return this.areas;
    }

    public final void setAreas(List<Section> AREAS) {
        this.areas.setAll(AREAS);
    }

    public final void setAreas(Section ... AREAS) {
        this.setAreas(Arrays.asList(AREAS));
    }

    public final void addArea(Section AREA) {
        if (!this.areas.contains((Object)AREA)) {
            this.areas.add((Object)AREA);
        }
    }

    public final void removeArea(Section AREA) {
        if (this.areas.contains((Object)AREA)) {
            this.areas.remove((Object)AREA);
        }
    }

    public final ObservableMap<Marker, Rotate> getMarkers() {
        return this.markers;
    }

    public final void setMarkers(List<Marker> MARKERS) {
        int markerCounter = 0;
        for (Marker marker : MARKERS) {
            Rotate markerRotate = new Rotate(180.0 - this.getStartAngle());
            marker.getTransforms().setAll((Object[])new Transform[]{markerRotate});
            marker.getStyleClass().add((Object)("marker" + markerCounter));
            this.markers.put((Object)marker, (Object)markerRotate);
            ++markerCounter;
        }
    }

    public final void setMarkers(Marker ... MARKERS) {
        this.setMarkers(Arrays.asList(MARKERS));
    }

    public final void addMarker(Marker MARKER) {
        if (!this.markers.keySet().contains((Object)MARKER)) {
            Rotate markerRotate = new Rotate(180.0 - this.getStartAngle());
            MARKER.getTransforms().setAll((Object[])new Transform[]{markerRotate});
            MARKER.getStyleClass().add((Object)("marker" + this.markers.size()));
            this.markers.put((Object)MARKER, (Object)markerRotate);
        }
    }

    public final void removeMarker(Marker MARKER) {
        if (this.markers.keySet().contains((Object)MARKER)) {
            this.markers.remove((Object)MARKER);
        }
    }

    public final double getMajorTickSpace() {
        return null == this.majorTickSpace ? this._majorTickSpace : this.majorTickSpace.get();
    }

    public final void setMajorTickSpace(double MAJOR_TICK_SPACE) {
        if (null == this.majorTickSpace) {
            this._majorTickSpace = MAJOR_TICK_SPACE;
        } else {
            this.majorTickSpace.set(MAJOR_TICK_SPACE);
        }
    }

    public final DoubleProperty majorTickSpaceProperty() {
        if (null == this.majorTickSpace) {
            this.majorTickSpace = new SimpleDoubleProperty((Object)this, "majorTickSpace", this._majorTickSpace);
        }
        return this.majorTickSpace;
    }

    public final double getMinorTickSpace() {
        return null == this.minorTickSpace ? this._minorTickSpace : this.minorTickSpace.get();
    }

    public final void setMinorTickSpace(double MINOR_TICK_SPACE) {
        if (null == this.minorTickSpace) {
            this._minorTickSpace = MINOR_TICK_SPACE;
        } else {
            this.minorTickSpace.set(MINOR_TICK_SPACE);
        }
    }

    public final DoubleProperty minorTickSpaceProperty() {
        if (null == this.minorTickSpace) {
            this.minorTickSpace = new SimpleDoubleProperty((Object)this, "minorTickSpace", this._minorTickSpace);
        }
        return this.minorTickSpace;
    }

    public final boolean isPlainValue() {
        return null == this.plainValue ? this._plainValue : this.plainValue.get();
    }

    public final void setPlainValue(boolean PLAIN_VALUE) {
        if (null == this.plainValue) {
            this._plainValue = PLAIN_VALUE;
        } else {
            this.plainValue.set(PLAIN_VALUE);
        }
    }

    public final BooleanProperty plainValueProperty() {
        if (null == this.plainValue) {
            this.plainValue = new SimpleBooleanProperty((Object)this, "plainValue", this._plainValue);
        }
        return this.plainValue;
    }

    public final boolean isHistogramEnabled() {
        return null == this.histogramEnabled ? this._histogramEnabled : this.histogramEnabled.get();
    }

    public final void setHistogramEnabled(boolean HISTOGRAM_ENABLED) {
        if (null == this.histogramEnabled) {
            this._histogramEnabled = HISTOGRAM_ENABLED;
        } else {
            this.histogramEnabled.set(HISTOGRAM_ENABLED);
        }
    }

    public final BooleanProperty histogramEnabledProperty() {
        if (null == this.histogramEnabled) {
            this.histogramEnabled = new SimpleBooleanProperty((Object)this, "histogramEnabled", this._histogramEnabled);
        }
        return this.histogramEnabled;
    }

    public final boolean isDropShadowEnabled() {
        return null == this.dropShadowEnabled ? this._dropShadowEnabled : this.dropShadowEnabled.get();
    }

    public final void setDropShadowEnabled(boolean DROP_SHADOW_ENABLED) {
        if (null == this.dropShadowEnabled) {
            this._dropShadowEnabled = DROP_SHADOW_ENABLED;
        } else {
            this.dropShadowEnabled.set(DROP_SHADOW_ENABLED);
        }
    }

    public final BooleanProperty dropShadowEnabledProperty() {
        if (null == this.dropShadowEnabled) {
            this.dropShadowEnabled = new SimpleBooleanProperty((Object)this, "dropShadowEnabled", this._dropShadowEnabled);
        }
        return this.dropShadowEnabled;
    }

    public final boolean isSectionsVisible() {
        return null == this.sectionsVisible ? this._sectionsVisible : this.sectionsVisible.get();
    }

    public final void setSectionsVisible(boolean SECTIONS_VISIBLE) {
        if (null == this.sectionsVisible) {
            this._sectionsVisible = SECTIONS_VISIBLE;
        } else {
            this.sectionsVisible.set(SECTIONS_VISIBLE);
        }
    }

    public final BooleanProperty sectionsVisibleProperty() {
        if (null == this.sectionsVisible) {
            this.sectionsVisible = new SimpleBooleanProperty((Object)this, "sectionsVisible", this._sectionsVisible);
        }
        return this.sectionsVisible;
    }

    public final boolean isAreasVisible() {
        return null == this.areasVisible ? this._areasVisible : this.areasVisible.get();
    }

    public final void setAreasVisible(boolean AREAS_VISIBLE) {
        if (null == this.areasVisible) {
            this._areasVisible = AREAS_VISIBLE;
        } else {
            this.areasVisible.set(AREAS_VISIBLE);
        }
    }

    public final BooleanProperty areasVisibleProperty() {
        if (null == this.areasVisible) {
            this.areasVisible = new SimpleBooleanProperty((Object)this, "areasVisible", this._areasVisible);
        }
        return this.areasVisible;
    }

    public final boolean isMarkersVisible() {
        return null == this.markersVisible ? this._markersVisible : this.markersVisible.get();
    }

    public final void setMarkersVisible(boolean MARKERS_VISIBLE) {
        if (null == this.markersVisible) {
            this._markersVisible = MARKERS_VISIBLE;
        } else {
            this.markersVisible.set(MARKERS_VISIBLE);
        }
    }

    public final BooleanProperty markersVisibleProperty() {
        if (null == this.markersVisible) {
            this.markersVisible = new SimpleBooleanProperty((Object)this, "markersVisible", this._markersVisible);
        }
        return this.markersVisible;
    }

    public final boolean isThresholdVisible() {
        return null == this.thresholdVisible ? this._thresholdVisible : this.thresholdVisible.get();
    }

    public final void setThresholdVisible(boolean THRESHOLD_VISIBLE) {
        if (null == this.thresholdVisible) {
            this._thresholdVisible = THRESHOLD_VISIBLE;
        } else {
            this.thresholdVisible.set(THRESHOLD_VISIBLE);
        }
    }

    public final BooleanProperty thresholdVisibleProperty() {
        if (null == this.thresholdVisible) {
            this.thresholdVisible = new SimpleBooleanProperty((Object)this, "thresholdVisible", this._thresholdVisible);
        }
        return this.thresholdVisible;
    }

    public final boolean isMinMeasuredValueVisible() {
        return null == this.minMeasuredValueVisible ? this._minMeasuredValueVisible : this.minMeasuredValueVisible.get();
    }

    public final void setMinMeasuredValueVisible(boolean MIN_MEASURED_VALUE_VISIBLE) {
        if (null == this.minMeasuredValueVisible) {
            this._minMeasuredValueVisible = MIN_MEASURED_VALUE_VISIBLE;
        } else {
            this.minMeasuredValueVisible.set(MIN_MEASURED_VALUE_VISIBLE);
        }
    }

    public final BooleanProperty minMeasuredValueVisibleProperty() {
        if (null == this.minMeasuredValueVisible) {
            this.minMeasuredValueVisible = new SimpleBooleanProperty((Object)this, "minMeasuredValueVisible", this._minMeasuredValueVisible);
        }
        return this.minMeasuredValueVisible;
    }

    public final boolean isMaxMeasuredValueVisible() {
        return null == this.maxMeasuredValueVisible ? this._maxMeasuredValueVisible : this.maxMeasuredValueVisible.get();
    }

    public final void setMaxMeasuredValueVisible(boolean MAX_MEASURED_VALUE_VISIBLE) {
        if (null == this.maxMeasuredValueVisible) {
            this._maxMeasuredValueVisible = MAX_MEASURED_VALUE_VISIBLE;
        } else {
            this.maxMeasuredValueVisible.set(MAX_MEASURED_VALUE_VISIBLE);
        }
    }

    public final BooleanProperty maxMeasuredValueVisibleProperty() {
        if (null == this.maxMeasuredValueVisible) {
            this.maxMeasuredValueVisible = new SimpleBooleanProperty((Object)this, "maxMeasuredValueVisible", this._maxMeasuredValueVisible);
        }
        return this.maxMeasuredValueVisible;
    }

    public final Limit getLimit() {
        return (Limit)((Object)this.limit.get());
    }

    public final ReadOnlyObjectProperty<Limit> limitProperty() {
        return this.limit;
    }

    public final void addCustomKnobClickHandler(EventHandler<MouseEvent> HANDLER) {
        this.customKnobClickHandler.set(HANDLER);
    }

    public final void removeCustomKnobClickHandler() {
        this.customKnobClickHandler.set(null);
    }

    public final EventHandler<MouseEvent> getCustomKnobClickHandler() {
        return (EventHandler)this.customKnobClickHandler.get();
    }

    public final ObjectProperty<EventHandler<MouseEvent>> customKnobClickHandlerProperty() {
        return this.customKnobClickHandler;
    }

    private double clamp(double MIN_VALUE, double MAX_VALUE, double VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    private int clamp(int MIN_VALUE, int MAX_VALUE, int VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    private Duration clamp(Duration MIN_VALUE, Duration MAX_VALUE, Duration VALUE) {
        if (VALUE.lessThan(MIN_VALUE)) {
            return MIN_VALUE;
        }
        if (VALUE.greaterThan(MAX_VALUE)) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    public void calcAutoScale() {
        if (this.isAutoScale()) {
            double maxNoOfMajorTicks = 10.0;
            double maxNoOfMinorTicks = 10.0;
            double niceRange = this.calcNiceNumber(this.getMaxValue() - this.getMinValue(), false);
            this.majorTickSpace.set(this.calcNiceNumber(niceRange / (maxNoOfMajorTicks - 1.0), true));
            double niceMinValue = Math.floor(this.getMinValue() / this.majorTickSpace.doubleValue()) * this.majorTickSpace.doubleValue();
            double niceMaxValue = Math.ceil(this.getMaxValue() / this.majorTickSpace.doubleValue()) * this.majorTickSpace.doubleValue();
            this.minorTickSpace.set(this.calcNiceNumber(this.majorTickSpace.doubleValue() / (maxNoOfMinorTicks - 1.0), true));
            this.setMinValue(niceMinValue);
            this.setMaxValue(niceMaxValue);
        }
    }

    private double calcNiceNumber(double RANGE, boolean ROUND) {
        double EXPONENT = Math.floor(Math.log10(RANGE));
        double FRACTION = RANGE / Math.pow(10.0, EXPONENT);
        double niceFraction = ROUND ? (FRACTION < 1.5 ? 1.0 : (FRACTION < 3.0 ? 2.0 : (FRACTION < 7.0 ? 5.0 : 10.0))) : (Double.compare(FRACTION, 1.0) <= 0 ? 1.0 : (Double.compare(FRACTION, 2.0) <= 0 ? 2.0 : (Double.compare(FRACTION, 5.0) <= 0 ? 5.0 : 10.0)));
        return niceFraction * Math.pow(10.0, EXPONENT);
    }

    public void validate() {
        if (this.getValue() < this.getMinValue()) {
            this.setValue(this.getMinValue());
        }
        if (this.getValue() > this.getMaxValue()) {
            this.setValue(this.getMaxValue());
        }
        if (this.getThreshold() < this.getMinValue()) {
            this.setThreshold(this.getMinValue());
        }
        if (this.getThreshold() > this.getMaxValue()) {
            this.setThreshold(this.getMaxValue());
        }
        for (Marker marker : this.markers.keySet()) {
            if (marker.getValue() < this.getMinValue()) {
                marker.setValue(this.getMinValue());
            }
            if (!(marker.getValue() > this.getMaxValue())) continue;
            marker.setValue(this.getMaxValue());
        }
        for (Section section : this.sections) {
            if (section.getStart() < this.getMinValue()) {
                section.setStart(this.getMinValue());
            }
            if (section.getStart() > this.getMaxValue()) {
                section.setStart(this.getMaxValue());
            }
            if (section.getStop() < this.getMinValue()) {
                section.setStop(this.getMinValue());
            }
            if (!(section.getStop() > this.getMaxValue())) continue;
            section.setStop(this.getMaxValue());
        }
    }

    public final Paint getTickMarkFill() {
        return null == this.tickMarkFill ? Color.BLACK : (Paint)this.tickMarkFill.get();
    }

    public final void setTickMarkFill(Paint value) {
        this.tickMarkFillProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> tickMarkFillProperty() {
        if (null == this.tickMarkFill) {
            this.tickMarkFill = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.TICK_MARK_FILL;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "tickMarkFill";
                }
            };
        }
        return this.tickMarkFill;
    }

    public final Paint getTickLabelFill() {
        return null == this.tickLabelFill ? Color.BLACK : (Paint)this.tickLabelFill.get();
    }

    public final void setTickLabelFill(Paint value) {
        this.tickLabelFillProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> tickLabelFillProperty() {
        if (null == this.tickLabelFill) {
            this.tickLabelFill = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.TICK_LABEL_FILL;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "tickLabelFill";
                }
            };
        }
        return this.tickLabelFill;
    }

    public final Paint getSectionFill0() {
        return null == this.sectionFill0 ? DEFAULT_SECTION_FILL_0 : (Paint)this.sectionFill0.get();
    }

    public final void setSectionFill0(Paint value) {
        this.sectionFill0Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill0Property() {
        if (null == this.sectionFill0) {
            this.sectionFill0 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_0){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_0;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "sectionFill0";
                }
            };
        }
        return this.sectionFill0;
    }

    public final Paint getSectionFill1() {
        return null == this.sectionFill1 ? DEFAULT_SECTION_FILL_1 : (Paint)this.sectionFill1.get();
    }

    public final void setSectionFill1(Paint value) {
        this.sectionFill1Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill1Property() {
        if (null == this.sectionFill1) {
            this.sectionFill1 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_1){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_1;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "sectionFill1";
                }
            };
        }
        return this.sectionFill1;
    }

    public final Paint getSectionFill2() {
        return null == this.sectionFill2 ? DEFAULT_SECTION_FILL_2 : (Paint)this.sectionFill2.get();
    }

    public final void setSectionFill2(Paint value) {
        this.sectionFill2Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill2Property() {
        if (null == this.sectionFill2) {
            this.sectionFill2 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_2){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_2;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "sectionFill2";
                }
            };
        }
        return this.sectionFill2;
    }

    public final Paint getSectionFill3() {
        return null == this.sectionFill3 ? DEFAULT_SECTION_FILL_3 : (Paint)this.sectionFill3.get();
    }

    public final void setSectionFill3(Paint value) {
        this.sectionFill3Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill3Property() {
        if (null == this.sectionFill3) {
            this.sectionFill3 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_3){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_3;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "sectionFill3";
                }
            };
        }
        return this.sectionFill3;
    }

    public final Paint getSectionFill4() {
        return null == this.sectionFill4 ? DEFAULT_SECTION_FILL_4 : (Paint)this.sectionFill4.get();
    }

    public final void setSectionFill4(Paint value) {
        this.sectionFill4Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill4Property() {
        if (null == this.sectionFill4) {
            this.sectionFill4 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_4){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_4;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "sectionFill4";
                }
            };
        }
        return this.sectionFill4;
    }

    public final Paint getSectionFill5() {
        return null == this.sectionFill5 ? DEFAULT_SECTION_FILL_5 : (Paint)this.sectionFill5.get();
    }

    public final void setSectionFill5(Paint value) {
        this.sectionFill5Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill5Property() {
        if (null == this.sectionFill5) {
            this.sectionFill5 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_5){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_5;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "sectionFill5";
                }
            };
        }
        return this.sectionFill5;
    }

    public final Paint getSectionFill6() {
        return null == this.sectionFill6 ? DEFAULT_SECTION_FILL_6 : (Paint)this.sectionFill6.get();
    }

    public final void setSectionFill6(Paint value) {
        this.sectionFill6Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill6Property() {
        if (null == this.sectionFill6) {
            this.sectionFill6 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_6){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_6;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "sectionFill6";
                }
            };
        }
        return this.sectionFill6;
    }

    public final Paint getSectionFill7() {
        return null == this.sectionFill7 ? DEFAULT_SECTION_FILL_7 : (Paint)this.sectionFill7.get();
    }

    public final void setSectionFill7(Paint value) {
        this.sectionFill7Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill7Property() {
        if (null == this.sectionFill7) {
            this.sectionFill7 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_7){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_7;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "sectionFill7";
                }
            };
        }
        return this.sectionFill7;
    }

    public final Paint getSectionFill8() {
        return null == this.sectionFill8 ? DEFAULT_SECTION_FILL_8 : (Paint)this.sectionFill8.get();
    }

    public final void setSectionFill8(Paint value) {
        this.sectionFill8Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill8Property() {
        if (null == this.sectionFill8) {
            this.sectionFill8 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_8){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_8;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "sectionFill8";
                }
            };
        }
        return this.sectionFill8;
    }

    public final Paint getSectionFill9() {
        return null == this.sectionFill9 ? DEFAULT_SECTION_FILL_9 : (Paint)this.sectionFill9.get();
    }

    public final void setSectionFill9(Paint value) {
        this.sectionFill9Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill9Property() {
        if (null == this.sectionFill9) {
            this.sectionFill9 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_9){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_9;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "sectionFill9";
                }
            };
        }
        return this.sectionFill9;
    }

    public final Paint getHistogramFill() {
        return null == this.histogramFill ? DEFAULT_HISTOGRAM_FILL : (Paint)this.histogramFill.get();
    }

    public final void setHistogramFill(Paint value) {
        this.histogramFillProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> histogramFillProperty() {
        if (null == this.histogramFill) {
            this.histogramFill = new StyleableObjectProperty<Paint>((Paint)DEFAULT_HISTOGRAM_FILL){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.HISTOGRAM_FILL;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "histogramFill";
                }
            };
        }
        return this.histogramFill;
    }

    public final Paint getAreaFill0() {
        return null == this.areaFill0 ? DEFAULT_AREA_FILL_0 : (Paint)this.areaFill0.get();
    }

    public final void setAreaFill0(Paint value) {
        this.areaFill0Property().set((Object)value);
    }

    public final ObjectProperty<Paint> areaFill0Property() {
        if (null == this.areaFill0) {
            this.areaFill0 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_AREA_FILL_0){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.AREA_FILL_0;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "areaFill0";
                }
            };
        }
        return this.areaFill0;
    }

    public final Paint getAreaFill1() {
        return null == this.areaFill1 ? DEFAULT_AREA_FILL_1 : (Paint)this.areaFill1.get();
    }

    public final void setAreaFill1(Paint value) {
        this.areaFill1Property().set((Object)value);
    }

    public final ObjectProperty<Paint> areaFill1Property() {
        if (null == this.areaFill1) {
            this.areaFill1 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_AREA_FILL_1){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.AREA_FILL_1;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "areaFill1";
                }
            };
        }
        return this.areaFill1;
    }

    public final Paint getAreaFill2() {
        return null == this.areaFill2 ? DEFAULT_AREA_FILL_2 : (Paint)this.areaFill2.get();
    }

    public final void setAreaFill2(Paint value) {
        this.areaFill2Property().set((Object)value);
    }

    public final ObjectProperty<Paint> areaFill2Property() {
        if (null == this.areaFill2) {
            this.areaFill2 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_AREA_FILL_2){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.AREA_FILL_2;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "areaFill2";
                }
            };
        }
        return this.areaFill2;
    }

    public final Paint getAreaFill3() {
        return null == this.areaFill3 ? DEFAULT_AREA_FILL_3 : (Paint)this.areaFill3.get();
    }

    public final void setAreaFill3(Paint value) {
        this.areaFill3Property().set((Object)value);
    }

    public final ObjectProperty<Paint> areaFill3Property() {
        if (null == this.areaFill3) {
            this.areaFill3 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_AREA_FILL_3){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.AREA_FILL_3;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "areaFill3";
                }
            };
        }
        return this.areaFill3;
    }

    public final Paint getAreaFill4() {
        return null == this.areaFill4 ? DEFAULT_AREA_FILL_4 : (Paint)this.areaFill4.get();
    }

    public final void setAreaFill4(Paint value) {
        this.areaFill4Property().set((Object)value);
    }

    public final ObjectProperty<Paint> areaFill4Property() {
        if (null == this.areaFill4) {
            this.areaFill4 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_AREA_FILL_4){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.AREA_FILL_4;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "areaFill4";
                }
            };
        }
        return this.areaFill4;
    }

    public final Paint getAreaFill5() {
        return null == this.areaFill5 ? DEFAULT_AREA_FILL_5 : (Paint)this.areaFill5.get();
    }

    public final void setAreaFill5(Paint value) {
        this.areaFill5Property().set((Object)value);
    }

    public final ObjectProperty<Paint> areaFill5Property() {
        if (null == this.areaFill5) {
            this.areaFill5 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_AREA_FILL_5){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.AREA_FILL_5;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "areaFill5";
                }
            };
        }
        return this.areaFill5;
    }

    public final Paint getAreaFill6() {
        return null == this.areaFill6 ? DEFAULT_AREA_FILL_6 : (Paint)this.areaFill6.get();
    }

    public final void setAreaFill6(Paint value) {
        this.areaFill6Property().set((Object)value);
    }

    public final ObjectProperty<Paint> areaFill6Property() {
        if (null == this.areaFill6) {
            this.areaFill6 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_AREA_FILL_6){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.AREA_FILL_6;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "areaFill6";
                }
            };
        }
        return this.areaFill6;
    }

    public final Paint getAreaFill7() {
        return null == this.areaFill7 ? DEFAULT_AREA_FILL_7 : (Paint)this.areaFill7.get();
    }

    public final void setAreaFill7(Paint value) {
        this.areaFill7Property().set((Object)value);
    }

    public final ObjectProperty<Paint> areaFill7Property() {
        if (null == this.areaFill7) {
            this.areaFill7 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_AREA_FILL_7){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.AREA_FILL_7;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "areaFill7";
                }
            };
        }
        return this.areaFill7;
    }

    public final Paint getAreaFill8() {
        return null == this.areaFill8 ? DEFAULT_AREA_FILL_8 : (Paint)this.areaFill8.get();
    }

    public final void setAreaFill8(Paint value) {
        this.areaFill8Property().set((Object)value);
    }

    public final ObjectProperty<Paint> areaFill8Property() {
        if (null == this.areaFill8) {
            this.areaFill8 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_AREA_FILL_8){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.AREA_FILL_8;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "areaFill8";
                }
            };
        }
        return this.areaFill8;
    }

    public final Paint getAreaFill9() {
        return null == this.areaFill9 ? DEFAULT_AREA_FILL_9 : (Paint)this.areaFill9.get();
    }

    public final void setAreaFill9(Paint value) {
        this.areaFill9Property().set((Object)value);
    }

    public final ObjectProperty<Paint> areaFill9Property() {
        if (null == this.areaFill9) {
            this.areaFill9 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_AREA_FILL_9){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.AREA_FILL_9;
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "areaFill9";
                }
            };
        }
        return this.areaFill9;
    }

    public final Paint getMarkerFill0() {
        return null == this.markerFill0 ? DEFAULT_MARKER_FILL_0 : (Paint)this.markerFill0.get();
    }

    public final void setMarkerFill0(Paint value) {
        this.markerFill0Property().set((Object)value);
    }

    public final ObjectProperty<Paint> markerFill0Property() {
        if (null == this.markerFill0) {
            this.markerFill0 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_MARKER_FILL_0){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.MARKER_FILL_0;
                }

                public void set(Paint PAINT) {
                    super.set((Object)PAINT);
                    if (Gauge.this.markers.size() < 1) {
                        return;
                    }
                    ArrayList markerList = new ArrayList(Gauge.this.markers.keySet());
                    ((Marker)((Object)markerList.get(0))).setStyle("-marker-fill-0: " + PAINT.toString().replace("0x", "#") + ";");
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "markerFill0";
                }
            };
        }
        return this.markerFill0;
    }

    public final Paint getMarkerFill1() {
        return null == this.markerFill1 ? DEFAULT_MARKER_FILL_1 : (Paint)this.markerFill1.get();
    }

    public final void setMarkerFill1(Paint value) {
        this.markerFill1Property().set((Object)value);
    }

    public final ObjectProperty<Paint> markerFill1Property() {
        if (null == this.markerFill1) {
            this.markerFill1 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_MARKER_FILL_1){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.MARKER_FILL_1;
                }

                public void set(Paint PAINT) {
                    super.set((Object)PAINT);
                    if (Gauge.this.markers.size() < 2) {
                        return;
                    }
                    ArrayList markerList = new ArrayList(Gauge.this.markers.keySet());
                    ((Marker)((Object)markerList.get(1))).setStyle("-marker-fill-1: " + PAINT.toString().replace("0x", "#") + ";");
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "markerFill1";
                }
            };
        }
        return this.markerFill1;
    }

    public final Paint getMarkerFill2() {
        return null == this.markerFill2 ? DEFAULT_MARKER_FILL_2 : (Paint)this.markerFill2.get();
    }

    public final void setMarkerFill2(Paint value) {
        this.markerFill2Property().set((Object)value);
    }

    public final ObjectProperty<Paint> markerFill2Property() {
        if (null == this.markerFill2) {
            this.markerFill2 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_MARKER_FILL_2){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.MARKER_FILL_2;
                }

                public void set(Paint PAINT) {
                    super.set((Object)PAINT);
                    if (Gauge.this.markers.size() < 3) {
                        return;
                    }
                    ArrayList markerList = new ArrayList(Gauge.this.markers.keySet());
                    ((Marker)((Object)markerList.get(2))).setStyle("-marker-fill-2: " + PAINT.toString().replace("0x", "#") + ";");
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "markerFill2";
                }
            };
        }
        return this.markerFill2;
    }

    public final Paint getMarkerFill3() {
        return null == this.markerFill3 ? DEFAULT_MARKER_FILL_3 : (Paint)this.markerFill3.get();
    }

    public final void setMarkerFill3(Paint value) {
        this.markerFill3Property().set((Object)value);
    }

    public final ObjectProperty<Paint> markerFill3Property() {
        if (null == this.markerFill3) {
            this.markerFill3 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_MARKER_FILL_3){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.MARKER_FILL_3;
                }

                public void set(Paint PAINT) {
                    super.set((Object)PAINT);
                    if (Gauge.this.markers.size() < 4) {
                        return;
                    }
                    ArrayList markerList = new ArrayList(Gauge.this.markers.keySet());
                    ((Marker)((Object)markerList.get(3))).setStyle("-marker-fill-3: " + PAINT.toString().replace("0x", "#") + ";");
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "markerFill3";
                }
            };
        }
        return this.markerFill3;
    }

    public final Paint getMarkerFill4() {
        return null == this.markerFill4 ? DEFAULT_MARKER_FILL_4 : (Paint)this.markerFill4.get();
    }

    public final void setMarkerFill4(Paint value) {
        this.markerFill4Property().set((Object)value);
    }

    public final ObjectProperty<Paint> markerFill4Property() {
        if (null == this.markerFill4) {
            this.markerFill4 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_MARKER_FILL_4){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.MARKER_FILL_4;
                }

                public void set(Paint PAINT) {
                    super.set((Object)PAINT);
                    if (Gauge.this.markers.size() < 5) {
                        return;
                    }
                    ArrayList markerList = new ArrayList(Gauge.this.markers.keySet());
                    ((Marker)((Object)markerList.get(4))).setStyle("-marker-fill-4: " + PAINT.toString().replace("0x", "#") + ";");
                }

                public Object getBean() {
                    return Gauge.this;
                }

                public String getName() {
                    return "markerFill4";
                }
            };
        }
        return this.markerFill4;
    }

    public final boolean isInteractive() {
        return null == this.interactive ? false : this.interactive.get();
    }

    public final void setInteractive(boolean INTERACTIVE) {
        this.interactiveProperty().set(INTERACTIVE);
    }

    public final BooleanProperty interactiveProperty() {
        if (null == this.interactive) {
            this.interactive = new BooleanPropertyBase(false){

                protected void invalidated() {
                    Gauge.this.pseudoClassStateChanged(INTERACTIVE_PSEUDO_CLASS, this.get());
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "interactive";
                }
            };
        }
        return this.interactive;
    }

    protected Skin createDefaultSkin() {
        return new GaugeSkin(this);
    }

    public String getUserAgentStylesheet() {
        return Gauge.class.getResource("gauge.css").toExternalForm();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Gauge.getClassCssMetaData();
    }

    static /* synthetic */ Color access$3900() {
        return DEFAULT_SECTION_FILL_0;
    }

    static /* synthetic */ Color access$4100() {
        return DEFAULT_SECTION_FILL_1;
    }

    static /* synthetic */ Color access$4300() {
        return DEFAULT_SECTION_FILL_2;
    }

    static /* synthetic */ Color access$4500() {
        return DEFAULT_SECTION_FILL_3;
    }

    static /* synthetic */ Color access$4700() {
        return DEFAULT_SECTION_FILL_4;
    }

    static /* synthetic */ Color access$4900() {
        return DEFAULT_SECTION_FILL_5;
    }

    static /* synthetic */ Color access$5100() {
        return DEFAULT_SECTION_FILL_6;
    }

    static /* synthetic */ Color access$5300() {
        return DEFAULT_SECTION_FILL_7;
    }

    static /* synthetic */ Color access$5500() {
        return DEFAULT_SECTION_FILL_8;
    }

    static /* synthetic */ Color access$5700() {
        return DEFAULT_SECTION_FILL_9;
    }

    static /* synthetic */ Color access$5900() {
        return DEFAULT_HISTOGRAM_FILL;
    }

    static /* synthetic */ Color access$6100() {
        return DEFAULT_AREA_FILL_0;
    }

    static /* synthetic */ Color access$6300() {
        return DEFAULT_AREA_FILL_1;
    }

    static /* synthetic */ Color access$6500() {
        return DEFAULT_AREA_FILL_2;
    }

    static /* synthetic */ Color access$6700() {
        return DEFAULT_AREA_FILL_3;
    }

    static /* synthetic */ Color access$6900() {
        return DEFAULT_AREA_FILL_4;
    }

    static /* synthetic */ Color access$7100() {
        return DEFAULT_AREA_FILL_5;
    }

    static /* synthetic */ Color access$7300() {
        return DEFAULT_AREA_FILL_6;
    }

    static /* synthetic */ Color access$7500() {
        return DEFAULT_AREA_FILL_7;
    }

    static /* synthetic */ Color access$7700() {
        return DEFAULT_AREA_FILL_8;
    }

    static /* synthetic */ Color access$7900() {
        return DEFAULT_AREA_FILL_9;
    }

    static /* synthetic */ Color access$8100() {
        return DEFAULT_MARKER_FILL_0;
    }

    static /* synthetic */ Color access$8300() {
        return DEFAULT_MARKER_FILL_1;
    }

    static /* synthetic */ Color access$8500() {
        return DEFAULT_MARKER_FILL_2;
    }

    static /* synthetic */ Color access$8700() {
        return DEFAULT_MARKER_FILL_3;
    }

    static /* synthetic */ Color access$8900() {
        return DEFAULT_MARKER_FILL_4;
    }

    private static class StyleableProperties {
        private static final CssMetaData<Gauge, Paint> TICK_MARK_FILL = new CssMetaData<Gauge, Paint>("-tick-mark-fill", StyleConverter.getPaintConverter(), (Paint)Color.BLACK){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.tickMarkFill || !gauge.tickMarkFill.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.tickMarkFillProperty();
            }
        };
        private static final CssMetaData<Gauge, Paint> TICK_LABEL_FILL = new CssMetaData<Gauge, Paint>("-tick-label-fill", StyleConverter.getPaintConverter(), (Paint)Color.BLACK){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.tickLabelFill || !gauge.tickLabelFill.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.tickLabelFillProperty();
            }
        };
        private static final CssMetaData<Gauge, Paint> SECTION_FILL_0 = new CssMetaData<Gauge, Paint>("-section-fill-0", StyleConverter.getPaintConverter(), (Paint)Gauge.access$3900()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.sectionFill0 || !gauge.sectionFill0.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.sectionFill0Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getSectionFill0();
            }
        };
        private static final CssMetaData<Gauge, Paint> SECTION_FILL_1 = new CssMetaData<Gauge, Paint>("-section-fill-1", StyleConverter.getPaintConverter(), (Paint)Gauge.access$4100()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.sectionFill1 || !gauge.sectionFill1.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.sectionFill1Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getSectionFill1();
            }
        };
        private static final CssMetaData<Gauge, Paint> SECTION_FILL_2 = new CssMetaData<Gauge, Paint>("-section-fill-2", StyleConverter.getPaintConverter(), (Paint)Gauge.access$4300()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.sectionFill2 || !gauge.sectionFill2.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.sectionFill2Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getSectionFill2();
            }
        };
        private static final CssMetaData<Gauge, Paint> SECTION_FILL_3 = new CssMetaData<Gauge, Paint>("-section-fill-3", StyleConverter.getPaintConverter(), (Paint)Gauge.access$4500()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.sectionFill3 || !gauge.sectionFill3.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.sectionFill3Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getSectionFill3();
            }
        };
        private static final CssMetaData<Gauge, Paint> SECTION_FILL_4 = new CssMetaData<Gauge, Paint>("-section-fill-4", StyleConverter.getPaintConverter(), (Paint)Gauge.access$4700()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.sectionFill4 || !gauge.sectionFill4.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.sectionFill4Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getSectionFill4();
            }
        };
        private static final CssMetaData<Gauge, Paint> SECTION_FILL_5 = new CssMetaData<Gauge, Paint>("-section-fill-5", StyleConverter.getPaintConverter(), (Paint)Gauge.access$4900()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.sectionFill5 || !gauge.sectionFill5.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.sectionFill5Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getSectionFill5();
            }
        };
        private static final CssMetaData<Gauge, Paint> SECTION_FILL_6 = new CssMetaData<Gauge, Paint>("-section-fill-6", StyleConverter.getPaintConverter(), (Paint)Gauge.access$5100()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.sectionFill6 || !gauge.sectionFill6.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.sectionFill6Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getSectionFill6();
            }
        };
        private static final CssMetaData<Gauge, Paint> SECTION_FILL_7 = new CssMetaData<Gauge, Paint>("-section-fill-7", StyleConverter.getPaintConverter(), (Paint)Gauge.access$5300()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.sectionFill7 || !gauge.sectionFill7.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.sectionFill7Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getSectionFill7();
            }
        };
        private static final CssMetaData<Gauge, Paint> SECTION_FILL_8 = new CssMetaData<Gauge, Paint>("-section-fill-8", StyleConverter.getPaintConverter(), (Paint)Gauge.access$5500()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.sectionFill8 || !gauge.sectionFill8.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.sectionFill8Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getSectionFill8();
            }
        };
        private static final CssMetaData<Gauge, Paint> SECTION_FILL_9 = new CssMetaData<Gauge, Paint>("-section-fill-9", StyleConverter.getPaintConverter(), (Paint)Gauge.access$5700()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.sectionFill9 || !gauge.sectionFill9.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.sectionFill9Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getSectionFill9();
            }
        };
        private static final CssMetaData<Gauge, Paint> HISTOGRAM_FILL = new CssMetaData<Gauge, Paint>("-histogram-fill", StyleConverter.getPaintConverter(), (Paint)Gauge.access$5900()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.histogramFill || !gauge.histogramFill.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.histogramFillProperty();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getHistogramFill();
            }
        };
        private static final CssMetaData<Gauge, Paint> AREA_FILL_0 = new CssMetaData<Gauge, Paint>("-area-fill-0", StyleConverter.getPaintConverter(), (Paint)Gauge.access$6100()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.areaFill0 || !gauge.areaFill0.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.areaFill0Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getAreaFill0();
            }
        };
        private static final CssMetaData<Gauge, Paint> AREA_FILL_1 = new CssMetaData<Gauge, Paint>("-area-fill-1", StyleConverter.getPaintConverter(), (Paint)Gauge.access$6300()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.areaFill1 || !gauge.areaFill1.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.areaFill1Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getAreaFill1();
            }
        };
        private static final CssMetaData<Gauge, Paint> AREA_FILL_2 = new CssMetaData<Gauge, Paint>("-area-fill-2", StyleConverter.getPaintConverter(), (Paint)Gauge.access$6500()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.areaFill2 || !gauge.areaFill2.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.areaFill2Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getAreaFill2();
            }
        };
        private static final CssMetaData<Gauge, Paint> AREA_FILL_3 = new CssMetaData<Gauge, Paint>("-area-fill-3", StyleConverter.getPaintConverter(), (Paint)Gauge.access$6700()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.areaFill3 || !gauge.areaFill3.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.areaFill3Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getAreaFill3();
            }
        };
        private static final CssMetaData<Gauge, Paint> AREA_FILL_4 = new CssMetaData<Gauge, Paint>("-area-fill-4", StyleConverter.getPaintConverter(), (Paint)Gauge.access$6900()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.areaFill4 || !gauge.areaFill4.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.areaFill4Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getAreaFill4();
            }
        };
        private static final CssMetaData<Gauge, Paint> AREA_FILL_5 = new CssMetaData<Gauge, Paint>("-area-fill-5", StyleConverter.getPaintConverter(), (Paint)Gauge.access$7100()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.areaFill5 || !gauge.areaFill5.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.areaFill5Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getAreaFill5();
            }
        };
        private static final CssMetaData<Gauge, Paint> AREA_FILL_6 = new CssMetaData<Gauge, Paint>("-area-fill-6", StyleConverter.getPaintConverter(), (Paint)Gauge.access$7300()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.areaFill6 || !gauge.areaFill6.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.areaFill6Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getAreaFill6();
            }
        };
        private static final CssMetaData<Gauge, Paint> AREA_FILL_7 = new CssMetaData<Gauge, Paint>("-area-fill-7", StyleConverter.getPaintConverter(), (Paint)Gauge.access$7500()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.areaFill7 || !gauge.areaFill7.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.areaFill7Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getAreaFill7();
            }
        };
        private static final CssMetaData<Gauge, Paint> AREA_FILL_8 = new CssMetaData<Gauge, Paint>("-area-fill-8", StyleConverter.getPaintConverter(), (Paint)Gauge.access$7700()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.areaFill8 || !gauge.areaFill8.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.areaFill8Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getAreaFill8();
            }
        };
        private static final CssMetaData<Gauge, Paint> AREA_FILL_9 = new CssMetaData<Gauge, Paint>("-area-fill-9", StyleConverter.getPaintConverter(), (Paint)Gauge.access$7900()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.areaFill9 || !gauge.areaFill9.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.areaFill9Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getAreaFill9();
            }
        };
        private static final CssMetaData<Gauge, Paint> MARKER_FILL_0 = new CssMetaData<Gauge, Paint>("-marker-fill-0", StyleConverter.getPaintConverter(), (Paint)Gauge.access$8100()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.markerFill0 || !gauge.markerFill0.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.markerFill0Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getMarkerFill0();
            }
        };
        private static final CssMetaData<Gauge, Paint> MARKER_FILL_1 = new CssMetaData<Gauge, Paint>("-marker-fill-1", StyleConverter.getPaintConverter(), (Paint)Gauge.access$8300()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.markerFill1 || !gauge.markerFill1.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.markerFill1Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getMarkerFill1();
            }
        };
        private static final CssMetaData<Gauge, Paint> MARKER_FILL_2 = new CssMetaData<Gauge, Paint>("-marker-fill-2", StyleConverter.getPaintConverter(), (Paint)Gauge.access$8500()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.markerFill2 || !gauge.markerFill2.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.markerFill2Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getMarkerFill2();
            }
        };
        private static final CssMetaData<Gauge, Paint> MARKER_FILL_3 = new CssMetaData<Gauge, Paint>("-marker-fill-3", StyleConverter.getPaintConverter(), (Paint)Gauge.access$8700()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.markerFill3 || !gauge.markerFill3.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.markerFill3Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getMarkerFill3();
            }
        };
        private static final CssMetaData<Gauge, Paint> MARKER_FILL_4 = new CssMetaData<Gauge, Paint>("-marker-fill-4", StyleConverter.getPaintConverter(), (Paint)Gauge.access$8900()){

            public boolean isSettable(Gauge gauge) {
                return null == gauge.markerFill4 || !gauge.markerFill4.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(Gauge gauge) {
                return (StyleableProperty)gauge.markerFill4Property();
            }

            public Paint getInitialValue(Gauge gauge) {
                return gauge.getMarkerFill4();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, TICK_MARK_FILL, TICK_LABEL_FILL, SECTION_FILL_0, SECTION_FILL_1, SECTION_FILL_2, SECTION_FILL_3, SECTION_FILL_4, SECTION_FILL_5, SECTION_FILL_6, SECTION_FILL_7, SECTION_FILL_8, SECTION_FILL_9, HISTOGRAM_FILL, AREA_FILL_0, AREA_FILL_1, AREA_FILL_2, AREA_FILL_3, AREA_FILL_4, AREA_FILL_5, AREA_FILL_6, AREA_FILL_7, AREA_FILL_8, AREA_FILL_9, MARKER_FILL_0, MARKER_FILL_1, MARKER_FILL_2, MARKER_FILL_3, MARKER_FILL_4);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    public static enum NumberFormat {
        AUTO("0"),
        STANDARD("0"),
        FRACTIONAL("0.0#"),
        SCIENTIFIC("0.##E0"),
        PERCENTAGE("##0.0%");

        private final DecimalFormat DF;

        private NumberFormat(String FORMAT_STRING) {
            Locale.setDefault(new Locale("en", "US"));
            this.DF = new DecimalFormat(FORMAT_STRING);
        }

        public String format(Number NUMBER) {
            return this.DF.format(NUMBER);
        }
    }

    public static enum TickLabelOrientation {
        ORTHOGONAL,
        HORIZONTAL,
        TANGENT;

    }

    public static enum NeedleType {
        STANDARD("needle-standard");

        public final String STYLE_CLASS;

        private NeedleType(String STYLE_CLASS) {
            this.STYLE_CLASS = STYLE_CLASS;
        }
    }

    public static enum Limit {
        EXCEEDED,
        IN_RANGE,
        UNDERRUN;

    }
}

