/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge.skin;

import eu.hansolo.enzo.common.Section;
import eu.hansolo.enzo.fonts.Fonts;
import eu.hansolo.enzo.gauge.DoubleRadialGauge;
import java.time.Instant;
import java.util.Locale;
import java.util.stream.IntStream;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.util.Duration;

public class DoubleRadialGaugeSkin
extends SkinBase<DoubleRadialGauge>
implements Skin<DoubleRadialGauge> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double oldValueOne;
    private double oldValueTwo;
    private double size;
    private Pane pane;
    private Region background;
    private Canvas ticksAndSectionsCanvas;
    private GraphicsContext ticksAndSections;
    private Region ledFrameOne;
    private Region ledMainOne;
    private Region ledHlOne;
    private Region ledFrameTwo;
    private Region ledMainTwo;
    private Region ledHlTwo;
    private Region needleOne;
    private Region needleOneHighlight;
    private Rotate needleOneRotate;
    private Region needleTwo;
    private Region needleTwoHighlight;
    private Rotate needleTwoRotate;
    private Region knob;
    private Group shadowGroup;
    private DropShadow dropShadow;
    private InnerShadow innerShadow;
    private DropShadow glow;
    private Text titleTextOne;
    private Text titleTextTwo;
    private Text unitTextOne;
    private Text unitTextTwo;
    private Text valueTextOne;
    private Text valueTextTwo;
    private double angleStepOne;
    private double angleStepTwo;
    private Timeline timelineOne;
    private Timeline timelineTwo;
    private String limitString;
    private Instant lastCallOne;
    private Instant lastCallTwo;
    private boolean withinSpeedLimitOne;
    private boolean withinSpeedLimitTwo;

    public DoubleRadialGaugeSkin(DoubleRadialGauge gauge) {
        super((Control)gauge);
        this.angleStepOne = gauge.getAngleRangeOne() / (gauge.getMaxValueOne() - gauge.getMinValueOne());
        this.angleStepTwo = -gauge.getAngleRangeTwo() / (gauge.getMaxValueTwo() - gauge.getMinValueTwo());
        this.timelineOne = new Timeline();
        this.timelineTwo = new Timeline();
        this.oldValueOne = ((DoubleRadialGauge)this.getSkinnable()).getValueOne();
        this.oldValueTwo = ((DoubleRadialGauge)this.getSkinnable()).getValueTwo();
        this.limitString = "";
        this.lastCallOne = Instant.now();
        this.lastCallTwo = Instant.now();
        this.withinSpeedLimitOne = true;
        this.withinSpeedLimitTwo = true;
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if ((Double.compare(((DoubleRadialGauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((DoubleRadialGauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((DoubleRadialGauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((DoubleRadialGauge)this.getSkinnable()).getHeight(), 0.0) <= 0) && ((DoubleRadialGauge)this.getSkinnable()).getPrefWidth() < 0.0 && ((DoubleRadialGauge)this.getSkinnable()).getPrefHeight() < 0.0) {
            ((DoubleRadialGauge)this.getSkinnable()).setPrefSize(250.0, 250.0);
        }
        if (Double.compare(((DoubleRadialGauge)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((DoubleRadialGauge)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((DoubleRadialGauge)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((DoubleRadialGauge)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((DoubleRadialGauge)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((DoubleRadialGauge)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.background = new Region();
        this.background.getStyleClass().setAll((Object[])new String[]{"background"});
        this.ticksAndSectionsCanvas = new Canvas(250.0, 250.0);
        this.ticksAndSections = this.ticksAndSectionsCanvas.getGraphicsContext2D();
        this.innerShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 8.0, 0.0, 0.0, 0.0);
        this.glow = new DropShadow(BlurType.TWO_PASS_BOX, ((DoubleRadialGauge)this.getSkinnable()).getLedColorOne(), 20.0, 0.0, 0.0, 0.0);
        this.glow.setInput((Effect)this.innerShadow);
        this.ledFrameOne = new Region();
        this.ledFrameOne.getStyleClass().setAll((Object[])new String[]{"led-frame"});
        this.ledMainOne = new Region();
        this.ledMainOne.getStyleClass().setAll((Object[])new String[]{"led-main-one"});
        this.ledMainOne.setStyle("-led-color-one: " + this.colorToCss(((DoubleRadialGauge)this.getSkinnable()).getLedColorOne()) + ";");
        this.ledHlOne = new Region();
        this.ledHlOne.getStyleClass().setAll((Object[])new String[]{"led-hl"});
        this.ledFrameTwo = new Region();
        this.ledFrameTwo.getStyleClass().setAll((Object[])new String[]{"led-frame"});
        this.ledMainTwo = new Region();
        this.ledMainTwo.getStyleClass().setAll((Object[])new String[]{"led-main-two"});
        this.ledMainTwo.setStyle("-led-color-two: " + this.colorToCss(((DoubleRadialGauge)this.getSkinnable()).getLedColorTwo()) + ";");
        this.ledHlTwo = new Region();
        this.ledHlTwo.getStyleClass().setAll((Object[])new String[]{"led-hl"});
        this.angleStepOne = ((DoubleRadialGauge)this.getSkinnable()).getAngleRangeOne() / (((DoubleRadialGauge)this.getSkinnable()).getMaxValueOne() - ((DoubleRadialGauge)this.getSkinnable()).getMinValueOne());
        double targetAngleOne = 180.0 - ((DoubleRadialGauge)this.getSkinnable()).getStartAngleOne() + (((DoubleRadialGauge)this.getSkinnable()).getValueOne() - ((DoubleRadialGauge)this.getSkinnable()).getMinValueOne()) * this.angleStepOne;
        targetAngleOne = this.clamp(180.0 - ((DoubleRadialGauge)this.getSkinnable()).getStartAngleOne(), 180.0 - ((DoubleRadialGauge)this.getSkinnable()).getStartAngleOne() + ((DoubleRadialGauge)this.getSkinnable()).getAngleRangeOne(), targetAngleOne);
        this.needleOneRotate = new Rotate(targetAngleOne);
        this.needleOne = new Region();
        this.needleOne.getStyleClass().setAll((Object[])new String[]{DoubleRadialGauge.STYLE_CLASS_NEEDLE_ONE_STANDARD});
        this.needleOne.getTransforms().setAll((Object[])new Transform[]{this.needleOneRotate});
        this.needleOneHighlight = new Region();
        this.needleOneHighlight.setMouseTransparent(true);
        this.needleOneHighlight.getStyleClass().setAll((Object[])new String[]{"needle-highlight"});
        this.needleOneHighlight.getTransforms().setAll((Object[])new Transform[]{this.needleOneRotate});
        this.angleStepTwo = -((DoubleRadialGauge)this.getSkinnable()).getAngleRangeTwo() / (((DoubleRadialGauge)this.getSkinnable()).getMaxValueTwo() - ((DoubleRadialGauge)this.getSkinnable()).getMinValueTwo());
        double targetAngleTwo = 180.0 - ((DoubleRadialGauge)this.getSkinnable()).getStartAngleTwo() + (((DoubleRadialGauge)this.getSkinnable()).getValueTwo() - ((DoubleRadialGauge)this.getSkinnable()).getMinValueTwo()) * this.angleStepTwo;
        targetAngleTwo = this.clamp(180.0 - ((DoubleRadialGauge)this.getSkinnable()).getStartAngleTwo() - ((DoubleRadialGauge)this.getSkinnable()).getAngleRangeTwo(), 180.0 - ((DoubleRadialGauge)this.getSkinnable()).getStartAngleTwo(), targetAngleTwo);
        this.needleTwoRotate = new Rotate(targetAngleTwo);
        this.needleTwo = new Region();
        this.needleTwo.getStyleClass().setAll((Object[])new String[]{DoubleRadialGauge.STYLE_CLASS_NEEDLE_TWO_STANDARD});
        this.needleTwo.getTransforms().setAll((Object[])new Transform[]{this.needleTwoRotate});
        this.needleTwoHighlight = new Region();
        this.needleTwoHighlight.setMouseTransparent(true);
        this.needleTwoHighlight.getStyleClass().setAll((Object[])new String[]{"needle-highlight"});
        this.needleTwoHighlight.getTransforms().setAll((Object[])new Transform[]{this.needleTwoRotate});
        this.knob = new Region();
        this.knob.setPickOnBounds(false);
        this.knob.getStyleClass().setAll((Object[])new String[]{"knob"});
        this.dropShadow = new DropShadow();
        this.dropShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.25));
        this.dropShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.dropShadow.setRadius(3.75);
        this.dropShadow.setOffsetY(3.75);
        this.shadowGroup = new Group(new Node[]{this.needleOne, this.needleOneHighlight, this.needleTwo, this.needleTwoHighlight, this.knob});
        this.shadowGroup.setEffect((Effect)(((DoubleRadialGauge)this.getSkinnable()).isDropShadowEnabled() ? this.dropShadow : null));
        this.titleTextOne = new Text(((DoubleRadialGauge)this.getSkinnable()).getTitleOne());
        this.titleTextOne.setTextOrigin(VPos.CENTER);
        this.titleTextOne.getStyleClass().setAll((Object[])new String[]{"title"});
        this.unitTextOne = new Text(((DoubleRadialGauge)this.getSkinnable()).getUnitOne());
        this.unitTextOne.setMouseTransparent(true);
        this.unitTextOne.setTextOrigin(VPos.CENTER);
        this.unitTextOne.getStyleClass().setAll((Object[])new String[]{"unit"});
        this.valueTextOne = new Text(String.format(Locale.US, "%." + ((DoubleRadialGauge)this.getSkinnable()).getDecimalsOne() + "f", ((DoubleRadialGauge)this.getSkinnable()).getValueOne()));
        this.valueTextOne.setMouseTransparent(true);
        this.valueTextOne.setTextOrigin(VPos.CENTER);
        this.valueTextOne.getStyleClass().setAll((Object[])new String[]{"value"});
        this.titleTextTwo = new Text(((DoubleRadialGauge)this.getSkinnable()).getTitleTwo());
        this.titleTextTwo.setTextOrigin(VPos.CENTER);
        this.titleTextTwo.getStyleClass().setAll((Object[])new String[]{"title"});
        this.unitTextTwo = new Text(((DoubleRadialGauge)this.getSkinnable()).getUnitTwo());
        this.unitTextTwo.setMouseTransparent(true);
        this.unitTextTwo.setTextOrigin(VPos.CENTER);
        this.unitTextTwo.getStyleClass().setAll((Object[])new String[]{"unit"});
        this.valueTextTwo = new Text(String.format(Locale.US, "%." + ((DoubleRadialGauge)this.getSkinnable()).getDecimalsTwo() + "f", ((DoubleRadialGauge)this.getSkinnable()).getValueTwo()));
        this.valueTextTwo.setMouseTransparent(true);
        this.valueTextTwo.setTextOrigin(VPos.CENTER);
        this.valueTextTwo.getStyleClass().setAll((Object[])new String[]{"value"});
        this.pane = new Pane();
        this.pane.getChildren().setAll((Object[])new Node[]{this.background, this.ticksAndSectionsCanvas, this.titleTextOne, this.titleTextTwo, this.ledFrameOne, this.ledMainOne, this.ledHlOne, this.ledFrameTwo, this.ledMainTwo, this.ledHlTwo, this.unitTextOne, this.valueTextOne, this.unitTextTwo, this.valueTextTwo, this.shadowGroup});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((DoubleRadialGauge)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((DoubleRadialGauge)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((DoubleRadialGauge)this.getSkinnable()).ledOnOneProperty().addListener(observable -> this.ledMainOne.setEffect((Effect)(((DoubleRadialGauge)this.getSkinnable()).getLedOnOne() ? this.glow : this.innerShadow)));
        ((DoubleRadialGauge)this.getSkinnable()).ledColorOneProperty().addListener(observable -> this.handleControlPropertyChanged("LED_COLOR_ONE"));
        ((DoubleRadialGauge)this.getSkinnable()).ledVisibleOneProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((DoubleRadialGauge)this.getSkinnable()).valueVisibleOneProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((DoubleRadialGauge)this.getSkinnable()).tickLabelOrientationOneProperty().addListener(observable -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((DoubleRadialGauge)this.getSkinnable()).tickLabelFillOneProperty().addListener(observable -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((DoubleRadialGauge)this.getSkinnable()).tickMarkFillOneProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((DoubleRadialGauge)this.getSkinnable()).needleColorOneProperty().addListener(observable -> this.handleControlPropertyChanged("NEEDLE_COLOR_ONE"));
        ((DoubleRadialGauge)this.getSkinnable()).numberFormatOneProperty().addListener(observable -> this.handleControlPropertyChanged("RECALC"));
        ((DoubleRadialGauge)this.getSkinnable()).getSectionsOne().addListener(change -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((DoubleRadialGauge)this.getSkinnable()).getAreasOne().addListener(change -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((DoubleRadialGauge)this.getSkinnable()).ledOnTwoProperty().addListener(observable -> this.ledMainTwo.setEffect((Effect)(((DoubleRadialGauge)this.getSkinnable()).getLedOnTwo() ? this.glow : this.innerShadow)));
        ((DoubleRadialGauge)this.getSkinnable()).ledColorTwoProperty().addListener(observable -> this.handleControlPropertyChanged("LED_COLOR_TWO"));
        ((DoubleRadialGauge)this.getSkinnable()).ledVisibleTwoProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((DoubleRadialGauge)this.getSkinnable()).valueVisibleTwoProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((DoubleRadialGauge)this.getSkinnable()).tickLabelOrientationTwoProperty().addListener(observable -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((DoubleRadialGauge)this.getSkinnable()).tickLabelFillTwoProperty().addListener(observable -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((DoubleRadialGauge)this.getSkinnable()).tickMarkFillTwoProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((DoubleRadialGauge)this.getSkinnable()).needleColorTwoProperty().addListener(observable -> this.handleControlPropertyChanged("NEEDLE_COLOR_TWO"));
        ((DoubleRadialGauge)this.getSkinnable()).numberFormatTwoProperty().addListener(observable -> this.handleControlPropertyChanged("RECALC"));
        ((DoubleRadialGauge)this.getSkinnable()).getSectionsTwo().addListener(change -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((DoubleRadialGauge)this.getSkinnable()).getAreasTwo().addListener(change -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((DoubleRadialGauge)this.getSkinnable()).dropShadowEnabledProperty().addListener(observable -> this.handleControlPropertyChanged("DROP_SHADOW"));
        ((DoubleRadialGauge)this.getSkinnable()).animatedProperty().addListener(observable -> this.handleControlPropertyChanged("ANIMATED"));
        ((DoubleRadialGauge)this.getSkinnable()).valueOneProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.withinSpeedLimitOne = !Instant.now().minusMillis((long)((DoubleRadialGauge)this.getSkinnable()).getAnimationDuration()).isBefore(this.lastCallOne);
            this.lastCallOne = Instant.now();
            this.oldValueOne = OLD_VALUE.doubleValue();
            this.rotateNeedleOne();
        });
        ((DoubleRadialGauge)this.getSkinnable()).minValueOneProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.angleStepOne = ((DoubleRadialGauge)this.getSkinnable()).getAngleRangeOne() / (((DoubleRadialGauge)this.getSkinnable()).getMaxValueOne() - NEW_VALUE.doubleValue());
            this.needleOneRotate.setAngle(180.0 - ((DoubleRadialGauge)this.getSkinnable()).getStartAngleOne() + (((DoubleRadialGauge)this.getSkinnable()).getValueOne() - NEW_VALUE.doubleValue()) * this.angleStepOne);
            if (((DoubleRadialGauge)this.getSkinnable()).getValueOne() < NEW_VALUE.doubleValue()) {
                ((DoubleRadialGauge)this.getSkinnable()).setValueOne(NEW_VALUE.doubleValue());
                this.oldValueOne = NEW_VALUE.doubleValue();
            }
        });
        ((DoubleRadialGauge)this.getSkinnable()).maxValueOneProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.angleStepOne = ((DoubleRadialGauge)this.getSkinnable()).getAngleRangeOne() / (NEW_VALUE.doubleValue() - ((DoubleRadialGauge)this.getSkinnable()).getMinValueOne());
            this.needleOneRotate.setAngle(180.0 - ((DoubleRadialGauge)this.getSkinnable()).getStartAngleOne() + (((DoubleRadialGauge)this.getSkinnable()).getValueOne() - ((DoubleRadialGauge)this.getSkinnable()).getMinValueOne()) * this.angleStepOne);
            if (((DoubleRadialGauge)this.getSkinnable()).getValueOne() > NEW_VALUE.doubleValue()) {
                ((DoubleRadialGauge)this.getSkinnable()).setValueOne(NEW_VALUE.doubleValue());
                this.oldValueOne = NEW_VALUE.doubleValue();
            }
        });
        ((DoubleRadialGauge)this.getSkinnable()).valueTwoProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.withinSpeedLimitTwo = !Instant.now().minusMillis((long)((DoubleRadialGauge)this.getSkinnable()).getAnimationDuration()).isBefore(this.lastCallTwo);
            this.lastCallTwo = Instant.now();
            this.oldValueTwo = OLD_VALUE.doubleValue();
            this.rotateNeedleTwo();
        });
        ((DoubleRadialGauge)this.getSkinnable()).minValueTwoProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.angleStepTwo = ((DoubleRadialGauge)this.getSkinnable()).getAngleRangeTwo() / (((DoubleRadialGauge)this.getSkinnable()).getMaxValueTwo() - NEW_VALUE.doubleValue());
            this.needleTwoRotate.setAngle(180.0 - ((DoubleRadialGauge)this.getSkinnable()).getStartAngleTwo() + (((DoubleRadialGauge)this.getSkinnable()).getValueTwo() - NEW_VALUE.doubleValue()) * this.angleStepTwo);
            if (((DoubleRadialGauge)this.getSkinnable()).getValueTwo() < NEW_VALUE.doubleValue()) {
                ((DoubleRadialGauge)this.getSkinnable()).setValueTwo(NEW_VALUE.doubleValue());
                this.oldValueTwo = NEW_VALUE.doubleValue();
            }
        });
        ((DoubleRadialGauge)this.getSkinnable()).maxValueTwoProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.angleStepTwo = ((DoubleRadialGauge)this.getSkinnable()).getAngleRangeTwo() / (NEW_VALUE.doubleValue() - ((DoubleRadialGauge)this.getSkinnable()).getMinValueTwo());
            this.needleTwoRotate.setAngle(180.0 - ((DoubleRadialGauge)this.getSkinnable()).getStartAngleTwo() + (((DoubleRadialGauge)this.getSkinnable()).getValueTwo() - ((DoubleRadialGauge)this.getSkinnable()).getMinValueTwo()) * this.angleStepTwo);
            if (((DoubleRadialGauge)this.getSkinnable()).getValueTwo() > NEW_VALUE.doubleValue()) {
                ((DoubleRadialGauge)this.getSkinnable()).setValueTwo(NEW_VALUE.doubleValue());
                this.oldValueTwo = NEW_VALUE.doubleValue();
            }
        });
        this.needleOneRotate.angleProperty().addListener(observable -> this.handleControlPropertyChanged("ANGLE_ONE"));
        this.needleTwoRotate.angleProperty().addListener(observable -> this.handleControlPropertyChanged("ANGLE_TWO"));
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("ANGLE_ONE".equals(PROPERTY)) {
            double currentValueOne = (this.needleOneRotate.getAngle() + ((DoubleRadialGauge)this.getSkinnable()).getStartAngleOne() - 180.0) / this.angleStepOne + ((DoubleRadialGauge)this.getSkinnable()).getMinValueOne();
            this.valueTextOne.setText(this.limitString + String.format(Locale.US, "%." + ((DoubleRadialGauge)this.getSkinnable()).getDecimalsOne() + "f", currentValueOne));
            this.valueTextOne.setTranslateX((this.size - this.valueTextOne.getLayoutBounds().getWidth()) * 0.35);
        } else if ("ANGLE_TWO".equals(PROPERTY)) {
            double currentValueTwo = (this.needleTwoRotate.getAngle() + ((DoubleRadialGauge)this.getSkinnable()).getStartAngleTwo() - 180.0) / this.angleStepTwo + ((DoubleRadialGauge)this.getSkinnable()).getMinValueTwo();
            this.valueTextTwo.setText(this.limitString + String.format(Locale.US, "%." + ((DoubleRadialGauge)this.getSkinnable()).getDecimalsTwo() + "f", currentValueTwo));
            this.valueTextTwo.setTranslateX((this.size - this.valueTextTwo.getLayoutBounds().getWidth()) * 0.65);
        } else if ("DROP_SHADOW".equals(PROPERTY)) {
            this.shadowGroup.setEffect((Effect)(((DoubleRadialGauge)this.getSkinnable()).isDropShadowEnabled() ? this.dropShadow : null));
        } else if ("CANVAS_REFRESH".equals(PROPERTY)) {
            this.ticksAndSections.clearRect(0.0, 0.0, this.size, this.size);
            this.drawSections(this.ticksAndSections);
            this.drawAreas(this.ticksAndSections);
            this.drawTickMarks(this.ticksAndSections);
        } else if ("NEEDLE_COLOR_ONE".equals(PROPERTY)) {
            this.needleOne.setStyle("-needle-color-one: " + this.colorToCss(((DoubleRadialGauge)this.getSkinnable()).getNeedleColorOne()) + ";");
            this.resize();
        } else if ("LED_COLOR".equals(PROPERTY)) {
            this.ledMainOne.setStyle("-led-color-one: " + this.colorToCss(((DoubleRadialGauge)this.getSkinnable()).getLedColorOne()));
            this.resize();
        } else if ("NEEDLE_COLOR_TWO".equals(PROPERTY)) {
            this.needleTwo.setStyle("-needle-color-two: " + this.colorToCss(((DoubleRadialGauge)this.getSkinnable()).getNeedleColorTwo()) + ";");
            this.resize();
        } else if ("LED_COLOR_TWO".equals(PROPERTY)) {
            this.ledMainTwo.setStyle("-led-color-two: " + this.colorToCss(((DoubleRadialGauge)this.getSkinnable()).getLedColorTwo()));
            this.resize();
        }
    }

    private String colorToCss(Color COLOR) {
        return COLOR.toString().replace("0x", "#");
    }

    private void rotateNeedleOne() {
        this.timelineOne.stop();
        this.angleStepOne = ((DoubleRadialGauge)this.getSkinnable()).getAngleRangeOne() / (((DoubleRadialGauge)this.getSkinnable()).getMaxValueOne() - ((DoubleRadialGauge)this.getSkinnable()).getMinValueOne());
        double targetAngle = 180.0 - ((DoubleRadialGauge)this.getSkinnable()).getStartAngleOne() + (((DoubleRadialGauge)this.getSkinnable()).getValueOne() - ((DoubleRadialGauge)this.getSkinnable()).getMinValueOne()) * this.angleStepOne;
        targetAngle = this.clamp(180.0 - ((DoubleRadialGauge)this.getSkinnable()).getStartAngleOne(), 180.0 - ((DoubleRadialGauge)this.getSkinnable()).getStartAngleOne() + ((DoubleRadialGauge)this.getSkinnable()).getAngleRangeOne(), targetAngle);
        if (this.withinSpeedLimitOne && ((DoubleRadialGauge)this.getSkinnable()).isAnimated()) {
            KeyValue KEY_VALUE = new KeyValue((WritableValue)this.needleOneRotate.angleProperty(), (Object)targetAngle, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
            KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)((DoubleRadialGauge)this.getSkinnable()).getAnimationDuration()), new KeyValue[]{KEY_VALUE});
            this.timelineOne.getKeyFrames().setAll((Object[])new KeyFrame[]{KEY_FRAME});
            this.timelineOne.play();
        } else {
            this.needleOneRotate.setAngle(targetAngle);
        }
    }

    private void rotateNeedleTwo() {
        this.timelineTwo.stop();
        this.angleStepTwo = -((DoubleRadialGauge)this.getSkinnable()).getAngleRangeTwo() / (((DoubleRadialGauge)this.getSkinnable()).getMaxValueTwo() - ((DoubleRadialGauge)this.getSkinnable()).getMinValueTwo());
        double targetAngle = 180.0 - ((DoubleRadialGauge)this.getSkinnable()).getStartAngleTwo() + (((DoubleRadialGauge)this.getSkinnable()).getValueTwo() - ((DoubleRadialGauge)this.getSkinnable()).getMinValueTwo()) * this.angleStepTwo;
        targetAngle = this.clamp(180.0 - ((DoubleRadialGauge)this.getSkinnable()).getStartAngleTwo() - ((DoubleRadialGauge)this.getSkinnable()).getAngleRangeTwo(), 180.0 - ((DoubleRadialGauge)this.getSkinnable()).getStartAngleTwo(), targetAngle);
        if (this.withinSpeedLimitTwo && ((DoubleRadialGauge)this.getSkinnable()).isAnimated()) {
            KeyValue KEY_VALUE = new KeyValue((WritableValue)this.needleTwoRotate.angleProperty(), (Object)targetAngle, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
            KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)((DoubleRadialGauge)this.getSkinnable()).getAnimationDuration()), new KeyValue[]{KEY_VALUE});
            this.timelineTwo.getKeyFrames().setAll((Object[])new KeyFrame[]{KEY_FRAME});
            this.timelineTwo.play();
        } else {
            this.needleTwoRotate.setAngle(targetAngle);
        }
    }

    private void drawTickMarks(GraphicsContext CTX) {
        Point2D textPoint;
        Point2D outerPoint;
        Point2D innerMinorPoint;
        Point2D innerMediumPoint;
        Point2D innerMainPoint;
        double cosValue;
        double sinValue;
        double startAngle = ((DoubleRadialGauge)this.getSkinnable()).getStartAngleOne();
        double orthText = DoubleRadialGauge.TickLabelOrientation.ORTHOGONAL == ((DoubleRadialGauge)this.getSkinnable()).getTickLabelOrientationOne() ? 0.35 : 0.33;
        Point2D center = new Point2D(this.size * 0.5, this.size * 0.5);
        boolean smallRange = ((DoubleRadialGauge)this.getSkinnable()).getMaxValueOne() - ((DoubleRadialGauge)this.getSkinnable()).getMinValueOne() < 10.0;
        double tmpMinValue = smallRange ? ((DoubleRadialGauge)this.getSkinnable()).getMinValueOne() * 10.0 : ((DoubleRadialGauge)this.getSkinnable()).getMinValueOne();
        double tmpMaxValue = smallRange ? ((DoubleRadialGauge)this.getSkinnable()).getMaxValueOne() * 10.0 : ((DoubleRadialGauge)this.getSkinnable()).getMaxValueOne();
        double tmpAngleStep = smallRange ? this.angleStepOne / 10.0 : this.angleStepOne;
        double angle = 0.0;
        double counter = tmpMinValue;
        while (Double.compare(counter, tmpMaxValue) <= 0) {
            sinValue = Math.sin(Math.toRadians(angle + startAngle));
            cosValue = Math.cos(Math.toRadians(angle + startAngle));
            innerMainPoint = new Point2D(center.getX() + this.size * 0.368 * sinValue, center.getY() + this.size * 0.368 * cosValue);
            innerMediumPoint = new Point2D(center.getX() + this.size * 0.388 * sinValue, center.getY() + this.size * 0.388 * cosValue);
            innerMinorPoint = new Point2D(center.getX() + this.size * 0.3975 * sinValue, center.getY() + this.size * 0.3975 * cosValue);
            outerPoint = new Point2D(center.getX() + this.size * 0.432 * sinValue, center.getY() + this.size * 0.432 * cosValue);
            textPoint = new Point2D(center.getX() + this.size * orthText * sinValue, center.getY() + this.size * orthText * cosValue);
            CTX.setStroke(((DoubleRadialGauge)this.getSkinnable()).getTickMarkFillOne());
            if (counter % ((DoubleRadialGauge)this.getSkinnable()).getMajorTickSpaceOne() == 0.0) {
                CTX.setLineWidth(this.size * 0.0055);
                CTX.strokeLine(innerMainPoint.getX(), innerMainPoint.getY(), outerPoint.getX(), outerPoint.getY());
                CTX.save();
                CTX.translate(textPoint.getX(), textPoint.getY());
                switch (((DoubleRadialGauge)this.getSkinnable()).getTickLabelOrientationOne()) {
                    case ORTHOGONAL: {
                        if ((360.0 - startAngle - angle) % 360.0 > 90.0 && (360.0 - startAngle - angle) % 360.0 < 270.0) {
                            CTX.rotate((180.0 - startAngle - angle) % 360.0);
                            break;
                        }
                        CTX.rotate((360.0 - startAngle - angle) % 360.0);
                        break;
                    }
                    case TANGENT: {
                        if ((360.0 - startAngle - angle - 90.0) % 360.0 > 90.0 && (360.0 - startAngle - angle - 90.0) % 360.0 < 270.0) {
                            CTX.rotate((90.0 - startAngle - angle) % 360.0);
                            break;
                        }
                        CTX.rotate((270.0 - startAngle - angle) % 360.0);
                        break;
                    }
                }
                CTX.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (double)(0.035 * this.size)));
                CTX.setTextAlign(TextAlignment.CENTER);
                CTX.setTextBaseline(VPos.CENTER);
                CTX.setFill(((DoubleRadialGauge)this.getSkinnable()).getTickLabelFillOne());
                CTX.fillText(Integer.toString((int)(smallRange ? counter / 10.0 : counter)), 0.0, 0.0);
                CTX.restore();
            } else if (((DoubleRadialGauge)this.getSkinnable()).getMinorTickSpaceOne() % 2.0 != 0.0 && counter % 5.0 == 0.0) {
                CTX.setLineWidth(this.size * 0.0035);
                CTX.strokeLine(innerMediumPoint.getX(), innerMediumPoint.getY(), outerPoint.getX(), outerPoint.getY());
            } else if (counter % ((DoubleRadialGauge)this.getSkinnable()).getMinorTickSpaceOne() == 0.0) {
                CTX.setLineWidth(this.size * 0.00225);
                CTX.strokeLine(innerMinorPoint.getX(), innerMinorPoint.getY(), outerPoint.getX(), outerPoint.getY());
            }
            angle -= tmpAngleStep;
            counter += 1.0;
        }
        startAngle = ((DoubleRadialGauge)this.getSkinnable()).getStartAngleTwo();
        smallRange = ((DoubleRadialGauge)this.getSkinnable()).getMaxValueTwo() - ((DoubleRadialGauge)this.getSkinnable()).getMinValueTwo() < 10.0;
        tmpMinValue = smallRange ? ((DoubleRadialGauge)this.getSkinnable()).getMinValueTwo() * 10.0 : ((DoubleRadialGauge)this.getSkinnable()).getMinValueTwo();
        tmpMaxValue = smallRange ? ((DoubleRadialGauge)this.getSkinnable()).getMaxValueTwo() * 10.0 : ((DoubleRadialGauge)this.getSkinnable()).getMaxValueTwo();
        tmpAngleStep = smallRange ? this.angleStepTwo / 10.0 : this.angleStepTwo;
        angle = 0.0;
        counter = tmpMinValue;
        while (Double.compare(counter, tmpMaxValue) <= 0) {
            sinValue = Math.sin(Math.toRadians(angle + startAngle));
            cosValue = Math.cos(Math.toRadians(angle + startAngle));
            innerMainPoint = new Point2D(center.getX() + this.size * 0.368 * sinValue, center.getY() + this.size * 0.368 * cosValue);
            innerMediumPoint = new Point2D(center.getX() + this.size * 0.388 * sinValue, center.getY() + this.size * 0.388 * cosValue);
            innerMinorPoint = new Point2D(center.getX() + this.size * 0.3975 * sinValue, center.getY() + this.size * 0.3975 * cosValue);
            outerPoint = new Point2D(center.getX() + this.size * 0.432 * sinValue, center.getY() + this.size * 0.432 * cosValue);
            textPoint = new Point2D(center.getX() + this.size * orthText * sinValue, center.getY() + this.size * orthText * cosValue);
            CTX.setStroke(((DoubleRadialGauge)this.getSkinnable()).getTickMarkFillTwo());
            if (counter % ((DoubleRadialGauge)this.getSkinnable()).getMajorTickSpaceTwo() == 0.0) {
                CTX.setLineWidth(this.size * 0.0055);
                CTX.strokeLine(innerMainPoint.getX(), innerMainPoint.getY(), outerPoint.getX(), outerPoint.getY());
                CTX.save();
                CTX.translate(textPoint.getX(), textPoint.getY());
                switch (((DoubleRadialGauge)this.getSkinnable()).getTickLabelOrientationTwo()) {
                    case ORTHOGONAL: {
                        if ((360.0 - startAngle - angle) % 360.0 > 90.0 && (360.0 - startAngle - angle) % 360.0 < 270.0) {
                            CTX.rotate((180.0 - startAngle - angle) % 360.0);
                            break;
                        }
                        CTX.rotate((360.0 - startAngle - angle) % 360.0);
                        break;
                    }
                    case TANGENT: {
                        if ((360.0 - startAngle - angle - 90.0) % 360.0 > 90.0 && (360.0 - startAngle - angle - 90.0) % 360.0 < 270.0) {
                            CTX.rotate((90.0 - startAngle - angle) % 360.0);
                            break;
                        }
                        CTX.rotate((270.0 - startAngle - angle) % 360.0);
                        break;
                    }
                }
                CTX.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (double)(0.035 * this.size)));
                CTX.setTextAlign(TextAlignment.CENTER);
                CTX.setTextBaseline(VPos.CENTER);
                CTX.setFill(((DoubleRadialGauge)this.getSkinnable()).getTickLabelFillTwo());
                CTX.fillText(Integer.toString((int)(smallRange ? counter / 10.0 : counter)), 0.0, 0.0);
                CTX.restore();
            } else if (((DoubleRadialGauge)this.getSkinnable()).getMinorTickSpaceTwo() % 2.0 != 0.0 && counter % 5.0 == 0.0) {
                CTX.setLineWidth(this.size * 0.0035);
                CTX.strokeLine(innerMediumPoint.getX(), innerMediumPoint.getY(), outerPoint.getX(), outerPoint.getY());
            } else if (counter % ((DoubleRadialGauge)this.getSkinnable()).getMinorTickSpaceTwo() == 0.0) {
                CTX.setLineWidth(this.size * 0.00225);
                CTX.strokeLine(innerMinorPoint.getX(), innerMinorPoint.getY(), outerPoint.getX(), outerPoint.getY());
            }
            angle -= tmpAngleStep;
            counter += 1.0;
        }
    }

    private final void drawSections(GraphicsContext CTX) {
        double xy = (this.size - 0.83425 * this.size) / 2.0;
        double wh = this.size * 0.83425;
        double MIN_VALUE_ONE = ((DoubleRadialGauge)this.getSkinnable()).getMinValueOne();
        double MAX_VALUE_ONE = ((DoubleRadialGauge)this.getSkinnable()).getMaxValueOne();
        double OFFSET_ONE = 90.0 - ((DoubleRadialGauge)this.getSkinnable()).getStartAngleOne();
        IntStream.range(0, ((DoubleRadialGauge)this.getSkinnable()).getSectionsOne().size()).parallel().forEachOrdered(i -> {
            Section SECTION = (Section)((DoubleRadialGauge)this.getSkinnable()).getSectionsOne().get(i);
            if (Double.compare(SECTION.getStart(), MAX_VALUE_ONE) <= 0 && Double.compare(SECTION.getStop(), MIN_VALUE_ONE) >= 0) {
                double SECTION_START_ANGLE = SECTION.getStart() < MIN_VALUE_ONE && SECTION.getStop() < MAX_VALUE_ONE ? MIN_VALUE_ONE * this.angleStepOne : (SECTION.getStart() - MIN_VALUE_ONE) * this.angleStepOne;
                double SECTION_ANGLE_EXTEND = SECTION.getStop() > MAX_VALUE_ONE ? (MAX_VALUE_ONE - SECTION.getStart()) * this.angleStepOne : (SECTION.getStop() - SECTION.getStart()) * this.angleStepOne;
                CTX.save();
                switch (i) {
                    case 0: {
                        CTX.setStroke((Paint)((DoubleRadialGauge)this.getSkinnable()).getSectionFill0One());
                        break;
                    }
                    case 1: {
                        CTX.setStroke((Paint)((DoubleRadialGauge)this.getSkinnable()).getSectionFill1One());
                        break;
                    }
                    case 2: {
                        CTX.setStroke((Paint)((DoubleRadialGauge)this.getSkinnable()).getSectionFill2One());
                        break;
                    }
                    case 3: {
                        CTX.setStroke((Paint)((DoubleRadialGauge)this.getSkinnable()).getSectionFill3One());
                        break;
                    }
                    case 4: {
                        CTX.setStroke((Paint)((DoubleRadialGauge)this.getSkinnable()).getSectionFill4One());
                    }
                }
                CTX.setLineWidth(this.size * 0.0415);
                CTX.setLineCap(StrokeLineCap.BUTT);
                CTX.strokeArc(xy, xy, wh, wh, -(OFFSET_ONE + SECTION_START_ANGLE), -SECTION_ANGLE_EXTEND, ArcType.OPEN);
                CTX.restore();
            }
        });
        double MIN_VALUE_TWO = ((DoubleRadialGauge)this.getSkinnable()).getMinValueTwo();
        double MAX_VALUE_TWO = ((DoubleRadialGauge)this.getSkinnable()).getMaxValueTwo();
        double OFFSET_TWO = 90.0 - ((DoubleRadialGauge)this.getSkinnable()).getStartAngleTwo();
        IntStream.range(0, ((DoubleRadialGauge)this.getSkinnable()).getSectionsTwo().size()).parallel().forEachOrdered(i -> {
            Section SECTION = (Section)((DoubleRadialGauge)this.getSkinnable()).getSectionsTwo().get(i);
            if (Double.compare(SECTION.getStart(), MAX_VALUE_TWO) <= 0 && Double.compare(SECTION.getStop(), MIN_VALUE_TWO) >= 0) {
                double SECTION_START_ANGLE = SECTION.getStart() < MIN_VALUE_TWO && SECTION.getStop() < MAX_VALUE_TWO ? MIN_VALUE_TWO * this.angleStepTwo : (SECTION.getStart() - MIN_VALUE_TWO) * this.angleStepTwo;
                double SECTION_ANGLE_EXTEND = SECTION.getStop() > MAX_VALUE_TWO ? (MAX_VALUE_TWO - SECTION.getStart()) * this.angleStepTwo : (SECTION.getStop() - SECTION.getStart()) * this.angleStepTwo;
                CTX.save();
                switch (i) {
                    case 0: {
                        CTX.setStroke((Paint)((DoubleRadialGauge)this.getSkinnable()).getSectionFill0Two());
                        break;
                    }
                    case 1: {
                        CTX.setStroke((Paint)((DoubleRadialGauge)this.getSkinnable()).getSectionFill1Two());
                        break;
                    }
                    case 2: {
                        CTX.setStroke((Paint)((DoubleRadialGauge)this.getSkinnable()).getSectionFill2Two());
                        break;
                    }
                    case 3: {
                        CTX.setStroke((Paint)((DoubleRadialGauge)this.getSkinnable()).getSectionFill3Two());
                        break;
                    }
                    case 4: {
                        CTX.setStroke((Paint)((DoubleRadialGauge)this.getSkinnable()).getSectionFill4Two());
                    }
                }
                CTX.setLineWidth(this.size * 0.0415);
                CTX.setLineCap(StrokeLineCap.BUTT);
                CTX.strokeArc(xy, xy, wh, wh, -(OFFSET_TWO + SECTION_START_ANGLE), -SECTION_ANGLE_EXTEND, ArcType.OPEN);
                CTX.restore();
            }
        });
    }

    private final void drawAreas(GraphicsContext CTX) {
        double xy = (this.size - 0.7925 * this.size) / 2.0;
        double wh = this.size * 0.7925;
        double MIN_VALUE_ONE = ((DoubleRadialGauge)this.getSkinnable()).getMinValueOne();
        double MAX_VALUE_ONE = ((DoubleRadialGauge)this.getSkinnable()).getMaxValueOne();
        double OFFSET_ONE = 90.0 - ((DoubleRadialGauge)this.getSkinnable()).getStartAngleOne();
        IntStream.range(0, ((DoubleRadialGauge)this.getSkinnable()).getAreasOne().size()).parallel().forEachOrdered(i -> {
            Section AREA = (Section)((DoubleRadialGauge)this.getSkinnable()).getAreasOne().get(i);
            if (Double.compare(AREA.getStart(), MAX_VALUE_ONE) <= 0 && Double.compare(AREA.getStop(), MIN_VALUE_ONE) >= 0) {
                double AREA_START_ANGLE = AREA.getStart() < MIN_VALUE_ONE && AREA.getStop() < MAX_VALUE_ONE ? MIN_VALUE_ONE * this.angleStepOne : (AREA.getStart() - MIN_VALUE_ONE) * this.angleStepOne;
                double AREA_ANGLE_EXTEND = AREA.getStop() > MAX_VALUE_ONE ? (MAX_VALUE_ONE - AREA.getStart()) * this.angleStepOne : (AREA.getStop() - AREA.getStart()) * this.angleStepOne;
                CTX.save();
                switch (i) {
                    case 0: {
                        CTX.setFill((Paint)((DoubleRadialGauge)this.getSkinnable()).getAreaFill0One());
                        break;
                    }
                    case 1: {
                        CTX.setFill((Paint)((DoubleRadialGauge)this.getSkinnable()).getAreaFill1One());
                        break;
                    }
                    case 2: {
                        CTX.setFill((Paint)((DoubleRadialGauge)this.getSkinnable()).getAreaFill2One());
                        break;
                    }
                    case 3: {
                        CTX.setFill((Paint)((DoubleRadialGauge)this.getSkinnable()).getAreaFill3One());
                        break;
                    }
                    case 4: {
                        CTX.setFill((Paint)((DoubleRadialGauge)this.getSkinnable()).getAreaFill4One());
                    }
                }
                CTX.fillArc(xy, xy, wh, wh, -(OFFSET_ONE + AREA_START_ANGLE), -AREA_ANGLE_EXTEND, ArcType.ROUND);
                CTX.restore();
            }
        });
        double MIN_VALUE_TWO = ((DoubleRadialGauge)this.getSkinnable()).getMinValueTwo();
        double MAX_VALUE_TWO = ((DoubleRadialGauge)this.getSkinnable()).getMaxValueTwo();
        double OFFSET_TWO = 90.0 - ((DoubleRadialGauge)this.getSkinnable()).getStartAngleTwo();
        IntStream.range(0, ((DoubleRadialGauge)this.getSkinnable()).getAreasTwo().size()).parallel().forEachOrdered(i -> {
            Section AREA = (Section)((DoubleRadialGauge)this.getSkinnable()).getAreasTwo().get(i);
            if (Double.compare(AREA.getStart(), MAX_VALUE_TWO) <= 0 && Double.compare(AREA.getStop(), MIN_VALUE_TWO) >= 0) {
                double AREA_START_ANGLE = AREA.getStart() < MIN_VALUE_TWO && AREA.getStop() < MAX_VALUE_TWO ? MIN_VALUE_TWO * this.angleStepTwo : (AREA.getStart() - MIN_VALUE_TWO) * this.angleStepTwo;
                double AREA_ANGLE_EXTEND = AREA.getStop() > MAX_VALUE_TWO ? (MAX_VALUE_TWO - AREA.getStart()) * this.angleStepTwo : (AREA.getStop() - AREA.getStart()) * this.angleStepTwo;
                CTX.save();
                switch (i) {
                    case 0: {
                        CTX.setFill((Paint)((DoubleRadialGauge)this.getSkinnable()).getAreaFill0Two());
                        break;
                    }
                    case 1: {
                        CTX.setFill((Paint)((DoubleRadialGauge)this.getSkinnable()).getAreaFill1Two());
                        break;
                    }
                    case 2: {
                        CTX.setFill((Paint)((DoubleRadialGauge)this.getSkinnable()).getAreaFill2Two());
                        break;
                    }
                    case 3: {
                        CTX.setFill((Paint)((DoubleRadialGauge)this.getSkinnable()).getAreaFill3Two());
                        break;
                    }
                    case 4: {
                        CTX.setFill((Paint)((DoubleRadialGauge)this.getSkinnable()).getAreaFill4Two());
                    }
                }
                CTX.fillArc(xy, xy, wh, wh, -(OFFSET_TWO + AREA_START_ANGLE), -AREA_ANGLE_EXTEND, ArcType.ROUND);
                CTX.restore();
            }
        });
    }

    private double clamp(double MIN_VALUE, double MAX_VALUE, double VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    private void resizeText() {
        this.titleTextOne.setFont(Fonts.robotoMedium(this.size * 0.04));
        this.titleTextOne.setTranslateX((this.size - this.titleTextOne.getLayoutBounds().getWidth()) * 0.35);
        this.titleTextOne.setTranslateY(this.size * 0.35);
        this.unitTextOne.setFont(Fonts.robotoMedium(this.size * 0.04));
        this.unitTextOne.setTranslateX((this.size - this.unitTextOne.getLayoutBounds().getWidth()) * 0.35);
        this.unitTextOne.setTranslateY(this.size * 0.84);
        this.unitTextOne.setRotate(-60.0);
        this.valueTextOne.setFont(Fonts.robotoBold(this.size * 0.04));
        this.valueTextOne.setTranslateX((this.size - this.valueTextOne.getLayoutBounds().getWidth()) * 0.35);
        this.valueTextOne.setTranslateY(this.size * 0.65);
        this.valueTextOne.setVisible(((DoubleRadialGauge)this.getSkinnable()).isValueVisibleOne());
        this.titleTextTwo.setFont(Fonts.robotoMedium(this.size * 0.04));
        this.titleTextTwo.setTranslateX((this.size - this.titleTextTwo.getLayoutBounds().getWidth()) * 0.65);
        this.titleTextTwo.setTranslateY(this.size * 0.35);
        this.unitTextTwo.setFont(Fonts.robotoMedium(this.size * 0.04));
        this.unitTextTwo.setTranslateX((this.size - this.unitTextTwo.getLayoutBounds().getWidth()) * 0.65);
        this.unitTextTwo.setTranslateY(this.size * 0.84);
        this.unitTextTwo.setRotate(60.0);
        this.valueTextTwo.setFont(Fonts.robotoBold(this.size * 0.04));
        this.valueTextTwo.setTranslateX((this.size - this.valueTextTwo.getLayoutBounds().getWidth()) * 0.65);
        this.valueTextTwo.setTranslateY(this.size * 0.65);
        this.valueTextTwo.setVisible(((DoubleRadialGauge)this.getSkinnable()).isValueVisibleTwo());
    }

    private void resize() {
        double d = this.size = ((DoubleRadialGauge)this.getSkinnable()).getWidth() < ((DoubleRadialGauge)this.getSkinnable()).getHeight() ? ((DoubleRadialGauge)this.getSkinnable()).getWidth() : ((DoubleRadialGauge)this.getSkinnable()).getHeight();
        if (this.size > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((((DoubleRadialGauge)this.getSkinnable()).getWidth() - this.size) * 0.5, (((DoubleRadialGauge)this.getSkinnable()).getHeight() - this.size) * 0.5);
            this.dropShadow.setRadius(0.01 * this.size);
            this.dropShadow.setOffsetY(0.01 * this.size);
            this.background.setPrefSize(this.size, this.size);
            this.background.setStyle("-fx-background-insets: 0, " + 0.02 * this.size + ", " + 0.022 * this.size + ", " + 0.038 * this.size + ";");
            this.ticksAndSectionsCanvas.setWidth(this.size);
            this.ticksAndSectionsCanvas.setHeight(this.size);
            this.ticksAndSections.clearRect(0.0, 0.0, this.size, this.size);
            if (((DoubleRadialGauge)this.getSkinnable()).getSectionsVisibleOne()) {
                this.drawSections(this.ticksAndSections);
            }
            if (((DoubleRadialGauge)this.getSkinnable()).getAreasVisibleOne()) {
                this.drawAreas(this.ticksAndSections);
            }
            this.drawTickMarks(this.ticksAndSections);
            this.ticksAndSectionsCanvas.setCache(true);
            this.ticksAndSectionsCanvas.setCacheHint(CacheHint.QUALITY);
            this.innerShadow.setRadius(0.01 * this.size);
            this.glow.setRadius(0.05 * this.size);
            this.glow.setColor(((DoubleRadialGauge)this.getSkinnable()).getLedColorOne());
            this.ledFrameOne.setPrefSize(0.06 * this.size, 0.06 * this.size);
            this.ledFrameOne.relocate(0.33 * this.size, 0.11 * this.size);
            this.ledMainOne.setPrefSize(0.0432 * this.size, 0.0432 * this.size);
            this.ledMainOne.relocate(0.33 * this.size + 0.0084 * this.size, 0.11 * this.size + 0.0084 * this.size);
            this.ledHlOne.setPrefSize(0.0348 * this.size, 0.0348 * this.size);
            this.ledHlOne.relocate(0.33 * this.size + 0.0126 * this.size, 0.11 * this.size + 0.0126 * this.size);
            this.ledFrameTwo.setPrefSize(0.06 * this.size, 0.06 * this.size);
            this.ledFrameTwo.relocate(0.61 * this.size, 0.11 * this.size);
            this.ledMainTwo.setPrefSize(0.0432 * this.size, 0.0432 * this.size);
            this.ledMainTwo.relocate(0.61 * this.size + 0.0084 * this.size, 0.11 * this.size + 0.0084 * this.size);
            this.ledHlTwo.setPrefSize(0.0348 * this.size, 0.0348 * this.size);
            this.ledHlTwo.relocate(0.61 * this.size + 0.0126 * this.size, 0.11 * this.size + 0.0126 * this.size);
            boolean ledOneVisible = ((DoubleRadialGauge)this.getSkinnable()).getLedVisibleOne();
            this.ledFrameOne.setManaged(ledOneVisible);
            this.ledFrameOne.setVisible(ledOneVisible);
            this.ledMainOne.setManaged(ledOneVisible);
            this.ledMainOne.setVisible(ledOneVisible);
            this.ledHlOne.setManaged(ledOneVisible);
            this.ledHlOne.setVisible(ledOneVisible);
            boolean ledTwoVisible = ((DoubleRadialGauge)this.getSkinnable()).getLedVisibleTwo();
            this.ledFrameTwo.setManaged(ledTwoVisible);
            this.ledFrameTwo.setVisible(ledTwoVisible);
            this.ledMainTwo.setManaged(ledTwoVisible);
            this.ledMainTwo.setVisible(ledTwoVisible);
            this.ledHlTwo.setManaged(ledTwoVisible);
            this.ledHlTwo.setVisible(ledTwoVisible);
            this.needleOne.setStyle("-needle-color-one: " + this.colorToCss(((DoubleRadialGauge)this.getSkinnable()).getNeedleColorOne()) + ";");
            this.needleOne.setPrefSize(this.size * 0.04, this.size * 0.425);
            this.needleOne.relocate((this.size - this.needleOne.getPrefWidth()) * 0.5, this.size * 0.5 - this.needleOne.getPrefHeight());
            this.needleOneRotate.setPivotX(this.needleOne.getPrefWidth() * 0.5);
            this.needleOneRotate.setPivotY(this.needleOne.getPrefHeight());
            this.needleOneHighlight.setPrefSize(this.size * 0.04, this.size * 0.425);
            this.needleOneHighlight.setTranslateX((this.size - this.needleOne.getPrefWidth()) * 0.5);
            this.needleOneHighlight.setTranslateY(this.size * 0.5 - this.needleOne.getPrefHeight());
            this.needleTwo.setStyle("-needle-color-two: " + this.colorToCss(((DoubleRadialGauge)this.getSkinnable()).getNeedleColorTwo()) + ";");
            this.needleTwo.setPrefSize(this.size * 0.04, this.size * 0.425);
            this.needleTwo.relocate((this.size - this.needleTwo.getPrefWidth()) * 0.5, this.size * 0.5 - this.needleTwo.getPrefHeight());
            this.needleTwoRotate.setPivotX(this.needleTwo.getPrefWidth() * 0.5);
            this.needleTwoRotate.setPivotY(this.needleTwo.getPrefHeight());
            this.needleTwoHighlight.setPrefSize(this.size * 0.04, this.size * 0.425);
            this.needleTwoHighlight.setTranslateX((this.size - this.needleTwo.getPrefWidth()) * 0.5);
            this.needleTwoHighlight.setTranslateY(this.size * 0.5 - this.needleTwo.getPrefHeight());
            this.knob.setPrefSize(this.size * 0.15, this.size * 0.15);
            this.knob.setTranslateX((this.size - this.knob.getPrefWidth()) * 0.5);
            this.knob.setTranslateY((this.size - this.knob.getPrefHeight()) * 0.5);
            this.resizeText();
        }
    }
}

