/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge.skin;

import eu.hansolo.enzo.common.Section;
import eu.hansolo.enzo.fonts.Fonts;
import eu.hansolo.enzo.gauge.RectangularGauge;
import java.time.Instant;
import java.util.Locale;
import java.util.stream.IntStream;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.util.Duration;

public class RectangularGaugeSkin
extends SkinBase<RectangularGauge>
implements Skin<RectangularGauge> {
    private static final double PREFERRED_WIDTH = 310.0;
    private static final double PREFERRED_HEIGHT = 260.0;
    private static final double MINIMUM_WIDTH = 31.0;
    private static final double MINIMUM_HEIGHT = 26.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 858.0;
    private double aspectRatio = 0.8387096774193549;
    private double oldValue;
    private double width;
    private double height;
    private Pane pane;
    private Region foreground;
    private Canvas ticksAndSectionsCanvas;
    private GraphicsContext ticksAndSections;
    private Region ledFrame;
    private Region ledMain;
    private Region ledHl;
    private Region needle;
    private Region needleHighlight;
    private Rotate needleRotate;
    private Group shadowGroup;
    private InnerShadow lightEffect;
    private DropShadow dropShadow;
    private InnerShadow innerShadow;
    private DropShadow glow;
    private Text titleText;
    private Text unitText;
    private Label lcdText;
    private double angleStep;
    private Timeline timeline;
    private String limitString;
    private Instant lastCall;
    private boolean withinSpeedLimit;

    public RectangularGaugeSkin(RectangularGauge gauge) {
        super((Control)gauge);
        this.angleStep = gauge.getAngleRange() / (gauge.getMaxValue() - gauge.getMinValue());
        this.timeline = new Timeline();
        this.oldValue = ((RectangularGauge)this.getSkinnable()).getValue();
        this.limitString = "";
        this.lastCall = Instant.now();
        this.withinSpeedLimit = true;
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((RectangularGauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((RectangularGauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((RectangularGauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((RectangularGauge)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((RectangularGauge)this.getSkinnable()).getPrefWidth() > 0.0 && ((RectangularGauge)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((RectangularGauge)this.getSkinnable()).setPrefSize(((RectangularGauge)this.getSkinnable()).getPrefWidth(), ((RectangularGauge)this.getSkinnable()).getPrefHeight());
            } else {
                ((RectangularGauge)this.getSkinnable()).setPrefSize(310.0, 260.0);
            }
        }
        if (Double.compare(((RectangularGauge)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((RectangularGauge)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((RectangularGauge)this.getSkinnable()).setMinSize(31.0, 26.0);
        }
        if (Double.compare(((RectangularGauge)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((RectangularGauge)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((RectangularGauge)this.getSkinnable()).setMaxSize(1024.0, 858.0);
        }
        if (((RectangularGauge)this.getSkinnable()).getPrefWidth() != 310.0 || ((RectangularGauge)this.getSkinnable()).getPrefHeight() != 260.0) {
            this.aspectRatio = ((RectangularGauge)this.getSkinnable()).getPrefHeight() / ((RectangularGauge)this.getSkinnable()).getPrefWidth();
        }
    }

    private void initGraphics() {
        this.ticksAndSectionsCanvas = new Canvas(310.0, 260.0);
        this.ticksAndSections = this.ticksAndSectionsCanvas.getGraphicsContext2D();
        this.innerShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 8.0, 0.0, 0.0, 0.0);
        this.glow = new DropShadow(BlurType.TWO_PASS_BOX, ((RectangularGauge)this.getSkinnable()).getLedColor(), 20.0, 0.0, 0.0, 0.0);
        this.glow.setInput((Effect)this.innerShadow);
        this.ledFrame = new Region();
        this.ledFrame.getStyleClass().setAll((Object[])new String[]{"led-frame"});
        this.ledMain = new Region();
        this.ledMain.getStyleClass().setAll((Object[])new String[]{"led-main"});
        this.ledMain.setStyle("-led-color: " + this.colorToCss(((RectangularGauge)this.getSkinnable()).getLedColor()) + ";");
        this.ledHl = new Region();
        this.ledHl.getStyleClass().setAll((Object[])new String[]{"led-hl"});
        this.needle = new Region();
        this.needle.getStyleClass().setAll((Object[])new String[]{RectangularGauge.STYLE_CLASS_NEEDLE_STANDARD});
        this.needleRotate = new Rotate(180.0 - ((RectangularGauge)this.getSkinnable()).getStartAngle());
        this.needleRotate.setAngle(this.needleRotate.getAngle() + (((RectangularGauge)this.getSkinnable()).getValue() - this.oldValue - ((RectangularGauge)this.getSkinnable()).getMinValue()) * this.angleStep);
        this.needle.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.needleHighlight = new Region();
        this.needleHighlight.setMouseTransparent(true);
        this.needleHighlight.getStyleClass().setAll((Object[])new String[]{"needle-highlight"});
        this.needleHighlight.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.dropShadow = new DropShadow();
        this.dropShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.25));
        this.dropShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.dropShadow.setRadius(4.6499999999999995);
        this.dropShadow.setOffsetY(4.6499999999999995);
        this.shadowGroup = new Group(new Node[]{this.needle, this.needleHighlight});
        this.shadowGroup.setEffect((Effect)(((RectangularGauge)this.getSkinnable()).isDropShadowEnabled() ? this.dropShadow : null));
        this.titleText = new Text(((RectangularGauge)this.getSkinnable()).getTitle());
        this.titleText.setTextOrigin(VPos.CENTER);
        this.titleText.getStyleClass().setAll((Object[])new String[]{"title"});
        this.unitText = new Text(((RectangularGauge)this.getSkinnable()).getUnit());
        this.unitText.setMouseTransparent(true);
        this.unitText.setTextOrigin(VPos.CENTER);
        this.unitText.getStyleClass().setAll((Object[])new String[]{"unit"});
        this.lcdText = new Label(String.format(Locale.US, "%." + ((RectangularGauge)this.getSkinnable()).getDecimals() + "f", ((RectangularGauge)this.getSkinnable()).getValue()));
        this.lcdText.getStyleClass().setAll((Object[])new String[]{"lcd-text"});
        this.angleStep = ((RectangularGauge)this.getSkinnable()).getAngleRange() / (((RectangularGauge)this.getSkinnable()).getMaxValue() - ((RectangularGauge)this.getSkinnable()).getMinValue());
        double targetAngle = 180.0 - ((RectangularGauge)this.getSkinnable()).getStartAngle() + (((RectangularGauge)this.getSkinnable()).getValue() - ((RectangularGauge)this.getSkinnable()).getMinValue()) * this.angleStep;
        targetAngle = this.clamp(180.0 - ((RectangularGauge)this.getSkinnable()).getStartAngle(), 180.0 - ((RectangularGauge)this.getSkinnable()).getStartAngle() + ((RectangularGauge)this.getSkinnable()).getAngleRange(), targetAngle);
        this.needleRotate.setAngle(targetAngle);
        this.lightEffect = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)255, (int)255, (int)255, (double)0.65), 2.0, 0.0, 0.0, 2.0);
        this.foreground = new Region();
        this.foreground.getStyleClass().setAll((Object[])new String[]{"foreground"});
        this.foreground.setEffect((Effect)this.lightEffect);
        this.pane = new Pane();
        this.pane.getChildren().setAll((Object[])new Node[]{this.ticksAndSectionsCanvas, this.ledFrame, this.ledMain, this.ledHl, this.unitText, this.lcdText, this.shadowGroup, this.foreground, this.titleText});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((RectangularGauge)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((RectangularGauge)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((RectangularGauge)this.getSkinnable()).ledOnProperty().addListener(observable -> this.ledMain.setEffect((Effect)(((RectangularGauge)this.getSkinnable()).isLedOn() ? this.glow : this.innerShadow)));
        ((RectangularGauge)this.getSkinnable()).ledColorProperty().addListener(observable -> this.handleControlPropertyChanged("LED_COLOR"));
        ((RectangularGauge)this.getSkinnable()).ledVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((RectangularGauge)this.getSkinnable()).tickLabelOrientationProperty().addListener(observable -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((RectangularGauge)this.getSkinnable()).tickLabelFillProperty().addListener(observable -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((RectangularGauge)this.getSkinnable()).tickMarkFillProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((RectangularGauge)this.getSkinnable()).needleColorProperty().addListener(observable -> this.handleControlPropertyChanged("NEEDLE_COLOR"));
        ((RectangularGauge)this.getSkinnable()).animatedProperty().addListener(observable -> this.handleControlPropertyChanged("ANIMATED"));
        ((RectangularGauge)this.getSkinnable()).angleRangeProperty().addListener(observable -> this.handleControlPropertyChanged("ANGLE_RANGE"));
        ((RectangularGauge)this.getSkinnable()).numberFormatProperty().addListener(observable -> this.handleControlPropertyChanged("RECALC"));
        ((RectangularGauge)this.getSkinnable()).dropShadowEnabledProperty().addListener(observable -> this.handleControlPropertyChanged("DROP_SHADOW"));
        ((RectangularGauge)this.getSkinnable()).getSections().addListener(change -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((RectangularGauge)this.getSkinnable()).valueProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.withinSpeedLimit = !Instant.now().minusMillis((long)((RectangularGauge)this.getSkinnable()).getAnimationDuration()).isBefore(this.lastCall);
            this.lastCall = Instant.now();
            this.oldValue = OLD_VALUE.doubleValue();
            this.rotateNeedle();
        });
        ((RectangularGauge)this.getSkinnable()).minValueProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.angleStep = ((RectangularGauge)this.getSkinnable()).getAngleRange() / (((RectangularGauge)this.getSkinnable()).getMaxValue() - NEW_VALUE.doubleValue());
            this.needleRotate.setAngle(180.0 - ((RectangularGauge)this.getSkinnable()).getStartAngle() + (((RectangularGauge)this.getSkinnable()).getValue() - NEW_VALUE.doubleValue()) * this.angleStep);
            if (((RectangularGauge)this.getSkinnable()).getValue() < NEW_VALUE.doubleValue()) {
                ((RectangularGauge)this.getSkinnable()).setValue(NEW_VALUE.doubleValue());
                this.oldValue = NEW_VALUE.doubleValue();
            }
        });
        ((RectangularGauge)this.getSkinnable()).maxValueProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.angleStep = ((RectangularGauge)this.getSkinnable()).getAngleRange() / (NEW_VALUE.doubleValue() - ((RectangularGauge)this.getSkinnable()).getMinValue());
            this.needleRotate.setAngle(180.0 - ((RectangularGauge)this.getSkinnable()).getStartAngle() + (((RectangularGauge)this.getSkinnable()).getValue() - ((RectangularGauge)this.getSkinnable()).getMinValue()) * this.angleStep);
            if (((RectangularGauge)this.getSkinnable()).getValue() > NEW_VALUE.doubleValue()) {
                ((RectangularGauge)this.getSkinnable()).setValue(NEW_VALUE.doubleValue());
                this.oldValue = NEW_VALUE.doubleValue();
            }
        });
        this.needleRotate.angleProperty().addListener(observable -> this.handleControlPropertyChanged("ANGLE"));
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("ANGLE".equals(PROPERTY)) {
            double currentValue = (this.needleRotate.getAngle() + ((RectangularGauge)this.getSkinnable()).getStartAngle() - 180.0) / this.angleStep + ((RectangularGauge)this.getSkinnable()).getMinValue();
            this.lcdText.setText(this.limitString + String.format(Locale.US, "%." + ((RectangularGauge)this.getSkinnable()).getDecimals() + "f", currentValue));
        } else if ("DROP_SHADOW".equals(PROPERTY)) {
            this.shadowGroup.setEffect((Effect)(((RectangularGauge)this.getSkinnable()).isDropShadowEnabled() ? this.dropShadow : null));
        } else if ("CANVAS_REFRESH".equals(PROPERTY)) {
            this.ticksAndSections.clearRect(0.0, 0.0, this.width, this.height);
            this.drawSections(this.ticksAndSections);
            this.drawTickMarks(this.ticksAndSections);
        } else if ("NEEDLE_COLOR".equals(PROPERTY)) {
            this.needle.setStyle("-needle-color: " + this.colorToCss(((RectangularGauge)this.getSkinnable()).getNeedleColor()) + ";");
        } else if ("LED_COLOR".equals(PROPERTY)) {
            this.ledMain.setStyle("-led-color: " + this.colorToCss(((RectangularGauge)this.getSkinnable()).getLedColor()));
            this.resize();
        }
    }

    private String colorToCss(Color COLOR) {
        return COLOR.toString().replace("0x", "#");
    }

    private void rotateNeedle() {
        this.timeline.stop();
        this.angleStep = ((RectangularGauge)this.getSkinnable()).getAngleRange() / (((RectangularGauge)this.getSkinnable()).getMaxValue() - ((RectangularGauge)this.getSkinnable()).getMinValue());
        double targetAngle = 180.0 - ((RectangularGauge)this.getSkinnable()).getStartAngle() + (((RectangularGauge)this.getSkinnable()).getValue() - ((RectangularGauge)this.getSkinnable()).getMinValue()) * this.angleStep;
        targetAngle = this.clamp(180.0 - ((RectangularGauge)this.getSkinnable()).getStartAngle(), 180.0 - ((RectangularGauge)this.getSkinnable()).getStartAngle() + ((RectangularGauge)this.getSkinnable()).getAngleRange(), targetAngle);
        if (this.withinSpeedLimit && ((RectangularGauge)this.getSkinnable()).isAnimated()) {
            KeyValue KEY_VALUE = new KeyValue((WritableValue)this.needleRotate.angleProperty(), (Object)targetAngle, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
            KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)((RectangularGauge)this.getSkinnable()).getAnimationDuration()), new KeyValue[]{KEY_VALUE});
            this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{KEY_FRAME});
            this.timeline.play();
        } else {
            this.needleRotate.setAngle(targetAngle);
        }
    }

    private void drawTickMarks(GraphicsContext CTX) {
        double startAngle = ((RectangularGauge)this.getSkinnable()).getStartAngle();
        double orthText = RectangularGauge.TickLabelOrientation.ORTHOGONAL == ((RectangularGauge)this.getSkinnable()).getTickLabelOrientation() ? 0.51 : 0.52;
        Point2D center = new Point2D(this.width * 0.5, this.height * 0.77);
        boolean smallRange = ((RectangularGauge)this.getSkinnable()).getMaxValue() - ((RectangularGauge)this.getSkinnable()).getMinValue() < 10.0;
        double tmpMinValue = smallRange ? ((RectangularGauge)this.getSkinnable()).getMinValue() * 10.0 : ((RectangularGauge)this.getSkinnable()).getMinValue();
        double tmpMaxValue = smallRange ? ((RectangularGauge)this.getSkinnable()).getMaxValue() * 10.0 : ((RectangularGauge)this.getSkinnable()).getMaxValue();
        double tmpAngleStep = smallRange ? this.angleStep / 10.0 : this.angleStep;
        double angle = 0.0;
        double counter = tmpMinValue;
        while (Double.compare(counter, tmpMaxValue) <= 0) {
            double sinValue = Math.sin(Math.toRadians(angle + startAngle));
            double cosValue = Math.cos(Math.toRadians(angle + startAngle));
            Point2D innerPoint = new Point2D(center.getX() + this.width * 0.41987097 * sinValue, center.getY() + this.width * 0.41987097 * cosValue);
            Point2D outerMinorPoint = new Point2D(center.getX() + this.width * 0.45387097 * sinValue, center.getY() + this.width * 0.45387097 * cosValue);
            Point2D outerMediumPoint = new Point2D(center.getX() + this.width * 0.46387097 * sinValue, center.getY() + this.width * 0.46387097 * cosValue);
            Point2D outerPoint = new Point2D(center.getX() + this.width * 0.48387097 * sinValue, center.getY() + this.width * 0.48387097 * cosValue);
            Point2D textPoint = new Point2D(center.getX() + this.width * orthText * sinValue, center.getY() + this.width * orthText * cosValue);
            CTX.setStroke(((RectangularGauge)this.getSkinnable()).getTickMarkFill());
            if (counter % ((RectangularGauge)this.getSkinnable()).getMajorTickSpace() == 0.0) {
                CTX.setLineWidth(this.height * 0.0055);
                CTX.strokeLine(innerPoint.getX(), innerPoint.getY(), outerPoint.getX(), outerPoint.getY());
                CTX.save();
                CTX.translate(textPoint.getX(), textPoint.getY());
                switch (((RectangularGauge)this.getSkinnable()).getTickLabelOrientation()) {
                    case ORTHOGONAL: {
                        if ((360.0 - startAngle - angle) % 360.0 > 90.0 && (360.0 - startAngle - angle) % 360.0 < 270.0) {
                            CTX.rotate((180.0 - startAngle - angle) % 360.0);
                            break;
                        }
                        CTX.rotate((360.0 - startAngle - angle) % 360.0);
                        break;
                    }
                    case TANGENT: {
                        if ((360.0 - startAngle - angle - 90.0) % 360.0 > 90.0 && (360.0 - startAngle - angle - 90.0) % 360.0 < 270.0) {
                            CTX.rotate((90.0 - startAngle - angle) % 360.0);
                            break;
                        }
                        CTX.rotate((270.0 - startAngle - angle) % 360.0);
                        break;
                    }
                }
                CTX.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.LIGHT, (double)(0.04 * this.height)));
                CTX.setTextAlign(TextAlignment.CENTER);
                CTX.setTextBaseline(VPos.CENTER);
                CTX.setFill(((RectangularGauge)this.getSkinnable()).getTickLabelFill());
                CTX.fillText(Integer.toString((int)(smallRange ? counter / 10.0 : counter)), 0.0, 0.0);
                CTX.restore();
            } else if (((RectangularGauge)this.getSkinnable()).getMinorTickSpace() % 2.0 != 0.0 && counter % 5.0 == 0.0) {
                CTX.setLineWidth(this.height * 0.0035);
                CTX.strokeLine(innerPoint.getX(), innerPoint.getY(), outerMediumPoint.getX(), outerMediumPoint.getY());
            } else if (counter % ((RectangularGauge)this.getSkinnable()).getMinorTickSpace() == 0.0) {
                CTX.setLineWidth(this.height * 0.00225);
                CTX.strokeLine(innerPoint.getX(), innerPoint.getY(), outerMinorPoint.getX(), outerMinorPoint.getY());
            }
            angle -= tmpAngleStep;
            counter += 1.0;
        }
    }

    private final void drawSections(GraphicsContext CTX) {
        double x = this.width * 0.06;
        double y = this.width * 0.21;
        double w = this.width * 0.88;
        double h = this.height * 1.05;
        double MIN_VALUE = ((RectangularGauge)this.getSkinnable()).getMinValue();
        double MAX_VALUE = ((RectangularGauge)this.getSkinnable()).getMaxValue();
        double OFFSET = 90.0 - ((RectangularGauge)this.getSkinnable()).getStartAngle();
        IntStream.range(0, ((RectangularGauge)this.getSkinnable()).getSections().size()).parallel().forEachOrdered(i -> {
            Section SECTION = (Section)((RectangularGauge)this.getSkinnable()).getSections().get(i);
            if (Double.compare(SECTION.getStart(), MAX_VALUE) <= 0 && Double.compare(SECTION.getStop(), MIN_VALUE) >= 0) {
                double SECTION_START_ANGLE = SECTION.getStart() < MIN_VALUE && SECTION.getStop() < MAX_VALUE ? MIN_VALUE * this.angleStep : (SECTION.getStart() - MIN_VALUE) * this.angleStep;
                double SECTION_ANGLE_EXTEND = SECTION.getStop() > MAX_VALUE ? (MAX_VALUE - SECTION.getStart()) * this.angleStep : (SECTION.getStop() - SECTION.getStart()) * this.angleStep;
                CTX.save();
                switch (i) {
                    case 0: {
                        CTX.setStroke((Paint)((RectangularGauge)this.getSkinnable()).getSectionFill0());
                        break;
                    }
                    case 1: {
                        CTX.setStroke((Paint)((RectangularGauge)this.getSkinnable()).getSectionFill1());
                        break;
                    }
                    case 2: {
                        CTX.setStroke((Paint)((RectangularGauge)this.getSkinnable()).getSectionFill2());
                        break;
                    }
                    case 3: {
                        CTX.setStroke((Paint)((RectangularGauge)this.getSkinnable()).getSectionFill3());
                        break;
                    }
                    case 4: {
                        CTX.setStroke((Paint)((RectangularGauge)this.getSkinnable()).getSectionFill4());
                        break;
                    }
                    case 5: {
                        CTX.setStroke((Paint)((RectangularGauge)this.getSkinnable()).getSectionFill5());
                        break;
                    }
                    case 6: {
                        CTX.setStroke((Paint)((RectangularGauge)this.getSkinnable()).getSectionFill6());
                        break;
                    }
                    case 7: {
                        CTX.setStroke((Paint)((RectangularGauge)this.getSkinnable()).getSectionFill7());
                        break;
                    }
                    case 8: {
                        CTX.setStroke((Paint)((RectangularGauge)this.getSkinnable()).getSectionFill8());
                        break;
                    }
                    case 9: {
                        CTX.setStroke((Paint)((RectangularGauge)this.getSkinnable()).getSectionFill9());
                    }
                }
                CTX.setLineWidth(this.height * 0.0415);
                CTX.setLineCap(StrokeLineCap.BUTT);
                CTX.strokeArc(x, y, w, h, -(OFFSET + SECTION_START_ANGLE), -SECTION_ANGLE_EXTEND, ArcType.OPEN);
                CTX.restore();
            }
        });
    }

    private double clamp(double MIN_VALUE, double MAX_VALUE, double VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    private void resizeText() {
        this.titleText.setFont(Fonts.robotoMedium(this.height * 0.11));
        this.titleText.setTranslateX((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5);
        this.titleText.setTranslateY(this.height * 0.76);
        this.unitText.setFont(Fonts.robotoMedium(this.height * 0.1));
        this.unitText.setTranslateX((this.width - this.unitText.getLayoutBounds().getWidth()) * 0.5);
        this.unitText.setTranslateY(this.height * 0.37);
        this.lcdText.setStyle("-fx-background-radius: " + 0.0125 * this.height + ";");
        this.lcdText.setFont(Fonts.digitalReadoutBold(this.height * 0.09));
        this.lcdText.setPrefSize(0.3 * this.width, 0.014 * this.height);
        this.lcdText.relocate((this.width - this.lcdText.getPrefWidth()) * 0.5, 0.44 * this.height);
    }

    private void resize() {
        this.width = ((RectangularGauge)this.getSkinnable()).getWidth();
        this.height = ((RectangularGauge)this.getSkinnable()).getHeight();
        if (this.aspectRatio * this.width > this.height) {
            this.width = 1.0 / (this.aspectRatio / this.height);
        } else if (1.0 / (this.aspectRatio / this.height) > this.width) {
            this.height = this.aspectRatio * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.relocate((((RectangularGauge)this.getSkinnable()).getWidth() - this.width) * 0.5, (((RectangularGauge)this.getSkinnable()).getHeight() - this.height) * 0.5);
            this.dropShadow.setRadius(0.01 * this.height);
            this.dropShadow.setOffsetY(0.01 * this.height);
            this.ticksAndSectionsCanvas.setWidth(this.width);
            this.ticksAndSectionsCanvas.setHeight(this.height);
            this.ticksAndSections.clearRect(0.0, 0.0, this.width, this.height);
            this.ticksAndSections.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, this.height, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(0.07692308, Color.rgb((int)180, (int)180, (int)180)), new Stop(0.08461538, Color.rgb((int)235, (int)235, (int)235)), new Stop(0.56923077, Color.rgb((int)255, (int)255, (int)255)), new Stop(0.57692308, Color.rgb((int)180, (int)180, (int)180)), new Stop(1.0, Color.TRANSPARENT)}));
            this.ticksAndSections.fillRect(0.0, 0.0, this.width, this.height);
            if (((RectangularGauge)this.getSkinnable()).isSectionsVisible()) {
                this.drawSections(this.ticksAndSections);
            }
            this.drawTickMarks(this.ticksAndSections);
            this.ticksAndSectionsCanvas.setCache(true);
            this.ticksAndSectionsCanvas.setCacheHint(CacheHint.QUALITY);
            this.innerShadow.setRadius(0.01 * this.height);
            this.glow.setRadius(0.05 * this.height);
            this.glow.setColor(((RectangularGauge)this.getSkinnable()).getLedColor());
            this.ledFrame.setPrefSize(0.06 * this.height, 0.06 * this.height);
            this.ledFrame.relocate(0.11 * this.width, 0.1 * this.height);
            this.ledMain.setPrefSize(0.0432 * this.height, 0.0432 * this.height);
            this.ledMain.relocate(0.11 * this.width + 0.0084 * this.width, 0.1 * this.height + 0.0084 * this.width);
            this.ledHl.setPrefSize(0.0348 * this.height, 0.0348 * this.height);
            this.ledHl.relocate(0.11 * this.width + 0.0126 * this.width, 0.1 * this.height + 0.0126 * this.width);
            boolean ledVisible = ((RectangularGauge)this.getSkinnable()).isLedVisible();
            this.ledFrame.setManaged(ledVisible);
            this.ledFrame.setVisible(ledVisible);
            this.ledMain.setManaged(ledVisible);
            this.ledMain.setVisible(ledVisible);
            this.ledHl.setManaged(ledVisible);
            this.ledHl.setVisible(ledVisible);
            this.needle.setPrefSize(this.width * 0.02, this.height * 0.58);
            this.needle.relocate((this.width - this.needle.getPrefWidth()) * 0.5, this.height * 0.77 - this.needle.getPrefHeight());
            this.needleRotate.setPivotX(this.needle.getPrefWidth() * 0.5);
            this.needleRotate.setPivotY(this.needle.getPrefHeight());
            this.needleHighlight.setPrefSize(this.width * 0.02, this.height * 0.58);
            this.needleHighlight.setTranslateX((this.width - this.needle.getPrefWidth()) * 0.5);
            this.needleHighlight.setTranslateY(this.height * 0.77 - this.needle.getPrefHeight());
            this.lightEffect.setRadius(0.00769231 * this.height);
            this.lightEffect.setOffsetY(0.00769231 * this.height);
            this.foreground.setPrefSize(this.width, this.height);
            this.resizeText();
        }
    }
}

