/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.heatcontrol.skin;

import eu.hansolo.enzo.common.ValueEvent;
import eu.hansolo.enzo.fonts.Fonts;
import eu.hansolo.enzo.heatcontrol.GradientLookup;
import eu.hansolo.enzo.heatcontrol.HeatControl;
import java.util.Locale;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.animation.PauseTransition;
import javafx.animation.SequentialTransition;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.util.Duration;

public class HeatControlSkin
extends SkinBase<HeatControl>
implements Skin<HeatControl> {
    private static final double PREFERRED_WIDTH = 200.0;
    private static final double PREFERRED_HEIGHT = 200.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static boolean userAction;
    private double size;
    private double centerX;
    private double centerY;
    private Pane pane;
    private Circle background;
    private Canvas ticksCanvas;
    private GraphicsContext ticks;
    private Region targetIndicator;
    private Rotate targetIndicatorRotate;
    private boolean targetExceeded;
    private Region valueIndicator;
    private Rotate valueIndicatorRotate;
    private Text infoText;
    private Text value;
    private String newTarget;
    private GradientLookup gradientLookup;
    private InnerShadow innerShadow;
    private double angleStep;
    private double interactiveAngle;
    private EventHandler<MouseEvent> mouseEventHandler;
    private EventHandler<TouchEvent> touchEventHandler;

    public HeatControlSkin(HeatControl heatControl) {
        super((Control)heatControl);
        userAction = false;
        this.newTarget = "";
        this.gradientLookup = new GradientLookup(new Stop(0.1, Color.web((String)"#3221c9")), new Stop(0.2, Color.web((String)"#216ec9")), new Stop(0.3, Color.web((String)"#21bac9")), new Stop(0.4, Color.web((String)"#30cb22")), new Stop(0.5, Color.web((String)"#2fcb22")), new Stop(0.6, Color.web((String)"#f1ec28")), new Stop(0.7, Color.web((String)"#f1c428")), new Stop(0.8, Color.web((String)"#f19c28")), new Stop(0.9, Color.web((String)"#f16f28")), new Stop(1.0, Color.web((String)"#ec272f")));
        this.angleStep = heatControl.getAngleRange() / (heatControl.getMaxValue() - heatControl.getMinValue());
        this.mouseEventHandler = mouseEvent -> this.handleMouseEvent((MouseEvent)mouseEvent);
        this.touchEventHandler = touchEvent -> this.handleTouchEvent((TouchEvent)touchEvent);
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((HeatControl)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((HeatControl)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((HeatControl)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((HeatControl)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((HeatControl)this.getSkinnable()).getPrefWidth() > 0.0 && ((HeatControl)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((HeatControl)this.getSkinnable()).setPrefSize(((HeatControl)this.getSkinnable()).getPrefWidth(), ((HeatControl)this.getSkinnable()).getPrefHeight());
            } else {
                ((HeatControl)this.getSkinnable()).setPrefSize(200.0, 200.0);
            }
        }
        if (Double.compare(((HeatControl)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((HeatControl)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((HeatControl)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((HeatControl)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((HeatControl)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((HeatControl)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.innerShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 20.0, 0.0, 0.0, 0.0);
        Color color = this.gradientLookup.getColorAt(((HeatControl)this.getSkinnable()).getValue() / (((HeatControl)this.getSkinnable()).getMaxValue() - ((HeatControl)this.getSkinnable()).getMinValue()));
        this.background = new Circle(100.0, 100.0, 100.0);
        this.background.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, 200.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, color.deriveColor(0.0, 1.0, 0.8, 1.0)), new Stop(1.0, color.deriveColor(0.0, 1.0, 0.6, 1.0))}));
        this.background.setEffect((Effect)this.innerShadow);
        this.ticksCanvas = new Canvas(200.0, 200.0);
        this.ticksCanvas.setMouseTransparent(true);
        this.ticks = this.ticksCanvas.getGraphicsContext2D();
        this.targetIndicator = new Region();
        this.targetIndicator.getStyleClass().setAll((Object[])new String[]{"target-indicator"});
        this.targetIndicatorRotate = new Rotate(180.0 - ((HeatControl)this.getSkinnable()).getStartAngle() - ((HeatControl)this.getSkinnable()).getMinValue() * this.angleStep);
        this.targetIndicator.getTransforms().setAll((Object[])new Transform[]{this.targetIndicatorRotate});
        this.targetExceeded = false;
        this.targetIndicator.setVisible(((HeatControl)this.getSkinnable()).isTargetEnabled());
        this.valueIndicator = new Region();
        this.valueIndicator.getStyleClass().setAll((Object[])new String[]{"value-indicator"});
        this.valueIndicatorRotate = new Rotate(180.0 - ((HeatControl)this.getSkinnable()).getStartAngle());
        this.valueIndicatorRotate.setAngle(this.valueIndicatorRotate.getAngle() + (((HeatControl)this.getSkinnable()).getValue() - ((HeatControl)this.getSkinnable()).getOldValue() - ((HeatControl)this.getSkinnable()).getMinValue()) * this.angleStep);
        this.valueIndicator.getTransforms().setAll((Object[])new Transform[]{this.valueIndicatorRotate});
        this.infoText = new Text(((HeatControl)this.getSkinnable()).getInfoText().toUpperCase());
        this.infoText.setTextOrigin(VPos.CENTER);
        this.infoText.setFont(Fonts.robotoMedium(12.0));
        this.infoText.setMouseTransparent(true);
        this.infoText.getStyleClass().setAll((Object[])new String[]{"info-text"});
        this.value = new Text(String.format(Locale.US, "%." + ((HeatControl)this.getSkinnable()).getDecimals() + "f", ((HeatControl)this.getSkinnable()).getValue()));
        this.value.setMouseTransparent(true);
        this.value.setTextOrigin(VPos.CENTER);
        this.value.setFont(Fonts.robotoBold(64.0));
        this.value.setMouseTransparent(true);
        this.value.getStyleClass().setAll((Object[])new String[]{"value"});
        this.pane = new Pane();
        this.pane.getChildren().setAll((Object[])new Node[]{this.background, this.ticksCanvas, this.valueIndicator, this.targetIndicator, this.infoText, this.value});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((HeatControl)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((HeatControl)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((HeatControl)this.getSkinnable()).infoTextProperty().addListener(observable -> this.handleControlPropertyChanged("INFO_TEXT"));
        ((HeatControl)this.getSkinnable()).targetEnabledProperty().addListener(observable -> this.handleControlPropertyChanged("TARGET_ENABLED"));
        ((HeatControl)this.getSkinnable()).valueProperty().addListener(observable -> this.handleControlPropertyChanged("VALUE"));
        ((HeatControl)this.getSkinnable()).minValueProperty().addListener(observable -> this.handleControlPropertyChanged("RECALC"));
        ((HeatControl)this.getSkinnable()).maxValueProperty().addListener(observable -> this.handleControlPropertyChanged("RECALC"));
        ((HeatControl)this.getSkinnable()).minMeasuredValueProperty().addListener(observable -> this.handleControlPropertyChanged("MIN_MEASURED_VALUE"));
        ((HeatControl)this.getSkinnable()).maxMeasuredValueProperty().addListener(observable -> this.handleControlPropertyChanged("MAX_MEASURED_VALUE"));
        ((HeatControl)this.getSkinnable()).thresholdProperty().addListener(observable -> this.handleControlPropertyChanged("TARGET"));
        ((HeatControl)this.getSkinnable()).angleRangeProperty().addListener(observable -> this.handleControlPropertyChanged("ANGLE_RANGE"));
        this.valueIndicatorRotate.angleProperty().addListener(observable -> this.handleControlPropertyChanged("ANGLE"));
        this.targetIndicator.setOnMousePressed(this.mouseEventHandler);
        this.targetIndicator.setOnMouseDragged(this.mouseEventHandler);
        this.targetIndicator.setOnMouseReleased(this.mouseEventHandler);
        this.targetIndicator.setOnTouchPressed(this.touchEventHandler);
        this.targetIndicator.setOnTouchMoved(this.touchEventHandler);
        this.targetIndicator.setOnTouchReleased(this.touchEventHandler);
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("INFO_TEXT".equals(PROPERTY)) {
            this.infoText.setText(((HeatControl)this.getSkinnable()).getInfoText().toUpperCase());
            this.resize();
        } else if ("VALUE".equals(PROPERTY)) {
            this.rotateNeedle();
            this.adjustBackgroundColor();
        } else if ("RECALC".equals(PROPERTY)) {
            if (((HeatControl)this.getSkinnable()).getMinValue() < 0.0) {
                this.angleStep = ((HeatControl)this.getSkinnable()).getAngleRange() / (((HeatControl)this.getSkinnable()).getMaxValue() - ((HeatControl)this.getSkinnable()).getMinValue());
                this.valueIndicatorRotate.setAngle(180.0 - ((HeatControl)this.getSkinnable()).getStartAngle() - ((HeatControl)this.getSkinnable()).getMinValue() * this.angleStep);
            } else {
                this.angleStep = ((HeatControl)this.getSkinnable()).getAngleRange() / (((HeatControl)this.getSkinnable()).getMaxValue() + ((HeatControl)this.getSkinnable()).getMinValue());
                this.valueIndicatorRotate.setAngle(180.0 - ((HeatControl)this.getSkinnable()).getStartAngle() * this.angleStep);
            }
            this.resize();
        } else if ("ANGLE".equals(PROPERTY)) {
            double currentValue = (this.valueIndicatorRotate.getAngle() + ((HeatControl)this.getSkinnable()).getStartAngle() - 180.0) / this.angleStep + ((HeatControl)this.getSkinnable()).getMinValue();
            if (!userAction) {
                this.value.setText(String.format(Locale.US, "%." + ((HeatControl)this.getSkinnable()).getDecimals() + "f", currentValue));
                this.value.setTranslateX((this.size - this.value.getLayoutBounds().getWidth()) * 0.5);
            }
            if (this.targetExceeded) {
                if (currentValue < ((HeatControl)this.getSkinnable()).getTarget()) {
                    ((HeatControl)this.getSkinnable()).fireEvent(new ValueEvent((Object)this, null, ValueEvent.VALUE_UNDERRUN));
                    this.targetExceeded = false;
                }
            } else if (currentValue > ((HeatControl)this.getSkinnable()).getTarget()) {
                ((HeatControl)this.getSkinnable()).fireEvent(new ValueEvent((Object)this, null, ValueEvent.VALUE_EXCEEDED));
                this.targetExceeded = true;
            }
        } else if ("TARGET".equals(PROPERTY)) {
            this.targetIndicatorRotate.setAngle(((HeatControl)this.getSkinnable()).getTarget() * this.angleStep - 180.0 - ((HeatControl)this.getSkinnable()).getStartAngle());
        } else if ("TARGET_ENABLED".equals(PROPERTY)) {
            this.targetIndicator.setVisible(((HeatControl)this.getSkinnable()).isTargetEnabled());
        }
    }

    private void handleMouseEvent(MouseEvent MOUSE_EVENT) {
        Object SRC = MOUSE_EVENT.getSource();
        EventType TYPE = MOUSE_EVENT.getEventType();
        if (SRC.equals(this.targetIndicator)) {
            if (MouseEvent.MOUSE_PRESSED == TYPE) {
                userAction = true;
                this.value.setText(String.format(Locale.US, "%." + ((HeatControl)this.getSkinnable()).getDecimals() + "f", ((HeatControl)this.getSkinnable()).getTarget()));
                this.resizeText();
            } else if (MouseEvent.MOUSE_DRAGGED == TYPE) {
                this.touchRotate(MOUSE_EVENT.getSceneX() - ((HeatControl)this.getSkinnable()).getLayoutX(), MOUSE_EVENT.getSceneY() - ((HeatControl)this.getSkinnable()).getLayoutY(), this.targetIndicatorRotate);
            } else if (MouseEvent.MOUSE_RELEASED == TYPE) {
                ((HeatControl)this.getSkinnable()).setTarget(Double.parseDouble(this.newTarget));
                this.fadeBack();
            }
        }
    }

    private void handleTouchEvent(TouchEvent TOUCH_EVENT) {
        Object SRC = TOUCH_EVENT.getSource();
        EventType TYPE = TOUCH_EVENT.getEventType();
        if (SRC.equals(this.targetIndicator)) {
            if (TouchEvent.TOUCH_PRESSED == TYPE) {
                this.value.setText(String.format(Locale.US, "%." + ((HeatControl)this.getSkinnable()).getDecimals() + "f", ((HeatControl)this.getSkinnable()).getTarget()));
                this.resizeText();
            } else if (TouchEvent.TOUCH_MOVED == TYPE) {
                this.touchRotate(TOUCH_EVENT.getTouchPoint().getSceneX() - ((HeatControl)this.getSkinnable()).getLayoutX(), TOUCH_EVENT.getTouchPoint().getSceneY() - ((HeatControl)this.getSkinnable()).getLayoutY(), this.targetIndicatorRotate);
            } else if (TouchEvent.TOUCH_RELEASED == TYPE) {
                ((HeatControl)this.getSkinnable()).setTarget(Double.parseDouble(this.value.getText()));
                this.fadeBack();
            }
        }
    }

    private double getTheta(double x, double y) {
        double nx;
        double deltaY = y - this.centerY;
        double deltaX = x - this.centerX;
        double radius = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        double ny = deltaY / radius;
        double theta = Math.atan2(ny, nx = deltaX / radius);
        return Double.compare(theta, 0.0) >= 0 ? Math.toDegrees(theta) : Math.toDegrees(theta) + 360.0;
    }

    private void touchRotate(double X, double Y, Rotate ROTATE) {
        double newValue;
        double theta = this.getTheta(X, Y);
        this.interactiveAngle = (theta + 90.0) % 360.0;
        double d = newValue = Double.compare(this.interactiveAngle, 180.0) <= 0 ? (this.interactiveAngle + 180.0 + ((HeatControl)this.getSkinnable()).getStartAngle() - 360.0) / this.angleStep + ((HeatControl)this.getSkinnable()).getMinValue() : (this.interactiveAngle - 180.0 + ((HeatControl)this.getSkinnable()).getStartAngle() - 360.0) / this.angleStep + ((HeatControl)this.getSkinnable()).getMinValue();
        if (Double.compare(newValue, ((HeatControl)this.getSkinnable()).getMinValue()) >= 0 && Double.compare(newValue, ((HeatControl)this.getSkinnable()).getMaxValue()) <= 0) {
            ROTATE.setAngle(this.interactiveAngle);
            this.value.setText(String.format(Locale.US, "%." + ((HeatControl)this.getSkinnable()).getDecimals() + "f", newValue));
            this.newTarget = this.value.getText();
            this.resizeText();
        }
    }

    private void fadeBack() {
        FadeTransition fadeInfoTextOut = new FadeTransition(Duration.millis((double)425.0), (Node)this.infoText);
        fadeInfoTextOut.setFromValue(1.0);
        fadeInfoTextOut.setToValue(0.0);
        FadeTransition fadeValueOut = new FadeTransition(Duration.millis((double)425.0), (Node)this.value);
        fadeValueOut.setFromValue(1.0);
        fadeValueOut.setToValue(0.0);
        PauseTransition pause = new PauseTransition(Duration.millis((double)50.0));
        FadeTransition fadeInfoTextIn = new FadeTransition(Duration.millis((double)425.0), (Node)this.infoText);
        fadeInfoTextIn.setFromValue(0.0);
        fadeInfoTextIn.setToValue(1.0);
        FadeTransition fadeValueIn = new FadeTransition(Duration.millis((double)425.0), (Node)this.value);
        fadeValueIn.setFromValue(0.0);
        fadeValueIn.setToValue(1.0);
        ParallelTransition parallelIn = new ParallelTransition(new Animation[]{fadeInfoTextIn, fadeValueIn});
        ParallelTransition parallelOut = new ParallelTransition(new Animation[]{fadeInfoTextOut, fadeValueOut});
        parallelOut.setOnFinished(event -> {
            double currentValue = (this.valueIndicatorRotate.getAngle() + ((HeatControl)this.getSkinnable()).getStartAngle() - 180.0) / this.angleStep + ((HeatControl)this.getSkinnable()).getMinValue();
            this.value.setText(String.format(Locale.US, "%." + ((HeatControl)this.getSkinnable()).getDecimals() + "f", currentValue));
            this.value.setTranslateX((this.size - this.value.getLayoutBounds().getWidth()) * 0.5);
            if (((HeatControl)this.getSkinnable()).getTarget() < ((HeatControl)this.getSkinnable()).getValue()) {
                ((HeatControl)this.getSkinnable()).setInfoText("COOLING");
            } else if (((HeatControl)this.getSkinnable()).getTarget() > ((HeatControl)this.getSkinnable()).getValue()) {
                ((HeatControl)this.getSkinnable()).setInfoText("HEATING");
            }
            this.resizeText();
            this.drawTickMarks(this.ticks);
            userAction = false;
        });
        SequentialTransition sequence = new SequentialTransition(new Animation[]{parallelOut, pause, parallelIn});
        sequence.play();
    }

    private void rotateNeedle() {
        double range = ((HeatControl)this.getSkinnable()).getMaxValue() - ((HeatControl)this.getSkinnable()).getMinValue();
        double angleRange = ((HeatControl)this.getSkinnable()).getAngleRange();
        this.angleStep = angleRange / range;
        double targetAngle = this.valueIndicatorRotate.getAngle() + (((HeatControl)this.getSkinnable()).getValue() - ((HeatControl)this.getSkinnable()).getOldValue()) * this.angleStep;
        this.valueIndicatorRotate.setAngle(targetAngle);
        this.drawTickMarks(this.ticks);
    }

    private void adjustBackgroundColor() {
        Color color = this.gradientLookup.getColorAt(((HeatControl)this.getSkinnable()).getValue() / (((HeatControl)this.getSkinnable()).getMaxValue() - ((HeatControl)this.getSkinnable()).getMinValue()));
        this.background.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, this.size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, color.deriveColor(0.0, 1.0, 0.8, 1.0)), new Stop(1.0, color.deriveColor(0.0, 1.0, 0.6, 1.0))}));
    }

    private void drawTickMarks(GraphicsContext CTX) {
        CTX.clearRect(0.0, 0.0, this.size, this.size);
        double startAngle = ((HeatControl)this.getSkinnable()).getStartAngle();
        Point2D center = new Point2D(this.size * 0.5, this.size * 0.5);
        double stdLineWidth = this.size * 0.003;
        double rangeLineWidth = this.size * 0.007;
        double angle = 0.0;
        double counter = ((HeatControl)this.getSkinnable()).getMinValue();
        while (Double.compare(counter, ((HeatControl)this.getSkinnable()).getMaxValue()) <= 0) {
            double sinValue = Math.sin(Math.toRadians(angle + startAngle));
            double cosValue = Math.cos(Math.toRadians(angle + startAngle));
            Point2D innerPoint = new Point2D(center.getX() + this.size * 0.368 * sinValue, center.getY() + this.size * 0.368 * cosValue);
            Point2D outerPoint = new Point2D(center.getX() + this.size * 0.457 * sinValue, center.getY() + this.size * 0.457 * cosValue);
            CTX.setStroke(((HeatControl)this.getSkinnable()).getTickMarkFill());
            if (((HeatControl)this.getSkinnable()).isTargetEnabled() && counter > ((HeatControl)this.getSkinnable()).getValue() && counter < ((HeatControl)this.getSkinnable()).getTarget() || counter > ((HeatControl)this.getSkinnable()).getTarget() && counter < ((HeatControl)this.getSkinnable()).getValue()) {
                CTX.setLineWidth(rangeLineWidth);
            } else {
                CTX.setLineWidth(stdLineWidth);
            }
            CTX.setLineCap(StrokeLineCap.ROUND);
            CTX.strokeLine(innerPoint.getX(), innerPoint.getY(), outerPoint.getX(), outerPoint.getY());
            angle -= this.angleStep / 3.0;
            counter += 0.33333;
        }
    }

    private void resizeText() {
        this.infoText.setFont(Fonts.robotoLight(this.size * 0.07));
        this.infoText.setTranslateX((this.size - this.infoText.getLayoutBounds().getWidth()) * 0.5);
        this.infoText.setTranslateY(this.size * 0.34);
        this.value.setFont(Fonts.robotoBold(this.size * 0.32));
        this.value.setTranslateX((this.size - this.value.getLayoutBounds().getWidth()) * 0.5);
        this.value.setTranslateY(this.size * 0.5);
    }

    private void resize() {
        double d = this.size = ((HeatControl)this.getSkinnable()).getWidth() < ((HeatControl)this.getSkinnable()).getHeight() ? ((HeatControl)this.getSkinnable()).getWidth() : ((HeatControl)this.getSkinnable()).getHeight();
        if (this.size > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.centerX = this.size * 0.5;
            this.centerY = this.size * 0.5;
            this.innerShadow.setRadius(this.size * 0.1);
            this.background.setCenterX(this.centerX);
            this.background.setCenterY(this.centerY);
            this.background.setRadius(this.size * 0.5);
            this.ticksCanvas.setWidth(this.size);
            this.ticksCanvas.setHeight(this.size);
            this.ticks.clearRect(0.0, 0.0, this.size, this.size);
            this.drawTickMarks(this.ticks);
            this.ticksCanvas.setCache(true);
            this.ticksCanvas.setCacheHint(CacheHint.QUALITY);
            this.valueIndicator.setPrefSize(this.size * 0.025, this.size * 0.096);
            this.valueIndicator.relocate((this.size - this.valueIndicator.getPrefWidth()) * 0.5, this.size * 0.039);
            this.valueIndicatorRotate.setPivotX(this.valueIndicator.getPrefWidth() * 0.5);
            this.valueIndicatorRotate.setPivotY(this.size * 0.461);
            this.targetIndicator.setPrefSize(0.025 * this.size, 0.13 * this.size);
            this.targetIndicator.relocate((this.size - this.targetIndicator.getPrefWidth()) * 0.5, this.size * 0.039);
            this.targetIndicatorRotate.setPivotX(this.targetIndicator.getPrefWidth() * 0.5);
            this.targetIndicatorRotate.setPivotY(this.size * 0.461);
            this.targetIndicatorRotate.setAngle(((HeatControl)this.getSkinnable()).getTarget() * this.angleStep - 180.0 - ((HeatControl)this.getSkinnable()).getStartAngle() - ((HeatControl)this.getSkinnable()).getMinValue() * this.angleStep);
            this.infoText.setText(((HeatControl)this.getSkinnable()).getInfoText().toUpperCase());
            this.value.setText(String.format(Locale.US, "%." + ((HeatControl)this.getSkinnable()).getDecimals() + "f", (this.valueIndicatorRotate.getAngle() + ((HeatControl)this.getSkinnable()).getStartAngle() - 180.0) / this.angleStep));
            this.resizeText();
        }
    }
}

