/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.splitflap;

import eu.hansolo.enzo.splitflap.SplitFlap;
import eu.hansolo.enzo.splitflap.SplitFlapBuilder;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class Demo
extends Application {
    private static int noOfNodes = 0;
    private SplitFlap control;
    private AnimationTimer timer;
    private long start;

    public void init() {
        this.control = SplitFlapBuilder.create().flipTime(1000.0).withFixture(false).build();
        this.start = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > Demo.this.start + 2000000000L) {
                    Demo.this.control.setText("X");
                }
            }
        };
    }

    public void start(Stage stage) {
        StackPane pane = new StackPane();
        pane.getChildren().setAll((Object[])new Node[]{this.control});
        PerspectiveCamera camera = new PerspectiveCamera();
        camera.setFieldOfView(10.0);
        Scene scene = new Scene((Parent)pane, (Paint)Color.DARKGRAY);
        stage.setScene(scene);
        stage.show();
        this.timer.start();
        Demo.calcNoOfNodes((Node)pane);
        System.out.println(noOfNodes + " Nodes in SceneGraph");
    }

    public void stop() {
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                Demo.calcNoOfNodes(n);
            }
        }
    }

    public static void main(String[] args) {
        Demo.launch((String[])args);
    }
}

