/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import java.util.Arrays;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.AnnotationInfo;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IModule;

public class ModuleInfo
extends ClassFileStruct
implements IBinaryModule {
    protected int flags;
    protected int requiresCount;
    protected int exportsCount;
    protected int usesCount;
    protected int providesCount;
    protected int opensCount;
    protected char[] name;
    protected char[] version;
    protected ModuleReferenceInfo[] requires;
    protected PackageExportInfo[] exports;
    protected PackageExportInfo[] opens;
    char[][] uses;
    IModule.IService[] provides;
    protected AnnotationInfo[] annotations;
    private long tagBits;

    @Override
    public boolean isOpen() {
        return (this.flags & 0x20) != 0;
    }

    public int requiresCount() {
        return this.requiresCount;
    }

    public int exportsCount() {
        return this.exportsCount;
    }

    public int usesCount() {
        return this.usesCount;
    }

    public int providesCount() {
        return this.providesCount;
    }

    @Override
    public char[] name() {
        return this.name;
    }

    public void setName(char[] cArray) {
        this.name = cArray;
    }

    @Override
    public IModule.IModuleReference[] requires() {
        return this.requires;
    }

    @Override
    public IModule.IPackageExport[] exports() {
        return this.exports;
    }

    @Override
    public char[][] uses() {
        return this.uses;
    }

    @Override
    public IModule.IService[] provides() {
        return this.provides;
    }

    @Override
    public IModule.IPackageExport[] opens() {
        return this.opens;
    }

    @Override
    public IBinaryAnnotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public long getTagBits() {
        return this.tagBits;
    }

    protected ModuleInfo(byte[] byArray, int[] nArray, int n) {
        super(byArray, nArray, n);
    }

    public static ModuleInfo createModule(byte[] byArray, int[] nArray, int n) {
        ModuleInfo moduleInfo = new ModuleInfo(byArray, nArray, 0);
        moduleInfo.readModuleAttribute(n + 6);
        return moduleInfo;
    }

    private void readModuleAttribute(int n) {
        char[] cArray;
        int n2;
        int n3;
        char[] cArray2;
        int n4;
        int n5;
        int n6 = this.constantPoolOffsets[this.u2At(n)];
        int n7 = this.constantPoolOffsets[this.u2At(n6 + 1)];
        this.name = this.utf8At(n7 + 3, this.u2At(n7 + 1));
        CharOperation.replace(this.name, '/', '.');
        this.flags = this.u2At(n += 2);
        int n8 = this.u2At(n += 2);
        if (n8 > 0) {
            n7 = this.constantPoolOffsets[n8];
            this.version = this.utf8At(n7 + 3, this.u2At(n7 + 1));
        }
        this.requiresCount = n5 = this.u2At(n += 2);
        this.requires = new ModuleReferenceInfo[n5];
        n += 2;
        for (n4 = 0; n4 < n5; ++n4) {
            int n9;
            n6 = this.constantPoolOffsets[this.u2At(n)];
            n7 = this.constantPoolOffsets[this.u2At(n6 + 1)];
            cArray2 = this.utf8At(n7 + 3, this.u2At(n7 + 1));
            this.requires[n4] = new ModuleReferenceInfo();
            CharOperation.replace(cArray2, '/', '.');
            this.requires[n4].refName = cArray2;
            this.requires[n4].modifiers = n9 = this.u2At(n += 2);
            this.requires[n4].isTransitive = (0x20 & n9) != 0;
            n8 = this.u2At(n += 2);
            if (n8 > 0) {
                n7 = this.constantPoolOffsets[n8];
                this.requires[n4].required_version = this.utf8At(n7 + 3, this.u2At(n7 + 1));
            }
            n += 2;
        }
        n5 = this.u2At(n);
        n += 2;
        this.exportsCount = n5;
        this.exports = new PackageExportInfo[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            PackageExportInfo packageExportInfo;
            n6 = this.constantPoolOffsets[this.u2At(n)];
            n7 = this.constantPoolOffsets[this.u2At(n6 + 1)];
            cArray2 = this.utf8At(n7 + 3, this.u2At(n7 + 1));
            CharOperation.replace(cArray2, '/', '.');
            this.exports[n4] = packageExportInfo = new PackageExportInfo();
            packageExportInfo.packageName = cArray2;
            packageExportInfo.modifiers = this.u2At(n += 2);
            n3 = this.u2At(n += 2);
            n += 2;
            if (n3 <= 0) continue;
            packageExportInfo.exportedTo = new char[n3][];
            packageExportInfo.exportedToCount = n3;
            for (n2 = 0; n2 < n3; ++n2) {
                n6 = this.constantPoolOffsets[this.u2At(n)];
                n7 = this.constantPoolOffsets[this.u2At(n6 + 1)];
                cArray = this.utf8At(n7 + 3, this.u2At(n7 + 1));
                CharOperation.replace(cArray, '/', '.');
                packageExportInfo.exportedTo[n2] = cArray;
                n += 2;
            }
        }
        n5 = this.u2At(n);
        n += 2;
        this.opensCount = n5;
        this.opens = new PackageExportInfo[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            PackageExportInfo packageExportInfo;
            n6 = this.constantPoolOffsets[this.u2At(n)];
            n7 = this.constantPoolOffsets[this.u2At(n6 + 1)];
            cArray2 = this.utf8At(n7 + 3, this.u2At(n7 + 1));
            CharOperation.replace(cArray2, '/', '.');
            this.opens[n4] = packageExportInfo = new PackageExportInfo();
            packageExportInfo.packageName = cArray2;
            packageExportInfo.modifiers = this.u2At(n += 2);
            n3 = this.u2At(n += 2);
            n += 2;
            if (n3 <= 0) continue;
            packageExportInfo.exportedTo = new char[n3][];
            packageExportInfo.exportedToCount = n3;
            for (n2 = 0; n2 < n3; ++n2) {
                n6 = this.constantPoolOffsets[this.u2At(n)];
                n7 = this.constantPoolOffsets[this.u2At(n6 + 1)];
                cArray = this.utf8At(n7 + 3, this.u2At(n7 + 1));
                CharOperation.replace(cArray, '/', '.');
                packageExportInfo.exportedTo[n2] = cArray;
                n += 2;
            }
        }
        n5 = this.u2At(n);
        n += 2;
        this.usesCount = n5;
        this.uses = new char[n5][];
        for (n4 = 0; n4 < n5; ++n4) {
            int n10 = this.constantPoolOffsets[this.u2At(n)];
            n7 = this.constantPoolOffsets[this.u2At(n10 + 1)];
            char[] cArray3 = this.utf8At(n7 + 3, this.u2At(n7 + 1));
            CharOperation.replace(cArray3, '/', '.');
            this.uses[n4] = cArray3;
            n += 2;
        }
        n5 = this.u2At(n);
        n += 2;
        this.providesCount = n5;
        this.provides = new ServiceInfo[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            int n11 = this.constantPoolOffsets[this.u2At(n)];
            n7 = this.constantPoolOffsets[this.u2At(n11 + 1)];
            char[] cArray4 = this.utf8At(n7 + 3, this.u2At(n7 + 1));
            CharOperation.replace(cArray4, '/', '.');
            ServiceInfo serviceInfo = new ServiceInfo();
            this.provides[n4] = serviceInfo;
            serviceInfo.serviceName = cArray4;
            n2 = this.u2At(n += 2);
            n += 2;
            serviceInfo.with = new char[n2][];
            if (n2 <= 0) continue;
            serviceInfo.with = new char[n2][];
            for (int i = 0; i < n2; ++i) {
                n11 = this.constantPoolOffsets[this.u2At(n)];
                n7 = this.constantPoolOffsets[this.u2At(n11 + 1)];
                char[] cArray5 = this.utf8At(n7 + 3, this.u2At(n7 + 1));
                CharOperation.replace(cArray5, '/', '.');
                serviceInfo.with[i] = cArray5;
                n += 2;
            }
        }
    }

    void setAnnotations(AnnotationInfo[] annotationInfoArray, long l2, boolean bl) {
        this.annotations = annotationInfoArray;
        this.tagBits = l2;
        if (bl) {
            int n = annotationInfoArray.length;
            for (int i = 0; i < n; ++i) {
                annotationInfoArray[i].initialize();
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IModule)) {
            return false;
        }
        IModule iModule = (IModule)object;
        if (!CharOperation.equals(this.name, iModule.name())) {
            return false;
        }
        return Arrays.equals(this.requires, iModule.requires());
    }

    public int hashCode() {
        int n = 17;
        int n2 = CharOperation.hashCode(this.name);
        n = 31 * n + n2;
        n2 = Arrays.hashCode(this.requires);
        n = 31 * n + n2;
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        this.toStringContent(stringBuffer);
        return stringBuffer.toString();
    }

    protected void toStringContent(StringBuffer stringBuffer) {
        int n;
        stringBuffer.append("\nmodule ");
        stringBuffer.append(this.name).append(' ');
        stringBuffer.append('{').append('\n');
        if (this.requiresCount > 0) {
            for (n = 0; n < this.requiresCount; ++n) {
                stringBuffer.append("\trequires ");
                if (this.requires[n].isTransitive) {
                    stringBuffer.append(" public ");
                }
                stringBuffer.append(this.requires[n].refName);
                stringBuffer.append(';').append('\n');
            }
        }
        if (this.exportsCount > 0) {
            stringBuffer.append('\n');
            for (n = 0; n < this.exportsCount; ++n) {
                stringBuffer.append("\texports ");
                stringBuffer.append(this.exports[n].toString());
            }
        }
        stringBuffer.append('\n').append('}').toString();
    }

    class ModuleReferenceInfo
    implements IModule.IModuleReference {
        char[] refName;
        boolean isTransitive = false;
        int modifiers;
        char[] required_version;

        ModuleReferenceInfo() {
        }

        @Override
        public char[] name() {
            return this.refName;
        }

        @Override
        public boolean isTransitive() {
            return this.isTransitive;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof IModule.IModuleReference)) {
                return false;
            }
            IModule.IModuleReference iModuleReference = (IModule.IModuleReference)object;
            if (this.modifiers != iModuleReference.getModifiers()) {
                return false;
            }
            return CharOperation.equals(this.refName, iModuleReference.name(), false);
        }

        public int hashCode() {
            return CharOperation.hashCode(this.refName);
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }
    }

    class PackageExportInfo
    implements IModule.IPackageExport {
        char[] packageName;
        char[][] exportedTo;
        int exportedToCount;
        int modifiers;

        PackageExportInfo() {
        }

        @Override
        public char[] name() {
            return this.packageName;
        }

        @Override
        public char[][] targets() {
            return this.exportedTo;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            this.toStringContent(stringBuffer);
            return stringBuffer.toString();
        }

        protected void toStringContent(StringBuffer stringBuffer) {
            stringBuffer.append(this.packageName);
            if (this.exportedToCount > 0) {
                stringBuffer.append(" to ");
                for (int i = 0; i < this.exportedToCount; ++i) {
                    stringBuffer.append(this.exportedTo[i]);
                    stringBuffer.append(',').append(' ');
                }
            }
            stringBuffer.append(';').append('\n');
        }
    }

    class ServiceInfo
    implements IModule.IService {
        char[] serviceName;
        char[][] with;

        ServiceInfo() {
        }

        @Override
        public char[] name() {
            return this.serviceName;
        }

        @Override
        public char[][] with() {
            return this.with;
        }
    }
}

