/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.RecordComponent;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RecordComponentBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeCollisionException;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;

public class ClassScope
extends Scope {
    public TypeDeclaration referenceContext;
    public TypeReference superTypeReference;
    ArrayList<Object> deferredBoundChecks;

    public ClassScope(Scope scope, TypeDeclaration typeDeclaration) {
        super(3, scope);
        this.referenceContext = typeDeclaration;
        this.deferredBoundChecks = null;
    }

    void buildAnonymousTypeBinding(SourceTypeBinding sourceTypeBinding, ReferenceBinding referenceBinding) {
        Object object;
        LocalTypeBinding localTypeBinding = this.buildLocalType(sourceTypeBinding, sourceTypeBinding.fPackage);
        localTypeBinding.modifiers |= 0x8000000;
        int n = referenceBinding.typeBits;
        if ((n & 4) != 0 && (object = this.referenceContext.methods) != null) {
            for (int i = 0; i < ((AbstractMethodDeclaration[])object).length; ++i) {
                if (!CharOperation.equals(TypeConstants.CLOSE, object[i].selector) || object[i].arguments != null) continue;
                n &= 0x713;
                break;
            }
        }
        localTypeBinding.typeBits |= n;
        localTypeBinding.setPermittedTypes(Binding.NO_PERMITTEDTYPES);
        if (referenceBinding.isInterface()) {
            localTypeBinding.setSuperClass(this.getJavaLangObject());
            localTypeBinding.setSuperInterfaces(new ReferenceBinding[]{referenceBinding});
            object = this.referenceContext.allocation.type;
            if (object != null) {
                this.referenceContext.superInterfaces = new TypeReference[]{object};
                if ((referenceBinding.tagBits & 0x40000000L) != 0L) {
                    this.problemReporter().superTypeCannotUseWildcard(localTypeBinding, (TypeReference)object, referenceBinding);
                    localTypeBinding.tagBits |= 0x20000L;
                    localTypeBinding.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
                }
            }
        } else {
            localTypeBinding.setSuperClass(referenceBinding);
            localTypeBinding.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
            this.checkForEnumSealedPreview(referenceBinding, localTypeBinding);
            object = this.referenceContext.allocation.type;
            if (object != null) {
                this.referenceContext.superclass = object;
                if (referenceBinding.erasure().id == 41) {
                    this.problemReporter().cannotExtendEnum(localTypeBinding, (TypeReference)object, referenceBinding);
                    localTypeBinding.tagBits |= 0x20000L;
                    localTypeBinding.setSuperClass(this.getJavaLangObject());
                } else if (referenceBinding.erasure().id == 93) {
                    if (!this.referenceContext.isRecord()) {
                        this.problemReporter().recordCannotExtendRecord(localTypeBinding, (TypeReference)object, referenceBinding);
                        localTypeBinding.tagBits |= 0x20000L;
                        localTypeBinding.setSuperClass(this.getJavaLangObject());
                    }
                } else if (referenceBinding.isFinal()) {
                    this.problemReporter().anonymousClassCannotExtendFinalClass((TypeReference)object, referenceBinding);
                    localTypeBinding.tagBits |= 0x20000L;
                    localTypeBinding.setSuperClass(this.getJavaLangObject());
                } else if ((referenceBinding.tagBits & 0x40000000L) != 0L) {
                    this.problemReporter().superTypeCannotUseWildcard(localTypeBinding, (TypeReference)object, referenceBinding);
                    localTypeBinding.tagBits |= 0x20000L;
                    localTypeBinding.setSuperClass(this.getJavaLangObject());
                } else if (referenceBinding.isSealed()) {
                    this.problemReporter().sealedAnonymousClassCannotExtendSealedType((TypeReference)object, referenceBinding);
                    localTypeBinding.tagBits |= 0x20000L;
                    localTypeBinding.setSuperClass(this.getJavaLangObject());
                }
            }
        }
        this.connectMemberTypes();
        this.buildFieldsAndMethods();
        localTypeBinding.faultInTypesForFieldsAndMethods();
        localTypeBinding.verifyMethods(this.environment().methodVerifier());
    }

    private void checkForEnumSealedPreview(ReferenceBinding referenceBinding, LocalTypeBinding localTypeBinding) {
        int n;
        if (!(this.compilerOptions().sourceLevel >= 0x3B0000L && this.compilerOptions().enablePreviewFeatures && referenceBinding.isEnum() && referenceBinding instanceof SourceTypeBinding)) {
            return;
        }
        SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)referenceBinding;
        ReferenceBinding[] referenceBindingArray = sourceTypeBinding.permittedTypes();
        int n2 = n = referenceBindingArray == null ? 0 : referenceBindingArray.length;
        if (n == 0) {
            referenceBindingArray = new ReferenceBinding[]{localTypeBinding};
        } else {
            ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
            referenceBindingArray = new ReferenceBinding[n + 1];
            System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n);
            referenceBindingArray[n] = localTypeBinding;
        }
        sourceTypeBinding.setPermittedTypes(referenceBindingArray);
    }

    void buildComponents() {
        int n;
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if (!sourceTypeBinding.isRecord()) {
            return;
        }
        if (sourceTypeBinding.areComponentsInitialized()) {
            return;
        }
        if (this.referenceContext.recordComponents == null) {
            sourceTypeBinding.setComponents(Binding.NO_COMPONENTS);
            return;
        }
        RecordComponent[] recordComponentArray = this.referenceContext.recordComponents;
        int n2 = n = recordComponentArray.length;
        RecordComponentBinding[] recordComponentBindingArray = new RecordComponentBinding[n2];
        HashtableOfObject hashtableOfObject = new HashtableOfObject(n2);
        n2 = 0;
        for (int i = 0; i < n; ++i) {
            RecordComponent recordComponent = recordComponentArray[i];
            RecordComponentBinding recordComponentBinding = new RecordComponentBinding(sourceTypeBinding, recordComponent, null, recordComponent.modifiers | 0x2000000);
            recordComponentBinding.id = n2;
            this.checkAndSetModifiersForComponents(recordComponentBinding, recordComponent);
            if (hashtableOfObject.containsKey(recordComponent.name)) {
                RecordComponentBinding recordComponentBinding2 = (RecordComponentBinding)hashtableOfObject.get(recordComponent.name);
                if (recordComponentBinding2 != null) {
                    for (int j = 0; j < i; ++j) {
                        RecordComponent recordComponent2 = recordComponentArray[j];
                        if (recordComponent2.binding != recordComponentBinding2) continue;
                        this.problemReporter().recordDuplicateComponent(recordComponent2);
                        break;
                    }
                }
                hashtableOfObject.put(recordComponent.name, null);
                this.problemReporter().recordDuplicateComponent(recordComponent);
                recordComponent.binding = null;
                continue;
            }
            hashtableOfObject.put(recordComponent.name, recordComponentBinding);
            recordComponentBindingArray[n2++] = recordComponentBinding;
        }
        if (n2 != recordComponentBindingArray.length) {
            RecordComponentBinding[] recordComponentBindingArray2 = recordComponentBindingArray;
            recordComponentBindingArray = new RecordComponentBinding[n2];
            System.arraycopy(recordComponentBindingArray2, 0, recordComponentBindingArray, 0, n2);
        }
        sourceTypeBinding.setComponents(recordComponentBindingArray);
    }

    private void checkAndSetModifiersForComponents(RecordComponentBinding recordComponentBinding, RecordComponent recordComponent) {
        int n = recordComponentBinding.modifiers;
        int n2 = n & 0xFFFF;
        if (n2 != 0 && recordComponent != null) {
            this.problemReporter().recordComponentsCannotHaveModifiers(recordComponent);
        }
    }

    void buildFields() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if (sourceTypeBinding.areFieldsInitialized()) {
            return;
        }
        if (this.referenceContext.fields == null) {
            sourceTypeBinding.setFields(Binding.NO_FIELDS);
            return;
        }
        FieldDeclaration[] fieldDeclarationArray = this.referenceContext.fields;
        int n = fieldDeclarationArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            switch (fieldDeclarationArray[i].getKind()) {
                case 1: 
                case 3: {
                    ++n2;
                }
            }
        }
        FieldBinding[] fieldBindingArray = new FieldBinding[n2];
        HashtableOfObject hashtableOfObject = new HashtableOfObject(n2);
        n2 = 0;
        for (int i = 0; i < n; ++i) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[i];
            if (fieldDeclaration.getKind() == 2) continue;
            FieldBinding fieldBinding = new FieldBinding(fieldDeclaration, null, fieldDeclaration.modifiers | 0x2000000, sourceTypeBinding);
            fieldBinding.id = n2;
            this.checkAndSetModifiersForField(fieldBinding, fieldDeclaration);
            if (hashtableOfObject.containsKey(fieldDeclaration.name)) {
                FieldBinding fieldBinding2 = (FieldBinding)hashtableOfObject.get(fieldDeclaration.name);
                if (fieldBinding2 != null) {
                    for (int j = 0; j < i; ++j) {
                        FieldDeclaration fieldDeclaration2 = fieldDeclarationArray[j];
                        if (fieldDeclaration2.binding != fieldBinding2) continue;
                        this.problemReporter().duplicateFieldInType(sourceTypeBinding, fieldDeclaration2);
                        break;
                    }
                }
                hashtableOfObject.put(fieldDeclaration.name, null);
                this.problemReporter().duplicateFieldInType(sourceTypeBinding, fieldDeclaration);
                fieldDeclaration.binding = null;
                continue;
            }
            hashtableOfObject.put(fieldDeclaration.name, fieldBinding);
            fieldBindingArray[n2++] = fieldBinding;
        }
        if (n2 != fieldBindingArray.length) {
            FieldBinding[] fieldBindingArray2 = fieldBindingArray;
            fieldBindingArray = new FieldBinding[n2];
            System.arraycopy(fieldBindingArray2, 0, fieldBindingArray, 0, n2);
        }
        sourceTypeBinding.tagBits &= 0xFFFFFFFFFFFFCFFFL;
        sourceTypeBinding.setFields(fieldBindingArray);
    }

    void buildFieldsAndMethods() {
        this.buildComponents();
        this.buildFields();
        this.buildMethods();
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if (!sourceTypeBinding.isPrivate() && sourceTypeBinding.superclass instanceof SourceTypeBinding && sourceTypeBinding.superclass.isPrivate()) {
            ((SourceTypeBinding)sourceTypeBinding.superclass).tagIndirectlyAccessibleMembers();
        }
        if (sourceTypeBinding.isMemberType() && !sourceTypeBinding.isLocalType()) {
            ((MemberTypeBinding)sourceTypeBinding).checkSyntheticArgsAndFields();
        }
        ReferenceBinding[] referenceBindingArray = sourceTypeBinding.memberTypes;
        int n = referenceBindingArray.length;
        for (int i = 0; i < n; ++i) {
            ((SourceTypeBinding)referenceBindingArray[i]).scope.buildFieldsAndMethods();
        }
    }

    private LocalTypeBinding buildLocalType(SourceTypeBinding sourceTypeBinding, PackageBinding packageBinding) {
        this.referenceContext.scope = this;
        this.referenceContext.staticInitializerScope = new MethodScope(this, this.referenceContext, true);
        this.referenceContext.initializerScope = new MethodScope(this, this.referenceContext, false);
        LocalTypeBinding localTypeBinding = new LocalTypeBinding(this, sourceTypeBinding, this.innermostSwitchCase());
        this.referenceContext.binding = localTypeBinding;
        this.checkAndSetModifiers();
        this.buildTypeVariables();
        ReferenceBinding[] referenceBindingArray = Binding.NO_MEMBER_TYPES;
        if (this.referenceContext.memberTypes != null) {
            int n = this.referenceContext.memberTypes.length;
            referenceBindingArray = new ReferenceBinding[n];
            int n2 = 0;
            block3: for (int i = 0; i < n; ++i) {
                TypeDeclaration typeDeclaration = this.referenceContext.memberTypes[i];
                switch (TypeDeclaration.kind(typeDeclaration.modifiers)) {
                    case 2: 
                    case 4: {
                        this.problemReporter().illegalLocalTypeDeclaration(typeDeclaration);
                        continue block3;
                    }
                    default: {
                        ReferenceBinding referenceBinding = localTypeBinding;
                        do {
                            if (!CharOperation.equals(referenceBinding.sourceName, typeDeclaration.name)) continue;
                            this.problemReporter().typeCollidesWithEnclosingType(typeDeclaration);
                            continue block3;
                        } while ((referenceBinding = ((TypeBinding)referenceBinding).enclosingType()) != null);
                        for (int j = 0; j < i; ++j) {
                            if (!CharOperation.equals(this.referenceContext.memberTypes[j].name, typeDeclaration.name)) continue;
                            this.problemReporter().duplicateNestedType(typeDeclaration);
                            continue block3;
                        }
                        ClassScope classScope = new ClassScope(this, this.referenceContext.memberTypes[i]);
                        LocalTypeBinding localTypeBinding2 = classScope.buildLocalType(localTypeBinding, packageBinding);
                        localTypeBinding2.setAsMemberType();
                        referenceBindingArray[n2++] = localTypeBinding2;
                    }
                }
            }
            if (n2 != n) {
                ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2];
                System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n2);
            }
        }
        localTypeBinding.setMemberTypes(referenceBindingArray);
        return localTypeBinding;
    }

    void buildLocalTypeBinding(SourceTypeBinding sourceTypeBinding) {
        LocalTypeBinding localTypeBinding = this.buildLocalType(sourceTypeBinding, sourceTypeBinding.fPackage);
        this.connectTypeHierarchy();
        this.connectImplicitPermittedTypes();
        if (this.compilerOptions().sourceLevel >= 0x310000L) {
            this.checkParameterizedTypeBounds();
            this.checkParameterizedSuperTypeCollisions();
        }
        this.buildFieldsAndMethods();
        localTypeBinding.faultInTypesForFieldsAndMethods();
        this.referenceContext.binding.verifyMethods(this.environment().methodVerifier());
    }

    private void buildMemberTypes(AccessRestriction accessRestriction) {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        ReferenceBinding[] referenceBindingArray = Binding.NO_MEMBER_TYPES;
        if (this.referenceContext.memberTypes != null) {
            int n = this.referenceContext.memberTypes.length;
            referenceBindingArray = new ReferenceBinding[n];
            int n2 = 0;
            block3: for (int i = 0; i < n; ++i) {
                TypeDeclaration typeDeclaration = this.referenceContext.memberTypes[i];
                if (this.environment().root.isProcessingAnnotations && this.environment().isMissingType(typeDeclaration.name)) {
                    throw new SourceTypeCollisionException();
                }
                switch (TypeDeclaration.kind(typeDeclaration.modifiers)) {
                    case 2: 
                    case 4: {
                        if (sourceTypeBinding.isNestedType() && sourceTypeBinding.isClass() && !sourceTypeBinding.isStatic()) {
                            this.problemReporter().illegalLocalTypeDeclaration(typeDeclaration);
                            continue block3;
                        }
                    }
                    default: {
                        ReferenceBinding referenceBinding = sourceTypeBinding;
                        do {
                            if (!CharOperation.equals(referenceBinding.sourceName, typeDeclaration.name)) continue;
                            this.problemReporter().typeCollidesWithEnclosingType(typeDeclaration);
                            continue block3;
                        } while ((referenceBinding = referenceBinding.enclosingType()) != null);
                        for (int j = 0; j < i; ++j) {
                            if (!CharOperation.equals(this.referenceContext.memberTypes[j].name, typeDeclaration.name)) continue;
                            this.problemReporter().duplicateNestedType(typeDeclaration);
                            continue block3;
                        }
                        ClassScope classScope = new ClassScope(this, typeDeclaration);
                        referenceBindingArray[n2++] = classScope.buildType(sourceTypeBinding, sourceTypeBinding.fPackage, accessRestriction);
                    }
                }
            }
            if (n2 != n) {
                ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2];
                System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n2);
            }
        }
        sourceTypeBinding.setMemberTypes(referenceBindingArray);
    }

    void buildMethods() {
        Object object;
        int n;
        int n2;
        boolean bl;
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if (sourceTypeBinding.areMethodsInitialized()) {
            return;
        }
        boolean bl2 = bl = TypeDeclaration.kind(this.referenceContext.modifiers) == 3;
        if (this.referenceContext.methods == null && !bl && !sourceTypeBinding.isRecord()) {
            this.referenceContext.binding.setMethods(Binding.NO_METHODS);
            return;
        }
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = this.referenceContext.methods;
        int n3 = abstractMethodDeclarationArray == null ? 0 : abstractMethodDeclarationArray.length;
        int n4 = -1;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!abstractMethodDeclarationArray[n2].isClinit()) continue;
            n4 = n2;
            break;
        }
        n2 = bl ? 2 : 0;
        MethodBinding[] methodBindingArray = new MethodBinding[(n4 == -1 ? n3 : n3 - 1) + n2];
        if (bl) {
            methodBindingArray[0] = sourceTypeBinding.addSyntheticEnumMethod(TypeConstants.VALUES);
            methodBindingArray[1] = sourceTypeBinding.addSyntheticEnumMethod(TypeConstants.VALUEOF);
        }
        boolean bl3 = false;
        if (sourceTypeBinding.isAbstract()) {
            for (n = 0; n < n3; ++n) {
                MethodScope methodScope;
                if (n == n4 || (object = (methodScope = new MethodScope(this, abstractMethodDeclarationArray[n], false)).createMethod(abstractMethodDeclarationArray[n])) == null) continue;
                methodBindingArray[n2++] = object;
                bl3 = bl3 || ((MethodBinding)object).isNative();
            }
        } else {
            n = 0;
            for (int i = 0; i < n3; ++i) {
                MethodBinding methodBinding;
                if (i == n4 || (methodBinding = ((MethodScope)(object = new MethodScope(this, abstractMethodDeclarationArray[i], false))).createMethod(abstractMethodDeclarationArray[i])) == null) continue;
                methodBindingArray[n2++] = methodBinding;
                n = n != 0 || methodBinding.isAbstract() ? 1 : 0;
                bl3 = bl3 || methodBinding.isNative();
            }
            if (n != 0) {
                this.problemReporter().abstractMethodInConcreteClass(sourceTypeBinding);
            }
        }
        if (sourceTypeBinding.isRecord()) {
            assert (this.referenceContext.isRecord());
            methodBindingArray = sourceTypeBinding.checkAndAddSyntheticRecordMethods(methodBindingArray, n2);
            n2 = methodBindingArray.length;
        }
        if (n2 != methodBindingArray.length) {
            MethodBinding[] methodBindingArray2 = methodBindingArray;
            methodBindingArray = new MethodBinding[n2];
            System.arraycopy(methodBindingArray2, 0, methodBindingArray, 0, n2);
        }
        sourceTypeBinding.tagBits &= 0xFFFFFFFFFFFF3FFFL;
        sourceTypeBinding.setMethods(methodBindingArray);
        if (bl3) {
            for (n = 0; n < methodBindingArray.length; ++n) {
                methodBindingArray[n].modifiers |= 0x8000000;
            }
            FieldBinding[] fieldBindingArray = sourceTypeBinding.unResolvedFields();
            for (int i = 0; i < fieldBindingArray.length; ++i) {
                fieldBindingArray[i].modifiers |= 0x8000000;
            }
        }
        if (bl && this.compilerOptions().isAnnotationBasedNullAnalysisEnabled) {
            LookupEnvironment lookupEnvironment = this.environment();
            ((SyntheticMethodBinding)methodBindingArray[0]).markNonNull(lookupEnvironment);
            ((SyntheticMethodBinding)methodBindingArray[1]).markNonNull(lookupEnvironment);
        }
    }

    SourceTypeBinding buildType(SourceTypeBinding sourceTypeBinding, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        Object object;
        this.referenceContext.scope = this;
        this.referenceContext.staticInitializerScope = new MethodScope(this, this.referenceContext, true);
        this.referenceContext.initializerScope = new MethodScope(this, this.referenceContext, false);
        if (sourceTypeBinding == null) {
            object = CharOperation.arrayConcat(packageBinding.compoundName, this.referenceContext.name);
            this.referenceContext.binding = new SourceTypeBinding((char[][])object, packageBinding, this);
        } else {
            object = CharOperation.deepCopy(sourceTypeBinding.compoundName);
            object[((char[][])object).length - 1] = CharOperation.concat(object[((char[][])object).length - 1], this.referenceContext.name, '$');
            if (packageBinding.hasType0Any(object[((char[][])object).length - 1])) {
                this.parent.problemReporter().duplicateNestedType(this.referenceContext);
            }
            this.referenceContext.binding = new MemberTypeBinding((char[][])object, this, sourceTypeBinding);
        }
        object = this.referenceContext.binding;
        object.module = this.module();
        this.environment().setAccessRestriction((ReferenceBinding)object, accessRestriction);
        TypeParameter[] typeParameterArray = this.referenceContext.typeParameters;
        object.typeVariables = typeParameterArray == null || typeParameterArray.length == 0 ? Binding.NO_TYPE_VARIABLES : null;
        object.fPackage.addType((ReferenceBinding)object);
        this.checkAndSetModifiers();
        this.buildTypeVariables();
        this.buildMemberTypes(accessRestriction);
        return object;
    }

    private void buildTypeVariables() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        TypeParameter[] typeParameterArray = this.referenceContext.typeParameters;
        if (typeParameterArray == null || typeParameterArray.length == 0) {
            sourceTypeBinding.setTypeVariables(Binding.NO_TYPE_VARIABLES);
            return;
        }
        sourceTypeBinding.setTypeVariables(Binding.NO_TYPE_VARIABLES);
        if (sourceTypeBinding.id == 1) {
            this.problemReporter().objectCannotBeGeneric(this.referenceContext);
            return;
        }
        sourceTypeBinding.setTypeVariables(this.createTypeVariables(typeParameterArray, sourceTypeBinding));
        sourceTypeBinding.modifiers |= 0x40000000;
    }

    @Override
    void resolveTypeParameter(TypeParameter typeParameter) {
        typeParameter.resolve(this);
    }

    private void checkAndSetModifiers() {
        Binding binding;
        Object object;
        boolean bl;
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        int n = sourceTypeBinding.modifiers;
        boolean bl2 = this.compilerOptions().sourceLevel == ClassFileConstants.getLatestJDKLevel() && this.compilerOptions().enablePreviewFeatures;
        boolean bl3 = bl = bl2 && (n & 0x14000000) != 0;
        if (sourceTypeBinding.isRecord()) {
            n |= 0x10;
        }
        if ((n & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForType(sourceTypeBinding);
        }
        ReferenceBinding referenceBinding = sourceTypeBinding.enclosingType();
        boolean bl4 = sourceTypeBinding.isMemberType();
        if (bl4) {
            if (sourceTypeBinding.hasEnclosingInstanceContext()) {
                n |= referenceBinding.modifiers & 0x40000000;
            }
            n |= referenceBinding.modifiers & 0x800;
            if (referenceBinding.isInterface()) {
                n |= 1;
            }
            if (sourceTypeBinding.isEnum()) {
                if (!referenceBinding.isStatic()) {
                    this.problemReporter().nonStaticContextForEnumMemberType(sourceTypeBinding);
                } else {
                    n |= 8;
                }
            } else if (sourceTypeBinding.isInterface()) {
                n |= 8;
            } else if (sourceTypeBinding.isRecord()) {
                n |= 8;
            }
        } else if (sourceTypeBinding.isLocalType()) {
            if (sourceTypeBinding.isEnum()) {
                if (!bl2) {
                    this.problemReporter().illegalLocalTypeDeclaration(this.referenceContext);
                    sourceTypeBinding.modifiers = 0;
                    return;
                }
                if ((n & 0xFFFF & 0xFFFFB7FF) != 0 || bl) {
                    this.problemReporter().illegalModifierForLocalEnumDeclaration(sourceTypeBinding);
                    return;
                }
                n |= 8;
            } else if (sourceTypeBinding.isRecord()) {
                if (referenceBinding != null && referenceBinding.isLocalType()) {
                    this.problemReporter().illegalLocalTypeDeclaration(this.referenceContext);
                    return;
                }
                if ((n & 8) != 0) {
                    this.problemReporter().recordIllegalStaticModifierForLocalClassOrInterface(sourceTypeBinding);
                    return;
                }
                n |= 8;
            }
            if (sourceTypeBinding.isAnonymousType()) {
                if (this.compilerOptions().complianceLevel < 0x350000L) {
                    n |= 0x10;
                }
                if (this.referenceContext.allocation.type == null) {
                    n |= 0x4000;
                }
            }
            Scope scope = this;
            block4: do {
                switch (scope.kind) {
                    case 2: {
                        object = (MethodScope)scope;
                        if (((MethodScope)object).isLambdaScope()) {
                            object = ((Scope)object).namedMethodScope();
                        }
                        if (((MethodScope)object).isInsideInitializer()) {
                            binding = ((TypeDeclaration)((MethodScope)object).referenceContext).binding;
                            if (((MethodScope)object).initializedField != null) {
                                if (!((MethodScope)object).initializedField.isViewedAsDeprecated() || sourceTypeBinding.isDeprecated()) continue block4;
                                n |= 0x200000;
                                break;
                            }
                            if (((ReferenceBinding)binding).isStrictfp()) {
                                n |= 0x800;
                            }
                            if (!((ReferenceBinding)binding).isViewedAsDeprecated() || sourceTypeBinding.isDeprecated()) continue block4;
                            n |= 0x200000;
                            break;
                        }
                        binding = ((AbstractMethodDeclaration)((MethodScope)object).referenceContext).binding;
                        if (binding == null) continue block4;
                        if (((MethodBinding)binding).isStrictfp()) {
                            n |= 0x800;
                        }
                        if (!((MethodBinding)binding).isViewedAsDeprecated() || sourceTypeBinding.isDeprecated()) continue block4;
                        n |= 0x200000;
                        break;
                    }
                    case 3: {
                        if (referenceBinding.isStrictfp()) {
                            n |= 0x800;
                        }
                        if (!referenceBinding.isViewedAsDeprecated() || sourceTypeBinding.isDeprecated()) continue block4;
                        n |= 0x200000;
                        sourceTypeBinding.tagBits |= referenceBinding.tagBits & 0x4000000000000000L;
                    }
                }
            } while ((scope = scope.parent) != null);
        }
        int n2 = n & 0xFFFF;
        if ((n2 & 0x200) != 0) {
            if (bl4) {
                if ((n2 & 0xFFFFD1F0) != 0) {
                    if ((n2 & 0x2000) != 0) {
                        this.problemReporter().illegalModifierForAnnotationMemberType(sourceTypeBinding);
                    } else {
                        this.problemReporter().illegalModifierForMemberInterface(sourceTypeBinding);
                    }
                }
            } else if (bl2 && sourceTypeBinding.isLocalType()) {
                if ((n2 & 0xFFFFD1FF) != 0 || bl) {
                    this.problemReporter().localStaticsIllegalVisibilityModifierForInterfaceLocalType(sourceTypeBinding);
                }
                n |= 8;
            } else if ((n2 & 0xFFFFD1FE) != 0) {
                if ((n2 & 0x2000) != 0) {
                    this.problemReporter().illegalModifierForAnnotationType(sourceTypeBinding);
                } else {
                    this.problemReporter().illegalModifierForInterface(sourceTypeBinding);
                }
            }
            if (sourceTypeBinding.sourceName == TypeConstants.PACKAGE_INFO_NAME && this.compilerOptions().targetJDK > 0x310000L) {
                n |= 0x1000;
            }
            n |= 0x400;
        } else if ((n2 & 0x4000) != 0) {
            if (bl4) {
                if ((n2 & 0xFFFFB7F0) != 0 || bl) {
                    this.problemReporter().illegalModifierForMemberEnum(sourceTypeBinding);
                    n &= 0xFFFFFBFF;
                    n2 &= 0xFFFFFBFF;
                }
            } else if (!sourceTypeBinding.isLocalType() && ((n2 & 0xFFFFB7FE) != 0 || bl)) {
                this.problemReporter().illegalModifierForEnum(sourceTypeBinding);
            }
            if (!sourceTypeBinding.isAnonymousType()) {
                block104: {
                    if ((this.referenceContext.bits & 0x800) != 0) {
                        n |= 0x400;
                    } else {
                        int n3;
                        object = this.referenceContext;
                        binding = ((TypeDeclaration)object).fields;
                        int n4 = n3 = binding == null ? 0 : ((Binding)binding).length;
                        if (n3 != 0) {
                            int n5;
                            AbstractMethodDeclaration[] abstractMethodDeclarationArray = ((TypeDeclaration)object).methods;
                            int n6 = abstractMethodDeclarationArray == null ? 0 : abstractMethodDeclarationArray.length;
                            boolean bl5 = ((TypeDeclaration)object).superInterfaces != null;
                            for (n5 = 0; n5 < n6 && !bl5; ++n5) {
                                bl5 = abstractMethodDeclarationArray[n5].isAbstract();
                            }
                            if (bl5) {
                                n5 = 0;
                                for (int i = 0; i < n3; ++i) {
                                    Binding binding2 = binding[i];
                                    if (((FieldDeclaration)((Object)binding2)).getKind() != 3) continue;
                                    if (((FieldDeclaration)((Object)binding2)).initialization instanceof QualifiedAllocationExpression) {
                                        n5 = 1;
                                        continue;
                                    }
                                    break block104;
                                }
                                if (n5 != 0) {
                                    n |= 0x400;
                                }
                            }
                        }
                    }
                }
                object = this.referenceContext;
                binding = ((TypeDeclaration)object).fields;
                if (binding != null) {
                    for (Binding binding3 : binding) {
                        if (((FieldDeclaration)((Object)binding3)).getKind() != 3 || !(((FieldDeclaration)((Object)binding3)).initialization instanceof QualifiedAllocationExpression)) {
                            continue;
                        }
                        break;
                    }
                } else {
                    n |= 0x10;
                }
                if (bl2 && (n & 0x10) == 0) {
                    n |= 0x10000000;
                }
            }
        } else if (sourceTypeBinding.isRecord()) {
            int n7 = 0x14000000;
            if (bl4) {
                if ((n2 & 0xFFFFF7E0) != 0 || (n & n7) != 0) {
                    this.problemReporter().illegalModifierForInnerRecord(sourceTypeBinding);
                }
            } else if (sourceTypeBinding.isLocalType()) {
                if ((n2 & 0xFFFFF7E7) != 0 || (n & n7) != 0) {
                    this.problemReporter().illegalModifierForLocalRecord(sourceTypeBinding);
                }
            } else if ((n2 & 0xFFFFF7EE) != 0 || (n & n7) != 0) {
                this.problemReporter().illegalModifierForRecord(sourceTypeBinding);
            }
        } else {
            if (bl4) {
                if ((n2 & 0xFFFFF3E0) != 0) {
                    this.problemReporter().illegalModifierForMemberClass(sourceTypeBinding);
                }
            } else if (sourceTypeBinding.isLocalType()) {
                if ((n2 & 0xFFFFF3EF) != 0 || bl) {
                    this.problemReporter().illegalModifierForLocalClass(sourceTypeBinding);
                }
            } else if ((n2 & 0xFFFFF3EE) != 0) {
                this.problemReporter().illegalModifierForClass(sourceTypeBinding);
            }
            if ((n2 & 0x410) == 1040) {
                this.problemReporter().illegalModifierCombinationFinalAbstractForClass(sourceTypeBinding);
            }
        }
        if (bl4) {
            if (referenceBinding.isInterface()) {
                if ((n2 & 6) != 0) {
                    this.problemReporter().illegalVisibilityModifierForInterfaceMemberType(sourceTypeBinding);
                    if ((n2 & 4) != 0) {
                        n &= 0xFFFFFFFB;
                    }
                    if ((n2 & 2) != 0) {
                        n &= 0xFFFFFFFD;
                    }
                }
            } else {
                int n8 = n2 & 7;
                if ((n8 & n8 - 1) > 1) {
                    this.problemReporter().illegalVisibilityModifierCombinationForMemberType(sourceTypeBinding);
                    if ((n8 & 1) != 0) {
                        if ((n8 & 4) != 0) {
                            n &= 0xFFFFFFFB;
                        }
                        if ((n8 & 2) != 0) {
                            n &= 0xFFFFFFFD;
                        }
                    } else if ((n8 & 4) != 0 && (n8 & 2) != 0) {
                        n &= 0xFFFFFFFD;
                    }
                }
            }
            if ((n2 & 8) == 0) {
                if (referenceBinding.isInterface()) {
                    n |= 8;
                }
            } else if (!referenceBinding.isStatic()) {
                if (sourceTypeBinding.isRecord()) {
                    this.problemReporter().recordNestedRecordInherentlyStatic(sourceTypeBinding);
                } else {
                    this.problemReporter().illegalStaticModifierForMemberType(sourceTypeBinding);
                }
            }
        }
        sourceTypeBinding.modifiers = n;
    }

    private void checkAndSetModifiersForField(FieldBinding fieldBinding, FieldDeclaration fieldDeclaration) {
        int n;
        int n2 = fieldBinding.modifiers;
        ReferenceBinding referenceBinding = fieldBinding.declaringClass;
        if ((n2 & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForField(referenceBinding, fieldDeclaration);
        }
        if (referenceBinding.isInterface()) {
            if (((n2 |= 0x19) & 0xFFFF) != 25) {
                if ((referenceBinding.modifiers & 0x2000) != 0) {
                    this.problemReporter().illegalModifierForAnnotationField(fieldDeclaration);
                } else {
                    this.problemReporter().illegalModifierForInterfaceField(fieldDeclaration);
                }
            }
            fieldBinding.modifiers = n2;
            return;
        }
        if (fieldDeclaration.getKind() == 3) {
            if ((n2 & 0xFFFF) != 0) {
                this.problemReporter().illegalModifierForEnumConstant(referenceBinding, fieldDeclaration);
            }
            fieldBinding.modifiers |= 0x8004019;
            return;
        }
        int n3 = n2 & 0xFFFF;
        if ((n3 & 0xFFFFFF20) != 0) {
            this.problemReporter().illegalModifierForField(referenceBinding, fieldDeclaration);
            n2 &= 0xFFFF00DF;
        }
        if (((n = n3 & 7) & n - 1) > 1) {
            this.problemReporter().illegalVisibilityModifierCombinationForField(referenceBinding, fieldDeclaration);
            if ((n & 1) != 0) {
                if ((n & 4) != 0) {
                    n2 &= 0xFFFFFFFB;
                }
                if ((n & 2) != 0) {
                    n2 &= 0xFFFFFFFD;
                }
            } else if ((n & 4) != 0 && (n & 2) != 0) {
                n2 &= 0xFFFFFFFD;
            }
        }
        if ((n3 & 0x50) == 80) {
            this.problemReporter().illegalModifierCombinationFinalVolatileForField(referenceBinding, fieldDeclaration);
        }
        if (fieldDeclaration.initialization == null && (n2 & 0x10) != 0) {
            n2 |= 0x4000000;
        }
        fieldBinding.modifiers = n2;
    }

    public void checkParameterizedSuperTypeCollisions() {
        int n;
        ReferenceBinding referenceBinding;
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        ReferenceBinding[] referenceBindingArray = sourceTypeBinding.superInterfaces;
        HashMap hashMap = new HashMap(2);
        ReferenceBinding referenceBinding2 = sourceTypeBinding.isInterface() ? null : sourceTypeBinding.superclass;
        int n2 = referenceBindingArray.length;
        for (int i = 0; i < n2; ++i) {
            ReferenceBinding referenceBinding3 = referenceBindingArray[i];
            if (referenceBinding3 == null || referenceBinding2 != null && this.hasErasedCandidatesCollisions(referenceBinding2, referenceBinding3, hashMap, sourceTypeBinding, this.referenceContext)) continue;
            for (int j = 0; !(j >= i || (referenceBinding = referenceBindingArray[j]) != null && this.hasErasedCandidatesCollisions(referenceBinding3, referenceBinding, hashMap, sourceTypeBinding, this.referenceContext)); ++j) {
            }
        }
        TypeParameter[] typeParameterArray = this.referenceContext.typeParameters;
        int n3 = n = typeParameterArray == null ? 0 : typeParameterArray.length;
        block2: for (n2 = 0; n2 < n; ++n2) {
            TypeReference[] typeReferenceArray;
            TypeParameter typeParameter = typeParameterArray[n2];
            referenceBinding = typeParameter.binding;
            if (referenceBinding == null || !referenceBinding.isValidBinding() || (typeReferenceArray = typeParameter.bounds) == null) continue;
            boolean bl = TypeBinding.equalsEquals(((TypeVariableBinding)referenceBinding).firstBound, ((TypeVariableBinding)referenceBinding).superclass);
            int n4 = typeReferenceArray.length;
            for (int i = 0; i < n4; ++i) {
                TypeReference typeReference = typeReferenceArray[i];
                TypeBinding typeBinding = typeReference.resolvedType;
                if (typeBinding == null || !typeBinding.isValidBinding()) continue;
                if (bl && this.hasErasedCandidatesCollisions(typeBinding, ((TypeVariableBinding)referenceBinding).superclass, hashMap, referenceBinding, typeReference)) continue block2;
                int n5 = ((TypeVariableBinding)referenceBinding).superInterfaces.length;
                while (--n5 >= 0) {
                    if (!this.hasErasedCandidatesCollisions(typeBinding, ((TypeVariableBinding)referenceBinding).superInterfaces[n5], hashMap, referenceBinding, typeReference)) continue;
                    continue block2;
                }
            }
        }
        ReferenceBinding[] referenceBindingArray2 = this.referenceContext.binding.memberTypes;
        if (referenceBindingArray2 != null && referenceBindingArray2 != Binding.NO_MEMBER_TYPES) {
            int n6 = referenceBindingArray2.length;
            for (n = 0; n < n6; ++n) {
                ((SourceTypeBinding)referenceBindingArray2[n]).scope.checkParameterizedSuperTypeCollisions();
            }
        }
    }

    private void checkForInheritedMemberTypes(SourceTypeBinding sourceTypeBinding) {
        int n;
        ReferenceBinding[] referenceBindingArray;
        int n2;
        ReferenceBinding referenceBinding = sourceTypeBinding;
        ReferenceBinding[] referenceBindingArray2 = null;
        int n3 = 0;
        do {
            if (referenceBinding.hasMemberTypes()) {
                return;
            }
            ReferenceBinding[] referenceBindingArray3 = referenceBinding.superInterfaces();
            if (referenceBindingArray3 == null || referenceBindingArray3 == Binding.NO_SUPERINTERFACES) continue;
            if (referenceBindingArray2 == null) {
                referenceBindingArray2 = referenceBindingArray3;
                n3 = referenceBindingArray2.length;
                continue;
            }
            n2 = referenceBindingArray3.length;
            if (n3 + n2 >= referenceBindingArray2.length) {
                ReferenceBinding[] referenceBindingArray4 = referenceBindingArray2;
                referenceBindingArray2 = new ReferenceBinding[n3 + n2 + 5];
                System.arraycopy(referenceBindingArray4, 0, referenceBindingArray2, 0, n3);
            }
            block1: for (int i = 0; i < n2; ++i) {
                referenceBindingArray = referenceBindingArray3[i];
                for (n = 0; n < n3; ++n) {
                    if (TypeBinding.equalsEquals((TypeBinding)referenceBindingArray, referenceBindingArray2[n])) continue block1;
                }
                referenceBindingArray2[n3++] = referenceBindingArray;
            }
        } while ((referenceBinding = referenceBinding.superclass()) != null && (referenceBinding.tagBits & 0x10000L) == 0L);
        if (referenceBindingArray2 != null) {
            boolean bl = false;
            for (n2 = 0; n2 < n3; ++n2) {
                ReferenceBinding referenceBinding2 = referenceBindingArray2[n2];
                if ((referenceBinding2.tagBits & 0x10000L) != 0L) continue;
                if (referenceBinding2.hasMemberTypes()) {
                    return;
                }
                bl = true;
                referenceBindingArray = referenceBinding2.superInterfaces();
                if (referenceBindingArray == null || referenceBindingArray == Binding.NO_SUPERINTERFACES) continue;
                n = referenceBindingArray.length;
                if (n3 + n >= referenceBindingArray2.length) {
                    ReferenceBinding[] referenceBindingArray5 = referenceBindingArray2;
                    referenceBindingArray2 = new ReferenceBinding[n3 + n + 5];
                    System.arraycopy(referenceBindingArray5, 0, referenceBindingArray2, 0, n3);
                }
                block4: for (int i = 0; i < n; ++i) {
                    ReferenceBinding referenceBinding3 = referenceBindingArray[i];
                    for (int j = 0; j < n3; ++j) {
                        if (TypeBinding.equalsEquals(referenceBinding3, referenceBindingArray2[j])) continue block4;
                    }
                    referenceBindingArray2[n3++] = referenceBinding3;
                }
            }
            if (bl) {
                for (n2 = 0; n2 < n3; ++n2) {
                    referenceBindingArray2[n2].tagBits |= 0x10000L;
                }
            }
        }
        referenceBinding = sourceTypeBinding;
        do {
            referenceBinding.tagBits |= 0x10000L;
        } while ((referenceBinding = referenceBinding.superclass()) != null && (referenceBinding.tagBits & 0x10000L) == 0L);
    }

    public void checkParameterizedTypeBounds() {
        int n;
        int n2 = n = this.deferredBoundChecks == null ? 0 : this.deferredBoundChecks.size();
        for (int i = 0; i < n; ++i) {
            Object object = this.deferredBoundChecks.get(i);
            if (object instanceof TypeReference) {
                ((TypeReference)object).checkBounds(this);
                continue;
            }
            if (!(object instanceof Runnable)) continue;
            ((Runnable)object).run();
        }
        this.deferredBoundChecks = null;
        ReferenceBinding[] referenceBindingArray = this.referenceContext.binding.memberTypes;
        if (referenceBindingArray != null && referenceBindingArray != Binding.NO_MEMBER_TYPES) {
            int n3 = referenceBindingArray.length;
            for (n = 0; n < n3; ++n) {
                ((SourceTypeBinding)referenceBindingArray[n]).scope.checkParameterizedTypeBounds();
            }
        }
    }

    private void connectMemberTypes() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        ReferenceBinding[] referenceBindingArray = sourceTypeBinding.memberTypes;
        if (referenceBindingArray != null && referenceBindingArray != Binding.NO_MEMBER_TYPES) {
            int n = referenceBindingArray.length;
            for (int i = 0; i < n; ++i) {
                ((SourceTypeBinding)referenceBindingArray[i]).scope.connectTypeHierarchy();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean connectSuperclass() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if (sourceTypeBinding.id == 1) {
            sourceTypeBinding.setSuperClass(null);
            sourceTypeBinding.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
            sourceTypeBinding.setPermittedTypes(Binding.NO_PERMITTEDTYPES);
            if (!sourceTypeBinding.isClass()) {
                this.problemReporter().objectMustBeClass(sourceTypeBinding);
            }
            if (this.referenceContext.superclass == null) {
                if (this.referenceContext.superInterfaces == null) return true;
                if (this.referenceContext.superInterfaces.length <= 0) return true;
            }
            this.problemReporter().objectCannotHaveSuperTypes(sourceTypeBinding);
            return true;
        }
        if (this.referenceContext.superclass == null) {
            if (sourceTypeBinding.isEnum() && this.compilerOptions().sourceLevel >= 0x310000L) {
                return this.connectEnumSuperclass();
            }
            sourceTypeBinding.setSuperClass(this.getJavaLangObject());
            if (this.detectHierarchyCycle(sourceTypeBinding, sourceTypeBinding.superclass, null)) return false;
            return true;
        }
        TypeReference typeReference = this.referenceContext.superclass;
        ReferenceBinding referenceBinding = this.findSupertype(typeReference);
        if (referenceBinding != null) {
            if (!referenceBinding.isClass() && (referenceBinding.tagBits & 0x80L) == 0L) {
                this.problemReporter().superclassMustBeAClass(sourceTypeBinding, typeReference, referenceBinding);
            } else if (referenceBinding.isFinal()) {
                this.problemReporter().classExtendFinalClass(sourceTypeBinding, typeReference, referenceBinding);
            } else if ((referenceBinding.tagBits & 0x40000000L) != 0L) {
                this.problemReporter().superTypeCannotUseWildcard(sourceTypeBinding, typeReference, referenceBinding);
            } else if (referenceBinding.erasure().id == 41) {
                this.problemReporter().cannotExtendEnum(sourceTypeBinding, typeReference, referenceBinding);
            } else if (referenceBinding.erasure().id == 93) {
                if (this.referenceContext.isRecord()) return this.connectRecordSuperclass();
                this.problemReporter().recordCannotExtendRecord(sourceTypeBinding, typeReference, referenceBinding);
            } else {
                if ((referenceBinding.tagBits & 0x20000L) != 0L || !typeReference.resolvedType.isValidBinding()) {
                    sourceTypeBinding.setSuperClass(referenceBinding);
                    sourceTypeBinding.tagBits |= 0x20000L;
                    return typeReference.resolvedType.isValidBinding();
                }
                sourceTypeBinding.setSuperClass(referenceBinding);
                sourceTypeBinding.typeBits |= referenceBinding.typeBits & 0x713;
                if ((sourceTypeBinding.typeBits & 3) == 0) return true;
                sourceTypeBinding.typeBits |= sourceTypeBinding.applyCloseableClassWhitelists(this.compilerOptions());
                return true;
            }
        }
        sourceTypeBinding.tagBits |= 0x20000L;
        sourceTypeBinding.setSuperClass(sourceTypeBinding.isRecord() ? this.getJavaLangRecord() : this.getJavaLangObject());
        if ((sourceTypeBinding.superclass.tagBits & 0x100L) != 0L) return false;
        this.detectHierarchyCycle(sourceTypeBinding, sourceTypeBinding.superclass, null);
        return false;
    }

    private boolean connectEnumSuperclass() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        ReferenceBinding referenceBinding = this.getJavaLangEnum();
        if ((referenceBinding.tagBits & 0x80L) != 0L) {
            sourceTypeBinding.tagBits |= 0x20000L;
            sourceTypeBinding.setSuperClass(referenceBinding);
            return false;
        }
        boolean bl = this.detectHierarchyCycle(sourceTypeBinding, referenceBinding, null);
        TypeVariableBinding[] typeVariableBindingArray = referenceBinding.typeVariables();
        if (typeVariableBindingArray == Binding.NO_TYPE_VARIABLES) {
            this.problemReporter().nonGenericTypeCannotBeParameterized(0, null, referenceBinding, new TypeBinding[]{sourceTypeBinding});
            return false;
        }
        if (1 != typeVariableBindingArray.length) {
            this.problemReporter().incorrectArityForParameterizedType(null, referenceBinding, new TypeBinding[]{sourceTypeBinding});
            return false;
        }
        ParameterizedTypeBinding parameterizedTypeBinding = this.environment().createParameterizedType(referenceBinding, new TypeBinding[]{this.environment().convertToRawType(sourceTypeBinding, false)}, null);
        sourceTypeBinding.tagBits |= parameterizedTypeBinding.tagBits & 0x20000L;
        sourceTypeBinding.setSuperClass(parameterizedTypeBinding);
        if (!typeVariableBindingArray[0].boundCheck(parameterizedTypeBinding, sourceTypeBinding, this, null).isOKbyJLS()) {
            this.problemReporter().typeMismatchError((TypeBinding)referenceBinding, typeVariableBindingArray[0], sourceTypeBinding, null);
        }
        return !bl;
    }

    /*
     * WARNING - void declaration
     */
    private void connectImplicitPermittedTypes(SourceTypeBinding sourceTypeBinding) {
        void referenceBinding;
        ArrayList<SourceTypeBinding> arrayList = new ArrayList<SourceTypeBinding>();
        Object linkedHashSet = this.referenceCompilationUnit().types;
        int n = ((TypeDeclaration[])linkedHashSet).length;
        boolean bl = false;
        while (referenceBinding < n) {
            TypeDeclaration typeDeclaration = linkedHashSet[referenceBinding];
            arrayList.addAll(sourceTypeBinding.collectAllTypeBindings(typeDeclaration, this.compilationUnitScope()));
            ++referenceBinding;
        }
        linkedHashSet = new LinkedHashSet();
        for (ReferenceBinding referenceBinding2 : arrayList) {
            if (TypeBinding.equalsEquals(referenceBinding2, sourceTypeBinding) || referenceBinding2.findSuperTypeOriginatingFrom(sourceTypeBinding) == null) continue;
            linkedHashSet.add(referenceBinding2);
        }
        if (!sourceTypeBinding.isSealed() || sourceTypeBinding.isLocalType()) {
            // empty if block
        }
        if (linkedHashSet.size() == 0) {
            if (!sourceTypeBinding.isLocalType()) {
                this.problemReporter().sealedSealedTypeMissingPermits(sourceTypeBinding, this.referenceContext);
            }
            return;
        }
        sourceTypeBinding.setPermittedTypes(linkedHashSet.toArray(new ReferenceBinding[0]));
    }

    void connectImplicitPermittedTypes() {
        ReferenceBinding[] referenceBindingArray;
        TypeDeclaration typeDeclaration = this.referenceContext;
        SourceTypeBinding sourceTypeBinding = typeDeclaration.binding;
        if (sourceTypeBinding.id == 1 || sourceTypeBinding.isEnum() || sourceTypeBinding.isRecord()) {
            return;
        }
        if (sourceTypeBinding.isSealed() && (typeDeclaration.permittedTypes == null || typeDeclaration.permittedTypes.length == 0)) {
            this.connectImplicitPermittedTypes(sourceTypeBinding);
        }
        if ((referenceBindingArray = sourceTypeBinding.memberTypes) != null && referenceBindingArray != Binding.NO_MEMBER_TYPES) {
            int n = referenceBindingArray.length;
            for (int i = 0; i < n; ++i) {
                ((SourceTypeBinding)referenceBindingArray[i]).scope.connectImplicitPermittedTypes();
            }
        }
    }

    void connectPermittedTypes() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        sourceTypeBinding.setPermittedTypes(Binding.NO_PERMITTEDTYPES);
        if (this.referenceContext.permittedTypes == null) {
            return;
        }
        if (sourceTypeBinding.id == 1 || sourceTypeBinding.isEnum()) {
            return;
        }
        int n = this.referenceContext.permittedTypes.length;
        ReferenceBinding[] referenceBindingArray = new ReferenceBinding[n];
        int n2 = 0;
        block0: for (int i = 0; i < n; ++i) {
            TypeReference typeReference = this.referenceContext.permittedTypes[i];
            ReferenceBinding referenceBinding = this.findPermittedtype(typeReference);
            if (referenceBinding == null) continue;
            for (int j = 0; j < i; ++j) {
                if (!TypeBinding.equalsEquals(referenceBindingArray[j], referenceBinding)) continue;
                this.problemReporter().sealedDuplicateTypeInPermits(sourceTypeBinding, typeReference, referenceBinding);
                continue block0;
            }
            referenceBindingArray[n2++] = referenceBinding;
        }
        if (n2 > 0) {
            if (n2 != n) {
                ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2];
                System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n2);
            }
            sourceTypeBinding.setPermittedTypes(referenceBindingArray);
        } else {
            sourceTypeBinding.setPermittedTypes(Binding.NO_PERMITTEDTYPES);
        }
    }

    private boolean connectRecordSuperclass() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        ReferenceBinding referenceBinding = this.getJavaLangRecord();
        sourceTypeBinding.setSuperClass(referenceBinding);
        if ((referenceBinding.tagBits & 0x80L) != 0L) {
            sourceTypeBinding.tagBits |= 0x20000L;
            return false;
        }
        return !this.detectHierarchyCycle(sourceTypeBinding, referenceBinding, null);
    }

    private boolean connectSuperInterfaces() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        sourceTypeBinding.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
        if (this.referenceContext.superInterfaces == null) {
            if (sourceTypeBinding.isAnnotationType() && this.compilerOptions().sourceLevel >= 0x310000L) {
                ReferenceBinding referenceBinding = this.getJavaLangAnnotationAnnotation();
                boolean bl = this.detectHierarchyCycle(sourceTypeBinding, referenceBinding, null);
                sourceTypeBinding.setSuperInterfaces(new ReferenceBinding[]{referenceBinding});
                return !bl;
            }
            return true;
        }
        if (sourceTypeBinding.id == 1) {
            return true;
        }
        boolean bl = true;
        int n = this.referenceContext.superInterfaces.length;
        ReferenceBinding[] referenceBindingArray = new ReferenceBinding[n];
        int n2 = 0;
        block0: for (int i = 0; i < n; ++i) {
            TypeReference typeReference = this.referenceContext.superInterfaces[i];
            ReferenceBinding referenceBinding = this.findSupertype(typeReference);
            if (referenceBinding == null) {
                sourceTypeBinding.tagBits |= 0x20000L;
                bl = false;
                continue;
            }
            for (int j = 0; j < i; ++j) {
                if (!TypeBinding.equalsEquals(referenceBindingArray[j], referenceBinding)) continue;
                this.problemReporter().duplicateSuperinterface(sourceTypeBinding, typeReference, referenceBinding);
                sourceTypeBinding.tagBits |= 0x20000L;
                bl = false;
                continue block0;
            }
            if (!referenceBinding.isInterface() && (referenceBinding.tagBits & 0x80L) == 0L) {
                this.problemReporter().superinterfaceMustBeAnInterface(sourceTypeBinding, typeReference, referenceBinding);
                sourceTypeBinding.tagBits |= 0x20000L;
                bl = false;
                continue;
            }
            if (referenceBinding.isAnnotationType()) {
                this.problemReporter().annotationTypeUsedAsSuperinterface(sourceTypeBinding, typeReference, referenceBinding);
            }
            if ((referenceBinding.tagBits & 0x40000000L) != 0L) {
                this.problemReporter().superTypeCannotUseWildcard(sourceTypeBinding, typeReference, referenceBinding);
                sourceTypeBinding.tagBits |= 0x20000L;
                bl = false;
                continue;
            }
            if ((referenceBinding.tagBits & 0x20000L) != 0L || !typeReference.resolvedType.isValidBinding()) {
                sourceTypeBinding.tagBits |= 0x20000L;
                bl &= typeReference.resolvedType.isValidBinding();
            }
            sourceTypeBinding.typeBits |= referenceBinding.typeBits & 0x713;
            if ((sourceTypeBinding.typeBits & 3) != 0) {
                sourceTypeBinding.typeBits |= sourceTypeBinding.applyCloseableInterfaceWhitelists();
            }
            referenceBindingArray[n2++] = referenceBinding;
        }
        if (n2 > 0) {
            if (n2 != n) {
                ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2];
                System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n2);
            }
            sourceTypeBinding.setSuperInterfaces(referenceBindingArray);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectTypeHierarchy() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        boolean bl = compilationUnitScope.connectingHierarchy;
        compilationUnitScope.connectingHierarchy = true;
        try {
            if ((sourceTypeBinding.tagBits & 0x100L) == 0L) {
                sourceTypeBinding.tagBits |= 0x100L;
                this.environment().typesBeingConnected.add(sourceTypeBinding);
                boolean bl2 = this.connectSuperclass();
                bl2 &= this.connectSuperInterfaces();
                this.connectPermittedTypes();
                this.environment().typesBeingConnected.remove(sourceTypeBinding);
                sourceTypeBinding.tagBits |= 0x200L;
                sourceTypeBinding.tagBits |= 0x40000L;
                if ((bl2 &= this.connectTypeVariables(this.referenceContext.typeParameters, false)) && sourceTypeBinding.isHierarchyInconsistent()) {
                    this.problemReporter().hierarchyHasProblems(sourceTypeBinding);
                }
            }
            this.connectMemberTypes();
        }
        finally {
            compilationUnitScope.connectingHierarchy = bl;
        }
        LookupEnvironment lookupEnvironment = this.environment();
        try {
            lookupEnvironment.missingClassFileLocation = this.referenceContext;
            this.checkForInheritedMemberTypes(sourceTypeBinding);
        }
        catch (AbortCompilation abortCompilation) {
            abortCompilation.updateContext(this.referenceContext, this.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
        finally {
            lookupEnvironment.missingClassFileLocation = null;
        }
    }

    @Override
    public boolean deferCheck(Runnable runnable) {
        if (this.compilationUnitScope().connectingHierarchy) {
            if (this.deferredBoundChecks == null) {
                this.deferredBoundChecks = new ArrayList();
            }
            this.deferredBoundChecks.add(runnable);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectTypeHierarchyWithoutMembers() {
        if (this.parent instanceof CompilationUnitScope) {
            if (((CompilationUnitScope)this.parent).imports == null) {
                ((CompilationUnitScope)this.parent).checkAndSetImports();
            }
        } else if (this.parent instanceof ClassScope) {
            ((ClassScope)this.parent).connectTypeHierarchyWithoutMembers();
        }
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if ((sourceTypeBinding.tagBits & 0x100L) != 0L) {
            return;
        }
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        boolean bl = compilationUnitScope.connectingHierarchy;
        compilationUnitScope.connectingHierarchy = true;
        try {
            sourceTypeBinding.tagBits |= 0x100L;
            this.environment().typesBeingConnected.add(sourceTypeBinding);
            boolean bl2 = this.connectSuperclass();
            bl2 &= this.connectSuperInterfaces();
            this.connectPermittedTypes();
            this.environment().typesBeingConnected.remove(sourceTypeBinding);
            sourceTypeBinding.tagBits |= 0x200L;
            sourceTypeBinding.tagBits |= 0x40000L;
            if ((bl2 &= this.connectTypeVariables(this.referenceContext.typeParameters, false)) && sourceTypeBinding.isHierarchyInconsistent()) {
                this.problemReporter().hierarchyHasProblems(sourceTypeBinding);
            }
        }
        finally {
            compilationUnitScope.connectingHierarchy = bl;
        }
    }

    public boolean detectHierarchyCycle(TypeBinding typeBinding, TypeReference typeReference) {
        if (!(typeBinding instanceof ReferenceBinding)) {
            return false;
        }
        if (typeReference == this.superTypeReference) {
            if (typeBinding.isTypeVariable()) {
                return false;
            }
            if (typeBinding.isParameterizedType()) {
                typeBinding = ((ParameterizedTypeBinding)typeBinding).genericType();
            }
            this.compilationUnitScope().recordSuperTypeReference(typeBinding);
            return this.detectHierarchyCycle(this.referenceContext.binding, (ReferenceBinding)typeBinding, typeReference);
        }
        if ((typeBinding.tagBits & 0x100L) == 0L && typeBinding instanceof SourceTypeBinding) {
            ((SourceTypeBinding)typeBinding).scope.connectTypeHierarchyWithoutMembers();
        }
        return false;
    }

    private boolean detectHierarchyCycle(SourceTypeBinding sourceTypeBinding, ReferenceBinding referenceBinding, TypeReference typeReference) {
        Object object;
        if (referenceBinding.isRawType()) {
            referenceBinding = ((RawTypeBinding)referenceBinding).genericType();
        }
        if (TypeBinding.equalsEquals(sourceTypeBinding, referenceBinding)) {
            this.problemReporter().hierarchyCircularity(sourceTypeBinding, referenceBinding, typeReference);
            sourceTypeBinding.tagBits |= 0x20000L;
            return true;
        }
        if (referenceBinding.isMemberType()) {
            object = referenceBinding.enclosingType();
            do {
                if (!((ReferenceBinding)object).isHierarchyBeingActivelyConnected()) continue;
                this.problemReporter().hierarchyCircularity(sourceTypeBinding, (ReferenceBinding)object, typeReference);
                sourceTypeBinding.tagBits |= 0x20000L;
                ((ReferenceBinding)object).tagBits |= 0x20000L;
                return true;
            } while ((object = ((TypeBinding)object).enclosingType()) != null);
        }
        if (referenceBinding.isBinaryBinding()) {
            ReferenceBinding[] referenceBindingArray;
            if (referenceBinding.problemId() != 1 && (referenceBinding.tagBits & 0x20000L) != 0L) {
                sourceTypeBinding.tagBits |= 0x20000L;
                this.problemReporter().hierarchyHasProblems(sourceTypeBinding);
                return true;
            }
            boolean bl = false;
            ReferenceBinding referenceBinding2 = referenceBinding.superclass();
            if (referenceBinding2 != null) {
                if (TypeBinding.equalsEquals(sourceTypeBinding, referenceBinding2)) {
                    this.problemReporter().hierarchyCircularity(sourceTypeBinding, referenceBinding, typeReference);
                    sourceTypeBinding.tagBits |= 0x20000L;
                    referenceBinding.tagBits |= 0x20000L;
                    return true;
                }
                if (referenceBinding2.isParameterizedType()) {
                    referenceBinding2 = ((ParameterizedTypeBinding)referenceBinding2).genericType();
                }
                bl |= this.detectHierarchyCycle(sourceTypeBinding, referenceBinding2, typeReference);
                if ((referenceBinding2.tagBits & 0x20000L) != 0L) {
                    sourceTypeBinding.tagBits |= 0x20000L;
                    referenceBinding2.tagBits |= 0x20000L;
                }
            }
            if ((referenceBindingArray = referenceBinding.superInterfaces()) != null && referenceBindingArray != Binding.NO_SUPERINTERFACES) {
                for (ReferenceBinding referenceBinding3 : referenceBindingArray) {
                    if (TypeBinding.equalsEquals(sourceTypeBinding, referenceBinding3)) {
                        this.problemReporter().hierarchyCircularity(sourceTypeBinding, referenceBinding, typeReference);
                        sourceTypeBinding.tagBits |= 0x20000L;
                        referenceBinding.tagBits |= 0x20000L;
                        return true;
                    }
                    if (referenceBinding3.isParameterizedType()) {
                        referenceBinding3 = ((ParameterizedTypeBinding)referenceBinding3).genericType();
                    }
                    bl |= this.detectHierarchyCycle(sourceTypeBinding, referenceBinding3, typeReference);
                    if ((referenceBinding3.tagBits & 0x20000L) == 0L) continue;
                    sourceTypeBinding.tagBits |= 0x20000L;
                    referenceBinding.tagBits |= 0x20000L;
                }
            }
            return bl;
        }
        if (referenceBinding.isHierarchyBeingActivelyConnected()) {
            Object object2;
            object = ((SourceTypeBinding)referenceBinding).scope.superTypeReference;
            if (object != null && ((TypeReference)object).resolvedType != null) {
                object2 = (ReferenceBinding)((TypeReference)object).resolvedType;
                do {
                    if (!((ReferenceBinding)object2).isHierarchyBeingActivelyConnected()) continue;
                    this.problemReporter().hierarchyCircularity(sourceTypeBinding, referenceBinding, typeReference);
                    sourceTypeBinding.tagBits |= 0x20000L;
                    referenceBinding.tagBits |= 0x20000L;
                    return true;
                } while ((object2 = ((TypeBinding)object2).enclosingType()) != null);
            }
            if (object != null && ((TypeReference)object).resolvedType == null) {
                object2 = ((TypeReference)object).getLastToken();
                for (SourceTypeBinding sourceTypeBinding2 : this.environment().typesBeingConnected) {
                    if (!CharOperation.equals((char[])object2, sourceTypeBinding2.sourceName())) continue;
                    this.problemReporter().hierarchyCircularity(sourceTypeBinding, referenceBinding, typeReference);
                    sourceTypeBinding.tagBits |= 0x20000L;
                    referenceBinding.tagBits |= 0x20000L;
                    return true;
                }
            }
        }
        if ((referenceBinding.tagBits & 0x100L) == 0L && referenceBinding.isValidBinding() && !referenceBinding.isUnresolvedType()) {
            ((SourceTypeBinding)referenceBinding).scope.connectTypeHierarchyWithoutMembers();
        }
        if ((referenceBinding.tagBits & 0x20000L) != 0L) {
            sourceTypeBinding.tagBits |= 0x20000L;
        }
        return false;
    }

    private ReferenceBinding findSupertype(TypeReference typeReference) {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        LookupEnvironment lookupEnvironment = compilationUnitScope.environment;
        try {
            ReferenceBinding referenceBinding;
            lookupEnvironment.missingClassFileLocation = typeReference;
            typeReference.aboutToResolve(this);
            compilationUnitScope.recordQualifiedReference(typeReference.getTypeName());
            this.superTypeReference = typeReference;
            ReferenceBinding referenceBinding2 = referenceBinding = (ReferenceBinding)typeReference.resolveSuperType(this);
            return referenceBinding2;
        }
        catch (AbortCompilation abortCompilation) {
            SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
            if (sourceTypeBinding.superInterfaces == null) {
                sourceTypeBinding.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
            }
            if (sourceTypeBinding.permittedTypes == null) {
                sourceTypeBinding.setPermittedTypes(Binding.NO_PERMITTEDTYPES);
            }
            abortCompilation.updateContext(typeReference, this.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
        finally {
            lookupEnvironment.missingClassFileLocation = null;
            this.superTypeReference = null;
        }
    }

    private ReferenceBinding findPermittedtype(TypeReference typeReference) {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        LookupEnvironment lookupEnvironment = compilationUnitScope.environment;
        try {
            ReferenceBinding referenceBinding;
            lookupEnvironment.missingClassFileLocation = typeReference;
            typeReference.aboutToResolve(this);
            compilationUnitScope.recordQualifiedReference(typeReference.getTypeName());
            ReferenceBinding referenceBinding2 = referenceBinding = (ReferenceBinding)typeReference.resolveType(this);
            return referenceBinding2;
        }
        catch (AbortCompilation abortCompilation) {
            SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
            if (sourceTypeBinding.permittedTypes == null) {
                sourceTypeBinding.setPermittedTypes(Binding.NO_PERMITTEDTYPES);
            }
            abortCompilation.updateContext(typeReference, this.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
        finally {
            lookupEnvironment.missingClassFileLocation = null;
        }
    }

    @Override
    public ProblemReporter problemReporter() {
        MethodScope methodScope = this.outerMostMethodScope();
        if (methodScope == null) {
            ProblemReporter problemReporter = this.referenceCompilationUnit().problemReporter;
            problemReporter.referenceContext = this.referenceContext;
            return problemReporter;
        }
        return methodScope.problemReporter();
    }

    public TypeDeclaration referenceType() {
        return this.referenceContext;
    }

    @Override
    public boolean hasDefaultNullnessFor(int n, int n2) {
        int n3;
        int n4 = this.localNonNullByDefaultValue(n2);
        if (n4 != 0) {
            return (n4 & n) != 0;
        }
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if (sourceTypeBinding != null && (n3 = sourceTypeBinding.getNullDefault()) != 0) {
            return (n3 & n) != 0;
        }
        return this.parent.hasDefaultNullnessFor(n, n2);
    }

    @Override
    public Binding checkRedundantDefaultNullness(int n, int n2) {
        int n3;
        Binding binding = this.localCheckRedundantDefaultNullness(n, n2);
        if (binding != null) {
            return binding;
        }
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if (sourceTypeBinding != null && (n3 = sourceTypeBinding.getNullDefault()) != 0) {
            return n3 == n ? sourceTypeBinding : null;
        }
        return this.parent.checkRedundantDefaultNullness(n, n2);
    }

    public String toString() {
        if (this.referenceContext != null) {
            return "--- Class Scope ---\n\n" + this.referenceContext.binding.toString();
        }
        return "--- Class Scope ---\n\n Binding not initialized";
    }
}

