/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.util.CtSym;
import org.eclipse.jdt.internal.compiler.util.JrtFileSystem;
import org.eclipse.jdt.internal.compiler.util.RuntimeIOException;

public class JRTUtil {
    public static final boolean DISABLE_CACHE = Boolean.getBoolean("org.eclipse.jdt.disable_JRT_cache");
    public static final String JAVA_BASE = "java.base".intern();
    public static final char[] JAVA_BASE_CHAR = JAVA_BASE.toCharArray();
    static final String MODULES_SUBDIR = "/modules";
    static final String[] DEFAULT_MODULE = new String[]{JAVA_BASE};
    static final String[] NO_MODULE = new String[0];
    static final String MULTIPLE = "MU";
    static final String DEFAULT_PACKAGE = "";
    static String MODULE_TO_LOAD;
    public static final String JRT_FS_JAR = "jrt-fs.jar";
    static URI JRT_URI;
    public static final int NOTIFY_FILES = 1;
    public static final int NOTIFY_PACKAGES = 2;
    public static final int NOTIFY_MODULES = 4;
    public static final int NOTIFY_ALL = 7;
    private static Map<String, Optional<JrtFileSystem>> images;
    private static final Map<Path, CtSym> ctSymFiles;

    public static JrtFileSystem getJrtSystem(File file2) {
        return JRTUtil.getJrtSystem(file2, null);
    }

    public static JrtFileSystem getJrtSystem(File file2, String string) {
        String string3 = file2.toString();
        if (string != null) {
            string3 = string3 + "|" + string;
        }
        Optional optional = images.computeIfAbsent(string3, string2 -> {
            try {
                return Optional.ofNullable(JrtFileSystem.getNewJrtFileSystem(file2, string));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return Optional.empty();
            }
        });
        return optional.orElse(null);
    }

    public static CtSym getCtSym(Path path2) throws IOException {
        CtSym ctSym2;
        try {
            ctSym2 = ctSymFiles.compute(path2, (path, ctSym) -> {
                if (ctSym == null || !ctSym.getFs().isOpen()) {
                    try {
                        return new CtSym((Path)path);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeIOException(iOException);
                    }
                }
                return ctSym;
            });
        }
        catch (RuntimeIOException runtimeIOException) {
            throw runtimeIOException.getCause();
        }
        return ctSym2;
    }

    public static void reset() {
        images.clear();
        MODULE_TO_LOAD = System.getProperty("modules.to.load");
    }

    public static void walkModuleImage(File file2, JrtFileVisitor<Path> jrtFileVisitor, int n) throws IOException {
        JRTUtil.getJrtSystem(file2, null).walkModuleImage(jrtFileVisitor, n);
    }

    public static void walkModuleImage(File file2, String string, JrtFileVisitor<Path> jrtFileVisitor, int n) throws IOException {
        JRTUtil.getJrtSystem(file2, string).walkModuleImage(jrtFileVisitor, n);
    }

    public static InputStream getContentFromJrt(File file2, String string, String string2) throws IOException {
        return JRTUtil.getJrtSystem(file2).getContentFromJrt(string, string2);
    }

    public static byte[] getClassfileContent(File file2, String string, String string2) throws IOException {
        return JRTUtil.getJrtSystem(file2).getClassfileContent(string, string2);
    }

    public static ClassFileReader getClassfile(File file2, String string, IModule iModule) throws IOException, ClassFormatException {
        return JRTUtil.getJrtSystem(file2).getClassfile(string, iModule);
    }

    public static ClassFileReader getClassfile(File file2, String string, String string2, Predicate<String> predicate) throws IOException, ClassFormatException {
        return JRTUtil.getJrtSystem(file2).getClassfile(string, string2, predicate);
    }

    public static List<String> getModulesDeclaringPackage(File file2, String string, String string2) {
        return JRTUtil.getJrtSystem(file2).getModulesDeclaringPackage(string, string2);
    }

    public static boolean hasCompilationUnit(File file2, String string, String string2) {
        return JRTUtil.getJrtSystem(file2).hasClassFile(string, string2);
    }

    public static String sanitizedFileName(Path path) {
        String string = path.getFileName().toString();
        if (string.length() > 1 && string.charAt(string.length() - 1) == '/') {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static byte[] safeReadBytes(Path path) throws IOException {
        try {
            return Files.readAllBytes(path);
        }
        catch (ClosedByInterruptException | NoSuchFileException iOException) {
            return null;
        }
    }

    static {
        JRT_URI = URI.create("jrt:/");
        images = new ConcurrentHashMap<String, Optional<JrtFileSystem>>();
        ctSymFiles = new ConcurrentHashMap<Path, CtSym>();
    }

    public static interface JrtFileVisitor<T> {
        public FileVisitResult visitPackage(T var1, T var2, BasicFileAttributes var3) throws IOException;

        public FileVisitResult visitFile(T var1, T var2, BasicFileAttributes var3) throws IOException;

        public FileVisitResult visitModule(T var1, String var2) throws IOException;
    }

    static abstract class AbstractFileVisitor<T>
    implements FileVisitor<T> {
        AbstractFileVisitor() {
        }

        @Override
        public FileVisitResult preVisitDirectory(T t, BasicFileAttributes basicFileAttributes) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(T t, BasicFileAttributes basicFileAttributes) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(T t, IOException iOException) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(T t, IOException iOException) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }
}

