/*
 * Decompiled with CFR 0.152.
 */
package org.rexxla.bsf;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.IOUtils;
import org.rexxla.bsf.engines.rexx.RexxEngine;
import org.rexxla.bsf.engines.rexx.RexxException;

public class RexxDispatcher {
    public static final String version = "404.20240707";
    private static final String keyName = "allCommandLineArguments";

    private RexxDispatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String string;
        if (stringArray.length == 0) {
            System.err.println("usage:\n\tjava RexxDispatcher rexx_file_name [arguments]");
            System.exit(1);
        }
        if (System.getProperty("os.name").startsWith("Mac")) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            string = stringArray[0];
            int n = string.lastIndexOf("/");
            if (n >= 0 && n + 1 < string.length()) {
                string = string.substring(n + 1);
            }
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "BSF4ooRexx [" + string + "]");
        }
        string = null;
        String string2 = null;
        Vector<String> vector = null;
        Object var4_5 = null;
        BSFManager bSFManager = null;
        RexxEngine rexxEngine = null;
        try {
            bSFManager = new BSFManager();
            bSFManager.declareBean(keyName, stringArray, stringArray.getClass());
            rexxEngine = (RexxEngine)bSFManager.loadScriptingEngine("rexx");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        if (stringArray.length > 1) {
            vector = new Vector<String>();
            string2 = "";
            boolean bl = false;
            for (int i = 1; i < stringArray.length; ++i) {
                string2 = string2 + (string2.length() > 0 ? " " : "");
                bl = false;
                for (int j = 0; j < stringArray[i].length() && !bl; ++j) {
                    bl = stringArray[i].charAt(j) == ' ';
                }
                string2 = string2 + (bl ? "\"" : "") + stringArray[i] + (bl ? "\"" : "");
            }
            vector.addElement(string2);
        }
        try {
            String string3 = RexxDispatcher.findFile(stringArray[0]);
            if (string3 == null) {
                System.err.println("RexxDispatcher.java: Rexx program \"" + stringArray[0] + "\" can neither be found in current directory (\".\") nor in 'java.library.path'=\"" + System.getProperty("java.library.path") + "\"), aborting...");
                System.exit(-1);
            }
            Object object = rexxEngine.apply(string3, 0, 0, IOUtils.getStringFromReader(new FileReader(string3)), null, vector);
        }
        catch (Throwable throwable) {
            System.err.println("RexxDispatcher.java: Throwable of type '" + throwable.getClass().getName() + "' thrown while invoking Rexx:\ngetLocalizedMessage(): [" + throwable.getLocalizedMessage() + "]");
            try {
                rexxEngine.terminate();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            System.exit(-1);
        }
        finally {
            block23: {
                try {
                    rexxEngine.terminate();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof RexxException) break block23;
                    System.err.println("\nRexxDispatcher.java: a '" + throwable.getClass().getName() + "' thrown while terminating Rexx instance: [" + throwable.getLocalizedMessage() + "]");
                    throwable.printStackTrace();
                }
            }
        }
        System.exit(0);
    }

    static String findFile(String string) {
        String[] stringArray;
        File file = new File(string);
        try {
            if (file.exists()) {
                return file.getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string2 = System.getProperty("file.separator");
        for (String string3 : stringArray = System.getProperty("java.library.path").split(System.getProperty("path.separator"))) {
            String string4 = string3 + string2 + string;
            file = new File(string4);
            if (!file.exists()) continue;
            try {
                return file.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

