/*
 * Decompiled with CFR 0.152.
 */
package org.rexxla.bsf.engines.rexx;

import org.apache.bsf.BSFException;
import org.rexxla.bsf.engines.rexx.RexxAndJava;

public class RexxStrictArgument {
    Class<?> classObject = null;
    Object value = null;

    public Class<?> getClassObject() {
        return this.classObject;
    }

    public Object getValue() {
        return this.value;
    }

    public RexxStrictArgument(Object object) throws BSFException {
        if (object == null) {
            throw new BSFException(0, "RexxScriptArgument: argument \"obj\" must not be \"null\"");
        }
        this.value = object;
        this.classObject = object.getClass();
    }

    public RexxStrictArgument(Class<?> clazz, Object object) throws BSFException {
        if (clazz == null) {
            throw new BSFException(0, "RexxScriptArgument: argument \"type\" must not be \"null\"");
        }
        if (object == null) {
            this.classObject = clazz;
            return;
        }
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new BSFException(0, "RexxScriptArgument: argument \"value\"=[" + object + "] (class=[" + (object != null ? object.getClass() : null) + "]) cannot be cast to argument \"type\"=[" + clazz + "]");
        }
        this.classObject = clazz;
        this.value = object;
    }

    RexxStrictArgument(RexxAndJava rexxAndJava, String string, String string2, boolean bl) throws BSFException {
        if (string != null) {
            switch (Character.toUpperCase(string.charAt(0))) {
                case 'S': {
                    if (string.length() == 1) break;
                    switch (Character.toUpperCase(string.charAt(1))) {
                        case 'T': {
                            this.value = string2;
                            this.classObject = String.class;
                            return;
                        }
                        case 'H': {
                            this.value = Short.valueOf(string2);
                            this.classObject = bl ? Short.TYPE : Short.class;
                            return;
                        }
                    }
                }
                case 'I': {
                    this.value = Integer.valueOf(string2);
                    this.classObject = bl ? Integer.TYPE : Integer.class;
                    return;
                }
                case 'C': {
                    Class<Character> clazz = this.classObject = bl ? Character.TYPE : Character.class;
                    if (string2 == null || string2.length() == 0) {
                        this.value = Character.valueOf('\u0000');
                        return;
                    }
                    this.value = Character.valueOf(string2.charAt(0));
                    return;
                }
                case 'B': {
                    if (string.length() == 1) break;
                    switch (Character.toUpperCase(string.charAt(1))) {
                        case 'O': {
                            this.classObject = bl ? Boolean.TYPE : Boolean.class;
                            this.value = string2 != null && (string2.equals("1") || string2.equalsIgnoreCase("true")) ? Boolean.TRUE : Boolean.FALSE;
                            return;
                        }
                        case 'Y': {
                            this.value = Byte.valueOf(string2);
                            this.classObject = bl ? Byte.TYPE : Byte.class;
                            return;
                        }
                    }
                }
                case 'F': {
                    this.value = Float.valueOf(string2);
                    this.classObject = bl ? Float.TYPE : Float.class;
                    return;
                }
                case 'L': {
                    this.value = Long.valueOf(string2);
                    this.classObject = bl ? Long.TYPE : Long.class;
                    return;
                }
                case 'D': {
                    this.value = Double.valueOf(string2);
                    this.classObject = bl ? Double.TYPE : Double.class;
                    return;
                }
            }
        }
        throw new BSFException(0, "RexxStrictArgument: argument \"type\": unknown [" + string + "] or argument \"strValue\" [" + string2 + "] not compatible");
    }

    public String toString() {
        return "RexxStrictArgument[classObject=\"" + this.classObject + "\",value=\"" + this.value + "\"]";
    }

    public Object getValue4Rexx() {
        if (this.classObject.isPrimitive()) {
            if (this.classObject == Boolean.TYPE || this.classObject == Boolean.class) {
                return (Boolean)this.value != false ? "1" : "0";
            }
            return this.value.toString();
        }
        return this.value;
    }
}

