/*
 * Decompiled with CFR 0.152.
 */
package org.netrexx.process;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Vector;
import netrexx.lang.Rexx;
import netrexx.lang.RexxIO;
import org.netrexx.process.RxChunk;
import org.netrexx.process.RxParser;
import org.netrexx.process.RxProgram;
import org.netrexx.process.RxQuit;
import org.netrexx.process.RxToken;
import org.netrexx.process.RxTranslator;
import org.netrexx.process.RxWarn;

public class RxStreamer {
    private static final Rexx $01 = Rexx.toRexx(".java");
    private static final Rexx $02 = Rexx.toRexx(".crossref");
    private static final Rexx $03 = Rexx.toRexx(".mod");
    private static final Rexx $04 = Rexx.toRexx("# *** out:");
    private static final Rexx $05 = new Rexx('0');
    private static final Rexx $06 = Rexx.toRexx("#      ---");
    private static final Rexx $07 = Rexx.toRexx("[null]");
    private static final Rexx $08 = Rexx.toRexx("");
    private static final Rexx $09 = new Rexx('[');
    private static final Rexx $010 = new Rexx(']');
    private static final String $0 = "RxStreamer.nrx";
    private static final Rexx blank = new Rexx(' ');
    private static final Rexx linesep = new Rexx(System.getProperty("line.separator"));
    private static final char[] linesepchars = linesep.toCharArray();
    private static final char[] jcomstart = "//".toCharArray();
    private static final char[] jncomstart = "(-".toCharArray();
    private static final char[] jncomend = "-)".toCharArray();
    public Rexx outfile = Rexx.toRexx("");
    public Rexx outfilefull = Rexx.toRexx("");
    public int chunks = 0;
    public ByteArrayOutputStream byteoutstream = null;
    private File outfileob;
    private OutputStreamWriter outhandle;
    private int lastinlineno = 0;
    private Vector chunklist = new Vector(250, 500);
    private boolean outnewline = true;
    private int maxindent = 1;
    private Rexx xrffile = Rexx.toRexx("");
    private File xrffileob;
    private OutputStreamWriter xrfhandle;
    private Rexx modfile = Rexx.toRexx("");
    private File modfileob;
    private OutputStreamWriter modhandle;
    private RxTranslator rxt;
    private RxProgram program;

    public RxStreamer(RxTranslator rxTranslator, RxProgram rxProgram) {
        this.rxt = rxTranslator;
        this.program = rxProgram;
    }

    public void openfiles(Rexx rexx, Rexx rexx2, Rexx rexx3) {
        int n;
        Rexx rexx4 = null;
        if (!this.program.flag.java && !this.program.flag.crossref && this.program.flag.model < 1) {
            return;
        }
        Rexx rexx5 = Rexx.toRexx(this.program.source.getName());
        String string = this.program.source.getPath();
        if (string == null) {
            string = "";
        }
        rexx4 = (n = rexx5.lastpos(new Rexx('.')).toint()) == 0 ? rexx5 : rexx5.left(new Rexx(n - 1));
        if (this.program.flag.java) {
            this.outfile = rexx != null ? rexx : rexx4.OpCc(null, $01);
            if (this.outfile.pos(new Rexx('.')).toint() == 0) {
                this.outfile = this.outfile.OpCc(null, $01);
            }
            if (this.outfile.right(new Rexx(5)).OpNotEqS(null, $01)) {
                throw new RxQuit(this.rxt, (RxToken)null, "output.extension.not.java", this.outfile);
            }
            this.outfilefull = Rexx.toRexx(string).OpCc(null, this.outfile);
            this.outfileob = new File(Rexx.toString(this.outfilefull));
        }
        this.modfileob = this.createModelFile(rexx3);
        this.xrffileob = this.createCrossrefFile(rexx2);
    }

    public File createCrossrefFile(Rexx rexx) {
        Rexx rexx2 = null;
        String string = null;
        int n = 0;
        Rexx rexx3 = null;
        if (this.program.flag.crossref) {
            rexx2 = Rexx.toRexx(this.program.source.getName());
            string = this.program.source.getPath();
            if (string == null) {
                string = "";
            }
            rexx3 = (n = rexx2.lastpos(new Rexx('.')).toint()) == 0 ? rexx2 : rexx2.left(new Rexx(n - 1));
            this.xrffile = rexx == null ? rexx3.OpCc(null, $02) : rexx;
            if (this.xrffile.pos(new Rexx('.')).toint() == 0) {
                this.xrffile = this.xrffile.OpCc(null, $02);
            }
            this.xrffileob = new File(Rexx.toString(Rexx.toRexx(string).OpCc(null, this.xrffile)));
        }
        return this.xrffileob;
    }

    public File createModelFile(Rexx rexx) {
        Rexx rexx2 = null;
        String string = null;
        int n = 0;
        Rexx rexx3 = null;
        if (this.program.flag.model > 0) {
            rexx2 = Rexx.toRexx(this.program.source.getName());
            string = this.program.source.getPath();
            if (string == null) {
                string = "";
            }
            rexx3 = (n = rexx2.lastpos(new Rexx('.')).toint()) == 0 ? rexx2 : rexx2.left(new Rexx(n - 1));
            this.modfile = rexx == null ? rexx3.OpCc(null, $03) : rexx;
            if (this.modfile.pos(new Rexx('.')).toint() == 0) {
                this.modfile = this.modfile.OpCc(null, $03);
            }
            this.modfileob = new File(Rexx.toString(Rexx.toRexx(string).OpCc(null, this.modfile)));
        }
        return this.modfileob;
    }

    public void outinsert(Rexx rexx, int n, int n2) {
        RxParser rxParser = null;
        if (!this.program.flag.java) {
            return;
        }
        if (!this.rxt.pass2) {
            if (this.program.flag.diag) {
                RexxIO.Say(Rexx.toRexx("# *** outi:").OpCcblank(null, rexx));
            }
            return;
        }
        if (this.program.flag.format) {
            rxParser = this.program.parser;
            if (rxParser.cursor.curclass != null) {
                n2 += rxParser.cursor.curclass.classinfo.parents;
            }
            rexx = linesep.OpCc(null, blank.copies(new Rexx(n2))).OpCc(null, rexx);
        }
        this.outinsertpart(rexx, n);
    }

    public void outinsertpart(Rexx rexx, int n) {
        if (!this.program.flag.java) {
            return;
        }
        if (!this.rxt.pass2) {
            if (this.program.flag.diag) {
                RexxIO.Say(Rexx.toRexx("# *** outip:").OpCcblank(null, rexx));
            }
            return;
        }
        if (n == 0) {
            return;
        }
        RxChunk rxChunk = (RxChunk)this.chunklist.elementAt(n - 1);
        rxChunk.insert = rxChunk.insert == null ? Rexx.toString(rexx) : Rexx.toString(Rexx.toRexx(rxChunk.insert).OpCc(null, rexx));
    }

    public void out(Rexx rexx) {
        this.out(rexx, false);
    }

    public void out(Rexx rexx, boolean bl) {
        if (!this.program.flag.java) {
            return;
        }
        if (!this.rxt.pass2) {
            if (this.program.flag.diag) {
                RexxIO.Say($04.OpCcblank(null, rexx));
            }
            return;
        }
        this.chunk(rexx, true, bl);
    }

    public void outpart(Rexx rexx) {
        this.outpart(rexx, false);
    }

    public void outpart(Rexx rexx, boolean bl) {
        if (!this.program.flag.java) {
            return;
        }
        if (!this.rxt.pass2) {
            if (this.program.flag.diag) {
                RexxIO.Say(Rexx.toRexx("# *** outp:").OpCcblank(null, rexx));
            }
            return;
        }
        this.chunk(rexx, false, bl);
    }

    private void chunk(Rexx rexx, boolean bl, boolean bl2) {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        RxParser rxParser = this.program.parser;
        if (!bl2 && rxParser.cursor != null && rxParser.cursor.curclause != null && rxParser.cursor.curclause.tokens != null) {
            n = rxParser.cursor.curclause.tokens[0].line;
        }
        if (this.program.flag.format) {
            if (this.outnewline) {
                n2 = rxParser.indention;
                if (rxParser.cursor.curclass != null) {
                    n2 += rxParser.cursor.curclass.classinfo.parents;
                }
                if (n2 > this.maxindent) {
                    this.maxindent = n2;
                }
            }
            if (bl) {
                if (n != this.lastinlineno && n != 0 && rexx != null && !rexx.verify(Rexx.toRexx(" }{")).OpEqS(null, $05)) {
                    this.lastinlineno = n;
                }
                this.outnewline = true;
                n3 = rxParser.level;
                if (n3 > this.maxindent) {
                    this.maxindent = n3;
                }
            } else {
                this.outnewline = false;
            }
        }
        this.chunklist.addElement(new RxChunk(Rexx.tochararray(rexx), n, bl, n2, n3));
        ++this.chunks;
        if (this.program.flag.diag) {
            if (rexx == null) {
                RexxIO.Say($06.OpCcblank(null, blank.copies(new Rexx(rxParser.indention))).OpCc(null, $07));
            } else if (rexx.OpNotEqS(null, $08)) {
                rexx = rexx.changestr(new Rexx('\r'), new Rexx(' '));
                rexx = rexx.changestr(new Rexx('\n'), new Rexx(' '));
                RexxIO.Say($06.OpCcblank(null, blank.copies(new Rexx(rxParser.indention))).OpCc(null, rexx.strip()));
            } else {
                RexxIO.Say($06.OpCcblank(null, blank.copies(new Rexx(rxParser.indention))).OpCc(null, $09).OpCc(null, rexx).OpCc(null, $010));
            }
        }
    }

    public void outwrite() {
        int n;
        FileOutputStream fileOutputStream = null;
        IOException iOException = null;
        char[] cArray = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        RxChunk rxChunk = null;
        int n7 = 0;
        int n8 = 0;
        char[] cArray2 = null;
        int n9 = 0;
        int n10 = 0;
        char[] cArray3 = null;
        char[] cArray4 = null;
        if (!this.program.flag.java) {
            return;
        }
        if (this.chunks == 0) {
            return;
        }
        if (this.outhandle == null) {
            try {
                if (this.outfileob == null) {
                    return;
                }
                if (this.rxt.keep || this.rxt.keepasjava) {
                    fileOutputStream = new FileOutputStream(this.outfileob);
                }
                this.byteoutstream = new ByteArrayOutputStream(5000);
                this.outhandle = new OutputStreamWriter(this.byteoutstream);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                this.outfileob = null;
                throw new RxQuit(this.rxt, null, "error.opening.file", this.outfile, Rexx.toRexx(iOException.getMessage()));
            }
        }
        boolean bl = true;
        if (this.program.flag.format) {
            bl = false;
            cArray = new char[this.maxindent];
            n = this.maxindent;
            n2 = 0;
            while (n > 0) {
                cArray[n2] = 32;
                --n;
                ++n2;
            }
        }
        int n11 = 1;
        RxChunk rxChunk2 = null;
        boolean bl2 = false;
        int n12 = 0;
        boolean bl3 = this.program.flag.comments;
        if (bl3) {
            n3 = 1;
            n4 = 0;
            n5 = 0;
            this.chunklist.addElement(new RxChunk("".toCharArray(), this.program.source.getLineCount() + 1));
            ++this.chunks;
            if (cArray == null) {
                cArray = new char[]{' '};
            }
        }
        try {
            n = this.chunks;
            n6 = 0;
            while (n > 0) {
                int n13;
                rxChunk = (RxChunk)this.chunklist.elementAt(n6);
                if (bl3) {
                    n7 = rxChunk.line;
                    if (n7 == 0 && !bl && rxChunk2 != null && rxChunk2.sep) {
                        n7 = rxChunk2.line + 1;
                    }
                    if (n7 > n3) {
                        if (rxChunk.datachars == null && !bl) {
                            this.outhandle.write(linesepchars, 0, linesepchars.length);
                        }
                        bl2 = false;
                        n8 = 0;
                        while ((cArray2 = this.program.source.getLine(n3)) != null) {
                            n5 = n8;
                            n13 = cArray2.length;
                            n2 = 0;
                            while (n13 > 0) {
                                if (cArray2[n2] != ' ') {
                                    if (n5 <= n2) break;
                                    n5 = n2;
                                    break;
                                }
                                --n13;
                                ++n2;
                            }
                            if (bl2) {
                                this.outhandle.write(cArray, 0, n12);
                            }
                            n9 = 32;
                            n13 = cArray2.length - 2;
                            for (n2 = 0; n2 <= n13; ++n2) {
                                n10 = cArray2[n2];
                                if (n9 != 32) {
                                    if (n10 != n9 || cArray2[n2 - 1] == '\\') continue;
                                    n9 = 32;
                                    continue;
                                }
                                if (n4 > 0) {
                                    bl2 = false;
                                    if (n10 == 42 && cArray2[n2 + 1] == '/') {
                                        if (--n4 == 0) {
                                            this.outhandle.write(cArray2, n5, n2 + 2 - n5);
                                            ++n2;
                                            continue;
                                        }
                                        this.outhandle.write(cArray2, n5, n2 - n5);
                                        this.outhandle.write(jncomend, 0, jncomend.length);
                                        n5 = ++n2 + 1;
                                    }
                                    if (n10 == 47 && cArray2[n2 + 1] == '*') {
                                        ++n4;
                                        this.outhandle.write(cArray2, n5, n2 - n5);
                                        this.outhandle.write(jncomstart, 0, jncomstart.length);
                                        n5 = ++n2 + 1;
                                    }
                                    if (n2 < cArray2.length - 2) continue;
                                    this.outhandle.write(cArray2, n5, cArray2.length - n5);
                                    break;
                                }
                                if (n10 == 39 | n10 == 34) {
                                    n9 = n10;
                                    continue;
                                }
                                if (n10 == 45 && cArray2[n2 + 1] == '-') {
                                    if (!bl2) {
                                        cArray3 = cArray;
                                        this.outhandle.write(cArray3, 0, 1);
                                    }
                                    this.outhandle.write(jcomstart, 0, jcomstart.length);
                                    this.outhandle.write(cArray2, n2 + 2, cArray2.length - (n2 + 2));
                                    bl2 = false;
                                    break;
                                }
                                if (n10 != 47 || cArray2[n2 + 1] != '*') continue;
                                n8 = n2;
                                n5 = n2++;
                                n4 = 1;
                                if (n2 < cArray2.length - 2) continue;
                                this.outhandle.write(cArray2, n5, cArray2.length - n5);
                                bl2 = false;
                                break;
                            }
                            if (++n3 <= rxChunk.line) {
                                this.outhandle.write(linesepchars, 0, linesepchars.length);
                                bl2 = true;
                            }
                            if (n3 < rxChunk.line || n4 != 0) continue;
                        }
                        n11 = n3;
                    }
                }
                if (!bl) {
                    if (rxChunk2 != null && rxChunk2.sep && !bl2) {
                        this.outhandle.write(linesepchars, 0, linesepchars.length);
                    }
                    rxChunk2 = rxChunk;
                }
                if (rxChunk.line > n11) {
                    if (bl) {
                        for (n13 = rxChunk.line - n11; n13 > 0; --n13) {
                            this.outhandle.write(linesepchars, 0, linesepchars.length);
                        }
                    }
                    n11 = rxChunk.line;
                }
                if (rxChunk.indent >= 0) {
                    this.outhandle.write(cArray, 0, rxChunk.indent);
                    n12 = rxChunk.indent;
                }
                if ((cArray4 = rxChunk.datachars) != null) {
                    this.outhandle.write(cArray4, 0, cArray4.length);
                }
                if (rxChunk.insert != null) {
                    cArray4 = rxChunk.insert.toCharArray();
                    this.outhandle.write(cArray4, 0, cArray4.length);
                }
                bl2 = false;
                if (rxChunk.postindent >= 0) {
                    n12 = rxChunk.postindent;
                }
                --n;
                ++n6;
            }
        }
        catch (IOException iOException3) {
            iOException = iOException3;
            throw new RxQuit(this.rxt, null, "error.writing.file", this.outfile, Rexx.toRexx(iOException.getMessage()));
        }
        try {
            this.outhandle.close();
        }
        catch (IOException iOException4) {
            // empty catch block
        }
        if (this.rxt.keep || this.rxt.keepasjava) {
            try {
                this.byteoutstream.writeTo(fileOutputStream);
                fileOutputStream.close();
            }
            catch (IOException iOException5) {
                // empty catch block
            }
        }
        this.outhandle = null;
        this.chunklist = null;
    }

    public void postindent(int n) {
        int n2 = this.chunklist.size();
        if (n2 == 0) {
            return;
        }
        RxChunk rxChunk = (RxChunk)this.chunklist.elementAt(n2 - 1);
        rxChunk.postindent = n;
    }

    public void checkoutfile() {
        if (!this.rxt.keep & !this.rxt.keepasjava) {
            return;
        }
        if (this.outfileob == null) {
            return;
        }
        if (!this.outfileob.exists()) {
            return;
        }
        if (!this.program.flag.replace) {
            this.outfileob = null;
            throw new RxQuit(this.rxt, (RxToken)null, "output.file.already.exists", this.outfile);
        }
        if (!this.outfileob.canWrite()) {
            this.outfileob = null;
            throw new RxQuit(this.rxt, (RxToken)null, "file.may.not.be.written", this.outfile);
        }
    }

    public void disposeoutputfile(boolean bl) {
        this.disposeoutputfile(bl, false);
    }

    public void disposeoutputfile(boolean bl, boolean bl2) {
        File file2 = null;
        if (this.outfileob == null || !this.outfileob.exists()) {
            return;
        }
        if (bl) {
            this.outfileob.delete();
            return;
        }
        if (!bl2) {
            file2 = new File(this.outfileob.getAbsolutePath() + ".keep");
            file2.delete();
            this.outfileob.renameTo(file2);
        }
    }

    public void crossref(Rexx rexx) {
        FileOutputStream fileOutputStream = null;
        IOException iOException = null;
        char[] cArray = null;
        if (this.xrfhandle == null) {
            try {
                try {
                    fileOutputStream = new FileOutputStream(this.xrffileob);
                }
                catch (NullPointerException nullPointerException) {
                    this.xrffileob = this.createCrossrefFile(null);
                    fileOutputStream = new FileOutputStream(this.xrffileob);
                }
                this.xrfhandle = new OutputStreamWriter(fileOutputStream);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                throw new RxQuit(this.rxt, null, "error.opening.file", this.xrffile, Rexx.toRexx(iOException.getMessage()));
            }
        }
        rexx = linesep.OpCc(null, rexx);
        try {
            cArray = rexx.toCharArray();
            this.xrfhandle.write(cArray, 0, cArray.length);
        }
        catch (IOException iOException3) {
            iOException = iOException3;
            throw new RxQuit(this.rxt, null, "error.writing.file", this.xrffile, Rexx.toRexx(iOException.getMessage()));
        }
    }

    public void model(Rexx rexx) {
        FileOutputStream fileOutputStream = null;
        IOException iOException = null;
        char[] cArray = null;
        if (this.modhandle == null) {
            try {
                try {
                    fileOutputStream = new FileOutputStream(this.modfileob);
                }
                catch (NullPointerException nullPointerException) {
                    new RxWarn(this.rxt, (RxToken)null, "conflicting.model.options", this.outfile);
                    this.modfileob = this.createModelFile(null);
                    fileOutputStream = new FileOutputStream(this.modfileob);
                }
                this.modhandle = new OutputStreamWriter(fileOutputStream);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                throw new RxQuit(this.rxt, null, "error.opening.file", this.modfile, Rexx.toRexx(iOException.getMessage()));
            }
        }
        rexx = linesep.OpCc(null, rexx);
        try {
            cArray = rexx.toCharArray();
            this.modhandle.write(cArray, 0, cArray.length);
        }
        catch (IOException iOException3) {
            iOException = iOException3;
            throw new RxQuit(this.rxt, null, "error.writing.file", this.modfile, Rexx.toRexx(iOException.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closefiles() {
        if (this.program.flag.diag) {
            RexxIO.Say("# closefiles");
        }
        if (this.outhandle != null) {
            try {
                this.outhandle.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.outhandle = null;
            }
        }
        if (this.modhandle != null) {
            try {
                this.modhandle.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.modhandle = null;
            }
        }
        if (this.xrfhandle != null) {
            try {
                this.xrfhandle.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.xrfhandle = null;
            }
        }
    }
}

