**Release 1.42 - Direct launch / embedded  enhancements and improvements to RESULT handling**

In this release a number of modules have been added for direct launch / embedded programs to call or require so that rexxdebugger command line options can be realised when debugging in this way. 

Details of how to use them in a program have  been added to the main package README file

The options / modules are as follows:

    /NOCAPTURE   RexxDebuggerNoCapture.rex

    /SHOWTRACE   RexxDebuggerShowTrace.rex

    /FONTSIZE:n  RexxDebuggerFont8.rex -> RexxDebuggerFont26.rex 

In addition  the default capture mode for direct launch / embedded debugging is now the same as the rexxdebugger default i.e. capture say output and drop trace output apart from errors. 


Other changes include the following:

 - A fix to ensure that the special RESULT variable is displayed in the top-level watch window when it is defined

 - A fix to ensure that Rexx statements executed in the console via the Next button which reference the RESULT variable accurately report its existence state / value

 - A change to how the debugger preserves the program's RESULT variable which should make processing of conditional breakpoints slightly faster

 - A change to allow statements executed in the console to modify the RESULT existence state / value for the program


**_Older releases are detailed below_**


**Release 1.41 - Font (size) selection + user interface fixes and enhancements**

In this release it is possible to change the size of the font used by the debugger with the /FONTSIZE argument when launching programs via rexxdebugger. A range of font sizes from 8-26 are avaiaible, though different ranges are used for the different interfaces. Sizes 8-16 are suitable for the Windows native interface and 12-26 for the Java interface.

Note that it has not been possible to extend this beyond the debugger dialogs so system dialogs like the file chooser and message boxes will still use the default font size

Other changes include the following:

 - On MacOS the push buttons on the dialogs now use the native look and feel

 - On the Windows interface the source display is scrollable when displaying startup text 

 - On the Windows interface the source display is not limited to displaying a whole number of rows so resizes more smoothly

 - A regression with the stack view displaying stack entries for debugger code has been fixed


**Release 1.40 - Support for multiple threads + some bug fixes**

In this release support for multithreaded Rexx programs has been added with independent debugger state now maintained for each program thread. This introduces a performance overhead of around 50% but for ooRexx 5.1 new interpreter features have been leveraged which largely cancel this out.

Other changes include the following:

 - The rexxdebugger script will load RexxDebugger.rex from the directory in which it runs fixing a 'file not found' error on MacOS in some installation scenarios. 
 
   **This means the debugger script and .rex files need to be in the same directory on Unix-based platforms**

- A bug fix for a scenario where the New Session dialog could be opened at non-integral co-ordinates on Windows causing a debugger error

- Java thread priority changes have been made in an effort to make the Break button more responsive in some scenarios


**Release 1.39 - Change to the previously added trace mode option + improved fixed font handling**

The /MODE:x option from the last release, where the interactive trace prefix ? was always added by the debugger, has been replaced with /TRACEMODE:xx where the interactive trace prefix needs to be explicitly specified if needed. e.g. /TRACEMODE:?R would be used to default to interactive tracing that traces all results and /TRACEMODE:N to set the standard non-interactive mode that is the ooRexx default

Fixed font handling has been improved, firstly to fall back to the Java default 'Monospaced' font if there is no Courier font installed, and secondly to modify the layout of screens if the font selected is larger than can be handled by the existing fixed layouts

**Release 1.38 - Default trace mode enhancements + ooRexx 5.1 support recognised**

In this release the default global trace mode set when starting a debug session using the rexxdebugger command has been changed from [R]esults to [A] as this generates slightly less trace output and can improve debugging performance accordingly

To provide greater control over the default trace mode a command-line /MODE:x option has been added to change the global trace mode or even set it to [O]ff so that only selected code blocks, where suitable trace clauses have been added to the code, will be actively intercepted by the debugger. This can significantly improve debugging performance as non-traced code blocks do not incur single step/breakpoint tracking performance overheads

The ooRexx 5.1 pre-release is now recognised as stable for use with the debugger, starting from ooRexx build 12948

**Release 1.37 - Enhancements and fixes incorporating new ooRexx functionality**

This release utilises a new ooRexx 5.1 feature (RFE [#847], build 12932) for improved debugging of the program call stack:

   - When selecting an entry in the stack list, update any Watch windows to show the variables valid for the selected stack entry. This is only available when running ooRexx 5.1 build 12932 or later.

   > This is a preview release of this feature and there will be some bugs. For example any action in a Watch window (opening a new window, changing a view) when any stack frame other that the top one is selected currently changes the selected stack row (and variables) back to the top frame but not the source location. Manually clicking on any stack list row corrects this. It's also currently possible to reactivate the watch windows after the program has finished running by clicking on any entry in the stack list. Please report any other issues found and a more detailed review will be undertaken for a future release
   
Other enhancements and bug fixes are as follows:

   - Make available the Rexx routines **RexxDebuggerHandleExit** and **RexxDebuggerHandleError** for use in embedded / direct launch programs. Using these  can result in better debug session management, especially useful on MacOS, when the debug session ends for any reason. This is covered in the readme under "Utility functions for embedded / direct launch debugging" 

   - Add a Copy context menu item to all list windows (source, stack and watch)

   - Update the clipboard Copy function for list windows on the Java version to behave the same as the Windows version instead of always selecting all visual text

   - Fix a bug for the Watch list window clipboard Copy function where the first character was not being  copied when watching a single string variable   (Windows UI)

   - Fix a bug for source list window clipboard Copy where breakpoint markers were being included

**Release 1.36 - Enhancements and fixes**

Mainly enhancements and fixes to watch windows

   - Enhance Relation collection handling in watch windows so that drilldown is now possible into different items which share the same index
   
   - Simplify the implementation requirements for a makedebuggerstring method and ensure that any errors arising when calling one are handled gracefully 
     
    
   - Add a variable object type indicator to all non top-level watch windows
   
   - For the ooDialog version, '(Native UI)' in the title is superfluous  since this is the default UI for Windows so has been removed. 



**Release 1.35 - Bug fixes, UI changes and Watch enhancements**

Further enhancements to watch functionality, especially for string types, have been the main focus of this release

   - MutableBuffer variables will show their string content in watch windows
     
   - Strings and MutableBuffers can be expanded into their own watch window where content can either be displayed in multi-line format (the default) with wrapping of lines > 255 characters or (via a right-click action) a "byte" view where the characters of the string are also displayed in hexadecimal in blocks of 10 characters per line

Other changes are as follows:
     
   - The .Environment and .Global directories no longer appear in the top-level watch window by default but can be added via a right-click action on this window
   
   - Watch windows display 'The NIL object' appropriately and drilldown where a NIL object is used as an index in a collection is possible

   - The text on the Vars button has been changed to Watch for naming consistency

   - A new "CLS" console command has been added to enable clearing of the console output window
     
   - A user interface issue where executing the RUN command in the debugger console would not switch the text on the Run button to Break has been addressed
   
   

**Release 1.34 - Bug fixes and Watch enhancements**
 
In this release the focus has been on enhancing the capabilities of Watch windows 

   - Missing Watch support for the Set, Bag, Table, IdentityTable and Relation classes has been added. All collection classes shipped with ooRexx can now be opened in Watch windows and drilldown support is provided for all, though drilldown support for Relation classes is currently limited to one item per group of duplicate indexes
     
   - For user-defined classes, a mechanism now exists for extending these so that the debugger can include object specific data in Watch windows. With this mechanism a Watch window showing an instance of a user-defined Point class can  display it as something like "a Point [x=2,y=4]" instead of just "a Point". More detail and an example can be found in the README.md file
     
   - Drilldown support for user-defined subclasses of the default collection classes has been added.

In addition to the above the following bugs were fixed

   - A debugged program calling CHAROUT with fewer than 2 characters causes a debugger error terminating the debug session
     
   - Under some circumstances the .Environment and .Local items in the top-level Watch Window are duplicated
     
   - Under some circumstances drilling into the .Environment and .Local items in the top-level Watch window opens an empty Watch window
    


**Release 1.33 - Bug fixes and enhancements**
 
The main work in this release has been to improve the logging in the console window. Many of these enhancements apply across the board but some may not apply when using direct launch, just when launching from rexxdebugger

   - All messages from the debugger (should) include the prefix <-> which is defined as a constant so it can easily be changed in one place if needed
     
   - Syntax errors along with runtime errors during pre-main code (e.g. in class initializers) will now be logged rather than replacing the contents of the source window
     
   - If a debugged program returns a value on exit / return  this will be logged and the result displayed if it is a string.
     
   - When a conditional breakpoint is hit and the condition is satisifed causing a break this event is logged
     
   - All debug session start events, along with session end events, whether normal or due to an error or user exit are logged

 There have additionally been some fixes and minor enhancements as follows
 
  - An inifinite error loop caused by using the ::OPTIONS NOVALUE SYNTAX directive in debugged programs has been fixed
    
  - Conditional breakpoints will always break if they are hit by an automatic break request
    
  - Some small performance improvements have been made to the code which receives all trace output and to the main processing loop which determines when to pause the debugged program.
    
  - Incorrect ordering of "auto breakpoint" log messages in the Windows UI have been fixed
    
  - Some typos in the readme have been addressed



**Release 1.32 - Usability enhancements**
 
 - In this release the ability to set conditional  breakpoints has been added. This can be done whenever the selected row in the source view already has a breakpoint set. Right-clicking anywhere in the source view will activate the Breakpoint Settings context menu, which can be used to show a dialog where the breakpoint can be modified to either break always (the default), or only when a specified Rexx expression (e.g. x=5) evaluates to true.
 

**Release 1.31 - Usability fixes and enhancements**

 - Methods for initializing classes such as activate or (class) init can now be stepped through when debugging programs launched from within the rexxdebugger application. In previous releases it was necessary to modify the  code to add debugging directives and launch the program directly in order to do this
 
 - For programs launched within the rexxdebugger application there is better reporting of unhandled runtime errors and it is now possible to reuse the debugging session when such errors occur


**Release 1.30 - Usability and performance enhancements**
 
 - The README.md documentation has been rewritten to improve clarity and reflect new features added
 - A file finder has been added to the New Debug Session dialog, with a filter for several known Rexx file types
 - The performance when logging output to the debugger console window has been dramatically improved
 - The rexxdebugger shell script for Linux now supports MacOS so "rexxdebugger" can be run on any platform to start a debug session 
 - On MacOS the debugger window no longer automatically closes at the end of every debug session (*) 
 - An issue with the main window sometimes disappearing behind another window when using the New Debug Session dialog has been addressed
 - There are better checks for an active debugging session when the closing the main window 
 - Some regressions for self-debugging programs caused by the addition of the New Debug Session dialog have been identified and fixed
 - Compatibility checks have been carried out with bsf4oorexx version 641 and this version is now supported

(*) This only applies to debug sessions launched with the rexxdebugger command. For programs run directly having been modified to launch the debugger themselves, the debugger window will still close when the program ends

**Release 1.29 - Usability enhancements**

The main enhancement in this release is that when the rexxdebugger command is used to launch the debugger there is now an Open button that can be used to start a debug session. This button is enabled before a program has been selected for debugging and after it has finished running i.e. whenever there is no active debug session. This makes it easy to get started without knowing the command line and also possible to run additional debug sessions, with the understanding that file handles, resources etc that were not released in a previous session may still be open in the new session. File find dialogs are not yet available in the Open dialog but may be added in a future release.

The following enhancements are also included:

- If there is an error when attempting to start a debug session for a specific Rexx program the debugger will now be launched with the error detail shown in the source list as well as in any command prompt/terminal
- The source list is no longer disabled when it is displaying informational or error text
- The name of the active source file is now displayed at the top of the main dialog
- Copy of the row selected in the various list boxes with the usual keyboard shortcuts has been added to the ooDialog UI. This was already possible with the Java IU


**Release 1.28 - Fixes, enhancements and some code refactoring**

In this release some refactoring of the UI code (mostly for lists) has been carried out to make the Windows and Java code UI more similar. This should make future UI enhancements more straightforward but please look out for any regressions.

The following enhancements have made been made to Watch windows:

- The .Local and .Environment collections have been added so that they are readily accessible
- The initial size has been increased but the windows can be resized to the previous minimum size if needed
- Expandable items are indicated with a plus (+) sign
- Windows for nested watch items have titles starting with the name of the item followed by the containing ones

The following changes have also been made:

- Multiple command line switches for RexxDebugger e.g. /JAVAUI etc can now be specified in any order
- Filename case and quoting for non-Windows platforms should now be correct
- Memory consumption / turnover should be lower when large amounts of data are being sent to the console output window
- Some code switches have been added to the Java UI to assist with troubleshooting a reported TRACE instability issue in ooRexx 5.1



**Release version 1.27 - Fixes and enhancements**

This release includes the following fixes and usability enhancements for the debugger:

- Fix regression where the presence of the ooDialog UI library was not being checked on Windows
- Improvements to threading code to improve stability
- On Windows allow the default ooDialog UI to be overridden with a ::REQUIRES statement in code or a new /JAVAUI command line option.
- (Development) Changes to permit most of the RexxDebugger and UI library code to be traced if required for troubleshooting purposes

NOTE: Some stability issues (occasional crashes or hangs) have been observed with ooRexx 5.1 when running the cross platform Java interface. These issues are believed to predate this debugger version as they have been seen occasionally with earlier releases but have been most commonly observed during this release cycle in sessions where debugger tracing has been activated. They will continue to be investigated.

**Release version 1.26 - Fixes and enhancements**

This release includes the following fixes and usability enhancements for the 1.2 release:

- Fix a debugger failure when attempting to switch between source files in the cross platform interface
- Add the ability to launch and debug Rexx programs with a "#!" as their first line e.g. some of the ooRexx samples
- Allow the cross platform interface to be forced on Windows with a ::REQUIRES statement in the source code
- Allow capture of some (not trace or error output) when the debugger has been modified to generate trace output for itself
- Ensure that any .TraceObject~option for formatting trace output (N,T,S,F) is respected.
- Change the main dialog title to say ooRexx, and for the Windows version add an indicator for the UI version
- Add /NOCAPTURE command line option to leave all output with the traced program's console
- Add NOCAPTURE debugger command to stop capturing output and return it to the traced program's console
- Change the behaviour of the Next button when there is a debugger command in the entryfield to ignore the command and carry out a single step
- Add HELP debugger command

**Release Version 1.250 - Support for ooRexx 5.1**

This release adds support for ooRexx 5.1 with the inclusion of a fix for an issue related to tracing enhancements in 5.1 that could cause crashes in a variety of scenarios.

**Release version 1.203 - Maintenance for the cross platform 1.200 release**

This is a maintenance release for the 1.200 cross platform release described below. Changes in this release are as follows:

- Fixed the text on the Exec button (incorrectly showing as Next) for the cross platform interface
- Removed erroneous 'Event Double Clicked' messages showing up in the debug output of the cross platform interface
- Fixed an issue where manual breakpoint setting on lines in the cross platform interface was not detecting if the line started with a comment
- Fixed an incorrect comment indicator in the Help text
- Moved copyright information in the tutorial because having this at the top of the file meant that the line number references were wrong
- Added notes to the README regarding Mac OS support

**Release version 1.200**

This release adds full cross platform support (with the minor exception of initial debugger window placement) for environments with an installed Java JRE/JDK supporting Swing + AWT and where BSF4ooRexx version 850 has been installed along with ooRexx 5.0. The existing ooDialog interface for Windows is retained as the default for that platform.

A minor enhancement to the Windows/ooDialog version in this release is expandability of StringTable objects in Watch windows if ooRexx 5.0 or later is being used. This is also included in the cross platform interface which should always be running ooRexx 5.0 or later.

There are some deployment changes compared to the 1.0x release and on Windows to use the standard ooDialog user interface, RexxDebuggerWINUI.rex must be installed in addition to RexxDebugger.rex

The cross platform interface requires RexxDebuggerBSFUI.rex to be installed in addition to RexxDebugger.rex, with a convenience bash script rexxdebugger available for platforms such as Linux. See the README.md file for more information

Note! There have been structural changes to the code Windows/ooDialog interface to support the cross platform interface so release 1.007 should be used if serious problems are found in this release.




[![Download ooRexx Debugger](https://a.fsdn.com/con/app/sf-download-button)](https://sourceforge.net/projects/oorexxdebugger/files/v1.42/Release%20Version%201.42%20source%20code.zip/download)