/*
 * Decompiled with CFR 0.152.
 */
package org.netrexx.njpipes.stages;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import netrexx.lang.Rexx;
import netrexx.lang.RexxIO;
import org.netrexx.njpipes.pipes.StageError;
import org.netrexx.njpipes.pipes.ThreadQ;
import org.netrexx.njpipes.pipes.stage;

public class listzip
extends stage {
    private static final Rexx $01 = new Rexx(12);
    private static final Rexx $02 = new Rexx('\n');
    private static final Rexx $03 = Rexx.toRexx("*/\n");
    private static final String $0 = "listzip.nrx";
    private ArrayList zipEntries;

    @Override
    public void run() throws ThreadQ {
        Rexx rexx = null;
        Iterator iterator = null;
        try {
            rexx = this.arg();
            iterator = this.readZip(rexx).iterator();
            while (iterator.hasNext()) {
                this.output(iterator.next());
            }
        }
        catch (StageError stageError) {
            RexxIO.Say("error in listzip");
        }
        int n = this.rc();
        this.exit(new Rexx(n).OpMult(null, new Rexx(new Rexx(n).OpNotEq(null, $01))).toint());
    }

    public ArrayList readZip(Rexx rexx) {
        FileInputStream fileInputStream = null;
        try {
            this.zipEntries = new ArrayList();
            fileInputStream = new FileInputStream(Rexx.toString(rexx));
            this.readZipFileStream(fileInputStream);
            return this.zipEntries;
        }
        catch (IOException iOException) {
            RexxIO.Say("error reading zip file");
            return null;
        }
    }

    public void readZipFileStream(InputStream inputStream) {
        ZipEntry zipEntry = null;
        IOException iOException = null;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                this.zipEntries.add(zipEntry.getName());
                if (!new Rexx(zipEntry.isDirectory()).OpNot(null) || !zipEntry.getName().endsWith(".zip")) continue;
                this.readZipFileStream(zipInputStream);
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            RexxIO.Say(Rexx.toRexx("error reading zip file stream").OpCcblank(null, Rexx.toRexx(iOException.toString())));
        }
    }

    public static Rexx givehelp() {
        return Rexx.toRexx("/** listzip -- List the Files in a Zipped File\n").OpCcblank(null, $02).OpCcblank(null, Rexx.toRexx(">>---LISTZIP----zipFileName------><\n")).OpCcblank(null, $02).OpCcblank(null, $03);
    }
}

