/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnionTypeReference;
import org.eclipse.jdt.internal.compiler.codegen.ObjectCache;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CatchParameterBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ExceptionHandlingFlowContext
extends FlowContext {
    public static final int BitCacheSize = 32;
    public ReferenceBinding[] handledExceptions;
    int[] isReached;
    int[] isNeeded;
    UnconditionalFlowInfo[] initsOnExceptions;
    ObjectCache indexes = new ObjectCache();
    boolean isMethodContext;
    public UnconditionalFlowInfo initsOnReturn;
    public FlowContext initializationParent;
    public List extendedExceptions;
    private static final Argument[] NO_ARGUMENTS = new Argument[0];
    public Argument[] catchArguments;
    private int[] exceptionToCatchBlockMap;

    public ExceptionHandlingFlowContext(FlowContext flowContext, ASTNode aSTNode, ReferenceBinding[] referenceBindingArray, FlowContext flowContext2, BlockScope blockScope, UnconditionalFlowInfo unconditionalFlowInfo) {
        this(flowContext, aSTNode, referenceBindingArray, null, NO_ARGUMENTS, flowContext2, blockScope, unconditionalFlowInfo);
    }

    public ExceptionHandlingFlowContext(FlowContext flowContext, TryStatement tryStatement, ReferenceBinding[] referenceBindingArray, int[] nArray, FlowContext flowContext2, BlockScope blockScope, FlowInfo flowInfo) {
        this(flowContext, tryStatement, referenceBindingArray, nArray, tryStatement.catchArguments, flowContext2, blockScope, flowInfo.unconditionalInits());
        UnconditionalFlowInfo unconditionalFlowInfo = flowInfo.unconditionalCopy();
        unconditionalFlowInfo.acceptAllIncomingNullness();
        unconditionalFlowInfo.tagBits |= 0x40;
        this.initsOnFinally = unconditionalFlowInfo;
    }

    ExceptionHandlingFlowContext(FlowContext flowContext, ASTNode aSTNode, ReferenceBinding[] referenceBindingArray, int[] nArray, Argument[] argumentArray, FlowContext flowContext2, BlockScope blockScope, UnconditionalFlowInfo unconditionalFlowInfo) {
        super(flowContext, aSTNode, true);
        this.isMethodContext = blockScope == blockScope.methodScope();
        this.handledExceptions = referenceBindingArray;
        this.catchArguments = argumentArray;
        this.exceptionToCatchBlockMap = nArray;
        int n = referenceBindingArray.length;
        int n2 = n / 32 + 1;
        this.isReached = new int[n2];
        this.isNeeded = new int[n2];
        this.initsOnExceptions = new UnconditionalFlowInfo[n];
        boolean bl = !this.isMethodContext || blockScope.compilerOptions().reportUnusedDeclaredThrownExceptionExemptExceptionAndThrowable;
        for (int i = 0; i < n; ++i) {
            ReferenceBinding referenceBinding = referenceBindingArray[i];
            int n3 = this.exceptionToCatchBlockMap != null ? this.exceptionToCatchBlockMap[i] : i;
            this.indexes.put(referenceBinding, i);
            if (referenceBinding.isUncheckedException(true)) {
                if (bl || referenceBinding.id != 21 && referenceBinding.id != 25) {
                    int n4 = i / 32;
                    this.isReached[n4] = this.isReached[n4] | 1 << i % 32;
                }
                this.initsOnExceptions[n3] = unconditionalFlowInfo.unconditionalCopy();
                continue;
            }
            this.initsOnExceptions[n3] = FlowInfo.DEAD_END;
        }
        if (!this.isMethodContext) {
            System.arraycopy(this.isReached, 0, this.isNeeded, 0, n2);
        }
        this.initsOnReturn = FlowInfo.DEAD_END;
        this.initializationParent = flowContext2;
    }

    public void complainIfUnusedExceptionHandlers(AbstractMethodDeclaration abstractMethodDeclaration) {
        int n;
        MethodScope methodScope = abstractMethodDeclaration.scope;
        if ((abstractMethodDeclaration.binding.modifiers & 0x30000000) != 0 && !methodScope.compilerOptions().reportUnusedDeclaredThrownExceptionWhenOverriding) {
            return;
        }
        TypeBinding[] typeBindingArray = null;
        int n2 = 0;
        if (methodScope.compilerOptions().reportUnusedDeclaredThrownExceptionIncludeDocCommentReference && abstractMethodDeclaration.javadoc != null && abstractMethodDeclaration.javadoc.exceptionReferences != null && (n2 = abstractMethodDeclaration.javadoc.exceptionReferences.length) > 0) {
            typeBindingArray = new TypeBinding[n2];
            for (n = 0; n < n2; ++n) {
                typeBindingArray[n] = abstractMethodDeclaration.javadoc.exceptionReferences[n].resolvedType;
            }
        }
        int n3 = this.handledExceptions.length;
        block1: for (n = 0; n < n3; ++n) {
            int n4 = this.indexes.get(this.handledExceptions[n]);
            if ((this.isReached[n4 / 32] & 1 << n4 % 32) != 0) continue;
            for (int i = 0; i < n2; ++i) {
                if (TypeBinding.equalsEquals(typeBindingArray[i], this.handledExceptions[n])) continue block1;
            }
            methodScope.problemReporter().unusedDeclaredThrownException(this.handledExceptions[n4], abstractMethodDeclaration, abstractMethodDeclaration.thrownExceptions[n4]);
        }
    }

    public void complainIfUnusedExceptionHandlers(BlockScope blockScope, TryStatement tryStatement) {
        int n = this.handledExceptions.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i / 32;
            int n3 = 1 << i % 32;
            if ((this.isReached[n2] & n3) == 0) {
                blockScope.problemReporter().unreachableCatchBlock(this.handledExceptions[i], this.getExceptionType(i));
                continue;
            }
            if ((this.isNeeded[n2] & n3) != 0) continue;
            blockScope.problemReporter().hiddenCatchBlock(this.handledExceptions[i], this.getExceptionType(i));
        }
    }

    private ASTNode getExceptionType(int n) {
        if (this.exceptionToCatchBlockMap == null) {
            return this.catchArguments[n].type;
        }
        int n2 = this.exceptionToCatchBlockMap[n];
        TypeReference typeReference = this.catchArguments[n2].type;
        if (typeReference instanceof UnionTypeReference) {
            for (TypeReference typeReference2 : ((UnionTypeReference)typeReference).typeReferences) {
                if (!TypeBinding.equalsEquals(typeReference2.resolvedType, this.handledExceptions[n])) continue;
                return typeReference2;
            }
        }
        return typeReference;
    }

    @Override
    public FlowContext getInitializationContext() {
        return this.initializationParent;
    }

    @Override
    public String individualToString() {
        StringBuffer stringBuffer = new StringBuffer("Exception flow context");
        int n = this.handledExceptions.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i / 32;
            int n3 = 1 << i % 32;
            stringBuffer.append('[').append(this.handledExceptions[i].readableName());
            if ((this.isReached[n2] & n3) != 0) {
                if ((this.isNeeded[n2] & n3) == 0) {
                    stringBuffer.append("-masked");
                } else {
                    stringBuffer.append("-reached");
                }
            } else {
                stringBuffer.append("-not reached");
            }
            int n4 = this.exceptionToCatchBlockMap != null ? this.exceptionToCatchBlockMap[i] : i;
            stringBuffer.append('-').append(this.initsOnExceptions[n4].toString()).append(']');
        }
        stringBuffer.append("[initsOnReturn -").append(this.initsOnReturn.toString()).append(']');
        return stringBuffer.toString();
    }

    public UnconditionalFlowInfo initsOnException(int n) {
        return this.initsOnExceptions[n];
    }

    @Override
    public UnconditionalFlowInfo initsOnReturn() {
        return this.initsOnReturn;
    }

    public void mergeUnhandledException(TypeBinding typeBinding) {
        if (this.extendedExceptions == null) {
            this.extendedExceptions = new ArrayList<ReferenceBinding>(Arrays.asList(this.handledExceptions));
        }
        boolean bl = false;
        block4: for (int i = this.extendedExceptions.size() - 1; i >= 0; --i) {
            switch (Scope.compareTypes(typeBinding, (TypeBinding)this.extendedExceptions.get(i))) {
                case 1: {
                    this.extendedExceptions.remove(i);
                    continue block4;
                }
                case -1: {
                    bl = true;
                    continue block4;
                }
            }
        }
        if (!bl) {
            this.extendedExceptions.add(typeBinding);
        }
    }

    public void recordHandlingException(ReferenceBinding referenceBinding, UnconditionalFlowInfo unconditionalFlowInfo, TypeBinding typeBinding, TypeBinding typeBinding2, ASTNode aSTNode, boolean bl) {
        int n;
        int n2 = this.indexes.get(referenceBinding);
        int n3 = n2 / 32;
        int n4 = 1 << n2 % 32;
        if (!bl) {
            int n5 = n3;
            this.isNeeded[n5] = this.isNeeded[n5] | n4;
        }
        int n6 = n3;
        this.isReached[n6] = this.isReached[n6] | n4;
        int n7 = n = this.exceptionToCatchBlockMap != null ? this.exceptionToCatchBlockMap[n2] : n2;
        if (typeBinding2 != null && this.catchArguments != null && this.catchArguments.length > 0 && !bl) {
            CatchParameterBinding catchParameterBinding = (CatchParameterBinding)this.catchArguments[n].binding;
            catchParameterBinding.setPreciseType(typeBinding2);
        }
        this.initsOnExceptions[n] = (this.initsOnExceptions[n].tagBits & 3) == 0 ? this.initsOnExceptions[n].mergedWith(unconditionalFlowInfo) : unconditionalFlowInfo.unconditionalCopy();
    }

    @Override
    public void recordReturnFrom(UnconditionalFlowInfo unconditionalFlowInfo) {
        if ((unconditionalFlowInfo.tagBits & 1) == 0) {
            this.initsOnReturn = (this.initsOnReturn.tagBits & 1) == 0 ? this.initsOnReturn.mergedWith(unconditionalFlowInfo) : (UnconditionalFlowInfo)unconditionalFlowInfo.copy();
        }
    }

    @Override
    public SubRoutineStatement subroutine() {
        if (this.associatedNode instanceof SubRoutineStatement) {
            if (this.parent.subroutine() == this.associatedNode) {
                return null;
            }
            return (SubRoutineStatement)this.associatedNode;
        }
        return null;
    }
}

