/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.common;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;

public class Section {
    private double _start;
    private DoubleProperty start;
    private double _stop;
    private DoubleProperty stop;
    private String _text;
    private StringProperty text;
    private ObjectProperty<Image> icon;
    private String _styleClass;
    private StringProperty styleClass;
    private ObjectProperty<Color> color;
    private Color _color;
    private ObjectProperty<EventHandler<SectionEvent>> onEnteringSection = new ObjectPropertyBase<EventHandler<SectionEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onEnteringSection";
        }
    };
    private ObjectProperty<EventHandler<SectionEvent>> onLeavingSection = new ObjectPropertyBase<EventHandler<SectionEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onLeavingSection";
        }
    };

    public Section() {
        this(-1.0, -1.0, "", null, "", null);
    }

    public Section(double START, double STOP) {
        this(START, STOP, "", null, "", null);
    }

    public Section(double START, double STOP, Color COLOR) {
        this(START, STOP, "", null, "", COLOR);
    }

    public Section(double START, double STOP, String TEXT) {
        this(START, STOP, TEXT, null, "", null);
    }

    public Section(double START, double STOP, String TEXT, Color COLOR) {
        this(START, STOP, TEXT, null, "", COLOR);
    }

    public Section(double START, double STOP, String TEXT, Image ICON) {
        this(START, STOP, TEXT, ICON, "", null);
    }

    public Section(double START, double STOP, String TEXT, Image ICON, Color COLOR) {
        this(START, STOP, TEXT, ICON, "", COLOR);
    }

    public Section(double START, double STOP, String TEXT, String STYLE_CLASS) {
        this(START, STOP, TEXT, null, STYLE_CLASS, null);
    }

    public Section(double START, double STOP, String TEXT, Image ICON, String STYLE_CLASS) {
        this(START, STOP, TEXT, ICON, STYLE_CLASS, null);
    }

    public Section(double START, double STOP, String TEXT, Image ICON, String STYLE_CLASS, Color COLOR) {
        this._start = START;
        this._stop = STOP;
        this._text = TEXT;
        this.icon = new SimpleObjectProperty((Object)this, "icon", (Object)ICON);
        this._styleClass = STYLE_CLASS;
        this._color = COLOR;
    }

    public final double getStart() {
        return null == this.start ? this._start : this.start.get();
    }

    public final void setStart(double START) {
        if (null == this.start) {
            this._start = START;
        } else {
            this.start.set(START);
        }
    }

    public final DoubleProperty startProperty() {
        if (null == this.start) {
            this.start = new SimpleDoubleProperty((Object)this, "start", this._start);
        }
        return this.start;
    }

    public final double getStop() {
        return null == this.stop ? this._stop : this.stop.get();
    }

    public final void setStop(double STOP) {
        if (null == this.stop) {
            this._stop = STOP;
        } else {
            this.stop.set(STOP);
        }
    }

    public final DoubleProperty stopProperty() {
        if (null == this.stop) {
            this.stop = new SimpleDoubleProperty((Object)this, "stop", this._stop);
        }
        return this.stop;
    }

    public final String getText() {
        return null == this.text ? this._text : (String)this.text.get();
    }

    public final void setText(String TEXT) {
        if (null == this.text) {
            this._text = TEXT;
        } else {
            this.text.set((Object)TEXT);
        }
    }

    public final StringProperty textProperty() {
        if (null == this.text) {
            this.text = new SimpleStringProperty((Object)this, "text", this._text);
        }
        return this.text;
    }

    public final Image getImage() {
        return (Image)this.icon.get();
    }

    public final void setIcon(Image IMAGE) {
        this.icon.set((Object)IMAGE);
    }

    public final ObjectProperty<Image> iconProperty() {
        return this.icon;
    }

    public final String getStyleClass() {
        return null == this.styleClass ? this._styleClass : (String)this.styleClass.get();
    }

    public final void setStyleClass(String STYLE_CLASS) {
        if (null == this.styleClass) {
            this._styleClass = STYLE_CLASS;
        } else {
            this.styleClass.set((Object)STYLE_CLASS);
        }
    }

    public final StringProperty styleClassProperty() {
        if (null == this.styleClass) {
            this.styleClass = new SimpleStringProperty((Object)this, "styleClass", this._styleClass);
        }
        return this.styleClass;
    }

    public final Color getColor() {
        return null == this.color ? this._color : (Color)this.color.get();
    }

    public final void setColor(Color COLOR) {
        if (null == this.color) {
            this._color = COLOR;
        } else {
            this.color.set((Object)COLOR);
        }
    }

    public final ObjectProperty<Color> colorProperty() {
        if (null == this.color) {
            this.color = new SimpleObjectProperty((Object)this, "color", (Object)this._color);
        }
        return this.color;
    }

    public boolean contains(double VALUE) {
        return Double.compare(VALUE, this.getStart()) >= 0 && Double.compare(VALUE, this.getStop()) <= 0;
    }

    public final ObjectProperty<EventHandler<SectionEvent>> onEnteringSectionProperty() {
        return this.onEnteringSection;
    }

    public final void setOnEnteringSection(EventHandler<SectionEvent> value) {
        this.onEnteringSectionProperty().set(value);
    }

    public final EventHandler<SectionEvent> getOnEnteringSection() {
        return (EventHandler)this.onEnteringSectionProperty().get();
    }

    public final ObjectProperty<EventHandler<SectionEvent>> onLeavingSectionProperty() {
        return this.onLeavingSection;
    }

    public final void setOnLeavingSection(EventHandler<SectionEvent> value) {
        this.onLeavingSectionProperty().set(value);
    }

    public final EventHandler<SectionEvent> getOnLeavingSection() {
        return (EventHandler)this.onLeavingSectionProperty().get();
    }

    public void fireSectionEvent(SectionEvent EVENT) {
        EventType TYPE = EVENT.getEventType();
        Object HANDLER = SectionEvent.ENTERING_SECTION == TYPE ? this.getOnEnteringSection() : (SectionEvent.LEAVING_SECTION == TYPE ? this.getOnLeavingSection() : null);
        if (null == HANDLER) {
            return;
        }
        HANDLER.handle((Event)EVENT);
    }

    public boolean equals(Section SECTION) {
        return Double.compare(SECTION.getStart(), this.getStart()) == 0 && Double.compare(SECTION.getStop(), this.getStop()) == 0 && SECTION.getText().equals(this.getText());
    }

    public String toString() {
        StringBuilder NAME = new StringBuilder();
        NAME.append("Section: ").append("\n");
        NAME.append("text      : ").append(this.getText()).append("\n");
        NAME.append("startValue: ").append(this.getStart()).append("\n");
        NAME.append("stopValue : ").append(this.getStop()).append("\n");
        return NAME.toString();
    }

    public static class SectionEvent
    extends Event {
        public static final EventType<SectionEvent> ENTERING_SECTION = new EventType(ANY, "enteringSection");
        public static final EventType<SectionEvent> LEAVING_SECTION = new EventType(ANY, "leavingSection");

        public SectionEvent(Object SOURCE, EventTarget TARGET, EventType<SectionEvent> TYPE) {
            super(SOURCE, TARGET, TYPE);
        }
    }
}

