/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge;

import eu.hansolo.enzo.gauge.Radial;
import eu.hansolo.enzo.gauge.RadialBuilder;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class DemoRadial
extends Application {
    private static final Random RND = new Random();
    private static int noOfNodes = 0;
    private Radial radial;
    private long lastTimerCall;
    private AnimationTimer timer;

    public void init() {
        this.radial = ((RadialBuilder)((RadialBuilder)((RadialBuilder)((RadialBuilder)((RadialBuilder)((RadialBuilder)RadialBuilder.create().prefSize(600.0, 600.0)).minValue(0.0)).maxValue(100.0)).title("Title")).unit("\u00b0C")).ledColor(Color.CYAN)).build();
        this.lastTimerCall = System.nanoTime() + 2000000000L;
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > DemoRadial.this.lastTimerCall + 2000000000L) {
                    double value = RND.nextDouble() * 8.0 + 4.0;
                    DemoRadial.this.radial.setValue(value);
                    System.out.println(value + "     " + DemoRadial.this.radial.getValue());
                    DemoRadial.this.lastTimerCall = now;
                }
            }
        };
    }

    public void start(Stage stage) throws Exception {
        HBox pane = new HBox();
        pane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        pane.setSpacing(10.0);
        pane.getChildren().addAll((Object[])new Node[]{this.radial});
        Scene scene = new Scene((Parent)pane, (Paint)Color.BLACK);
        stage.setTitle("Radial");
        stage.setScene(scene);
        stage.show();
        this.timer.start();
        DemoRadial.calcNoOfNodes((Node)scene.getRoot());
        System.out.println(noOfNodes + " Nodes in SceneGraph");
    }

    public void stop() {
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                DemoRadial.calcNoOfNodes(n);
            }
        }
    }
}

