/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge.skin;

import eu.hansolo.enzo.common.ConicalGradient;
import eu.hansolo.enzo.common.Marker;
import eu.hansolo.enzo.common.Section;
import eu.hansolo.enzo.common.ValueEvent;
import eu.hansolo.enzo.fonts.Fonts;
import eu.hansolo.enzo.gauge.RadialBargraph;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.stream.IntStream;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.PauseTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.Blend;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.util.Duration;

public class RadialBargraphSkin
extends SkinBase<RadialBargraph>
implements Skin<RadialBargraph> {
    private static final double PREFERRED_WIDTH = 200.0;
    private static final double PREFERRED_HEIGHT = 200.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double size;
    private double centerX;
    private double centerY;
    private Pane pane;
    private Region background;
    private Canvas ticksAndSectionsCanvas;
    private GraphicsContext ticksAndSections;
    private Region threshold;
    private Rotate thresholdRotate;
    private boolean thresholdExceeded;
    private Region minMeasuredValue;
    private Rotate minMeasuredValueRotate;
    private Region maxMeasuredValue;
    private Rotate maxMeasuredValueRotate;
    private DoubleProperty angle;
    private Arc bar;
    private Region knob;
    private DropShadow dropShadow;
    private Text title;
    private Text unit;
    private Text value;
    private DropShadow valueBlendBottomShadow;
    private InnerShadow valueBlendTopShadow;
    private Blend blend;
    private double angleStep;
    private Timeline timeline;
    private double interactiveAngle;
    private EventHandler<MouseEvent> mouseEventHandler;
    private EventHandler<TouchEvent> touchEventHandler;
    private List<Node> markersToRemove;
    private Color barColor;
    private ConicalGradient barGradient;
    private Instant lastCall;
    private boolean withinSpeedLimit;

    public RadialBargraphSkin(RadialBargraph radialBargraph) {
        super((Control)radialBargraph);
        this.angleStep = radialBargraph.getAngleRange() / (radialBargraph.getMaxValue() - radialBargraph.getMinValue());
        this.angle = new SimpleDoubleProperty((Object)this, "angle", ((RadialBargraph)this.getSkinnable()).getValue() * this.angleStep);
        this.lastCall = Instant.now();
        this.withinSpeedLimit = true;
        this.timeline = new Timeline();
        this.mouseEventHandler = mouseEvent -> this.handleMouseEvent((MouseEvent)mouseEvent);
        this.touchEventHandler = touchEvent -> this.handleTouchEvent((TouchEvent)touchEvent);
        this.markersToRemove = new ArrayList<Node>();
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if ((Double.compare(((RadialBargraph)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((RadialBargraph)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((RadialBargraph)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((RadialBargraph)this.getSkinnable()).getHeight(), 0.0) <= 0) && ((RadialBargraph)this.getSkinnable()).getPrefWidth() < 0.0 && ((RadialBargraph)this.getSkinnable()).getPrefHeight() < 0.0) {
            ((RadialBargraph)this.getSkinnable()).setPrefSize(200.0, 200.0);
        }
        if (Double.compare(((RadialBargraph)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((RadialBargraph)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((RadialBargraph)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((RadialBargraph)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((RadialBargraph)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((RadialBargraph)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/eu/hansolo/enzo/fonts/opensans-semibold.ttf"), (double)12.0);
        this.barColor = ((RadialBargraph)this.getSkinnable()).getBarColor();
        this.barGradient = new ConicalGradient(new Stop(0.0, Color.TRANSPARENT), new Stop(1.0, Color.TRANSPARENT));
        this.valueBlendBottomShadow = new DropShadow();
        this.valueBlendBottomShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.valueBlendBottomShadow.setColor(Color.rgb((int)255, (int)255, (int)255, (double)0.5));
        this.valueBlendBottomShadow.setOffsetX(0.0);
        this.valueBlendBottomShadow.setOffsetY(1.0);
        this.valueBlendBottomShadow.setRadius(0.0);
        this.valueBlendTopShadow = new InnerShadow();
        this.valueBlendTopShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.valueBlendTopShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.7));
        this.valueBlendTopShadow.setOffsetX(0.0);
        this.valueBlendTopShadow.setOffsetY(1.0);
        this.valueBlendTopShadow.setRadius(1.0);
        this.blend = new Blend();
        this.blend.setMode(BlendMode.MULTIPLY);
        this.blend.setBottomInput((Effect)this.valueBlendBottomShadow);
        this.blend.setTopInput((Effect)this.valueBlendTopShadow);
        this.background = new Region();
        this.background.getStyleClass().setAll((Object[])new String[]{"background"});
        this.ticksAndSectionsCanvas = new Canvas(200.0, 200.0);
        this.ticksAndSections = this.ticksAndSectionsCanvas.getGraphicsContext2D();
        this.minMeasuredValue = new Region();
        this.minMeasuredValue.getStyleClass().setAll((Object[])new String[]{"min-measured-value"});
        this.minMeasuredValueRotate = new Rotate(180.0 - ((RadialBargraph)this.getSkinnable()).getStartAngle());
        this.minMeasuredValue.getTransforms().setAll((Object[])new Transform[]{this.minMeasuredValueRotate});
        this.minMeasuredValue.setOpacity(((RadialBargraph)this.getSkinnable()).isMinMeasuredValueVisible() ? 1.0 : 0.0);
        this.minMeasuredValue.setManaged(((RadialBargraph)this.getSkinnable()).isMinMeasuredValueVisible());
        this.maxMeasuredValue = new Region();
        this.maxMeasuredValue.getStyleClass().setAll((Object[])new String[]{"max-measured-value"});
        this.maxMeasuredValueRotate = new Rotate(180.0 - ((RadialBargraph)this.getSkinnable()).getStartAngle());
        this.maxMeasuredValue.getTransforms().setAll((Object[])new Transform[]{this.maxMeasuredValueRotate});
        this.maxMeasuredValue.setOpacity(((RadialBargraph)this.getSkinnable()).isMaxMeasuredValueVisible() ? 1.0 : 0.0);
        this.maxMeasuredValue.setManaged(((RadialBargraph)this.getSkinnable()).isMaxMeasuredValueVisible());
        this.threshold = new Region();
        this.threshold.getStyleClass().setAll((Object[])new String[]{"threshold"});
        this.thresholdRotate = new Rotate(180.0 - ((RadialBargraph)this.getSkinnable()).getStartAngle());
        this.threshold.getTransforms().setAll((Object[])new Transform[]{this.thresholdRotate});
        this.threshold.setOpacity(((RadialBargraph)this.getSkinnable()).isThresholdVisible() ? 1.0 : 0.0);
        this.threshold.setManaged(((RadialBargraph)this.getSkinnable()).isThresholdVisible());
        this.thresholdExceeded = false;
        this.bar = new Arc();
        this.bar.setType(ArcType.ROUND);
        this.bar.setCenterX(100.0);
        this.bar.setCenterY(100.0);
        this.bar.setRadiusX(96.0);
        this.bar.setRadiusY(96.0);
        this.bar.setStartAngle(((RadialBargraph)this.getSkinnable()).getStartAngle() - 90.0);
        this.bar.setLength(0.0);
        this.bar.setStrokeType(StrokeType.CENTERED);
        this.bar.setStroke(null);
        this.bar.setFill((Paint)new RadialGradient(0.0, 0.0, 100.0, 100.0, 90.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.barColor), new Stop(0.76, this.barColor.deriveColor(-5.0, 1.0, 1.0, 1.0)), new Stop(0.79, this.barColor), new Stop(0.97, this.barColor), new Stop(1.0, this.barColor.deriveColor(-5.0, 1.0, 1.0, 1.0))}));
        this.knob = new Region();
        this.knob.setPickOnBounds(false);
        this.knob.getStyleClass().setAll((Object[])new String[]{"knob"});
        this.dropShadow = new DropShadow();
        this.dropShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.25));
        this.dropShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.dropShadow.setRadius(3.0);
        this.dropShadow.setOffsetY(3.0);
        this.title = new Text(((RadialBargraph)this.getSkinnable()).getTitle());
        this.title.setMouseTransparent(true);
        this.title.setTextOrigin(VPos.CENTER);
        this.title.getStyleClass().setAll((Object[])new String[]{"title"});
        this.title.setEffect((Effect)(((RadialBargraph)this.getSkinnable()).isPlainValue() ? null : this.blend));
        this.unit = new Text(((RadialBargraph)this.getSkinnable()).getUnit());
        this.unit.setMouseTransparent(true);
        this.unit.setTextOrigin(VPos.CENTER);
        this.unit.getStyleClass().setAll((Object[])new String[]{"unit"});
        this.unit.setEffect((Effect)(((RadialBargraph)this.getSkinnable()).isPlainValue() ? null : this.blend));
        this.value = new Text();
        this.value.setText(String.format(Locale.US, "%." + ((RadialBargraph)this.getSkinnable()).getDecimals() + "f", ((RadialBargraph)this.getSkinnable()).getValue()));
        this.value.setMouseTransparent(true);
        this.value.setTextOrigin(VPos.CENTER);
        this.value.getStyleClass().setAll((Object[])new String[]{"value"});
        this.value.setEffect((Effect)(((RadialBargraph)this.getSkinnable()).isPlainValue() ? null : this.blend));
        double range = ((RadialBargraph)this.getSkinnable()).getMaxValue() - ((RadialBargraph)this.getSkinnable()).getMinValue();
        double angleRange = ((RadialBargraph)this.getSkinnable()).getAngleRange();
        this.angleStep = angleRange / range;
        double targetAngle = ((RadialBargraph)this.getSkinnable()).getValue() * this.angleStep;
        this.angle.set(targetAngle);
        double currentValue = this.angle.get() / this.angleStep;
        this.value.setText(String.format(Locale.US, "%." + ((RadialBargraph)this.getSkinnable()).getDecimals() + "f", currentValue));
        this.value.setTranslateX((this.size - this.value.getLayoutBounds().getWidth()) * 0.5);
        this.bar.setLength(-currentValue * this.angleStep);
        this.pane = new Pane();
        this.pane.getChildren().setAll((Object[])new Node[]{this.background, this.bar, this.ticksAndSectionsCanvas, this.minMeasuredValue, this.maxMeasuredValue, this.threshold, this.knob, this.title, this.unit, this.value});
        this.pane.getChildren().addAll((Collection)((RadialBargraph)this.getSkinnable()).getMarkers().keySet());
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((RadialBargraph)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((RadialBargraph)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((RadialBargraph)this.getSkinnable()).valueProperty().addListener(observable -> this.handleControlPropertyChanged("VALUE"));
        ((RadialBargraph)this.getSkinnable()).minValueProperty().addListener(observable -> this.handleControlPropertyChanged("RECALC"));
        ((RadialBargraph)this.getSkinnable()).maxValueProperty().addListener(observable -> this.handleControlPropertyChanged("RECALC"));
        ((RadialBargraph)this.getSkinnable()).minMeasuredValueProperty().addListener(observable -> this.handleControlPropertyChanged("MIN_MEASURED_VALUE"));
        ((RadialBargraph)this.getSkinnable()).minMeasuredValueVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("MIN_MEASURED_VALUE_VISIBLE"));
        ((RadialBargraph)this.getSkinnable()).maxMeasuredValueProperty().addListener(observable -> this.handleControlPropertyChanged("MAX_MEASURED_VALUE"));
        ((RadialBargraph)this.getSkinnable()).maxMeasuredValueVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("MAX_MEASURED_VALUE_VISIBLE"));
        ((RadialBargraph)this.getSkinnable()).barColorProperty().addListener(observable -> this.handleControlPropertyChanged("BAR_COLOR"));
        ((RadialBargraph)this.getSkinnable()).animatedProperty().addListener(observable -> this.handleControlPropertyChanged("ANIMATED"));
        ((RadialBargraph)this.getSkinnable()).thresholdProperty().addListener(observable -> this.handleControlPropertyChanged("THRESHOLD"));
        ((RadialBargraph)this.getSkinnable()).thresholdVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("THRESHOLD_VISIBLE"));
        ((RadialBargraph)this.getSkinnable()).angleRangeProperty().addListener(observable -> this.handleControlPropertyChanged("ANGLE_RANGE"));
        ((RadialBargraph)this.getSkinnable()).numberFormatProperty().addListener(observable -> this.handleControlPropertyChanged("RECALC"));
        ((RadialBargraph)this.getSkinnable()).plainValueProperty().addListener(observable -> this.handleControlPropertyChanged("PLAIN_VALUE"));
        ((RadialBargraph)this.getSkinnable()).interactiveProperty().addListener(observable -> this.handleControlPropertyChanged("INTERACTIVE"));
        ((RadialBargraph)this.getSkinnable()).getSections().addListener(change -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((RadialBargraph)this.getSkinnable()).getMarkers().addListener(change -> this.handleControlPropertyChanged("MARKER"));
        ((RadialBargraph)this.getSkinnable()).barGradientProperty().addListener(change -> this.handleControlPropertyChanged("BAR_GRADIENT"));
        ((RadialBargraph)this.getSkinnable()).barGradientEnabledProperty().addListener(observable -> this.handleControlPropertyChanged("BAR_COLOR"));
        this.angle.addListener(observable -> this.handleControlPropertyChanged("ANGLE"));
        this.knob.setOnMousePressed(event -> ((RadialBargraph)this.getSkinnable()).setInteractive(!((RadialBargraph)this.getSkinnable()).isInteractive()));
        this.minMeasuredValue.setOnMousePressed(this.mouseEventHandler);
        this.minMeasuredValue.setOnMouseReleased(this.mouseEventHandler);
        this.minMeasuredValue.setOnTouchPressed(this.touchEventHandler);
        this.minMeasuredValue.setOnTouchReleased(this.touchEventHandler);
        this.maxMeasuredValue.setOnMousePressed(this.mouseEventHandler);
        this.maxMeasuredValue.setOnMouseReleased(this.mouseEventHandler);
        this.maxMeasuredValue.setOnTouchPressed(this.touchEventHandler);
        this.maxMeasuredValue.setOnTouchReleased(this.touchEventHandler);
        this.threshold.setOnMousePressed(this.mouseEventHandler);
        this.threshold.setOnMouseDragged(this.mouseEventHandler);
        this.threshold.setOnMouseReleased(this.mouseEventHandler);
        this.threshold.setOnTouchPressed(this.touchEventHandler);
        this.threshold.setOnTouchMoved(this.touchEventHandler);
        this.threshold.setOnTouchReleased(this.touchEventHandler);
        for (Marker marker : ((RadialBargraph)this.getSkinnable()).getMarkers().keySet()) {
            marker.setOnMousePressed(this.mouseEventHandler);
            marker.setOnMouseDragged(this.mouseEventHandler);
            marker.setOnMouseReleased(this.mouseEventHandler);
            marker.setOnTouchPressed(this.touchEventHandler);
            marker.setOnTouchMoved(this.touchEventHandler);
            marker.setOnTouchReleased(this.touchEventHandler);
        }
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("VALUE".equals(PROPERTY)) {
            this.withinSpeedLimit = !Instant.now().minusMillis((long)((RadialBargraph)this.getSkinnable()).getAnimationDuration()).isBefore(this.lastCall);
            this.lastCall = Instant.now();
            this.setBar();
        } else if ("RECALC".equals(PROPERTY)) {
            this.angleStep = ((RadialBargraph)this.getSkinnable()).getAngleRange() / (((RadialBargraph)this.getSkinnable()).getMaxValue() - ((RadialBargraph)this.getSkinnable()).getMinValue());
            this.resize();
        } else if ("ANGLE".equals(PROPERTY)) {
            if (((RadialBargraph)this.getSkinnable()).isInteractive()) {
                return;
            }
            double currentValue = this.angle.get() / this.angleStep;
            this.value.setText(String.format(Locale.US, "%." + ((RadialBargraph)this.getSkinnable()).getDecimals() + "f", currentValue));
            this.value.setTranslateX((this.size - this.value.getLayoutBounds().getWidth()) * 0.5);
            this.bar.setLength(-currentValue * this.angleStep);
            if (this.thresholdExceeded) {
                if (currentValue < ((RadialBargraph)this.getSkinnable()).getThreshold()) {
                    ((RadialBargraph)this.getSkinnable()).fireEvent(new ValueEvent((Object)this, null, ValueEvent.VALUE_UNDERRUN));
                    this.thresholdExceeded = false;
                }
            } else if (currentValue > ((RadialBargraph)this.getSkinnable()).getThreshold()) {
                ((RadialBargraph)this.getSkinnable()).fireEvent(new ValueEvent((Object)this, null, ValueEvent.VALUE_EXCEEDED));
                this.thresholdExceeded = true;
            }
            for (Marker marker : ((RadialBargraph)this.getSkinnable()).getMarkers().keySet()) {
                if (marker.isExceeded()) {
                    if (!(currentValue < marker.getValue())) continue;
                    marker.fireMarkerEvent(new Marker.MarkerEvent((Object)this, null, Marker.MarkerEvent.MARKER_UNDERRUN));
                    marker.setExceeded(false);
                    continue;
                }
                if (!(currentValue > marker.getValue())) continue;
                marker.fireMarkerEvent(new Marker.MarkerEvent((Object)this, null, Marker.MarkerEvent.MARKER_EXCEEDED));
                marker.setExceeded(true);
            }
            if (currentValue < ((RadialBargraph)this.getSkinnable()).getMinMeasuredValue()) {
                ((RadialBargraph)this.getSkinnable()).setMinMeasuredValue(currentValue);
                this.minMeasuredValueRotate.setAngle(currentValue * this.angleStep - 180.0 - ((RadialBargraph)this.getSkinnable()).getStartAngle());
            }
            if (currentValue > ((RadialBargraph)this.getSkinnable()).getMaxMeasuredValue()) {
                ((RadialBargraph)this.getSkinnable()).setMaxMeasuredValue(currentValue);
                this.maxMeasuredValueRotate.setAngle(currentValue * this.angleStep - 180.0 - ((RadialBargraph)this.getSkinnable()).getStartAngle());
            }
        } else if ("PLAIN_VALUE".equals(PROPERTY)) {
            this.value.setEffect((Effect)(((RadialBargraph)this.getSkinnable()).isPlainValue() ? null : this.blend));
        } else if ("INTERACTIVE".equals(PROPERTY)) {
            if (((RadialBargraph)this.getSkinnable()).isInteractive()) {
                this.unit.setText("Interactive");
                this.value.setText("");
                this.resizeText();
            } else {
                this.unit.setText(((RadialBargraph)this.getSkinnable()).getUnit());
                this.value.setText(String.format(Locale.US, "%." + ((RadialBargraph)this.getSkinnable()).getDecimals() + "f", this.angle.get() / this.angleStep));
                this.resizeText();
            }
        } else if ("CANVAS_REFRESH".equals(PROPERTY)) {
            this.ticksAndSections.clearRect(0.0, 0.0, this.size, this.size);
            this.drawSections(this.ticksAndSections);
            this.drawTickMarks(this.ticksAndSections);
        } else if ("THRESHOLD".equals(PROPERTY)) {
            this.thresholdRotate.setAngle(((RadialBargraph)this.getSkinnable()).getThreshold() * this.angleStep - 180.0 - ((RadialBargraph)this.getSkinnable()).getStartAngle());
        } else if ("THRESHOLD_VISIBLE".equals(PROPERTY)) {
            this.threshold.setOpacity(((RadialBargraph)this.getSkinnable()).isThresholdVisible() ? 1.0 : 0.0);
            this.threshold.setManaged(((RadialBargraph)this.getSkinnable()).isThresholdVisible());
        } else if ("MIN_MEASURED_VALUE_VISIBLE".equals(PROPERTY)) {
            this.minMeasuredValue.setOpacity(((RadialBargraph)this.getSkinnable()).isMinMeasuredValueVisible() ? 1.0 : 0.0);
            this.minMeasuredValue.setManaged(((RadialBargraph)this.getSkinnable()).isMinMeasuredValueVisible());
        } else if ("MAX_MEASURED_VALUE_VISIBLE".equals(PROPERTY)) {
            this.maxMeasuredValue.setOpacity(((RadialBargraph)this.getSkinnable()).isMaxMeasuredValueVisible() ? 1.0 : 0.0);
            this.maxMeasuredValue.setManaged(((RadialBargraph)this.getSkinnable()).isMaxMeasuredValueVisible());
        } else if ("MARKER".equals(PROPERTY)) {
            this.checkForRemovedMarkers();
            for (Marker marker : ((RadialBargraph)this.getSkinnable()).getMarkers().keySet()) {
                if (this.pane.getChildren().contains((Object)marker)) continue;
                this.pane.getChildren().add((Object)marker);
                marker.setOnMousePressed(this.mouseEventHandler);
                marker.setOnMouseDragged(this.mouseEventHandler);
                marker.setOnMouseReleased(this.mouseEventHandler);
                marker.setOnTouchPressed(this.touchEventHandler);
                marker.setOnTouchMoved(this.touchEventHandler);
                marker.setOnTouchReleased(this.touchEventHandler);
            }
            this.drawMarkers();
        } else if ("BAR_COLOR".equals(PROPERTY)) {
            this.barColor = ((RadialBargraph)this.getSkinnable()).getBarColor();
            this.resize();
        }
    }

    private void checkForRemovedMarkers() {
        this.markersToRemove.clear();
        for (Node node : this.pane.getChildren()) {
            if (!(node instanceof Marker) || ((RadialBargraph)this.getSkinnable()).getMarkers().keySet().contains(node)) continue;
            node.setManaged(false);
            node.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
            node.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseEventHandler);
            node.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseEventHandler);
            node.removeEventHandler(TouchEvent.TOUCH_PRESSED, this.touchEventHandler);
            node.removeEventHandler(TouchEvent.TOUCH_MOVED, this.touchEventHandler);
            node.removeEventHandler(TouchEvent.TOUCH_RELEASED, this.touchEventHandler);
            this.markersToRemove.add(node);
        }
        for (Node node : this.markersToRemove) {
            this.pane.getChildren().remove((Object)node);
        }
    }

    private void handleMouseEvent(MouseEvent MOUSE_EVENT) {
        Object SRC = MOUSE_EVENT.getSource();
        EventType TYPE = MOUSE_EVENT.getEventType();
        if (((RadialBargraph)this.getSkinnable()).isInteractive() && SRC.equals(this.threshold)) {
            if (MouseEvent.MOUSE_PRESSED == TYPE) {
                this.unit.setText("Threshold");
                this.value.setText(String.format(Locale.US, "%." + ((RadialBargraph)this.getSkinnable()).getDecimals() + "f", ((RadialBargraph)this.getSkinnable()).getThreshold()));
                this.resizeText();
            } else if (MouseEvent.MOUSE_DRAGGED == TYPE) {
                Point2D point = ((RadialBargraph)this.getSkinnable()).sceneToLocal(MOUSE_EVENT.getSceneX(), MOUSE_EVENT.getSceneY());
                this.touchRotate(point.getX(), point.getY(), this.thresholdRotate);
            } else if (MouseEvent.MOUSE_RELEASED == TYPE) {
                ((RadialBargraph)this.getSkinnable()).setThreshold(Double.parseDouble(this.value.getText()));
                this.fadeBackToInteractive();
            }
        } else if (((RadialBargraph)this.getSkinnable()).isInteractive() && SRC instanceof Marker) {
            if (MouseEvent.MOUSE_PRESSED == TYPE) {
                this.unit.setText(((Marker)((Object)SRC)).getText());
                this.value.setText(String.format(Locale.US, "%." + ((RadialBargraph)this.getSkinnable()).getDecimals() + "f", ((Marker)((Object)SRC)).getValue()));
                this.resizeText();
            } else if (MouseEvent.MOUSE_DRAGGED == TYPE) {
                Point2D point = ((RadialBargraph)this.getSkinnable()).sceneToLocal(MOUSE_EVENT.getSceneX(), MOUSE_EVENT.getSceneY());
                this.touchRotate(point.getX(), point.getY(), (Rotate)((RadialBargraph)this.getSkinnable()).getMarkers().get(SRC));
            } else if (MouseEvent.MOUSE_RELEASED == TYPE) {
                ((Marker)((Object)SRC)).setValue(Double.parseDouble(this.value.getText()));
                this.fadeBackToInteractive();
            }
        } else if (((RadialBargraph)this.getSkinnable()).isInteractive() && SRC.equals(this.minMeasuredValue)) {
            if (MouseEvent.MOUSE_PRESSED == TYPE) {
                this.unit.setText("Min");
                this.value.setText(String.format(Locale.US, "%." + ((RadialBargraph)this.getSkinnable()).getDecimals() + "f", ((RadialBargraph)this.getSkinnable()).getMinMeasuredValue()));
                this.resizeText();
            } else if (MouseEvent.MOUSE_RELEASED == TYPE) {
                this.fadeBackToInteractive();
            }
        } else if (((RadialBargraph)this.getSkinnable()).isInteractive() && SRC.equals(this.maxMeasuredValue)) {
            if (MouseEvent.MOUSE_PRESSED == TYPE) {
                this.unit.setText("Max");
                this.value.setText(String.format(Locale.US, "%." + ((RadialBargraph)this.getSkinnable()).getDecimals() + "f", ((RadialBargraph)this.getSkinnable()).getMaxMeasuredValue()));
                this.resizeText();
            } else if (MouseEvent.MOUSE_RELEASED == TYPE) {
                this.fadeBackToInteractive();
            }
        }
    }

    private void handleTouchEvent(TouchEvent TOUCH_EVENT) {
        Object SRC = TOUCH_EVENT.getSource();
        EventType TYPE = TOUCH_EVENT.getEventType();
        if (SRC.equals(this.threshold)) {
            if (TouchEvent.TOUCH_PRESSED == TYPE) {
                this.unit.setText("Threshold");
                this.value.setText(String.format(Locale.US, "%." + ((RadialBargraph)this.getSkinnable()).getDecimals() + "f", ((RadialBargraph)this.getSkinnable()).getThreshold()));
                this.resizeText();
            } else if (TouchEvent.TOUCH_MOVED == TYPE) {
                Point2D point = ((RadialBargraph)this.getSkinnable()).sceneToLocal(TOUCH_EVENT.getTouchPoint().getSceneX(), TOUCH_EVENT.getTouchPoint().getSceneY());
                this.touchRotate(point.getX(), point.getY(), this.thresholdRotate);
            } else if (TouchEvent.TOUCH_RELEASED == TYPE) {
                ((RadialBargraph)this.getSkinnable()).setThreshold(Double.parseDouble(this.value.getText()));
                this.fadeBackToInteractive();
            }
        } else if (SRC instanceof Marker) {
            if (TouchEvent.TOUCH_PRESSED == TYPE) {
                this.unit.setText(((Marker)((Object)SRC)).getText());
                this.value.setText(String.format(Locale.US, "%." + ((RadialBargraph)this.getSkinnable()).getDecimals() + "f", ((Marker)((Object)SRC)).getValue()));
                this.resizeText();
            } else if (TouchEvent.TOUCH_MOVED == TYPE) {
                Point2D point = ((RadialBargraph)this.getSkinnable()).sceneToLocal(TOUCH_EVENT.getTouchPoint().getSceneX(), TOUCH_EVENT.getTouchPoint().getSceneY());
                this.touchRotate(point.getX(), point.getY(), (Rotate)((RadialBargraph)this.getSkinnable()).getMarkers().get(SRC));
            } else if (TouchEvent.TOUCH_RELEASED == TYPE) {
                ((Marker)((Object)SRC)).setValue(Double.parseDouble(this.value.getText()));
                this.fadeBackToInteractive();
            }
        } else if (SRC.equals(this.minMeasuredValue)) {
            if (TouchEvent.TOUCH_PRESSED == TYPE) {
                this.unit.setText("Min");
                this.value.setText(String.format(Locale.US, "%." + ((RadialBargraph)this.getSkinnable()).getDecimals() + "f", ((RadialBargraph)this.getSkinnable()).getMinMeasuredValue()));
                this.resizeText();
            } else if (TouchEvent.TOUCH_RELEASED == TYPE) {
                this.fadeBackToInteractive();
            }
        } else if (SRC.equals(this.maxMeasuredValue)) {
            if (TouchEvent.TOUCH_PRESSED == TYPE) {
                this.unit.setText("Max");
                this.value.setText(String.format(Locale.US, "%." + ((RadialBargraph)this.getSkinnable()).getDecimals() + "f", ((RadialBargraph)this.getSkinnable()).getMaxMeasuredValue()));
                this.resizeText();
            } else if (TouchEvent.TOUCH_RELEASED == TYPE) {
                this.fadeBackToInteractive();
            }
        }
    }

    private double getTheta(double x, double y) {
        double nx;
        double radius;
        double deltaX = x - ((RadialBargraph)this.getSkinnable()).getWidth() * 0.5;
        double deltaY = y - ((RadialBargraph)this.getSkinnable()).getHeight() * 0.5;
        double ny = deltaY / (radius = Math.sqrt(deltaX * deltaX + deltaY * deltaY));
        double theta = Math.atan2(ny, nx = deltaX / radius);
        return Double.compare(theta, 0.0) >= 0 ? Math.toDegrees(theta) : Math.toDegrees(theta) + 360.0;
    }

    private void touchRotate(double X, double Y, Rotate ROTATE) {
        double newValue;
        double theta = this.getTheta(X, Y);
        this.interactiveAngle = (theta + 90.0) % 360.0;
        double d = newValue = Double.compare(this.interactiveAngle, 180.0) <= 0 ? (this.interactiveAngle + 180.0 + ((RadialBargraph)this.getSkinnable()).getStartAngle() - 360.0) / this.angleStep : (this.interactiveAngle - 180.0 + ((RadialBargraph)this.getSkinnable()).getStartAngle() - 360.0) / this.angleStep;
        if (Double.compare(newValue, ((RadialBargraph)this.getSkinnable()).getMinValue()) >= 0 && Double.compare(newValue, ((RadialBargraph)this.getSkinnable()).getMaxValue()) <= 0) {
            ROTATE.setAngle(this.interactiveAngle);
            this.value.setText(String.format(Locale.US, "%." + ((RadialBargraph)this.getSkinnable()).getDecimals() + "f", newValue));
            this.resizeText();
        }
    }

    private void fadeBackToInteractive() {
        FadeTransition fadeUnitOut = new FadeTransition(Duration.millis((double)425.0), (Node)this.unit);
        fadeUnitOut.setFromValue(1.0);
        fadeUnitOut.setToValue(0.0);
        FadeTransition fadeValueOut = new FadeTransition(Duration.millis((double)425.0), (Node)this.value);
        fadeValueOut.setFromValue(1.0);
        fadeValueOut.setToValue(0.0);
        PauseTransition pause = new PauseTransition(Duration.millis((double)50.0));
        FadeTransition fadeUnitIn = new FadeTransition(Duration.millis((double)425.0), (Node)this.unit);
        fadeUnitIn.setFromValue(0.0);
        fadeUnitIn.setToValue(1.0);
        FadeTransition fadeValueIn = new FadeTransition(Duration.millis((double)425.0), (Node)this.value);
        fadeValueIn.setFromValue(0.0);
        fadeValueIn.setToValue(1.0);
        ParallelTransition parallelIn = new ParallelTransition(new Animation[]{fadeUnitIn, fadeValueIn});
        ParallelTransition parallelOut = new ParallelTransition(new Animation[]{fadeUnitOut, fadeValueOut});
        parallelOut.setOnFinished(event -> {
            this.unit.setText("Interactive");
            this.value.setText("");
            this.resizeText();
        });
        SequentialTransition sequence = new SequentialTransition(new Animation[]{parallelOut, pause, parallelIn});
        sequence.play();
    }

    private void setBar() {
        double range = ((RadialBargraph)this.getSkinnable()).getMaxValue() - ((RadialBargraph)this.getSkinnable()).getMinValue();
        double angleRange = ((RadialBargraph)this.getSkinnable()).getAngleRange();
        this.angleStep = angleRange / range;
        double targetAngle = ((RadialBargraph)this.getSkinnable()).getValue() * this.angleStep;
        if (this.withinSpeedLimit && ((RadialBargraph)this.getSkinnable()).isAnimated()) {
            this.timeline.stop();
            KeyValue KEY_VALUE = new KeyValue((WritableValue)this.angle, (Object)targetAngle, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
            KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)((RadialBargraph)this.getSkinnable()).getAnimationDuration()), new KeyValue[]{KEY_VALUE});
            this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{KEY_FRAME});
            this.timeline.play();
        } else {
            this.angle.set(targetAngle);
        }
    }

    private void drawTickMarks(GraphicsContext CTX) {
        double startAngle = ((RadialBargraph)this.getSkinnable()).getStartAngle();
        Point2D center = new Point2D(this.size * 0.5, this.size * 0.5);
        boolean smallRange = ((RadialBargraph)this.getSkinnable()).getMaxValue() - ((RadialBargraph)this.getSkinnable()).getMinValue() < 10.0;
        double tmpMinValue = smallRange ? ((RadialBargraph)this.getSkinnable()).getMinValue() * 10.0 : ((RadialBargraph)this.getSkinnable()).getMinValue();
        double tmpMaxValue = smallRange ? ((RadialBargraph)this.getSkinnable()).getMaxValue() * 10.0 : ((RadialBargraph)this.getSkinnable()).getMaxValue();
        double tmpAngleStep = smallRange ? this.angleStep / 10.0 : this.angleStep;
        double angle = 0.0;
        double counter = tmpMinValue;
        while (Double.compare(counter, tmpMaxValue) <= 0) {
            double sinValue = Math.sin(Math.toRadians(angle + startAngle));
            double cosValue = Math.cos(Math.toRadians(angle + startAngle));
            Point2D innerPoint = new Point2D(center.getX() + this.size * 0.388 * sinValue, center.getY() + this.size * 0.388 * cosValue);
            Point2D outerPoint = new Point2D(center.getX() + this.size * 0.485 * sinValue, center.getY() + this.size * 0.485 * cosValue);
            CTX.setStroke(((RadialBargraph)this.getSkinnable()).getTickMarkFill());
            if (counter % ((RadialBargraph)this.getSkinnable()).getMinorTickSpace() == 0.0) {
                CTX.setLineWidth(this.size * 0.0035);
                CTX.strokeLine(innerPoint.getX(), innerPoint.getY(), outerPoint.getX(), outerPoint.getY());
            }
            angle -= tmpAngleStep;
            counter += 1.0;
        }
    }

    private final void drawSections(GraphicsContext CTX) {
        double xy = (this.size - 0.87 * this.size) * 0.5;
        double wh = this.size * 0.87;
        double MIN_VALUE = ((RadialBargraph)this.getSkinnable()).getMinValue();
        double MAX_VALUE = ((RadialBargraph)this.getSkinnable()).getMaxValue();
        double OFFSET = 90.0 - ((RadialBargraph)this.getSkinnable()).getStartAngle();
        IntStream.range(0, ((RadialBargraph)this.getSkinnable()).getSections().size()).parallel().forEachOrdered(i -> {
            Section SECTION = (Section)((RadialBargraph)this.getSkinnable()).getSections().get(i);
            if (Double.compare(SECTION.getStart(), MAX_VALUE) <= 0 && Double.compare(SECTION.getStop(), MIN_VALUE) >= 0) {
                double SECTION_START_ANGLE = SECTION.getStart() < MIN_VALUE && SECTION.getStop() < MAX_VALUE ? MIN_VALUE * this.angleStep : (SECTION.getStart() - MIN_VALUE) * this.angleStep;
                double SECTION_ANGLE_EXTEND = SECTION.getStop() > MAX_VALUE ? (MAX_VALUE - SECTION.getStart()) * this.angleStep : (SECTION.getStop() - SECTION.getStart()) * this.angleStep;
                CTX.save();
                switch (i) {
                    case 0: {
                        CTX.setStroke(((RadialBargraph)this.getSkinnable()).getSectionFill0());
                        break;
                    }
                    case 1: {
                        CTX.setStroke(((RadialBargraph)this.getSkinnable()).getSectionFill1());
                        break;
                    }
                    case 2: {
                        CTX.setStroke(((RadialBargraph)this.getSkinnable()).getSectionFill2());
                        break;
                    }
                    case 3: {
                        CTX.setStroke(((RadialBargraph)this.getSkinnable()).getSectionFill3());
                        break;
                    }
                    case 4: {
                        CTX.setStroke(((RadialBargraph)this.getSkinnable()).getSectionFill4());
                        break;
                    }
                    case 5: {
                        CTX.setStroke(((RadialBargraph)this.getSkinnable()).getSectionFill5());
                        break;
                    }
                    case 6: {
                        CTX.setStroke(((RadialBargraph)this.getSkinnable()).getSectionFill6());
                        break;
                    }
                    case 7: {
                        CTX.setStroke(((RadialBargraph)this.getSkinnable()).getSectionFill7());
                        break;
                    }
                    case 8: {
                        CTX.setStroke(((RadialBargraph)this.getSkinnable()).getSectionFill8());
                        break;
                    }
                    case 9: {
                        CTX.setStroke(((RadialBargraph)this.getSkinnable()).getSectionFill9());
                    }
                }
                CTX.setLineWidth(this.size * 0.1);
                CTX.setLineCap(StrokeLineCap.BUTT);
                CTX.strokeArc(xy, xy, wh, wh, -(OFFSET + SECTION_START_ANGLE), -SECTION_ANGLE_EXTEND, ArcType.OPEN);
                CTX.restore();
            }
        });
    }

    private final void drawMarkers() {
        for (Marker marker : ((RadialBargraph)this.getSkinnable()).getMarkers().keySet()) {
            marker.setPrefSize(0.05 * this.size, 0.05 * this.size);
            marker.relocate((this.size - marker.getPrefWidth()) * 0.5, this.size * 0.04);
            ((Rotate)((RadialBargraph)this.getSkinnable()).getMarkers().get((Object)marker)).setPivotX(marker.getPrefWidth() * 0.5);
            ((Rotate)((RadialBargraph)this.getSkinnable()).getMarkers().get((Object)marker)).setPivotY(this.size * 0.46);
            ((Rotate)((RadialBargraph)this.getSkinnable()).getMarkers().get((Object)marker)).setAngle(marker.getValue() * this.angleStep - 180.0 - ((RadialBargraph)this.getSkinnable()).getStartAngle());
        }
    }

    private void recalculateBarGradient() {
        double angleFactor = 0.002777777777777778;
        double emptyRange = 360.0 - ((RadialBargraph)this.getSkinnable()).getAngleRange();
        double offset = angleFactor * ((360.0 - ((RadialBargraph)this.getSkinnable()).getStartAngle() + 180.0 - emptyRange * 0.5) % 360.0);
        LinkedList<Stop> stops = new LinkedList<Stop>();
        double emptyOffset = emptyRange * 0.5 * angleFactor;
        double minFraction = 1.0;
        double maxFraction = 0.0;
        Color minFractionColor = Color.TRANSPARENT;
        Color maxFractionColor = Color.TRANSPARENT;
        for (Stop stop : ((RadialBargraph)this.getSkinnable()).getBarGradient()) {
            double fraction = stop.getOffset();
            if (fraction < minFraction) {
                minFraction = fraction;
                minFractionColor = stop.getColor();
            }
            if (!(fraction > maxFraction)) continue;
            maxFraction = fraction;
            maxFractionColor = stop.getColor();
        }
        stops.add(new Stop(0.0, minFractionColor));
        stops.add(new Stop(0.0 + emptyOffset, minFractionColor));
        stops.add(new Stop(1.0 - emptyOffset, maxFractionColor));
        stops.add(new Stop(1.0, maxFractionColor));
        if (((RadialBargraph)this.getSkinnable()).getBarGradient().size() == 2) {
            stops.add(new Stop((maxFraction - minFraction) * 0.5, (Color)Interpolator.LINEAR.interpolate((Object)minFractionColor, (Object)maxFractionColor, 0.5)));
        }
        for (Stop stop : ((RadialBargraph)this.getSkinnable()).getBarGradient()) {
            if (Double.compare(stop.getOffset(), minFraction) == 0 || Double.compare(stop.getOffset(), maxFraction) == 0) continue;
            stops.add(stop);
        }
        this.barGradient = new ConicalGradient(new Point2D(this.size * 0.5, this.size * 0.5), offset, stops);
    }

    private void resizeText() {
        this.title.setFont(Fonts.robotoMedium(this.size * 0.1));
        this.title.setTranslateX((this.size - this.title.getLayoutBounds().getWidth()) * 0.5);
        this.title.setTranslateY(this.size * 0.3);
        this.unit.setFont(Fonts.robotoMedium(this.size * 0.1));
        this.unit.setTranslateX((this.size - this.unit.getLayoutBounds().getWidth()) * 0.5);
        this.unit.setTranslateY(this.size * 0.7);
        this.value.setFont(Fonts.robotoBold(this.size * 0.25));
        this.value.setTranslateX((this.size - this.value.getLayoutBounds().getWidth()) * 0.5);
        this.value.setTranslateY(this.size * 0.5);
    }

    private void resize() {
        this.size = ((RadialBargraph)this.getSkinnable()).getWidth() < ((RadialBargraph)this.getSkinnable()).getHeight() ? ((RadialBargraph)this.getSkinnable()).getWidth() : ((RadialBargraph)this.getSkinnable()).getHeight();
        this.centerX = this.size * 0.5;
        this.centerY = this.size * 0.5;
        if (this.size > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((((RadialBargraph)this.getSkinnable()).getWidth() - this.size) * 0.5, (((RadialBargraph)this.getSkinnable()).getHeight() - this.size) * 0.5);
            double RADIUS = this.size * 0.5 - 2.0;
            this.valueBlendBottomShadow.setOffsetY(0.005 * this.size);
            this.valueBlendTopShadow.setOffsetY(0.005 * this.size);
            this.valueBlendTopShadow.setRadius(0.005 * this.size);
            this.dropShadow.setRadius(0.015 * this.size);
            this.dropShadow.setOffsetY(0.015 * this.size);
            this.background.setPrefSize(this.size, this.size);
            this.ticksAndSectionsCanvas.setWidth(this.size);
            this.ticksAndSectionsCanvas.setHeight(this.size);
            this.ticksAndSections.clearRect(0.0, 0.0, this.size, this.size);
            this.drawSections(this.ticksAndSections);
            this.drawTickMarks(this.ticksAndSections);
            this.ticksAndSectionsCanvas.setCache(true);
            this.ticksAndSectionsCanvas.setCacheHint(CacheHint.QUALITY);
            this.drawMarkers();
            this.minMeasuredValue.setPrefSize(0.03 * this.size, 0.03 * this.size);
            this.minMeasuredValue.relocate((this.size - this.minMeasuredValue.getPrefWidth()) * 0.5, this.size * 0.11);
            this.minMeasuredValueRotate.setPivotX(this.minMeasuredValue.getPrefWidth() * 0.5);
            this.minMeasuredValueRotate.setPivotY(this.size * 0.39);
            this.minMeasuredValueRotate.setAngle(((RadialBargraph)this.getSkinnable()).getMinMeasuredValue() * this.angleStep - 180.0 - ((RadialBargraph)this.getSkinnable()).getStartAngle());
            this.maxMeasuredValue.setPrefSize(0.03 * this.size, 0.03 * this.size);
            this.maxMeasuredValue.relocate((this.size - this.maxMeasuredValue.getPrefWidth()) * 0.5, this.size * 0.11);
            this.maxMeasuredValueRotate.setPivotX(this.maxMeasuredValue.getPrefWidth() * 0.5);
            this.maxMeasuredValueRotate.setPivotY(this.size * 0.39);
            this.maxMeasuredValueRotate.setAngle(((RadialBargraph)this.getSkinnable()).getMaxMeasuredValue() * this.angleStep - 180.0 - ((RadialBargraph)this.getSkinnable()).getStartAngle());
            this.threshold.setPrefSize(0.06 * this.size, 0.055 * this.size);
            this.threshold.relocate((this.size - this.threshold.getPrefWidth()) * 0.5, this.size * 0.08);
            this.thresholdRotate.setPivotX(this.threshold.getPrefWidth() * 0.5);
            this.thresholdRotate.setPivotY(this.size * 0.42);
            this.thresholdRotate.setAngle(((RadialBargraph)this.getSkinnable()).getThreshold() * this.angleStep - 180.0 - ((RadialBargraph)this.getSkinnable()).getStartAngle());
            this.bar.setCenterX(this.centerX);
            this.bar.setCenterY(this.centerY);
            this.bar.setRadiusX(RADIUS);
            this.bar.setRadiusY(RADIUS);
            if (((RadialBargraph)this.getSkinnable()).isBarGradientEnabled()) {
                this.recalculateBarGradient();
                Image image = this.barGradient.getImage(this.size, this.size);
                this.bar.setFill((Paint)new ImagePattern(image, 0.0, 0.0, this.size, this.size, false));
            } else {
                this.bar.setFill((Paint)new RadialGradient(0.0, 0.0, this.centerX, this.centerY, RADIUS, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.barColor), new Stop(0.76, this.barColor.deriveColor(-5.0, 1.0, 1.0, 1.0)), new Stop(0.79, this.barColor), new Stop(0.97, this.barColor), new Stop(1.0, this.barColor.deriveColor(-5.0, 1.0, 1.0, 1.0))}));
            }
            this.knob.setPrefSize(this.size * 0.75, this.size * 0.75);
            this.knob.setTranslateX((this.size - this.knob.getPrefWidth()) * 0.5);
            this.knob.setTranslateY((this.size - this.knob.getPrefHeight()) * 0.5);
            this.resizeText();
        }
    }
}

