/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.heatcontrol;

import eu.hansolo.enzo.heatcontrol.skin.HeatControlSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class HeatControl
extends Control {
    private DoubleProperty value;
    private double oldValue;
    private DoubleProperty minValue;
    private DoubleProperty maxValue;
    private DoubleProperty target;
    private double _minMeasuredValue;
    private DoubleProperty minMeasuredValue;
    private double _maxMeasuredValue;
    private DoubleProperty maxMeasuredValue;
    private int _decimals;
    private IntegerProperty decimals;
    private String _infoText;
    private StringProperty infoText;
    private BooleanProperty targetEnabled;
    private double _startAngle;
    private DoubleProperty startAngle;
    private double _angleRange;
    private DoubleProperty angleRange;
    private ObjectProperty<Paint> tickMarkFill;

    public HeatControl() {
        this.getStyleClass().add((Object)"heat-control");
        this.value = new DoublePropertyBase(0.0){

            protected void invalidated() {
                this.set(HeatControl.this.clamp(HeatControl.this.getMinValue(), HeatControl.this.getMaxValue(), this.get()));
            }

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "value";
            }
        };
        this.minValue = new DoublePropertyBase(0.0){

            protected void invalidated() {
                if (this.getValue() < this.get()) {
                    this.setValue(this.get());
                }
            }

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "minValue";
            }
        };
        this.maxValue = new DoublePropertyBase(40.0){

            protected void invalidated() {
                if (this.getValue() > this.get()) {
                    this.setValue(this.get());
                }
            }

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "maxValue";
            }
        };
        this.oldValue = 0.0;
        this.target = new DoublePropertyBase(20.0){

            protected void invalidated() {
                this.set(HeatControl.this.clamp(HeatControl.this.getMinValue(), HeatControl.this.getMaxValue(), this.get()));
            }

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "target";
            }
        };
        this._minMeasuredValue = this.maxValue.getValue();
        this._maxMeasuredValue = 0.0;
        this._decimals = 0;
        this._infoText = "";
        this.targetEnabled = new SimpleBooleanProperty((Object)this, "targetEnabled", false);
        this._startAngle = 325.0;
        this._angleRange = 290.0;
    }

    public final double getValue() {
        return this.value.get();
    }

    public final void setValue(double VALUE) {
        this.oldValue = this.value.get();
        this.value.set(this.clamp(this.getMinValue(), this.getMaxValue(), VALUE));
        if (Math.abs(this.value.get() - this.target.get()) < 0.5) {
            this.setInfoText("");
        }
    }

    public final DoubleProperty valueProperty() {
        return this.value;
    }

    public final double getOldValue() {
        return this.oldValue;
    }

    public final double getMinValue() {
        return this.minValue.get();
    }

    public final void setMinValue(double MIN_VALUE) {
        this.minValue.set(this.clamp(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, MIN_VALUE));
        this.validate();
    }

    public final DoubleProperty minValueProperty() {
        return this.minValue;
    }

    public final double getMaxValue() {
        return this.maxValue.get();
    }

    public final void setMaxValue(double MAX_VALUE) {
        this.maxValue.set(this.clamp(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, MAX_VALUE));
        this.validate();
    }

    public final DoubleProperty maxValueProperty() {
        return this.maxValue;
    }

    public final double getTarget() {
        return this.target.get();
    }

    public final void setTarget(double TARGET) {
        this.target.set(this.clamp(this.getMinValue(), this.getMaxValue(), TARGET));
    }

    public final DoubleProperty thresholdProperty() {
        return this.target;
    }

    public final double getMinMeasuredValue() {
        return null == this.minMeasuredValue ? this._minMeasuredValue : this.minMeasuredValue.get();
    }

    public final void setMinMeasuredValue(double MIN_MEASURED_VALUE) {
        if (null == this.minMeasuredValue) {
            this._minMeasuredValue = MIN_MEASURED_VALUE;
        } else {
            this.minMeasuredValue.set(MIN_MEASURED_VALUE);
        }
    }

    public final ReadOnlyDoubleProperty minMeasuredValueProperty() {
        if (null == this.minMeasuredValue) {
            this.minMeasuredValue = new SimpleDoubleProperty((Object)this, "minMeasuredValue", this._minMeasuredValue);
        }
        return this.minMeasuredValue;
    }

    public final double getMaxMeasuredValue() {
        return null == this.maxMeasuredValue ? this._maxMeasuredValue : this.maxMeasuredValue.get();
    }

    public final void setMaxMeasuredValue(double MAX_MEASURED_VALUE) {
        if (null == this.maxMeasuredValue) {
            this._maxMeasuredValue = MAX_MEASURED_VALUE;
        } else {
            this.maxMeasuredValue.set(MAX_MEASURED_VALUE);
        }
    }

    public final ReadOnlyDoubleProperty maxMeasuredValueProperty() {
        if (null == this.maxMeasuredValue) {
            this.maxMeasuredValue = new SimpleDoubleProperty((Object)this, "maxMeasuredValue", this._maxMeasuredValue);
        }
        return this.maxMeasuredValue;
    }

    public void resetMinMeasuredValue() {
        this.setMinMeasuredValue(this.getValue());
    }

    public void resetMaxMeasuredValue() {
        this.setMaxMeasuredValue(this.getValue());
    }

    public void resetMinAndMaxMeasuredValue() {
        this.setMinMeasuredValue(this.getValue());
        this.setMaxMeasuredValue(this.getValue());
    }

    public final int getDecimals() {
        return null == this.decimals ? this._decimals : this.decimals.get();
    }

    public final void setDecimals(int DECIMALS) {
        if (null == this.decimals) {
            this._decimals = this.clamp(0, 3, DECIMALS);
        } else {
            this.decimals.set(this.clamp(0, 3, DECIMALS));
        }
    }

    public final IntegerProperty decimalsProperty() {
        if (null == this.decimals) {
            this.decimals = new SimpleIntegerProperty((Object)this, "decimals", this._decimals);
        }
        return this.decimals;
    }

    public final String getInfoText() {
        return null == this.infoText ? this._infoText : (String)this.infoText.get();
    }

    public final void setInfoText(String INFO_TEXT) {
        if (null == this.infoText) {
            this._infoText = INFO_TEXT;
        } else {
            this.infoText.set((Object)INFO_TEXT);
        }
    }

    public final StringProperty infoTextProperty() {
        if (null == this.infoText) {
            this.infoText = new SimpleStringProperty((Object)this, "infoText", this._infoText);
        }
        return this.infoText;
    }

    public final boolean isTargetEnabled() {
        return this.targetEnabled.get();
    }

    public final void setTargetEnabled(boolean TARGET_ENABLED) {
        this.targetEnabled.set(TARGET_ENABLED);
    }

    public final BooleanProperty targetEnabledProperty() {
        return this.targetEnabled;
    }

    public double getStartAngle() {
        return null == this.startAngle ? this._startAngle : this.startAngle.get();
    }

    public final void setStartAngle(double START_ANGLE) {
        if (null == this.startAngle) {
            this._startAngle = this.clamp(0.0, 360.0, START_ANGLE);
        } else {
            this.startAngle.set(this.clamp(0.0, 360.0, START_ANGLE));
        }
    }

    public final DoubleProperty startAngleProperty() {
        if (null == this.startAngle) {
            this.startAngle = new SimpleDoubleProperty((Object)this, "startAngle", this._startAngle);
        }
        return this.startAngle;
    }

    public final double getAngleRange() {
        return null == this.angleRange ? this._angleRange : this.angleRange.get();
    }

    public final void setAngleRange(double ANGLE_RANGE) {
        if (null == this.angleRange) {
            this._angleRange = this.clamp(0.0, 360.0, ANGLE_RANGE);
        } else {
            this.angleRange.set(this.clamp(0.0, 360.0, ANGLE_RANGE));
        }
    }

    public final DoubleProperty angleRangeProperty() {
        if (null == this.angleRange) {
            this.angleRange = new SimpleDoubleProperty((Object)this, "angleRange", this._angleRange);
        }
        return this.angleRange;
    }

    private double clamp(double MIN_VALUE, double MAX_VALUE, double VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    private int clamp(int MIN_VALUE, int MAX_VALUE, int VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    private Duration clamp(Duration MIN_VALUE, Duration MAX_VALUE, Duration VALUE) {
        if (VALUE.lessThan(MIN_VALUE)) {
            return MIN_VALUE;
        }
        if (VALUE.greaterThan(MAX_VALUE)) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    private void validate() {
        if (this.getTarget() < this.getMinValue()) {
            this.setTarget(this.getMinValue());
        }
        if (this.getTarget() > this.getMaxValue()) {
            this.setTarget(this.getMaxValue());
        }
        if (this.getValue() < this.getMinValue()) {
            this.setValue(this.getMinValue());
        }
        if (this.getValue() > this.getMaxValue()) {
            this.setValue(this.getMaxValue());
        }
    }

    public final Paint getTickMarkFill() {
        return null == this.tickMarkFill ? Color.BLACK : (Paint)this.tickMarkFill.get();
    }

    public final void setTickMarkFill(Paint value) {
        this.tickMarkFillProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> tickMarkFillProperty() {
        if (null == this.tickMarkFill) {
            this.tickMarkFill = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.TICK_MARK_FILL;
                }

                public Object getBean() {
                    return HeatControl.this;
                }

                public String getName() {
                    return "tickMarkFill";
                }
            };
        }
        return this.tickMarkFill;
    }

    protected Skin createDefaultSkin() {
        return new HeatControlSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("heatcontrol.css").toExternalForm();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return HeatControl.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<HeatControl, Paint> TICK_MARK_FILL = new CssMetaData<HeatControl, Paint>("-tick-mark-fill", StyleConverter.getPaintConverter(), (Paint)Color.WHITE){

            public boolean isSettable(HeatControl heatControl) {
                return null == heatControl.tickMarkFill || !heatControl.tickMarkFill.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(HeatControl heatControl) {
                return (StyleableProperty)heatControl.tickMarkFillProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, TICK_MARK_FILL);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

