/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.signaltower.skin;

import eu.hansolo.enzo.common.Util;
import eu.hansolo.enzo.signaltower.SignalTower;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;

public class SignalTowerSkin
extends SkinBase<SignalTower>
implements Skin<SignalTower> {
    private static final double MINIMUM_WIDTH = 5.0;
    private static final double MINIMUM_HEIGHT = 5.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double PREFERRED_WIDTH = 150.0;
    private static final double PREFERRED_HEIGHT = 591.0;
    private double aspectRatio = 3.94;
    private double size;
    private double width;
    private double height;
    private Pane pane;
    private Region green;
    private Region yellow;
    private Region red;
    private Region rack;
    private Region body;
    private Region roof;
    private DropShadow bodyDropShadow;
    private InnerShadow bodyInnerShadow;

    public SignalTowerSkin(SignalTower CONTROL) {
        super((Control)CONTROL);
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((SignalTower)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((SignalTower)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((SignalTower)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((SignalTower)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((SignalTower)this.getSkinnable()).getPrefWidth() > 0.0 && ((SignalTower)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((SignalTower)this.getSkinnable()).setPrefSize(((SignalTower)this.getSkinnable()).getPrefWidth(), ((SignalTower)this.getSkinnable()).getPrefHeight());
            } else {
                ((SignalTower)this.getSkinnable()).setPrefSize(150.0, 591.0);
            }
        }
        if (Double.compare(((SignalTower)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((SignalTower)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((SignalTower)this.getSkinnable()).setMinSize(5.0, 5.0);
        }
        if (Double.compare(((SignalTower)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((SignalTower)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((SignalTower)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.green = new Region();
        this.green.getStyleClass().setAll((Object[])new String[]{"green"});
        this.yellow = new Region();
        this.yellow.getStyleClass().setAll((Object[])new String[]{"yellow"});
        this.red = new Region();
        this.red.getStyleClass().setAll((Object[])new String[]{"red"});
        this.rack = new Region();
        this.rack.getStyleClass().setAll((Object[])new String[]{"rack"});
        this.bodyDropShadow = new DropShadow(BlurType.TWO_PASS_BOX, Color.web((String)"0x000000a6"), 1.999999995, 1.0, 0.0, 2.0);
        this.bodyInnerShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.web((String)"0x000000a6"), 1.999999995, 1.0, 1.4142135623730951, 1.4142135623730951);
        this.bodyInnerShadow.setInput((Effect)this.bodyDropShadow);
        this.body = new Region();
        this.body.getStyleClass().setAll((Object[])new String[]{"body"});
        this.body.setEffect((Effect)this.bodyInnerShadow);
        this.roof = new Region();
        this.roof.getStyleClass().setAll((Object[])new String[]{"roof"});
        this.pane = new Pane();
        this.pane.getChildren().setAll((Object[])new Node[]{this.green, this.yellow, this.red, this.rack, this.body, this.roof});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
        this.resize();
    }

    private void registerListeners() {
        ((SignalTower)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SignalTower)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        }
    }

    private void resize() {
        this.size = ((SignalTower)this.getSkinnable()).getWidth() < ((SignalTower)this.getSkinnable()).getHeight() ? ((SignalTower)this.getSkinnable()).getWidth() : ((SignalTower)this.getSkinnable()).getHeight();
        this.width = ((SignalTower)this.getSkinnable()).getWidth();
        this.height = ((SignalTower)this.getSkinnable()).getHeight();
        if (((SignalTower)this.getSkinnable()).isKeepAspect()) {
            if (this.aspectRatio * this.width > this.height) {
                this.width = 1.0 / (this.aspectRatio / this.height);
            } else if (1.0 / (this.aspectRatio / this.height) > this.width) {
                this.height = this.aspectRatio * this.width;
            }
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.green.setPrefSize(0.5333333333333333 * this.width, 0.11844331641285956 * this.height);
            this.green.setTranslateX(0.26 * this.width);
            this.green.setTranslateY(0.350253807106599 * this.height);
            this.yellow.setPrefSize(0.5333333333333333 * this.width, 0.11844331641285956 * this.height);
            this.yellow.setTranslateX(0.26 * this.width);
            this.yellow.setTranslateY(0.22504230118443316 * this.height);
            this.red.setPrefSize(0.5333333333333333 * this.width, 0.11844331641285956 * this.height);
            this.red.setTranslateX(0.26 * this.width);
            this.red.setTranslateY(0.09475465313028765 * this.height);
            this.rack.setPrefSize(0.02666666666666667 * this.width, 0.3824027072758037 * this.height);
            this.rack.setTranslateX(0.4266666666666667 * this.width);
            this.rack.setTranslateY(0.09475465313028765 * this.height);
            this.bodyDropShadow.setRadius(Util.clamp(1.0, 3.0, 0.0133333333 * this.size));
            this.bodyInnerShadow.setRadius(Util.clamp(1.0, 3.0, 0.0133333333 * this.size));
            this.body.setPrefSize(0.6133333333333333 * this.width, 0.9111675126903553 * this.height);
            this.body.setTranslateX(0.22 * this.width);
            this.body.setTranslateY(0.03976311336717428 * this.height);
            this.roof.setPrefSize(0.6133333333333333 * this.width, 0.018612521150592216 * this.height);
            this.roof.setTranslateX(0.22 * this.width);
            this.roof.setTranslateY(0.028764805414551606 * this.height);
        }
    }
}

