/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;

public final class HashtableOfModule {
    public char[][] keyTable;
    public ModuleBinding[] valueTable;
    public int elementSize = 0;
    int threshold;

    public HashtableOfModule() {
        this(3);
    }

    public HashtableOfModule(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.keyTable = new char[n2][];
        this.valueTable = new ModuleBinding[n2];
    }

    public boolean containsKey(char[] cArray) {
        char[] cArray2;
        int n = this.keyTable.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        int n3 = cArray.length;
        while ((cArray2 = this.keyTable[n2]) != null) {
            if (cArray2.length == n3 && CharOperation.equals(cArray2, cArray)) {
                return true;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return false;
    }

    public ModuleBinding get(char[] cArray) {
        char[] cArray2;
        int n = this.keyTable.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        int n3 = cArray.length;
        while ((cArray2 = this.keyTable[n2]) != null) {
            if (cArray2.length == n3 && CharOperation.equals(cArray2, cArray)) {
                return this.valueTable[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    public ModuleBinding put(char[] cArray, ModuleBinding moduleBinding) {
        char[] cArray2;
        int n = this.keyTable.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        int n3 = cArray.length;
        while ((cArray2 = this.keyTable[n2]) != null) {
            if (cArray2.length == n3 && CharOperation.equals(cArray2, cArray)) {
                this.valueTable[n2] = moduleBinding;
                return this.valueTable[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.keyTable[n2] = cArray;
        this.valueTable[n2] = moduleBinding;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return moduleBinding;
    }

    private void rehash() {
        HashtableOfModule hashtableOfModule = new HashtableOfModule(this.elementSize * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            char[] cArray = this.keyTable[n];
            if (cArray == null) continue;
            hashtableOfModule.put(cArray, this.valueTable[n]);
        }
        this.keyTable = hashtableOfModule.keyTable;
        this.valueTable = hashtableOfModule.valueTable;
        this.threshold = hashtableOfModule.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String string = "";
        for (ModuleBinding moduleBinding : this.valueTable) {
            if (moduleBinding == null) continue;
            string = string + moduleBinding.toString() + "\n";
        }
        return string;
    }
}

