/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.engines.java;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.BSF_Log;
import org.apache.bsf.BSF_LogFactory;
import org.apache.bsf.util.BSFEngineImpl;
import org.apache.bsf.util.CodeBuffer;
import org.apache.bsf.util.EngineUtils;
import org.apache.bsf.util.JavaUtils;
import org.apache.bsf.util.MethodUtils;
import org.apache.bsf.util.ObjInfo;

public class JavaEngine
extends BSFEngineImpl {
    Class javaclass = null;
    static Hashtable codeToClass = new Hashtable();
    static String serializeCompilation = "";
    static String placeholder = "$$CLASSNAME$$";
    String minorPrefix;
    private BSF_Log logger = BSF_LogFactory.getLog(this.getClass().getName());
    private int uniqueFileOffset = -1;

    @Override
    public Object call(Object object, String string, Object[] objectArray) throws BSFException {
        throw new BSFException(499, "call() is not currently supported by JavaEngine");
    }

    @Override
    public void compileScript(String string, int n, int n2, Object object, CodeBuffer codeBuffer) throws BSFException {
        ObjInfo objInfo = codeBuffer.getFinalServiceMethodStatement();
        if (objInfo != null && objInfo.isExecutable()) {
            codeBuffer.addServiceMethodStatement(objInfo.objName + ";");
        }
        codeBuffer.addServiceMethodStatement(object.toString());
        codeBuffer.setFinalServiceMethodStatement(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(String string, int n, int n2, Object object) throws BSFException {
        Object object2;
        block17: {
            String[] stringArray;
            Object object3;
            String string2;
            object2 = null;
            String string3 = null;
            GeneratedFile generatedFile = null;
            String string4 = string2 = object.toString();
            try {
                this.javaclass = (Class)codeToClass.get(string2);
                if (this.javaclass != null) {
                    string3 = this.javaclass.getName();
                } else {
                    CharSequence charSequence;
                    generatedFile = this.openUniqueFile(this.tempDir, "BSFJava", ".java");
                    if (generatedFile == null) {
                        throw new BSFException("couldn't create JavaEngine scratchfile");
                    }
                    string3 = generatedFile.className;
                    generatedFile.fos.write(("import java.lang.*;import java.util.*;public class " + string3 + " {\n" + "  static public Object BSFJavaEngineEntry(org.apache.bsf.BSFManager bsf) {\n").getBytes());
                    int n3 = string4.indexOf(placeholder);
                    if (n3 >= 0) {
                        charSequence = new StringBuffer();
                        while (n3 >= 0) {
                            ((StringBuffer)charSequence).setLength(0);
                            if (n3 > 0) {
                                ((StringBuffer)charSequence).append(string4.substring(0, n3));
                            }
                            ((StringBuffer)charSequence).append(string3);
                            int n4 = n3 + placeholder.length();
                            if (n4 < string4.length()) {
                                ((StringBuffer)charSequence).append(string4.substring(n4));
                            }
                            string4 = ((StringBuffer)charSequence).toString();
                            n3 = string4.indexOf(placeholder, n3);
                        }
                    }
                    generatedFile.fos.write(string4.getBytes());
                    generatedFile.fos.write("\n  }\n}\n".getBytes());
                    generatedFile.fos.close();
                    charSequence = serializeCompilation;
                    synchronized (charSequence) {
                        JavaUtils.JDKcompile(generatedFile.file.getPath(), this.classPath);
                    }
                    this.javaclass = EngineUtils.loadClass(this.mgr, string3);
                    codeToClass.put(string2, this.javaclass);
                }
                object3 = new Object[]{this.mgr};
                object2 = this.internalCall(this, "BSFJavaEngineEntry", (Object[])object3);
                if (string3 == null) break block17;
                object3 = new File(this.tempDir + File.separatorChar + string3 + ".class");
                object3 = new File(this.tempDir);
                this.minorPrefix = string3 + "$";
                stringArray = ((File)object3).list(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return 0 == string.indexOf(JavaEngine.this.minorPrefix) && string.lastIndexOf(".class") == string.length() - 6;
                    }
                });
            }
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                    throw new BSFException(10, exception.getMessage());
                }
                catch (Throwable throwable) {
                    if (string3 != null) {
                        File file = new File(this.tempDir + File.separatorChar + string3 + ".class");
                        file = new File(this.tempDir);
                        this.minorPrefix = string3 + "$";
                        String[] stringArray2 = file.list(new /* invalid duplicate definition of identical inner class */);
                        for (int i = 0; i < stringArray2.length; ++i) {
                            file = new File(stringArray2[i]);
                        }
                    }
                    throw throwable;
                }
            }
            for (int i = 0; i < stringArray.length; ++i) {
                object3 = new File(stringArray[i]);
            }
        }
        return object2;
    }

    @Override
    public void initialize(BSFManager bSFManager, String string, Vector vector) throws BSFException {
        super.initialize(bSFManager, string, vector);
    }

    Object internalCall(Object object, String string, Object[] objectArray) throws BSFException {
        Object object2 = null;
        try {
            if (this.javaclass != null) {
                Class[] classArray = new Class[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    classArray[i] = objectArray[i].getClass();
                }
                Method method = MethodUtils.getMethod(this.javaclass, string, classArray);
                object2 = method.invoke(null, objectArray);
            }
        }
        catch (Exception exception) {
            throw new BSFException(10, exception.getMessage());
        }
        return object2;
    }

    private GeneratedFile openUniqueFile(String string, String string2, String string3) {
        File file = null;
        FileOutputStream fileOutputStream = null;
        int n = 1000;
        GeneratedFile generatedFile = null;
        String string4 = null;
        int n2 = n;
        ++this.uniqueFileOffset;
        while (fileOutputStream == null && n2 > 0) {
            block6: {
                try {
                    string4 = string2 + this.uniqueFileOffset;
                    file = new File(string + File.separatorChar + string4 + string3);
                    if (file != null && !file.exists()) {
                        fileOutputStream = new FileOutputStream(file);
                    }
                }
                catch (Exception exception) {
                    if (file.exists()) break block6;
                    this.logger.error("openUniqueFile: unexpected ", exception);
                }
            }
            --n2;
            ++this.uniqueFileOffset;
        }
        if (fileOutputStream == null) {
            this.logger.error("openUniqueFile: Failed " + n + "attempts.");
        } else {
            generatedFile = new GeneratedFile(file, fileOutputStream, string4);
        }
        return generatedFile;
    }

    private class GeneratedFile {
        File file = null;
        FileOutputStream fos = null;
        String className = null;

        GeneratedFile(File file, FileOutputStream fileOutputStream, String string) {
            this.file = file;
            this.fos = fileOutputStream;
            this.className = string;
        }
    }
}

