/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.BSFClassLoader;
import org.apache.bsf.util.BSFEventProcessor;
import org.apache.bsf.util.BSFEventProcessorReturningEventInfos;
import org.apache.bsf.util.Bean;
import org.apache.bsf.util.MethodUtils;
import org.apache.bsf.util.ReflectionUtils;

public class EngineUtils {
    static BSFClassLoader bsfCL;
    static ClassLoader bsfManagerDefinedCL;
    static boolean bMethodHasSetAccessible;

    public static void addEventListener(Object object, String string, String string2, BSFEngine bSFEngine, BSFManager bSFManager, String string3, int n, int n2, Object object2) throws BSFException {
        BSFEventProcessor bSFEventProcessor = new BSFEventProcessor(bSFEngine, bSFManager, string2, string3, n, n2, object2);
        try {
            ReflectionUtils.addEventListener(object, string, bSFEventProcessor);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BSFException(500, "[EngineUtils.addEventListener()] ouch while adding event listener: " + exception, exception);
        }
    }

    public static void addEventListenerReturningEventInfos(Object object, String string, String string2, BSFEngine bSFEngine, BSFManager bSFManager, String string3, int n, int n2, Object object2, Object object3) throws BSFException {
        BSFEventProcessorReturningEventInfos bSFEventProcessorReturningEventInfos = new BSFEventProcessorReturningEventInfos(bSFEngine, bSFManager, string2, string3, n, n2, object2, object3);
        try {
            ReflectionUtils.addEventListener(object, string, bSFEventProcessorReturningEventInfos);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BSFException(500, "[EngineUtils.addEventListenerReturningEventInfos()] ouch while adding event listener: " + exception, exception);
        }
    }

    public static Object callBeanMethod(Object object, String string, Object[] objectArray) throws BSFException {
        boolean bl;
        Class[] classArray = null;
        if (objectArray != null) {
            classArray = new Class[objectArray.length];
            for (bl = false; bl < objectArray.length; bl += 1) {
                classArray[bl] = objectArray[bl] == null ? null : objectArray[bl].getClass();
            }
        }
        bl = false;
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        try {
            Method method;
            try {
                method = MethodUtils.getMethod(clazz, string, classArray, bl);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (objectArray[i] instanceof Number) {
                            if (objectArray[i] instanceof Byte) {
                                classArray[i] = Byte.TYPE;
                                continue;
                            }
                            if (objectArray[i] instanceof Integer) {
                                classArray[i] = Integer.TYPE;
                                continue;
                            }
                            if (objectArray[i] instanceof Long) {
                                classArray[i] = Long.TYPE;
                                continue;
                            }
                            if (objectArray[i] instanceof Float) {
                                classArray[i] = Float.TYPE;
                                continue;
                            }
                            if (objectArray[i] instanceof Double) {
                                classArray[i] = Double.TYPE;
                                continue;
                            }
                            if (!(objectArray[i] instanceof Short)) continue;
                            classArray[i] = Short.TYPE;
                            continue;
                        }
                        if (objectArray[i] instanceof Boolean) {
                            classArray[i] = Boolean.TYPE;
                            continue;
                        }
                        if (!(objectArray[i] instanceof Character)) continue;
                        classArray[i] = Character.TYPE;
                    }
                    method = MethodUtils.getMethod(clazz, string, classArray, bl);
                }
                catch (Exception exception) {
                    throw noSuchMethodException;
                }
            }
            try {
                return method.invoke(object, objectArray);
            }
            catch (Exception exception) {
                if (exception instanceof IllegalAccessException && bMethodHasSetAccessible && Modifier.isPublic(method.getModifiers())) {
                    method.setAccessible(true);
                    return method.invoke(object, objectArray);
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            Throwable throwable = exception instanceof InvocationTargetException ? ((InvocationTargetException)exception).getTargetException() : null;
            throw new BSFException(500, "[EngineUtils.callBeanMethod()] method invocation failed: " + exception + (throwable == null ? "" : " target exception: " + throwable), throwable);
        }
    }

    public static Object createBean(String string, Object[] objectArray) throws BSFException {
        Class[] classArray = null;
        if (objectArray != null) {
            classArray = new Class[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                classArray[i] = objectArray[i] != null ? objectArray[i].getClass() : null;
            }
        }
        try {
            try {
                Bean bean = ReflectionUtils.createBean(null, string, classArray, objectArray);
                return bean.value;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (objectArray[i] instanceof Number) {
                            classArray[i] = Byte.TYPE;
                            continue;
                        }
                        if (objectArray[i] instanceof Boolean) {
                            classArray[i] = Boolean.TYPE;
                            continue;
                        }
                        if (!(objectArray[i] instanceof Character)) continue;
                        classArray[i] = Character.TYPE;
                    }
                    Bean bean = ReflectionUtils.createBean(null, string, classArray, objectArray);
                    return bean.value;
                }
                catch (Exception exception) {
                    throw noSuchMethodException;
                }
            }
        }
        catch (Exception exception) {
            throw new BSFException(500, "[EngineUtils.createBean()]" + exception.getMessage(), exception);
        }
    }

    public static String getTypeSignatureString(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            return "V";
        }
        StringBuffer stringBuffer = new StringBuffer("L");
        stringBuffer.append(clazz.getName());
        stringBuffer.append(";");
        return stringBuffer.toString().replace('.', '/');
    }

    public static Class loadClass(BSFManager bSFManager, String string) throws BSFException {
        ClassLoader classLoader = null;
        try {
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            if (classLoader2 != null) {
                try {
                    return Thread.currentThread().getContextClassLoader().loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            try {
                classLoader = bSFManager.getClassLoader();
                if (classLoader != null) {
                    return classLoader.loadClass(string);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (classLoader != bsfManagerDefinedCL) {
                return bsfManagerDefinedCL.loadClass(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                if (bsfCL == null) {
                    bsfCL = new BSFClassLoader();
                }
                bsfCL.setTempDir(bSFManager.getTempDir());
                return bsfCL.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new BSFException(500, "[EngineUtils.loadClass()] unable to load class '" + string + "':" + classNotFoundException, classNotFoundException);
            }
        }
        throw new BSFException(500, "[EngineUtils.loadClass()] unable to load class '" + string + "'");
    }

    static {
        bsfManagerDefinedCL = BSFManager.getDefinedClassLoader();
        bMethodHasSetAccessible = false;
        Class<Method> clazz = Method.class;
        Class[] classArray = new Class[]{Boolean.TYPE};
        try {
            clazz.getMethod("setAccessible", classArray);
            bMethodHasSetAccessible = true;
        }
        catch (Exception exception) {
            bMethodHasSetAccessible = false;
        }
    }
}

