/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.env;

import java.util.function.Predicate;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.util.SimpleSetOfCharArray;

public interface IModuleAwareNameEnvironment
extends INameEnvironment {
    @Override
    default public NameEnvironmentAnswer findType(char[][] cArray) {
        return this.findType(cArray, ModuleBinding.ANY);
    }

    @Override
    default public NameEnvironmentAnswer findType(char[] cArray, char[][] cArray2) {
        return this.findType(cArray, cArray2, ModuleBinding.ANY);
    }

    @Override
    default public boolean isPackage(char[][] cArray, char[] cArray2) {
        return this.getModulesDeclaringPackage(CharOperation.arrayConcat(cArray, cArray2), ModuleBinding.ANY) != null;
    }

    public NameEnvironmentAnswer findType(char[][] var1, char[] var2);

    public NameEnvironmentAnswer findType(char[] var1, char[][] var2, char[] var3);

    public char[][] getModulesDeclaringPackage(char[][] var1, char[] var2);

    default public char[][] getUniqueModulesDeclaringPackage(char[][] cArray, char[] cArray2) {
        Object object = this.getModulesDeclaringPackage(cArray, cArray2);
        if (object != null && ((char[][])object).length > 1) {
            SimpleSetOfCharArray simpleSetOfCharArray = new SimpleSetOfCharArray(((char[][])object).length);
            for (char[] cArray3 : object) {
                simpleSetOfCharArray.add(cArray3);
            }
            object = new char[simpleSetOfCharArray.elementSize][];
            simpleSetOfCharArray.asArray((Object[])object);
        }
        return object;
    }

    public boolean hasCompilationUnit(char[][] var1, char[] var2, boolean var3);

    public IModule getModule(char[] var1);

    public char[][] getAllAutomaticModules();

    default public void applyModuleUpdates(IUpdatableModule iUpdatableModule, IUpdatableModule.UpdateKind updateKind) {
    }

    public char[][] listPackages(char[] var1);

    public static enum LookupStrategy {
        Named{

            @Override
            public <T> boolean matchesWithName(T t, Predicate<T> predicate, Predicate<T> predicate2) {
                assert (predicate2 != null) : "name match needs a nameMatcher";
                return predicate.test(t) && predicate2.test(t);
            }
        }
        ,
        AnyNamed{

            @Override
            public <T> boolean matchesWithName(T t, Predicate<T> predicate, Predicate<T> predicate2) {
                return predicate.test(t);
            }
        }
        ,
        Any{

            @Override
            public <T> boolean matchesWithName(T t, Predicate<T> predicate, Predicate<T> predicate2) {
                return true;
            }
        }
        ,
        Unnamed{

            @Override
            public <T> boolean matchesWithName(T t, Predicate<T> predicate, Predicate<T> predicate2) {
                return !predicate.test(t);
            }
        };


        public abstract <T> boolean matchesWithName(T var1, Predicate<T> var2, Predicate<T> var3);

        public <T> boolean matches(T t, Predicate<T> predicate) {
            return this.matchesWithName(t, predicate, object -> true);
        }

        public static LookupStrategy get(char[] cArray) {
            if (cArray == ModuleBinding.ANY) {
                return Any;
            }
            if (cArray == ModuleBinding.ANY_NAMED) {
                return AnyNamed;
            }
            if (cArray == ModuleBinding.UNNAMED) {
                return Unnamed;
            }
            return Named;
        }

        public static String getStringName(char[] cArray) {
            switch (LookupStrategy.get(cArray).ordinal()) {
                case 0: {
                    return String.valueOf(cArray);
                }
            }
            return null;
        }
    }
}

