/*
 * Decompiled with CFR 0.152.
 */
package org.netrexx.njpipes.stages;

import java.net.InetAddress;
import java.net.UnknownHostException;
import netrexx.lang.Rexx;
import netrexx.lang.RexxIO;
import org.netrexx.njpipes.pipes.StageError;
import org.netrexx.njpipes.pipes.ThreadQ;
import org.netrexx.njpipes.pipes.stage;

public class hostid
extends stage {
    private static final String $0 = "hostid.nrx";

    @Override
    public void run() throws ThreadQ {
        Rexx rexx = null;
        int n = 0;
        if (!this.isFirstStage()) {
            RexxIO.Say("PIPE Error: " + this.getName() + " stage must be the first stage of a pipeline.");
            n = 83;
            this.exit(n);
        }
        try {
            try {
                while (true) {
                    rexx = Rexx.toRexx(InetAddress.getLocalHost().getHostAddress());
                    this.output(rexx);
                    this.exit(this.rc());
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.output("# Unable to determine hostid (IP address) #");
                this.exit(this.rc());
            }
        }
        catch (StageError stageError) {
            n = this.rc();
        }
        this.exit(n * (n != 12 ? 1 : 0));
    }

    public static Rexx givehelp() {
        return Rexx.toRexx("  /**  hostid - Write default IP address of the system\n    *\n    *  hostid writes a single output record which contains the IP address of the system.\n    *\n    *  Note:  hostid is not the same as hostid on common Unix platforms.\n    *         hostid must be in the first stage of a pipe.  It does not consume any records.\n    *\n    *\n    *  >>--HOSTID ---------------><\n    *\n    *\n    *  (1) The USERid option available under CMS is not applicable and not implemented\n    *\n    *  Arguments:  <none>\n    *\n    *  Examples:\n    *\n    *  Z:\\>pipe \"hostid | console\"\n    *  10.0.2.15\n    *\n    *  Z:\\>pipe \"literal abc | hostid | console\"\n    *  PIPE Error: hostid_2 stage must be the first stage of a pipeline.\n    *  RC=83\n    *\n    */\n");
    }
}

