/*
 * Decompiled with CFR 0.152.
 */
package org.netrexx.process;

import netrexx.lang.Rexx;
import org.netrexx.process.RxClauseParser;
import org.netrexx.process.RxCode;
import org.netrexx.process.RxConvert;
import org.netrexx.process.RxCursor;
import org.netrexx.process.RxError;
import org.netrexx.process.RxParser;
import org.netrexx.process.RxQuit;
import org.netrexx.process.RxToken;
import org.netrexx.process.RxTranslator;
import org.netrexx.process.RxType;

public class NrExit
implements RxClauseParser {
    private static final Rexx $01 = Rexx.toRexx(");return");
    private static final Rexx $02 = Rexx.toRexx(";}");
    private static final String $0 = "NrExit.nrx";
    private RxTranslator rxt;
    private RxParser parser;
    private RxCursor pcursor;
    private RxToken[] tokens;
    private Rexx exitjavacode = Rexx.toRexx("0");

    public NrExit(RxTranslator rxTranslator) {
        this.rxt = rxTranslator;
        this.parser = this.rxt.program.parser;
        this.pcursor = this.parser.cursor;
        this.tokens = this.pcursor.curclause.tokens;
    }

    @Override
    public void scan(int n) {
        int n2 = 0;
        RxCode rxCode = null;
        RxConvert rxConvert = null;
        if (n < 2) {
            throw new RxQuit(this.rxt, this.tokens[0], "internal.error", Rexx.toRexx("NrExit"), new Rexx(n));
        }
        if (this.rxt.jsr223Engine == null) {
            this.parser.thislevel.terminal = true;
        }
        if (this.tokens[1].type != ';') {
            n2 = this.tokens[1].type == 'B' ? 2 : 1;
            rxCode = this.rxt.eparser.parseexpr(this.pcursor, false, n2, null, null);
            rxConvert = this.rxt.converter.assigncost(this.pcursor, RxType.INT_TYPE, rxCode.type);
            if (rxConvert.cost > this.rxt.program.flag.maxassign) {
                new RxError(this.rxt, this.tokens[n2], "exit.needs.int.type", this.rxt.program.babel.typeString(rxCode.type));
            } else {
                this.rxt.converter.convertcode(this.pcursor, RxType.INT_TYPE, rxConvert.proc, rxCode);
                this.exitjavacode = rxCode.javacode;
            }
        }
    }

    @Override
    public String[] getAssigns() {
        return null;
    }

    @Override
    public void generate() {
        String string = null;
        string = this.pcursor.curmethod.methodconstructor ? "" : (this.pcursor.curmethod.methodrettype.equals(RxType.VOID_TYPE) ? "" : (this.pcursor.curmethod.methodrettype.equals(RxType.BOOL_TYPE) ? " false" : (this.pcursor.curmethod.methodrettype.isPrimitive() ? " 0" : " null")));
        this.rxt.program.streamer.out(Rexx.toRexx("{System.exit(").OpCc(null, this.exitjavacode).OpCc(null, $01).OpCc(null, Rexx.toRexx(string)).OpCc(null, $02));
    }

    public void interpret() {
        this.interpret(null);
    }

    @Override
    public void interpret(RxCursor rxCursor) {
        System.exit(this.exitjavacode.toint());
    }
}

