/*
 * Decompiled with CFR 0.152.
 */
package org.netrexx.process;

import netrexx.lang.Rexx;
import netrexx.lang.RexxIO;
import netrexx.lang.RexxParse;

public class RxFlag {
    private static final char[] $01 = new char[]{'\u0004', '\u0001', '\u0002', '\n', '\u0001', '\u0000', '\u0001', '\n', '\u0001', '\u0001', '\u0000'};
    private static final Rexx $02 = Rexx.toRexx("NO");
    private static final Rexx $03 = Rexx.toRexx("BINARY");
    private static final Rexx $04 = Rexx.toRexx("COMMENTS");
    private static final Rexx $05 = Rexx.toRexx("COMPACT");
    private static final Rexx $06 = Rexx.toRexx("CROSSREF");
    private static final Rexx $07 = Rexx.toRexx("DECIMAL");
    private static final Rexx $08 = Rexx.toRexx("DIAG");
    private static final Rexx $09 = Rexx.toRexx("EXPLICIT");
    private static final Rexx $010 = Rexx.toRexx("FORMAT");
    private static final Rexx $011 = Rexx.toRexx("MODEL");
    private static final Rexx $012 = Rexx.toRexx("MODEL0");
    private static final Rexx $013 = Rexx.toRexx("MODEL1");
    private static final Rexx $014 = Rexx.toRexx("MODEL2");
    private static final Rexx $015 = Rexx.toRexx("MODEL3");
    private static final Rexx $016 = Rexx.toRexx("JAVA");
    private static final Rexx $017 = Rexx.toRexx("LOGO");
    private static final Rexx $018 = Rexx.toRexx("REPLACE");
    private static final Rexx $019 = Rexx.toRexx("SOURCEDIR");
    private static final Rexx $020 = Rexx.toRexx("STRICTARGS");
    private static final Rexx $021 = Rexx.toRexx("STRICTCASE");
    private static final Rexx $022 = Rexx.toRexx("SYMBOLS");
    private static final Rexx $023 = Rexx.toRexx("TEST");
    private static final Rexx $024 = Rexx.toRexx("TRACE");
    private static final Rexx $025 = Rexx.toRexx("TRACE1");
    private static final Rexx $026 = Rexx.toRexx("TRACE2");
    private static final Rexx $027 = Rexx.toRexx("UTF8");
    private static final Rexx $028 = Rexx.toRexx("VERBOSE");
    private static final Rexx $029 = Rexx.toRexx("VERBOSE0");
    private static final Rexx $030 = Rexx.toRexx("VERBOSE1");
    private static final Rexx $031 = Rexx.toRexx("VERBOSE2");
    private static final Rexx $032 = Rexx.toRexx("VERBOSE3");
    private static final Rexx $033 = Rexx.toRexx("VERBOSE4");
    private static final Rexx $034 = Rexx.toRexx("VERBOSE5");
    private static final Rexx $035 = Rexx.toRexx("Binary");
    private static final Rexx $036 = Rexx.toRexx("NoBinary");
    private static final Rexx $037 = Rexx.toRexx("Comments");
    private static final Rexx $038 = Rexx.toRexx("NoComments");
    private static final Rexx $039 = Rexx.toRexx("Compact");
    private static final Rexx $040 = Rexx.toRexx("NoCompact");
    private static final Rexx $041 = Rexx.toRexx("Crossref");
    private static final Rexx $042 = Rexx.toRexx("NoCrossref");
    private static final Rexx $043 = Rexx.toRexx("Decimal");
    private static final Rexx $044 = Rexx.toRexx("NoDecimal");
    private static final Rexx $045 = Rexx.toRexx("Diag");
    private static final Rexx $046 = Rexx.toRexx("NoDiag");
    private static final Rexx $047 = Rexx.toRexx("Explicit");
    private static final Rexx $048 = Rexx.toRexx("NoExplicit");
    private static final Rexx $049 = Rexx.toRexx("Format");
    private static final Rexx $050 = Rexx.toRexx("NoFormat");
    private static final Rexx $051 = Rexx.toRexx("Model");
    private static final Rexx $052 = Rexx.toRexx("NoModel");
    private static final Rexx $053 = Rexx.toRexx("Java");
    private static final Rexx $054 = Rexx.toRexx("NoJava");
    private static final Rexx $055 = Rexx.toRexx("Logo");
    private static final Rexx $056 = Rexx.toRexx("NoLogo");
    private static final Rexx $057 = Rexx.toRexx("Replace");
    private static final Rexx $058 = Rexx.toRexx("NoReplace");
    private static final Rexx $059 = Rexx.toRexx("Sourcedir");
    private static final Rexx $060 = Rexx.toRexx("Strictargs");
    private static final Rexx $061 = Rexx.toRexx("Strictcase");
    private static final Rexx $062 = Rexx.toRexx("Symbols");
    private static final Rexx $063 = Rexx.toRexx("NoSymbols");
    private static final Rexx $064 = Rexx.toRexx("Test");
    private static final Rexx $065 = Rexx.toRexx("NoTest");
    private static final Rexx $066 = Rexx.toRexx("Trace");
    private static final Rexx $067 = Rexx.toRexx("NoTrace");
    private static final Rexx $068 = Rexx.toRexx("NoUTF8");
    private static final Rexx $069 = Rexx.toRexx("Verbose");
    private static final Rexx $070 = Rexx.toRexx("NoVerbose");
    private static final String $0 = "RxFlag.nrx";
    public boolean annotations = true;
    public boolean binary = false;
    public boolean bytes = false;
    public boolean comments = false;
    public boolean compact = false;
    public boolean crossref = false;
    public boolean decimal = true;
    public boolean diag = false;
    public boolean explicit = false;
    public boolean java = true;
    public boolean logo = true;
    public boolean format = false;
    public int model = 0;
    public boolean replace = false;
    public boolean sourcedir = false;
    public boolean strictargs = false;
    public boolean strictassign = false;
    public int maxassign = 25;
    public boolean strictcase = false;
    public boolean strictimport = false;
    public boolean strictmethods = false;
    public boolean strictprops = false;
    public boolean strictsignal = false;
    public boolean symbols = false;
    public boolean test = false;
    public int trace = 2;
    public boolean utf8 = false;
    public int verbose = 3;
    public boolean implicituses = true;

    public RxFlag() {
    }

    public RxFlag(RxFlag rxFlag) {
        this.annotations = rxFlag.annotations;
        this.binary = rxFlag.binary;
        this.bytes = rxFlag.bytes;
        this.comments = rxFlag.comments;
        this.compact = rxFlag.compact;
        this.crossref = rxFlag.crossref;
        this.decimal = rxFlag.decimal;
        this.diag = rxFlag.diag;
        this.explicit = rxFlag.explicit;
        this.format = rxFlag.format;
        this.model = rxFlag.model;
        this.java = rxFlag.java;
        this.logo = rxFlag.logo;
        this.replace = rxFlag.replace;
        this.sourcedir = rxFlag.sourcedir;
        this.strictargs = rxFlag.strictargs;
        this.strictassign = rxFlag.strictassign;
        this.strictcase = rxFlag.strictcase;
        this.strictimport = rxFlag.strictimport;
        this.strictmethods = rxFlag.strictmethods;
        this.strictprops = rxFlag.strictprops;
        this.strictsignal = rxFlag.strictsignal;
        this.symbols = rxFlag.symbols;
        this.test = rxFlag.test;
        this.trace = rxFlag.trace;
        this.utf8 = rxFlag.utf8;
        this.verbose = rxFlag.verbose;
        this.maxassign = rxFlag.maxassign;
        this.implicituses = rxFlag.implicituses;
    }

    public boolean setFlag(Rexx rexx) {
        Rexx rexx2 = null;
        Rexx rexx3 = null;
        int n = 0;
        Rexx rexx4 = rexx.upper();
        Rexx[] rexxArray = new Rexx[2];
        RexxParse.parse(rexx4, $01, rexxArray);
        rexx2 = rexxArray[0];
        rexx3 = rexxArray[1];
        if (rexx2.OpNotEqS(null, $02)) {
            n = 1;
        } else {
            n = 0;
            rexx4 = rexx3;
        }
        if (rexx4.OpEqS(null, Rexx.toRexx("ANNOTATIONS"))) {
            this.annotations = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, $03)) {
            this.binary = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, $04)) {
            this.comments = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, $05)) {
            this.compact = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, $06)) {
            this.crossref = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, $07)) {
            this.decimal = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, $08)) {
            this.diag = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, $09)) {
            this.explicit = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, $010)) {
            this.format = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, Rexx.toRexx("IMPLICITUSES"))) {
            this.implicituses = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, $011)) {
            this.model = n * 1;
        } else if (rexx4.OpEqS(null, $012)) {
            this.model = 0;
        } else if (rexx4.OpEqS(null, $013)) {
            this.model = n * 1;
        } else if (rexx4.OpEqS(null, $014)) {
            this.model = n * 2;
        } else if (rexx4.OpEqS(null, $015)) {
            this.model = n * 3;
        } else if (rexx4.OpEqS(null, $016)) {
            this.java = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, $017)) {
            this.logo = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, $018)) {
            this.replace = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, $019)) {
            this.sourcedir = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, $020)) {
            this.strictargs = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, Rexx.toRexx("STRICTASSIGN"))) {
            this.maxassign = (1 - n) * 25;
            this.strictassign = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, $021)) {
            this.strictcase = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, Rexx.toRexx("STRICTIMPORT"))) {
            this.strictimport = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, Rexx.toRexx("STRICTMETHODS"))) {
            this.strictmethods = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, Rexx.toRexx("STRICTPROPS"))) {
            this.strictprops = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, Rexx.toRexx("STRICTSIGNAL"))) {
            this.strictsignal = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, $022)) {
            this.symbols = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, $023)) {
            this.test = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, $024)) {
            this.trace = n * 2;
        } else if (rexx4.OpEqS(null, $025)) {
            this.trace = n * 1;
        } else if (rexx4.OpEqS(null, $026)) {
            this.trace = n * 2;
        } else if (rexx4.OpEqS(null, $027)) {
            this.utf8 = new Rexx(n).toboolean();
        } else if (rexx4.OpEqS(null, $028)) {
            this.verbose = n * 3;
        } else if (rexx4.OpEqS(null, $029)) {
            this.verbose = 0;
        } else if (rexx4.OpEqS(null, $030)) {
            this.verbose = n * 1;
        } else if (rexx4.OpEqS(null, $031)) {
            this.verbose = n * 2;
        } else if (rexx4.OpEqS(null, $032)) {
            this.verbose = n * 3;
        } else if (rexx4.OpEqS(null, $033)) {
            this.verbose = n * 4;
        } else if (rexx4.OpEqS(null, $034)) {
            this.verbose = n * 5;
        } else {
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        Rexx rexx = Rexx.toRexx("");
        if (this.annotations) {
            rexx = rexx.OpCcblank(null, Rexx.toRexx("Annotations"));
        } else if (bl) {
            rexx = rexx.OpCcblank(null, Rexx.toRexx("NoAnnotations"));
        }
        if (this.binary) {
            rexx = rexx.OpCcblank(null, $035);
        } else if (bl) {
            rexx = rexx.OpCcblank(null, $036);
        }
        if (this.comments) {
            rexx = rexx.OpCcblank(null, $037);
        } else if (bl) {
            rexx = rexx.OpCcblank(null, $038);
        }
        if (this.compact) {
            rexx = rexx.OpCcblank(null, $039);
        } else if (bl) {
            rexx = rexx.OpCcblank(null, $040);
        }
        if (this.crossref) {
            rexx = rexx.OpCcblank(null, $041);
        } else if (bl) {
            rexx = rexx.OpCcblank(null, $042);
        }
        if (this.decimal) {
            rexx = rexx.OpCcblank(null, $043);
        } else if (bl) {
            rexx = rexx.OpCcblank(null, $044);
        }
        if (this.diag) {
            rexx = rexx.OpCcblank(null, $045);
        } else if (bl) {
            rexx = rexx.OpCcblank(null, $046);
        }
        if (this.explicit) {
            rexx = rexx.OpCcblank(null, $047);
        } else if (bl) {
            rexx = rexx.OpCcblank(null, $048);
        }
        if (this.format) {
            rexx = rexx.OpCcblank(null, $049);
        } else if (bl) {
            rexx = rexx.OpCcblank(null, $050);
        }
        if (this.implicituses) {
            rexx = rexx.OpCcblank(null, Rexx.toRexx("Implicituses"));
        } else if (bl) {
            rexx = rexx.OpCcblank(null, Rexx.toRexx("NoImplicituses"));
        }
        if (this.model > 0) {
            rexx = rexx.OpCcblank(null, $051);
        } else if (bl) {
            rexx = rexx.OpCcblank(null, $052);
        }
        if (this.java) {
            rexx = rexx.OpCcblank(null, $053);
        } else if (bl) {
            rexx = rexx.OpCcblank(null, $054);
        }
        if (this.logo) {
            rexx = rexx.OpCcblank(null, $055);
        } else if (bl) {
            rexx = rexx.OpCcblank(null, $056);
        }
        if (this.replace) {
            rexx = rexx.OpCcblank(null, $057);
        } else if (bl) {
            rexx = rexx.OpCcblank(null, $058);
        }
        if (this.sourcedir) {
            rexx = rexx.OpCcblank(null, $059);
        } else if (bl) {
            rexx = rexx.OpCcblank(null, Rexx.toRexx("NoSourcedir"));
        }
        if (this.strictargs) {
            rexx = rexx.OpCcblank(null, $060);
        } else if (bl) {
            rexx = rexx.OpCcblank(null, Rexx.toRexx("NoStrictargs"));
        }
        if (this.strictassign) {
            rexx = rexx.OpCcblank(null, Rexx.toRexx("Strictassign"));
        } else if (bl) {
            rexx = rexx.OpCcblank(null, Rexx.toRexx("NoStrictassign"));
        }
        if (this.strictcase) {
            rexx = rexx.OpCcblank(null, $061);
        } else if (bl) {
            rexx = rexx.OpCcblank(null, Rexx.toRexx("NoStrictcase"));
        }
        if (this.strictimport) {
            rexx = rexx.OpCcblank(null, Rexx.toRexx("Strictimport"));
        } else if (bl) {
            rexx = rexx.OpCcblank(null, Rexx.toRexx("NoStrictimport"));
        }
        if (this.strictmethods) {
            rexx = rexx.OpCcblank(null, Rexx.toRexx("Strictmethods"));
        } else if (bl) {
            rexx = rexx.OpCcblank(null, Rexx.toRexx("NoStrictmethods"));
        }
        if (this.strictprops) {
            rexx = rexx.OpCcblank(null, Rexx.toRexx("Strictprops"));
        } else if (bl) {
            rexx = rexx.OpCcblank(null, Rexx.toRexx("NoStrictprops"));
        }
        if (this.strictsignal) {
            rexx = rexx.OpCcblank(null, Rexx.toRexx("Strictsignal"));
        } else if (bl) {
            rexx = rexx.OpCcblank(null, Rexx.toRexx("NoStrictsignal"));
        }
        if (this.symbols) {
            rexx = rexx.OpCcblank(null, $062);
        } else if (bl) {
            rexx = rexx.OpCcblank(null, $063);
        }
        if (this.test) {
            rexx = rexx.OpCcblank(null, $064);
        } else if (bl) {
            rexx = rexx.OpCcblank(null, $065);
        }
        if (this.trace > 0) {
            rexx = rexx.OpCcblank(null, $066).OpCc(null, new Rexx(this.trace));
        } else if (bl) {
            rexx = rexx.OpCcblank(null, $067);
        }
        if (this.utf8) {
            rexx = rexx.OpCcblank(null, $027);
        } else if (bl) {
            rexx = rexx.OpCcblank(null, $068);
        }
        if (this.verbose > 0) {
            rexx = rexx.OpCcblank(null, $069).OpCc(null, new Rexx(this.verbose));
        } else if (bl) {
            rexx = rexx.OpCcblank(null, $070);
        }
        return rexx.space().toString();
    }

    public String toConciseString() {
        return this.toString(false);
    }

    public static void usage() {
        RexxIO.Say("  -annotations   -- allow annotations to pass through");
        RexxIO.Say("  -binary        -- all classes are binary classes");
        RexxIO.Say("  -comments      -- copy comments across to generated .java");
        RexxIO.Say("  -compact       -- display error messages in compact form");
        RexxIO.Say("  -crossref      -- generate cross-reference listing");
        RexxIO.Say("  -decimal       -- allow implicit decimal arithmetic");
        RexxIO.Say("  -diag          -- show diagnostic messages");
        RexxIO.Say("  -explicit      -- local variables must be explicitly declared");
        RexxIO.Say("  -java          -- generate Java source code for this program");
        RexxIO.Say("  -logo          -- display logo (banner) after starting");
        RexxIO.Say("  -model[n]      -- model input file [0-3] none, stripped, compacted, braced");
        RexxIO.Say("  -format        -- format output file (pretty-print)");
        RexxIO.Say("  -implicituses  -- default uses RexxDate, RexxRexx, RexxStream");
        RexxIO.Say("  -replace       -- replace .java file even if it exists");
        RexxIO.Say("  -sourcedir     -- force output files to source directory");
        RexxIO.Say("  -strictargs    -- empty argument lists must be specified as ()");
        RexxIO.Say("  -strictassign  -- assignment must be cost-free");
        RexxIO.Say("  -strictcase    -- names must match in case");
        RexxIO.Say("  -strictimport  -- all imports must be explicit");
        RexxIO.Say("  -strictmethods -- superclass methods are not compared to local methods for best match");
        RexxIO.Say("  -strictprops   -- even local properties must be qualified");
        RexxIO.Say("  -strictsignal  -- signals list must be explicit");
        RexxIO.Say("  -symbols       -- include symbols table in generated .class files");
        RexxIO.Say("  -trace[n]      -- trace stream [1 or 2], or 0 for NOTRACE");
        RexxIO.Say("  -utf8          -- source file is in UTF8 encoding");
        RexxIO.Say("  -verbose[n]    -- verbosity of progress reports [0-5]");
    }
}

