/*
 * Decompiled with CFR 0.152.
 */
package japa.parser;

import japa.parser.ASTParser;
import japa.parser.ParseException;
import japa.parser.ast.CompilationUnit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class JavaParser {
    private static ASTParser parser;
    private static boolean cacheParser;

    private JavaParser() {
    }

    public static void setCacheParser(boolean value) {
        cacheParser = value;
        if (!value) {
            parser = null;
        }
    }

    public static CompilationUnit parse(InputStream in, String encoding) throws ParseException {
        if (cacheParser) {
            if (parser == null) {
                parser = new ASTParser(in, encoding);
            } else {
                parser.reset(in, encoding);
            }
            return parser.CompilationUnit();
        }
        return new ASTParser(in, encoding).CompilationUnit();
    }

    public static CompilationUnit parse(InputStream in) throws ParseException {
        return JavaParser.parse(in, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompilationUnit parse(File file, String encoding) throws ParseException, IOException {
        try (FileInputStream in = new FileInputStream(file);){
            CompilationUnit compilationUnit = JavaParser.parse(in, encoding);
            return compilationUnit;
        }
    }

    public static CompilationUnit parse(File file) throws ParseException, IOException {
        return JavaParser.parse(file, null);
    }

    static {
        cacheParser = true;
    }
}

