/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.canvasled;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;

public class Led
extends Region {
    private static final double PREFERRED_SIZE = 16.0;
    private static final double MINIMUM_SIZE = 8.0;
    private static final double MAXIMUM_SIZE = 1024.0;
    private static final int SHORTEST_INTERVAL = 50;
    private static final int LONGEST_INTERVAL = 5000;
    private ObjectProperty<Color> ledColor;
    private BooleanProperty on;
    private boolean _blinking = false;
    private BooleanProperty blinking;
    private boolean _frameVisible = true;
    private BooleanProperty frameVisible;
    private InnerShadow ledOnShadow;
    private InnerShadow ledOffShadow;
    private LinearGradient frameGradient;
    private LinearGradient ledOnGradient;
    private LinearGradient ledOffGradient;
    private RadialGradient highlightGradient;
    private int _interval = 500;
    private IntegerProperty interval;
    private volatile ScheduledFuture<?> periodicBlinkTask;
    private static ScheduledExecutorService periodicBlinkExecutorService;
    private Canvas canvas;
    private GraphicsContext ctx;

    public Led() {
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0 || Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0) {
            this.setPrefSize(16.0, 16.0);
        }
        if (Double.compare(this.getMinWidth(), 0.0) <= 0 || Double.compare(this.getMinHeight(), 0.0) <= 0) {
            this.setMinSize(8.0, 8.0);
        }
        if (Double.compare(this.getMaxWidth(), 0.0) <= 0 || Double.compare(this.getMaxHeight(), 0.0) <= 0) {
            this.setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.canvas = new Canvas();
        this.ctx = this.canvas.getGraphicsContext2D();
        this.getChildren().add((Object)this.canvas);
    }

    private void registerListeners() {
        this.widthProperty().addListener(observable -> this.recalc());
        this.heightProperty().addListener(observable -> this.recalc());
        this.frameVisibleProperty().addListener(observable -> this.draw());
        this.onProperty().addListener(observable -> this.draw());
        this.ledColorProperty().addListener(observable -> this.recalc());
    }

    public final boolean isOn() {
        return null == this.on ? false : this.on.get();
    }

    public final void setOn(boolean GLOWING) {
        this.onProperty().set(GLOWING);
    }

    public final BooleanProperty onProperty() {
        if (null == this.on) {
            this.on = new SimpleBooleanProperty((Object)this, "on", false);
        }
        return this.on;
    }

    public final boolean isBlinking() {
        return null == this.blinking ? this._blinking : this.blinking.get();
    }

    public final void setBlinking(boolean BLINKING) {
        if (null == this.blinking) {
            this._blinking = BLINKING;
            if (BLINKING) {
                this.scheduleBlinkTask();
            } else {
                this.stopTask(this.periodicBlinkTask);
                this.setOn(false);
            }
        } else {
            this.blinking.set(BLINKING);
        }
    }

    public final BooleanProperty blinkingProperty() {
        if (null == this.blinking) {
            this.blinking = new BooleanPropertyBase(){

                public void set(boolean BLINKING) {
                    super.set(BLINKING);
                    if (BLINKING) {
                        Led.this.scheduleBlinkTask();
                    } else {
                        Led.this.stopTask(Led.this.periodicBlinkTask);
                        Led.this.setOn(false);
                    }
                }

                public Object getBean() {
                    return Led.this;
                }

                public String getName() {
                    return "blinking";
                }
            };
        }
        return this.blinking;
    }

    public final int getInterval() {
        return null == this.interval ? this._interval : this.interval.get();
    }

    public final void setInterval(int INTERVAL) {
        if (null == this.interval) {
            this._interval = Led.clamp(50, 5000, INTERVAL);
        } else {
            this.interval.set(INTERVAL);
        }
    }

    public final IntegerProperty intervalProperty() {
        if (null == this.interval) {
            this.interval = new IntegerPropertyBase(){

                public void set(int INTERVAL) {
                    super.set(Led.clamp(50, 5000, INTERVAL));
                }

                public Object getBean() {
                    return Led.this;
                }

                public String getName() {
                    return "interval";
                }
            };
        }
        return this.interval;
    }

    public final boolean isFrameVisible() {
        return null == this.frameVisible ? this._frameVisible : this.frameVisible.get();
    }

    public final void setFrameVisible(boolean FRAME_VISIBLE) {
        if (null == this.frameVisible) {
            this._frameVisible = FRAME_VISIBLE;
        } else {
            this.frameVisible.set(FRAME_VISIBLE);
        }
    }

    public final BooleanProperty frameVisibleProperty() {
        if (null == this.frameVisible) {
            this.frameVisible = new SimpleBooleanProperty((Object)this, "frameVisible", this._frameVisible);
        }
        return this.frameVisible;
    }

    public final Color getLedColor() {
        return null == this.ledColor ? Color.RED : (Color)this.ledColor.get();
    }

    public final void setLedColor(Color LED_COLOR) {
        this.ledColorProperty().set((Object)LED_COLOR);
    }

    public final ObjectProperty<Color> ledColorProperty() {
        if (null == this.ledColor) {
            this.ledColor = new SimpleObjectProperty((Object)this, "ledColor", (Object)Color.RED);
        }
        return this.ledColor;
    }

    public static int clamp(int MIN, int MAX, int VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    private static synchronized void enableBlinkExecutorService() {
        if (null == periodicBlinkExecutorService) {
            periodicBlinkExecutorService = new ScheduledThreadPoolExecutor(1, Led.getThreadFactory("BlinkLED", false));
        }
    }

    private synchronized void scheduleBlinkTask() {
        Led.enableBlinkExecutorService();
        this.stopTask(this.periodicBlinkTask);
        this.periodicBlinkTask = periodicBlinkExecutorService.scheduleAtFixedRate(() -> Platform.runLater(() -> this.setOn(!this.isOn())), 0L, this.getInterval(), TimeUnit.MILLISECONDS);
    }

    private static ThreadFactory getThreadFactory(String THREAD_NAME, boolean IS_DAEMON) {
        return runnable -> {
            Thread thread = new Thread(runnable, THREAD_NAME);
            thread.setDaemon(IS_DAEMON);
            return thread;
        };
    }

    private void stopTask(ScheduledFuture<?> task) {
        if (null == task) {
            return;
        }
        task.cancel(true);
        task = null;
    }

    private void recalc() {
        double size = this.getWidth() < this.getHeight() ? this.getWidth() : this.getHeight();
        this.ledOffShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 0.07 * size, 0.0, 0.0, 0.0);
        this.ledOnShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 0.07 * size, 0.0, 0.0, 0.0);
        this.ledOnShadow.setInput((Effect)new DropShadow(BlurType.TWO_PASS_BOX, (Color)this.ledColor.get(), 0.36 * size, 0.0, 0.0, 0.0));
        this.frameGradient = new LinearGradient(0.14 * size, 0.14 * size, 0.84 * size, 0.84 * size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)20, (int)20, (int)20, (double)0.65)), new Stop(0.15, Color.rgb((int)20, (int)20, (int)20, (double)0.65)), new Stop(0.26, Color.rgb((int)41, (int)41, (int)41, (double)0.65)), new Stop(0.26, Color.rgb((int)41, (int)41, (int)41, (double)0.64)), new Stop(0.85, Color.rgb((int)200, (int)200, (int)200, (double)0.41)), new Stop(1.0, Color.rgb((int)200, (int)200, (int)200, (double)0.35))});
        this.ledOnGradient = new LinearGradient(0.25 * size, 0.25 * size, 0.74 * size, 0.74 * size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, ((Color)this.ledColor.get()).deriveColor(0.0, 1.0, 0.77, 1.0)), new Stop(0.49, ((Color)this.ledColor.get()).deriveColor(0.0, 1.0, 0.5, 1.0)), new Stop(1.0, (Color)this.ledColor.get())});
        this.ledOffGradient = new LinearGradient(0.25 * size, 0.25 * size, 0.74 * size, 0.74 * size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, ((Color)this.ledColor.get()).deriveColor(0.0, 1.0, 0.2, 1.0)), new Stop(0.49, ((Color)this.ledColor.get()).deriveColor(0.0, 1.0, 0.13, 1.0)), new Stop(1.0, ((Color)this.ledColor.get()).deriveColor(0.0, 1.0, 0.2, 1.0))});
        this.highlightGradient = new RadialGradient(0.0, 0.0, 0.3 * size, 0.3 * size, 0.29 * size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.WHITE), new Stop(1.0, Color.TRANSPARENT)});
        this.draw();
    }

    private void draw() {
        double width = this.getWidth();
        double height = this.getHeight();
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        double size = width < height ? width : height;
        this.canvas.setWidth(size);
        this.canvas.setHeight(size);
        if (width > height) {
            this.canvas.relocate(0.5 * (width - size), 0.0);
        } else if (height > width) {
            this.canvas.relocate(0.0, 0.5 * (height - size));
        }
        this.ctx.clearRect(0.0, 0.0, size, size);
        if (this.isFrameVisible()) {
            this.ctx.setFill((Paint)this.frameGradient);
            this.ctx.fillOval(0.0, 0.0, size, size);
        }
        if (this.isOn()) {
            this.ctx.save();
            this.ctx.setEffect((Effect)this.ledOnShadow);
            this.ctx.setFill((Paint)this.ledOnGradient);
            this.ctx.fillOval(0.14 * size, 0.14 * size, 0.72 * size, 0.72 * size);
            this.ctx.restore();
        } else {
            this.ctx.save();
            this.ctx.setEffect((Effect)this.ledOffShadow);
            this.ctx.setFill((Paint)this.ledOffGradient);
            this.ctx.fillOval(0.14 * size, 0.14 * size, 0.72 * size, 0.72 * size);
            this.ctx.restore();
        }
        this.ctx.setFill((Paint)this.highlightGradient);
        this.ctx.fillOval(0.21 * size, 0.21 * size, 0.58 * size, 0.58 * size);
    }
}

