/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.clock;

import eu.hansolo.enzo.clock.skin.ClockSkin;
import java.time.Duration;
import java.time.LocalTime;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class Clock
extends Control {
    private static final int SHORT_INTERVAL = 20;
    private static final int LONG_INTERVAL = 1000;
    private volatile ScheduledFuture<?> periodicTickTask;
    private static ScheduledExecutorService periodicTickExecutorService;
    private StringProperty text;
    private BooleanProperty discreteSecond;
    private BooleanProperty secondPointerVisible;
    private BooleanProperty nightMode;
    private ObjectProperty<Design> design;
    private BooleanProperty highlightVisible;
    private ObjectProperty<LocalTime> time;
    private BooleanProperty running;
    private boolean autoNightMode;
    private int updateInterval;

    public Clock() {
        this(LocalTime.now());
    }

    public Clock(LocalTime TIME) {
        this.getStyleClass().add((Object)"clock");
        this.text = new SimpleStringProperty((Object)this, "text", "");
        this.discreteSecond = new BooleanPropertyBase(false){

            public void set(boolean DISCRETE_SECOND) {
                super.set(DISCRETE_SECOND);
                Clock.this.updateInterval = DISCRETE_SECOND ? 1000 : 20;
            }

            public Object getBean() {
                return Clock.this;
            }

            public String getName() {
                return "discreteSecond";
            }
        };
        this.secondPointerVisible = new SimpleBooleanProperty((Object)this, "secondPointerVisible", false);
        this.nightMode = new SimpleBooleanProperty((Object)this, "nightMode", false);
        this.design = new ObjectPropertyBase<Design>(Design.IOS6){

            public void set(Design DESIGN) {
                switch (DESIGN) {
                    case IOS6: {
                        Clock.this.setDiscreteSecond(false);
                        Clock.this.setSecondPointerVisible(true);
                        break;
                    }
                    case DB: {
                        Clock.this.setDiscreteSecond(false);
                        Clock.this.setSecondPointerVisible(true);
                        break;
                    }
                    case BRAUN: {
                        Clock.this.setDiscreteSecond(true);
                        Clock.this.setSecondPointerVisible(true);
                        break;
                    }
                    case BOSCH: {
                        Clock.this.setDiscreteSecond(true);
                        Clock.this.setSecondPointerVisible(false);
                    }
                }
                super.set((Object)DESIGN);
            }

            public Object getBean() {
                return Clock.this;
            }

            public String getName() {
                return "design";
            }
        };
        this.highlightVisible = new SimpleBooleanProperty((Object)this, "highlightVisible", false);
        this.time = new SimpleObjectProperty((Object)this, "time", (Object)TIME);
        this.running = new BooleanPropertyBase(false){

            public void set(boolean RUNNING) {
                super.set(RUNNING);
                if (RUNNING) {
                    Clock.this.scheduleTickTask();
                } else {
                    Clock.this.stopTask(Clock.this.periodicTickTask);
                }
            }

            public Object getBean() {
                return Clock.this;
            }

            public String getName() {
                return "running";
            }
        };
        this.updateInterval = 20;
    }

    public final String getText() {
        return (String)this.text.get();
    }

    public final void setText(String TEXT) {
        this.text.set((Object)TEXT);
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final boolean isDiscreteSecond() {
        return this.discreteSecond.get();
    }

    public final void setDiscreteSecond(boolean DISCRETE_SECOND) {
        this.discreteSecond.set(DISCRETE_SECOND);
    }

    public final BooleanProperty discreteSecondProperty() {
        return this.discreteSecond;
    }

    public final boolean isSecondPointerVisible() {
        return this.secondPointerVisible.get();
    }

    public final void setSecondPointerVisible(boolean SECOND_POINTER_VISIBLE) {
        this.secondPointerVisible.set(SECOND_POINTER_VISIBLE);
    }

    public final BooleanProperty secondPointerVisibleProperty() {
        return this.secondPointerVisible;
    }

    public final boolean isNightMode() {
        return this.nightMode.get();
    }

    public final void setNightMode(boolean NIGHT_MODE) {
        this.nightMode.set(NIGHT_MODE);
    }

    public final BooleanProperty nightModeProperty() {
        return this.nightMode;
    }

    public final Design getDesign() {
        return (Design)((Object)this.design.get());
    }

    public final void setDesign(Design DESIGN) {
        this.design.set((Object)DESIGN);
    }

    public final ObjectProperty<Design> designProperty() {
        return this.design;
    }

    public final boolean isHighlightVisible() {
        return this.highlightVisible.get();
    }

    public final void setHighlightVisible(boolean HIGHLIGHT_VISIBLE) {
        this.highlightVisible.set(HIGHLIGHT_VISIBLE);
    }

    public final BooleanProperty highlightVisibleProperty() {
        return this.highlightVisible;
    }

    public final LocalTime getTime() {
        return (LocalTime)this.time.get();
    }

    public final void setTime(LocalTime TIME) {
        this.time.set((Object)TIME);
    }

    public final ObjectProperty<LocalTime> timeProperty() {
        return this.time;
    }

    public final boolean isRunning() {
        return this.running.get();
    }

    public final void setRunning(boolean RUNNING) {
        this.running.set(RUNNING);
    }

    public final BooleanProperty runningProperty() {
        return this.running;
    }

    public final boolean isAutoNightMode() {
        return this.autoNightMode;
    }

    public final void setAutoNightMode(boolean AUTO_NIGHT_MODE) {
        this.autoNightMode = AUTO_NIGHT_MODE;
    }

    private void tick() {
        Platform.runLater(() -> this.setTime(this.getTime().plus(Duration.ofMillis(this.updateInterval))));
    }

    private static synchronized void enableTickExecutorService() {
        if (null == periodicTickExecutorService) {
            periodicTickExecutorService = new ScheduledThreadPoolExecutor(1, Clock.getThreadFactory("ClockTick", false));
        }
    }

    private synchronized void scheduleTickTask() {
        Clock.enableTickExecutorService();
        this.stopTask(this.periodicTickTask);
        this.periodicTickTask = periodicTickExecutorService.scheduleAtFixedRate(() -> this.tick(), 0L, this.updateInterval, TimeUnit.MILLISECONDS);
    }

    private static ThreadFactory getThreadFactory(String THREAD_NAME, boolean IS_DAEMON) {
        return runnable -> {
            Thread thread = new Thread(runnable, THREAD_NAME);
            thread.setDaemon(IS_DAEMON);
            return thread;
        };
    }

    private void stopTask(ScheduledFuture<?> task) {
        if (null == task) {
            return;
        }
        task.cancel(true);
        task = null;
    }

    protected Skin createDefaultSkin() {
        return new ClockSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("clock.css").toExternalForm();
    }

    public static enum Design {
        IOS6,
        DB,
        BRAUN,
        BOSCH;

    }
}

