/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge;

import eu.hansolo.enzo.gauge.AvGauge;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Dimension2D;
import javafx.scene.paint.Color;
import javafx.scene.paint.Stop;

public class AvGaugeBuilder<B extends AvGaugeBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();
    private Stop[] outerStops;
    private Stop[] innerStops;

    protected AvGaugeBuilder() {
    }

    public static final AvGaugeBuilder create() {
        return new AvGaugeBuilder();
    }

    public final B outerValue(double VALUE) {
        this.properties.put("outerValue", (Property)new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B innerValue(double VALUE) {
        this.properties.put("innerValue", (Property)new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B minValue(double MIN_VALUE) {
        this.properties.put("minValue", (Property)new SimpleDoubleProperty(MIN_VALUE));
        return (B)this;
    }

    public final B maxValue(double MAX_VALUE) {
        this.properties.put("maxValue", (Property)new SimpleDoubleProperty(MAX_VALUE));
        return (B)this;
    }

    public final B decimals(int DECIMALS) {
        this.properties.put("decimals", (Property)new SimpleIntegerProperty(DECIMALS));
        return (B)this;
    }

    public final B title(String TITLE) {
        this.properties.put("title", (Property)new SimpleStringProperty(TITLE));
        return (B)this;
    }

    public final B animationDuration(int ANIMATION_DURATION) {
        this.properties.put("animationDuration", (Property)new SimpleIntegerProperty(ANIMATION_DURATION));
        return (B)this;
    }

    public final B outerBarColor(Color COLOR) {
        this.properties.put("outerBarColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B innerBarColor(Color COLOR) {
        this.properties.put("innerBarColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B backgroundColor(Color COLOR) {
        this.properties.put("backgroundColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B outerValueTextColor(Color COLOR) {
        this.properties.put("outerValueTextColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B innerValueTextColor(Color COLOR) {
        this.properties.put("innerValueTextColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B titleTextColor(Color COLOR) {
        this.properties.put("titleTextColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B borderColor(Color COLOR) {
        this.properties.put("borderColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B separatorColor(Color COLOR) {
        this.properties.put("separatorColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B multiColor(boolean MULTI_COLOR) {
        this.properties.put("multiColor", (Property)new SimpleBooleanProperty(MULTI_COLOR));
        return (B)this;
    }

    public final B outerGradient(Stop ... STOPS) {
        this.outerStops = STOPS;
        return (B)this;
    }

    public final B innerGradient(Stop ... STOPS) {
        this.innerStops = STOPS;
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B opacity(double OPACITY) {
        this.properties.put("opacity", (Property)new SimpleDoubleProperty(this.clamp(0.0, 1.0, OPACITY)));
        return (B)this;
    }

    private double clamp(double MIN, double MAX, double VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    public final AvGauge build() {
        AvGauge CONTROL = new AvGauge();
        this.properties.forEach((key, property) -> {
            if ("prefSize".equals(key)) {
                Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
            } else if ("minSize".equals(key)) {
                Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
            } else if ("maxSize".equals(key)) {
                Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
            } else if ("prefWidth".equals(key)) {
                CONTROL.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
            } else if ("prefHeight".equals(key)) {
                CONTROL.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
            } else if ("minWidth".equals(key)) {
                CONTROL.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
            } else if ("minHeight".equals(key)) {
                CONTROL.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
            } else if ("maxWidth".equals(key)) {
                CONTROL.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
            } else if ("maxHeight".equals(key)) {
                CONTROL.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
            } else if ("scaleX".equals(key)) {
                CONTROL.setScaleX(((DoubleProperty)this.properties.get(key)).get());
            } else if ("scaleY".equals(key)) {
                CONTROL.setScaleY(((DoubleProperty)this.properties.get(key)).get());
            } else if ("layoutX".equals(key)) {
                CONTROL.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
            } else if ("layoutY".equals(key)) {
                CONTROL.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
            } else if ("translateX".equals(key)) {
                CONTROL.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
            } else if ("translateY".equals(key)) {
                CONTROL.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
            } else if ("opacity".equals(key)) {
                CONTROL.setOpacity(((DoubleProperty)this.properties.get(key)).get());
            } else if ("styleClass".equals(key)) {
                CONTROL.getStyleClass().setAll((Object[])new String[]{"av-gauge"});
                CONTROL.getStyleClass().addAll((Object[])((ObjectProperty)this.properties.get(key)).get());
            } else if ("minValue".equals(key)) {
                CONTROL.setMinValue(((DoubleProperty)this.properties.get(key)).get());
            } else if ("maxValue".equals(key)) {
                CONTROL.setMaxValue(((DoubleProperty)this.properties.get(key)).get());
            } else if ("outerValue".equals(key)) {
                CONTROL.setOuterValue(((DoubleProperty)this.properties.get(key)).get());
            } else if ("innerValue".equals(key)) {
                CONTROL.setInnerValue(((DoubleProperty)this.properties.get(key)).get());
            } else if ("decimals".equals(key)) {
                CONTROL.setDecimals(((IntegerProperty)this.properties.get(key)).get());
            } else if ("title".equals(key)) {
                CONTROL.setTitle((String)((StringProperty)this.properties.get(key)).get());
            } else if ("animationDuration".equals(key)) {
                CONTROL.setAnimationDurationInMs(((IntegerProperty)this.properties.get(key)).get());
            } else if ("outerBarColor".equals(key)) {
                CONTROL.setOuterBarColor((Color)((ObjectProperty)this.properties.get(key)).get());
            } else if ("innerBarColor".equals(key)) {
                CONTROL.setInnerBarColor((Color)((ObjectProperty)this.properties.get(key)).get());
            } else if ("backgroundColor".equals(key)) {
                CONTROL.setBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
            } else if ("outerValueTextColor".equals(key)) {
                CONTROL.setOuterValueTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
            } else if ("innerValueTextColor".equals(key)) {
                CONTROL.setInnerValueTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
            } else if ("titleTextColor".equals(key)) {
                CONTROL.setTitleTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
            } else if ("borderColor".equals(key)) {
                CONTROL.setBorderColor((Color)((ObjectProperty)this.properties.get(key)).get());
            } else if ("separatorColor".equals(key)) {
                CONTROL.setSeparatorColor((Color)((ObjectProperty)this.properties.get(key)).get());
            } else if ("multiColor".equals(key)) {
                CONTROL.setMultiColor(((BooleanProperty)this.properties.get(key)).get());
            }
        });
        if (null != this.outerStops) {
            CONTROL.setOuterGradient(this.outerStops);
        }
        if (null != this.innerStops) {
            CONTROL.setInnerGradient(this.innerStops);
        }
        return CONTROL;
    }
}

