/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge;

import eu.hansolo.enzo.common.GradientLookup;
import eu.hansolo.enzo.gauge.skin.OneEightyGaugeSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;

public class OneEightyGauge
extends Control {
    private static final Paint DEFAULT_BAR_BACKGROUND_COLOR = Color.web((String)"#eff3f3");
    private static final Paint DEFAULT_BAR_COLOR = Color.web((String)"#3221c9");
    private static final Paint DEFAULT_TITLE_COLOR = Color.BLACK;
    private static final Paint DEFAULT_VALUE_COLOR = Color.BLACK;
    private static final Paint DEFAULT_UNIT_COLOR = Color.BLACK;
    private static final Paint DEFAULT_MIN_TEXT_COLOR = Color.BLACK;
    private static final Paint DEFAULT_MAX_TEXT_COLOR = Color.BLACK;
    private DoubleProperty value;
    private DoubleProperty minValue;
    private DoubleProperty maxValue;
    private double minMeasuredValue;
    private double maxMeasuredValue;
    private IntegerProperty decimals;
    private StringProperty title;
    private StringProperty unit;
    private BooleanProperty shadowsEnabled;
    private BooleanProperty animated;
    private double animationDuration;
    private BooleanProperty dynamicBarColor;
    private GradientLookup gradientLookup;
    private ObjectProperty<Paint> barBackgroundColor;
    private ObjectProperty<Paint> barColor;
    private ObjectProperty<Paint> titleColor;
    private ObjectProperty<Paint> valueColor;
    private ObjectProperty<Paint> unitColor;
    private ObjectProperty<Paint> minTextColor;
    private ObjectProperty<Paint> maxTextColor;

    public OneEightyGauge() {
        this.getStyleClass().add((Object)"one-eighty-gauge");
        this.minValue = new SimpleDoubleProperty((Object)this, "minValue", 0.0);
        this.maxValue = new SimpleDoubleProperty((Object)this, "maxValue", 100.0);
        this.value = new DoublePropertyBase(this.minValue.get()){

            public void set(double VALUE) {
                super.set(OneEightyGauge.this.clamp(OneEightyGauge.this.getMinValue(), OneEightyGauge.this.getMaxValue(), VALUE));
            }

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "value";
            }
        };
        this.decimals = new SimpleIntegerProperty((Object)this, "decimals", 0);
        this.title = new SimpleStringProperty((Object)this, "title", "");
        this.unit = new SimpleStringProperty((Object)this, "unit", "");
        this.shadowsEnabled = new SimpleBooleanProperty((Object)this, "shadowsEnabled", true);
        this.animated = new SimpleBooleanProperty((Object)this, "animated", false);
        this.animationDuration = 800.0;
        this.gradientLookup = new GradientLookup();
    }

    public final double getValue() {
        return this.value.get();
    }

    public final void setValue(double VALUE) {
        this.value.set(VALUE);
    }

    public final DoubleProperty valueProperty() {
        return this.value;
    }

    public final double getMinValue() {
        return this.minValue.get();
    }

    public final void setMinValue(double MIN_VALUE) {
        this.minValue.set(MIN_VALUE);
    }

    public final DoubleProperty minValueProperty() {
        return this.minValue;
    }

    public final double getMaxValue() {
        return this.maxValue.get();
    }

    public final void setMaxValue(double MAX_VALUE) {
        this.maxValue.set(MAX_VALUE);
    }

    public final DoubleProperty maxValueProperty() {
        return this.maxValue;
    }

    public final double getMinMeasuredValue() {
        return this.minMeasuredValue;
    }

    public final void setMinMeasuredValue(double MIN_MEASURED_VALUE) {
        this.minMeasuredValue = this.clamp(this.getMinValue(), this.getMaxValue(), MIN_MEASURED_VALUE);
    }

    public final double getMaxMeasuredValue() {
        return this.maxMeasuredValue;
    }

    public final void setMaxMeasuredValue(double MAX_MEASURED_VALUE) {
        this.maxMeasuredValue = this.clamp(this.getMinValue(), this.getMaxValue(), MAX_MEASURED_VALUE);
    }

    public final void resetMinMaxMeasuredValues() {
        this.minMeasuredValue = this.getValue();
        this.maxMeasuredValue = this.getValue();
    }

    public final int getDecimals() {
        return this.decimals.get();
    }

    public final void setDecimals(int DECIMALS) {
        this.decimals.set(DECIMALS);
    }

    public final IntegerProperty decimalsProperty() {
        return this.decimals;
    }

    public final String getTitle() {
        return (String)this.title.get();
    }

    public final void setTitle(String TITLE) {
        this.title.set((Object)TITLE);
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    public final String getUnit() {
        return (String)this.unit.get();
    }

    public final void setUnit(String UNIT) {
        this.unit.set((Object)UNIT);
    }

    public final StringProperty unitProperty() {
        return this.unit;
    }

    public final boolean isShadowsEnabled() {
        return this.shadowsEnabled.get();
    }

    public final void setShadowsEnabled(boolean SHADOWS_ENABLED) {
        this.shadowsEnabled.set(SHADOWS_ENABLED);
    }

    public final BooleanProperty shadowsEnabledProperty() {
        return this.shadowsEnabled;
    }

    public final boolean isAnimated() {
        return this.animated.get();
    }

    public final void setAnimated(boolean ANIMATED) {
        this.animated.set(ANIMATED);
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    public final double getAnimationDuration() {
        return this.animationDuration;
    }

    public final void setAnimationDuration(double ANIMATION_DURATION) {
        this.animationDuration = this.clamp(20.0, 5000.0, ANIMATION_DURATION);
    }

    public final boolean isDynamicBarColor() {
        return null == this.dynamicBarColor ? false : this.dynamicBarColor.get();
    }

    public final void setDynamicBarColor(boolean DYNAMIC_BAR_COLOR) {
        this.dynamicBarColorProperty().set(DYNAMIC_BAR_COLOR);
    }

    public final BooleanProperty dynamicBarColorProperty() {
        if (null == this.dynamicBarColor) {
            this.dynamicBarColor = new SimpleBooleanProperty((Object)this, "dynamicBarColor", false);
        }
        return this.dynamicBarColor;
    }

    public final GradientLookup getGradientLookup() {
        return this.gradientLookup;
    }

    public final void setGradientLookup(GradientLookup GRADIENT_LOOKUP) {
        this.gradientLookup = GRADIENT_LOOKUP;
    }

    public final List<Stop> getStops() {
        return this.gradientLookup.getStops();
    }

    public final void setStops(Stop ... STOPS) {
        this.gradientLookup.setStops(STOPS);
    }

    public final void setStops(List<Stop> STOPS) {
        this.gradientLookup.setStops(STOPS);
    }

    public final Paint getBarBackgroundColor() {
        return null == this.barBackgroundColor ? DEFAULT_BAR_BACKGROUND_COLOR : (Paint)this.barBackgroundColor.get();
    }

    public final void setBarBackgroundColor(Paint value) {
        this.barBackgroundColorProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> barBackgroundColorProperty() {
        if (null == this.barBackgroundColor) {
            this.barBackgroundColor = new StyleableObjectProperty<Paint>(DEFAULT_BAR_BACKGROUND_COLOR){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.BAR_BACKGROUND_COLOR;
                }

                public Object getBean() {
                    return OneEightyGauge.this;
                }

                public String getName() {
                    return "barBackgroundColor";
                }
            };
        }
        return this.barBackgroundColor;
    }

    public final Paint getBarColor() {
        return null == this.barColor ? DEFAULT_BAR_COLOR : (Paint)this.barColor.get();
    }

    public final void setBarColor(Paint value) {
        this.barColorProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> barColorProperty() {
        if (null == this.barColor) {
            this.barColor = new StyleableObjectProperty<Paint>(DEFAULT_BAR_COLOR){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.BAR_COLOR;
                }

                public Object getBean() {
                    return OneEightyGauge.this;
                }

                public String getName() {
                    return "barColor";
                }
            };
        }
        return this.barColor;
    }

    public final Paint getTitleColor() {
        return null == this.titleColor ? DEFAULT_TITLE_COLOR : (Paint)this.titleColor.get();
    }

    public final void setTitleColor(Paint value) {
        this.titleColorProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> titleColorProperty() {
        if (null == this.titleColor) {
            this.titleColor = new StyleableObjectProperty<Paint>(DEFAULT_TITLE_COLOR){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.TITLE_COLOR;
                }

                public Object getBean() {
                    return OneEightyGauge.this;
                }

                public String getName() {
                    return "titleColor";
                }
            };
        }
        return this.titleColor;
    }

    public final Paint getValueColor() {
        return null == this.valueColor ? DEFAULT_VALUE_COLOR : (Paint)this.valueColor.get();
    }

    public final void setValueColor(Paint value) {
        this.valueColorProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> valueColorProperty() {
        if (null == this.valueColor) {
            this.valueColor = new StyleableObjectProperty<Paint>(DEFAULT_VALUE_COLOR){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.VALUE_COLOR;
                }

                public Object getBean() {
                    return OneEightyGauge.this;
                }

                public String getName() {
                    return "valueColor";
                }
            };
        }
        return this.valueColor;
    }

    public final Paint getUnitColor() {
        return null == this.unitColor ? DEFAULT_UNIT_COLOR : (Paint)this.unitColor.get();
    }

    public final void setUnitColor(Paint value) {
        this.unitColorProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> unitColorProperty() {
        if (null == this.unitColor) {
            this.unitColor = new StyleableObjectProperty<Paint>(DEFAULT_UNIT_COLOR){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.UNIT_COLOR;
                }

                public Object getBean() {
                    return OneEightyGauge.this;
                }

                public String getName() {
                    return "unitColor";
                }
            };
        }
        return this.unitColor;
    }

    public final Paint getMinTextColor() {
        return null == this.minTextColor ? DEFAULT_MIN_TEXT_COLOR : (Paint)this.minTextColor.get();
    }

    public final void setMinTextColor(Paint value) {
        this.minTextColorProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> minTextColorProperty() {
        if (null == this.minTextColor) {
            this.minTextColor = new StyleableObjectProperty<Paint>(DEFAULT_MIN_TEXT_COLOR){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.MIN_TEXT_COLOR;
                }

                public Object getBean() {
                    return OneEightyGauge.this;
                }

                public String getName() {
                    return "minTextColor";
                }
            };
        }
        return this.minTextColor;
    }

    public final Paint getMaxTextColor() {
        return null == this.maxTextColor ? DEFAULT_MAX_TEXT_COLOR : (Paint)this.maxTextColor.get();
    }

    public final void setMaxTextColor(Paint value) {
        this.maxTextColorProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> maxTextColorProperty() {
        if (null == this.maxTextColor) {
            this.maxTextColor = new StyleableObjectProperty<Paint>(DEFAULT_MAX_TEXT_COLOR){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.MAX_TEXT_COLOR;
                }

                public Object getBean() {
                    return OneEightyGauge.this;
                }

                public String getName() {
                    return "maxTextColor";
                }
            };
        }
        return this.maxTextColor;
    }

    private double clamp(double MIN_VALUE, double MAX_VALUE, double VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    private int clamp(int MIN_VALUE, int MAX_VALUE, int VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    protected Skin createDefaultSkin() {
        return new OneEightyGaugeSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("oneeightygauge.css").toExternalForm();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return OneEightyGauge.getClassCssMetaData();
    }

    static /* synthetic */ Paint access$800() {
        return DEFAULT_BAR_BACKGROUND_COLOR;
    }

    static /* synthetic */ Paint access$1000() {
        return DEFAULT_BAR_COLOR;
    }

    static /* synthetic */ Paint access$1200() {
        return DEFAULT_TITLE_COLOR;
    }

    static /* synthetic */ Paint access$1400() {
        return DEFAULT_VALUE_COLOR;
    }

    static /* synthetic */ Paint access$1600() {
        return DEFAULT_UNIT_COLOR;
    }

    static /* synthetic */ Paint access$1800() {
        return DEFAULT_MIN_TEXT_COLOR;
    }

    static /* synthetic */ Paint access$2000() {
        return DEFAULT_MAX_TEXT_COLOR;
    }

    private static class StyleableProperties {
        private static final CssMetaData<OneEightyGauge, Paint> BAR_BACKGROUND_COLOR = new CssMetaData<OneEightyGauge, Paint>("-bar-background-color", StyleConverter.getPaintConverter(), OneEightyGauge.access$800()){

            public boolean isSettable(OneEightyGauge node) {
                return null == node.barBackgroundColor || !node.barBackgroundColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(OneEightyGauge node) {
                return (StyleableProperty)node.barBackgroundColorProperty();
            }

            public Color getInitialValue(OneEightyGauge node) {
                return (Color)node.getBarBackgroundColor();
            }
        };
        private static final CssMetaData<OneEightyGauge, Paint> BAR_COLOR = new CssMetaData<OneEightyGauge, Paint>("-bar-color", StyleConverter.getPaintConverter(), OneEightyGauge.access$1000()){

            public boolean isSettable(OneEightyGauge node) {
                return null == node.barColor || !node.barColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(OneEightyGauge node) {
                return (StyleableProperty)node.barColorProperty();
            }

            public Color getInitialValue(OneEightyGauge node) {
                return (Color)node.getBarColor();
            }
        };
        private static final CssMetaData<OneEightyGauge, Paint> TITLE_COLOR = new CssMetaData<OneEightyGauge, Paint>("-title-color", StyleConverter.getPaintConverter(), OneEightyGauge.access$1200()){

            public boolean isSettable(OneEightyGauge node) {
                return null == node.titleColor || !node.titleColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(OneEightyGauge node) {
                return (StyleableProperty)node.titleColorProperty();
            }

            public Color getInitialValue(OneEightyGauge node) {
                return (Color)node.getTitleColor();
            }
        };
        private static final CssMetaData<OneEightyGauge, Paint> VALUE_COLOR = new CssMetaData<OneEightyGauge, Paint>("-value-color", StyleConverter.getPaintConverter(), OneEightyGauge.access$1400()){

            public boolean isSettable(OneEightyGauge node) {
                return null == node.valueColor || !node.valueColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(OneEightyGauge node) {
                return (StyleableProperty)node.valueColorProperty();
            }

            public Color getInitialValue(OneEightyGauge node) {
                return (Color)node.getValueColor();
            }
        };
        private static final CssMetaData<OneEightyGauge, Paint> UNIT_COLOR = new CssMetaData<OneEightyGauge, Paint>("-unit-color", StyleConverter.getPaintConverter(), OneEightyGauge.access$1600()){

            public boolean isSettable(OneEightyGauge node) {
                return null == node.unitColor || !node.unitColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(OneEightyGauge node) {
                return (StyleableProperty)node.unitColorProperty();
            }

            public Color getInitialValue(OneEightyGauge node) {
                return (Color)node.getUnitColor();
            }
        };
        private static final CssMetaData<OneEightyGauge, Paint> MIN_TEXT_COLOR = new CssMetaData<OneEightyGauge, Paint>("-min-text-color", StyleConverter.getPaintConverter(), OneEightyGauge.access$1800()){

            public boolean isSettable(OneEightyGauge node) {
                return null == node.minTextColor || !node.minTextColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(OneEightyGauge node) {
                return (StyleableProperty)node.minTextColorProperty();
            }

            public Color getInitialValue(OneEightyGauge node) {
                return (Color)node.getMinTextColor();
            }
        };
        private static final CssMetaData<OneEightyGauge, Paint> MAX_TEXT_COLOR = new CssMetaData<OneEightyGauge, Paint>("-max-text-color", StyleConverter.getPaintConverter(), OneEightyGauge.access$2000()){

            public boolean isSettable(OneEightyGauge node) {
                return null == node.maxTextColor || !node.maxTextColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(OneEightyGauge node) {
                return (StyleableProperty)node.maxTextColorProperty();
            }

            public Color getInitialValue(OneEightyGauge node) {
                return (Color)node.getMaxTextColor();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, BAR_BACKGROUND_COLOR, BAR_COLOR, TITLE_COLOR, VALUE_COLOR, UNIT_COLOR, MIN_TEXT_COLOR, MAX_TEXT_COLOR);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

