/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge.skin;

import eu.hansolo.enzo.fonts.Fonts;
import eu.hansolo.enzo.gauge.Linear;
import java.time.Instant;
import java.util.Locale;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.value.WritableValue;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;

public class LinearSkin
extends SkinBase<Linear>
implements Skin<Linear> {
    private static final double MINIMUM_WIDTH = 140.0;
    private static final double MINIMUM_HEIGHT = 140.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double PREFERRED_WIDTH = 140.0;
    private static final double PREFERRED_HEIGHT = 350.0;
    private static final double ASPECT_RATIO = 2.5;
    private double size = 140.0;
    private double width = 140.0;
    private double height = 350.0;
    private double stepSize;
    private DoubleProperty currentValue;
    private Pane pane;
    private Region background;
    private Canvas ticksAndSectionsCanvas;
    private GraphicsContext ticksAndSections;
    private Text unitText;
    private Text titleText;
    private Region ledFrame;
    private Region ledMain;
    private Region ledHl;
    private Label lcdText;
    private Region barBackground;
    private Path barBackgroundBorder;
    private MoveTo barBackgroundBorderStart1;
    private LineTo barBackgroundBorderStop1;
    private MoveTo barBackgroundBorderStart2;
    private LineTo barBackgroundBorderStop2;
    private Region bar;
    private Region foreground;
    private InnerShadow innerShadow;
    private DropShadow glow;
    private Timeline timeline = new Timeline();
    private Instant lastCall = Instant.now();
    private boolean withinSpeedLimit = true;

    public LinearSkin(Linear CONTROL) {
        super((Control)CONTROL);
        this.currentValue = new DoublePropertyBase(((Linear)this.getSkinnable()).getValue()){

            public Object getBean() {
                return LinearSkin.this;
            }

            public String getName() {
                return "currentValue";
            }
        };
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((Linear)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Linear)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Linear)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Linear)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Linear)this.getSkinnable()).getPrefWidth() > 0.0 && ((Linear)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Linear)this.getSkinnable()).setPrefSize(((Linear)this.getSkinnable()).getPrefWidth(), ((Linear)this.getSkinnable()).getPrefHeight());
            } else {
                ((Linear)this.getSkinnable()).setPrefSize(140.0, 350.0);
            }
        }
        if (Double.compare(((Linear)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Linear)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Linear)this.getSkinnable()).setMinSize(140.0, 140.0);
        }
        if (Double.compare(((Linear)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Linear)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Linear)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.background = new Region();
        this.background.getStyleClass().setAll((Object[])new String[]{"background"});
        this.barBackground = new Region();
        this.barBackground.getStyleClass().setAll((Object[])new String[]{"bar-background"});
        this.barBackgroundBorderStart1 = new MoveTo();
        this.barBackgroundBorderStop1 = new LineTo();
        this.barBackgroundBorderStart2 = new MoveTo();
        this.barBackgroundBorderStop2 = new LineTo();
        this.barBackgroundBorder = new Path(new PathElement[]{this.barBackgroundBorderStart1, this.barBackgroundBorderStop1, this.barBackgroundBorderStart2, this.barBackgroundBorderStop2});
        this.barBackgroundBorder.getStyleClass().setAll((Object[])new String[]{"bar-background-border"});
        this.ticksAndSectionsCanvas = new Canvas(140.0, 350.0);
        this.ticksAndSections = this.ticksAndSectionsCanvas.getGraphicsContext2D();
        this.innerShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 8.0, 0.0, 0.0, 0.0);
        this.glow = new DropShadow(BlurType.TWO_PASS_BOX, ((Linear)this.getSkinnable()).getLedColor(), 20.0, 0.0, 0.0, 0.0);
        this.glow.setInput((Effect)this.innerShadow);
        this.ledFrame = new Region();
        this.ledFrame.getStyleClass().setAll((Object[])new String[]{"led-frame"});
        this.ledMain = new Region();
        this.ledMain.getStyleClass().setAll((Object[])new String[]{"led-main"});
        this.ledMain.setStyle("-led-color: " + this.colorToCss(((Linear)this.getSkinnable()).getLedColor()) + ";");
        this.ledHl = new Region();
        this.ledHl.getStyleClass().setAll((Object[])new String[]{"led-hl"});
        this.bar = new Region();
        this.bar.getStyleClass().setAll((Object[])new String[]{"bar"});
        this.foreground = new Region();
        this.foreground.getStyleClass().setAll((Object[])new String[]{"foreground"});
        this.titleText = new Text(((Linear)this.getSkinnable()).getTitle());
        this.titleText.getStyleClass().setAll((Object[])new String[]{"title"});
        this.unitText = new Text(((Linear)this.getSkinnable()).getUnit());
        this.unitText.getStyleClass().setAll((Object[])new String[]{"unit"});
        this.lcdText = new Label(((Linear)this.getSkinnable()).getNumberFormat().format(((Linear)this.getSkinnable()).getValue()));
        this.lcdText.getStyleClass().setAll((Object[])new String[]{"lcd-text"});
        this.pane = new Pane();
        this.pane.getChildren().setAll((Object[])new Node[]{this.background, this.barBackground, this.barBackgroundBorder, this.ticksAndSectionsCanvas, this.titleText, this.unitText, this.lcdText, this.ledFrame, this.ledMain, this.ledHl, this.bar, this.foreground});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
        this.resize();
    }

    private void registerListeners() {
        ((Linear)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Linear)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Linear)this.getSkinnable()).ledOnProperty().addListener(observable -> this.ledMain.setEffect((Effect)(((Linear)this.getSkinnable()).isLedOn() ? this.glow : this.innerShadow)));
        ((Linear)this.getSkinnable()).ledColorProperty().addListener(observable -> this.handleControlPropertyChanged("LED_COLOR"));
        ((Linear)this.getSkinnable()).tickLabelFillProperty().addListener(observable -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((Linear)this.getSkinnable()).tickMarkFillProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Linear)this.getSkinnable()).barColorProperty().addListener(observable -> this.handleControlPropertyChanged("BAR_COLOR"));
        ((Linear)this.getSkinnable()).animatedProperty().addListener(observable -> this.handleControlPropertyChanged("ANIMATED"));
        ((Linear)this.getSkinnable()).numberFormatProperty().addListener(observable -> this.handleControlPropertyChanged("RECALC"));
        ((Linear)this.getSkinnable()).unitProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Linear)this.getSkinnable()).titleProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Linear)this.getSkinnable()).orientationProperty().addListener(observable -> this.handleControlPropertyChanged("ORIENTATION"));
        ((Linear)this.getSkinnable()).minValueProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Linear)this.getSkinnable()).maxValueProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Linear)this.getSkinnable()).valueProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.withinSpeedLimit = !Instant.now().minusMillis((long)((Linear)this.getSkinnable()).getAnimationDuration()).isBefore(this.lastCall);
            this.lastCall = Instant.now();
            this.updateBar();
        });
        this.currentValue.addListener(observable -> {
            if (Orientation.VERTICAL == ((Linear)this.getSkinnable()).getOrientation()) {
                this.bar.setPrefSize(0.14286 * this.width, Math.abs(this.currentValue.get()) * this.stepSize);
                if (Double.compare(this.currentValue.get(), 0.0) >= 0) {
                    this.bar.setLayoutY(-this.currentValue.get() * this.stepSize);
                }
            } else {
                this.bar.setPrefSize(Math.abs(this.currentValue.get()) * this.stepSize, 0.14286 * this.height);
                if (Double.compare(this.currentValue.get(), 0.0) <= 0) {
                    this.bar.setLayoutX(-Math.abs(this.currentValue.get()) * this.stepSize);
                }
            }
            ((Linear)this.getSkinnable()).setBlinking(this.currentValue.get() + ((Linear)this.getSkinnable()).getMinValue() > ((Linear)this.getSkinnable()).getThreshold());
            this.lcdText.setText(String.format(Locale.US, "%." + ((Linear)this.getSkinnable()).getDecimals() + "f", this.currentValue.get() + ((Linear)this.getSkinnable()).getMinValue()));
        });
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("CANVAS_REFRESH".equals(PROPERTY)) {
            this.ticksAndSections.clearRect(0.0, 0.0, this.ticksAndSectionsCanvas.getWidth(), this.ticksAndSectionsCanvas.getHeight());
            this.drawTickMarks(this.ticksAndSections);
        } else if ("NEEDLE_COLOR".equals(PROPERTY)) {
            this.bar.setStyle("-bar-color: " + this.colorToCss(((Linear)this.getSkinnable()).getBarColor()) + ";");
        } else if ("LED_COLOR".equals(PROPERTY)) {
            this.ledMain.setStyle("-led-color: " + this.colorToCss(((Linear)this.getSkinnable()).getLedColor()));
            this.resize();
        } else if ("ORIENTATION".equals(PROPERTY)) {
            this.resize();
        }
    }

    private void drawTickMarks(GraphicsContext CTX) {
        double stepSize;
        double maxPosition;
        double minPosition;
        CTX.setFont(Fonts.robotoLight(0.06 * this.size));
        CTX.setStroke(((Linear)this.getSkinnable()).getTickMarkFill());
        CTX.setFill(((Linear)this.getSkinnable()).getTickLabelFill());
        double range = ((Linear)this.getSkinnable()).getMaxValue() - ((Linear)this.getSkinnable()).getMinValue();
        Orientation orientation = ((Linear)this.getSkinnable()).getOrientation();
        if (Orientation.VERTICAL == orientation) {
            minPosition = 0.32857000000000003 * this.height * 0.5;
            maxPosition = 0.32857000000000003 * this.height * 0.5 + 0.67143 * this.height;
            stepSize = Math.abs(0.67143 * this.height / range);
        } else {
            minPosition = 0.25 * this.width * 0.5;
            maxPosition = 0.25 * this.width * 0.5 + 0.75 * this.width;
            stepSize = Math.abs(0.75 * this.width / range);
        }
        double tickStart = minPosition;
        double tickStop = maxPosition;
        if (stepSize == 0.0) {
            return;
        }
        int tickCounter = 0;
        double counter = tickStart;
        while (Double.compare(counter, tickStop + 1.0) <= 0) {
            Point2D textPoint;
            Point2D outerPoint;
            Point2D innerMinorPoint;
            Point2D innerMediumPoint;
            Point2D innerMainPoint;
            if (Orientation.VERTICAL == orientation) {
                innerMainPoint = new Point2D(0.36 * this.width, counter);
                innerMediumPoint = new Point2D(0.375 * this.width, counter);
                innerMinorPoint = new Point2D(0.39 * this.width, counter);
                outerPoint = new Point2D(0.41 * this.width, counter);
                textPoint = new Point2D(0.34 * this.width, counter);
            } else {
                innerMainPoint = new Point2D(counter, 0.64 * this.height);
                innerMediumPoint = new Point2D(counter, 0.625 * this.height);
                innerMinorPoint = new Point2D(counter, 0.61 * this.height);
                outerPoint = new Point2D(counter, 0.59 * this.height);
                textPoint = new Point2D(counter, 0.7 * this.height);
            }
            if ((double)tickCounter % ((Linear)this.getSkinnable()).getMajorTickSpace() == 0.0) {
                CTX.setLineWidth(this.size * 0.007);
                CTX.strokeLine(innerMainPoint.getX(), innerMainPoint.getY(), outerPoint.getX(), outerPoint.getY());
                CTX.setTextBaseline(VPos.CENTER);
                if (Orientation.VERTICAL == orientation) {
                    CTX.setTextAlign(TextAlignment.RIGHT);
                    CTX.fillText(Integer.toString((int)(((Linear)this.getSkinnable()).getMaxValue() - (double)tickCounter * ((Linear)this.getSkinnable()).getMinorTickSpace())), textPoint.getX(), textPoint.getY());
                } else {
                    CTX.setTextAlign(TextAlignment.CENTER);
                    CTX.fillText(Integer.toString((int)(((Linear)this.getSkinnable()).getMinValue() + (double)tickCounter * ((Linear)this.getSkinnable()).getMinorTickSpace())), textPoint.getX(), textPoint.getY());
                }
            } else if (((Linear)this.getSkinnable()).getMinorTickSpace() % 2.0 != 0.0 && tickCounter % 5 == 0) {
                CTX.setLineWidth(this.size * 0.006);
                CTX.strokeLine(innerMediumPoint.getX(), innerMediumPoint.getY(), outerPoint.getX(), outerPoint.getY());
            } else if ((double)tickCounter % ((Linear)this.getSkinnable()).getMinorTickSpace() == 0.0) {
                CTX.setLineWidth(this.size * 0.005);
                CTX.strokeLine(innerMinorPoint.getX(), innerMinorPoint.getY(), outerPoint.getX(), outerPoint.getY());
            }
            ++tickCounter;
            counter += stepSize;
        }
    }

    private void updateBar() {
        this.timeline.stop();
        if (this.withinSpeedLimit && ((Linear)this.getSkinnable()).isAnimated()) {
            KeyValue KEY_VALUE = new KeyValue((WritableValue)this.currentValue, (Object)(((Linear)this.getSkinnable()).getValue() - ((Linear)this.getSkinnable()).getMinValue()), Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
            KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)((Linear)this.getSkinnable()).getAnimationDuration()), new KeyValue[]{KEY_VALUE});
            this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{KEY_FRAME});
            this.timeline.play();
        } else {
            this.currentValue.set(((Linear)this.getSkinnable()).getValue() - ((Linear)this.getSkinnable()).getMinValue());
        }
    }

    private String colorToCss(Color COLOR) {
        return COLOR.toString().replace("0x", "#");
    }

    private void resize() {
        this.width = ((Linear)this.getSkinnable()).getWidth();
        this.height = ((Linear)this.getSkinnable()).getHeight();
        if (Orientation.VERTICAL == ((Linear)this.getSkinnable()).getOrientation()) {
            this.width = this.height / 2.5;
        } else {
            this.height = this.width / 2.5;
        }
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            if (Orientation.VERTICAL == ((Linear)this.getSkinnable()).getOrientation()) {
                this.stepSize = Math.abs(0.67143 * this.height / (((Linear)this.getSkinnable()).getMaxValue() - ((Linear)this.getSkinnable()).getMinValue()));
                this.background.setStyle("-fx-background-insets: 0, " + 0.005 * this.width + ", " + 0.12143 * this.width + ";");
                this.background.setPrefSize(this.height / 2.5, this.height);
                this.barBackground.setPrefSize(0.14286 * this.width, 0.67143 * this.height);
                this.barBackground.relocate((this.width - this.barBackground.getPrefWidth()) * 0.5, (this.height - this.barBackground.getPrefHeight()) * 0.5);
                this.barBackgroundBorderStart1.setX(this.barBackground.getLayoutX() - 1.0);
                this.barBackgroundBorderStart1.setY(this.barBackground.getLayoutY());
                this.barBackgroundBorderStop1.setX(this.barBackground.getLayoutX() - 1.0);
                this.barBackgroundBorderStop1.setY(this.barBackground.getLayoutY() + this.barBackground.getPrefHeight());
                this.barBackgroundBorderStart2.setX(this.barBackground.getLayoutX() + this.barBackground.getPrefWidth() + 1.0);
                this.barBackgroundBorderStart2.setY(this.barBackground.getLayoutY());
                this.barBackgroundBorderStop2.setX(this.barBackground.getLayoutX() + this.barBackground.getPrefWidth() + 1.0);
                this.barBackgroundBorderStop2.setY(this.barBackground.getLayoutY() + this.barBackground.getPrefHeight());
                this.ticksAndSectionsCanvas.setWidth(this.height / 2.5);
                this.ticksAndSectionsCanvas.setHeight(this.height);
                this.ticksAndSections.clearRect(0.0, 0.0, this.ticksAndSectionsCanvas.getWidth(), this.ticksAndSectionsCanvas.getHeight());
                this.drawTickMarks(this.ticksAndSections);
                this.ticksAndSectionsCanvas.setCache(true);
                this.ticksAndSectionsCanvas.setCacheHint(CacheHint.QUALITY);
                this.innerShadow.setRadius(0.01 * this.width);
                this.glow.setRadius(0.05 * this.width);
                this.glow.setColor(((Linear)this.getSkinnable()).getLedColor());
                this.ledFrame.setPrefSize(0.08571 * this.width, 0.08571 * this.width);
                this.ledFrame.relocate(0.69286 * this.width, 0.14857 * this.height);
                this.ledMain.setPrefSize(0.06429 * this.width, 0.06429 * this.width);
                this.ledMain.relocate(0.70714 * this.width, 0.15429 * this.height);
                this.ledHl.setPrefSize(0.05 * this.width, 0.05 * this.width);
                this.ledHl.relocate(0.71429 * this.width, 0.15714 * this.height);
                this.bar.setPrefSize(0.14286 * this.width, Math.abs(this.currentValue.get()) * this.stepSize);
                this.bar.setTranslateX((this.width - this.bar.getPrefWidth()) * 0.5);
                this.bar.setTranslateY(this.barBackground.getLayoutY() + this.barBackground.getPrefHeight());
                this.foreground.setPrefSize(0.8 * this.width, 0.9 * this.height);
                this.foreground.relocate(0.1 * this.width, 0.05 * this.height);
            } else {
                this.stepSize = Math.abs(0.75 * this.width / (((Linear)this.getSkinnable()).getMaxValue() - ((Linear)this.getSkinnable()).getMinValue()));
                this.background.setStyle("-fx-background-insets: 0, " + 0.005 * this.height + ", " + 0.12143 * this.height + ";");
                this.background.setPrefSize(this.width, this.width / 2.5);
                this.barBackground.setPrefSize(0.75 * this.width, 0.14286 * this.height);
                this.barBackground.relocate((this.width - this.barBackground.getPrefWidth()) * 0.5, (this.height - this.barBackground.getPrefHeight()) * 0.5);
                this.barBackgroundBorderStart1.setX(this.barBackground.getLayoutX());
                this.barBackgroundBorderStart1.setY(this.barBackground.getLayoutY() - 1.0);
                this.barBackgroundBorderStop1.setX(this.barBackground.getLayoutX() + this.barBackground.getPrefWidth());
                this.barBackgroundBorderStop1.setY(this.barBackground.getLayoutY() - 1.0);
                this.barBackgroundBorderStart2.setX(this.barBackground.getLayoutX());
                this.barBackgroundBorderStart2.setY(this.barBackground.getLayoutY() + this.barBackground.getPrefHeight() + 1.0);
                this.barBackgroundBorderStop2.setX(this.barBackground.getLayoutX() + this.barBackground.getPrefWidth());
                this.barBackgroundBorderStop2.setY(this.barBackground.getLayoutY() + this.barBackground.getPrefHeight() + 1.0);
                this.ticksAndSectionsCanvas.setWidth(this.width);
                this.ticksAndSectionsCanvas.setHeight(this.width / 2.5);
                this.ticksAndSections.clearRect(0.0, 0.0, this.ticksAndSectionsCanvas.getWidth(), this.ticksAndSectionsCanvas.getHeight());
                this.drawTickMarks(this.ticksAndSections);
                this.ticksAndSectionsCanvas.setCache(true);
                this.ticksAndSectionsCanvas.setCacheHint(CacheHint.QUALITY);
                this.innerShadow.setRadius(0.01 * this.height);
                this.glow.setRadius(0.05 * this.height);
                this.glow.setColor(((Linear)this.getSkinnable()).getLedColor());
                this.ledFrame.setPrefSize(0.08571 * this.height, 0.08571 * this.height);
                this.ledFrame.relocate(0.89748 * this.width, 0.455 * this.height);
                this.ledMain.setPrefSize(0.06429 * this.height, 0.06429 * this.height);
                this.ledMain.relocate(0.90233 * this.width, 0.46714 * this.height);
                this.ledHl.setPrefSize(0.05 * this.height, 0.05 * this.height);
                this.ledHl.relocate(0.90476 * this.width, 0.47429 * this.height);
                this.bar.setPrefSize(Math.abs(this.currentValue.get()) * this.stepSize, 0.14286 * this.height);
                this.bar.setTranslateX(this.barBackground.getLayoutX());
                this.bar.setTranslateY(this.barBackground.getLayoutY());
                this.foreground.setPrefSize(0.9 * this.width, 0.8 * this.height);
                this.foreground.relocate((this.width - this.foreground.getPrefWidth()) * 0.5, 0.1 * this.height);
            }
            this.resizeText();
            this.updateBar();
        }
    }

    private void resizeText() {
        if (Orientation.VERTICAL == ((Linear)this.getSkinnable()).getOrientation()) {
            this.titleText.setFont(Fonts.robotoRegular(0.08571 * this.width));
            this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, 0.22 * this.width);
            this.unitText.setFont(Fonts.robotoRegular(0.07143 * this.width));
            this.unitText.relocate((this.width - this.unitText.getLayoutBounds().getWidth()) * 0.76, 0.88 * this.height);
            this.lcdText.setStyle("-fx-background-radius: " + 0.0125 * this.width + ";");
            this.lcdText.setFont(Fonts.robotoRegular(0.08571 * this.width));
            this.lcdText.setPrefSize(0.375 * this.width, 0.015 * this.width);
            this.lcdText.relocate((this.width - this.lcdText.getPrefWidth()) * 0.5, 0.87 * this.height);
        } else {
            this.titleText.setFont(Fonts.robotoRegular(0.08571 * this.height));
            this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.1, 0.22 * this.height);
            this.unitText.setFont(Fonts.robotoRegular(0.07143 * this.height));
            this.unitText.relocate((this.width - this.unitText.getLayoutBounds().getWidth()) * 0.5, this.height * 0.76);
            this.lcdText.setStyle("-fx-background-radius: " + 0.0125 * this.height + ";");
            this.lcdText.setFont(Fonts.robotoRegular(this.height * 0.09));
            this.lcdText.setPrefSize(0.5 * this.height, 0.025 * this.height);
            this.lcdText.relocate((this.width - this.lcdText.getPrefWidth()) * 0.9, 0.21 * this.height);
        }
    }
}

