/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.lcd;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;

public class Alarm {
    public static final boolean ARMED = true;
    public static final boolean UNARMED = false;
    private Repetition repetition;
    private LocalDateTime time;
    private boolean armed;
    private String text;
    private Command command;

    public Alarm() {
        this(Repetition.ONCE, LocalDateTime.now().plus(5L, ChronoUnit.MINUTES));
    }

    public Alarm(Repetition REPETITION, LocalDateTime TIME) {
        this(REPETITION, TIME, true);
    }

    public Alarm(Repetition REPETITION, LocalDateTime TIME, boolean ARMED) {
        this(REPETITION, TIME, ARMED, "");
    }

    public Alarm(Repetition REPETITION, LocalDateTime TIME, boolean ARMED, String TEXT) {
        this(REPETITION, TIME, ARMED, TEXT, null);
    }

    public Alarm(Repetition REPETITION, LocalDateTime TIME, boolean ARMED, String TEXT, Command COMMAND) {
        this.repetition = REPETITION;
        this.time = TIME;
        this.armed = ARMED;
        this.text = TEXT;
        this.command = COMMAND;
    }

    public Repetition getRepetition() {
        return this.repetition;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public boolean isArmed() {
        return this.armed;
    }

    public void setArmed(boolean ARMED) {
        this.armed = ARMED;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String TEXT) {
        this.text = TEXT;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command COMMAND) {
        this.command = COMMAND;
    }

    public void executeCommand() {
        if (null != this.command) {
            this.command.execute();
        }
    }

    public static interface Command {
        public void execute();
    }

    public static class AlarmEvent
    extends Event {
        public static final EventType<AlarmEvent> ALARM = new EventType(ANY, "ALARM");
        private Alarm alarm;

        public AlarmEvent(Alarm ALARM, Object SOURCE, EventTarget TARGET, EventType<AlarmEvent> TYPE) {
            super(SOURCE, TARGET, TYPE);
            this.alarm = ALARM;
        }

        public Alarm getAlarm() {
            return this.alarm;
        }
    }

    public static enum Repetition {
        ONCE,
        HOURLY,
        DAILY,
        WEEKLY;

    }
}

