/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.onoffswitch;

import eu.hansolo.enzo.onoffswitch.SelectionEvent;
import eu.hansolo.enzo.onoffswitch.skin.OnOffSwitchSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class OnOffSwitch
extends Control
implements Toggle {
    public static final Color DEFAULT_SWITCH_COLOR = Color.WHITE;
    public static final Color DEFAULT_TEXT_COLOR_ON = Color.WHITE;
    public static final Color DEFAULT_TEXT_COLOR_OFF = Color.WHITE;
    public static final Color DEFAULT_THUMB_COLOR = Color.WHITE;
    private static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass((String)"selected");
    private ObjectProperty<Paint> switchColor;
    private ObjectProperty<Paint> textColorOn;
    private ObjectProperty<Paint> textColorOff;
    private ObjectProperty<Paint> thumbColor;
    private ObjectProperty<ToggleGroup> toggleGroup;
    private BooleanProperty selected;
    private ObjectProperty<EventHandler<SelectionEvent>> onSelect = new ObjectPropertyBase<EventHandler<SelectionEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onSelect";
        }
    };
    private ObjectProperty<EventHandler<SelectionEvent>> onDeselect = new ObjectPropertyBase<EventHandler<SelectionEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onDeselect";
        }
    };

    public OnOffSwitch() {
        this.getStyleClass().setAll((Object[])new String[]{"on-off-switch"});
    }

    public final boolean isSelected() {
        return null == this.selected ? false : this.selected.get();
    }

    public final void setSelected(boolean SELECTED) {
        this.selectedProperty().set(SELECTED);
    }

    public final BooleanProperty selectedProperty() {
        if (null == this.selected) {
            this.selected = new BooleanPropertyBase(){

                protected void invalidated() {
                    if (null != OnOffSwitch.this.getToggleGroup()) {
                        if (this.get()) {
                            OnOffSwitch.this.getToggleGroup().selectToggle((Toggle)OnOffSwitch.this);
                        } else if (OnOffSwitch.this.getToggleGroup().getSelectedToggle() == OnOffSwitch.this) {
                            OnOffSwitch.this.getToggleGroup().selectToggle(null);
                        }
                    }
                    if (OnOffSwitch.this.selected.get()) {
                        OnOffSwitch.this.fireSelectionEvent(new SelectionEvent((Object)this, null, SelectionEvent.SELECT));
                    } else {
                        OnOffSwitch.this.fireSelectionEvent(new SelectionEvent((Object)this, null, SelectionEvent.DESELECT));
                    }
                    OnOffSwitch.this.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, this.get());
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "on";
                }
            };
        }
        return this.selected;
    }

    public final ToggleGroup getToggleGroup() {
        return null == this.toggleGroup ? null : (ToggleGroup)this.toggleGroup.get();
    }

    public final void setToggleGroup(ToggleGroup value) {
        this.toggleGroupProperty().set((Object)value);
    }

    public final ObjectProperty<ToggleGroup> toggleGroupProperty() {
        if (null == this.toggleGroup) {
            this.toggleGroup = new ObjectPropertyBase<ToggleGroup>(){
                private ToggleGroup oldToggleGroup;

                protected void invalidated() {
                    ToggleGroup toggleGroup = (ToggleGroup)this.get();
                    if (null != toggleGroup && !toggleGroup.getToggles().contains((Object)OnOffSwitch.this)) {
                        if (this.oldToggleGroup != null) {
                            this.oldToggleGroup.getToggles().remove((Object)OnOffSwitch.this);
                        }
                        toggleGroup.getToggles().add((Object)OnOffSwitch.this);
                    } else if (null == toggleGroup) {
                        this.oldToggleGroup.getToggles().remove((Object)OnOffSwitch.this);
                    }
                    this.oldToggleGroup = toggleGroup;
                }

                public Object getBean() {
                    return OnOffSwitch.this;
                }

                public String getName() {
                    return "toggleGroup";
                }
            };
        }
        return this.toggleGroup;
    }

    public final Paint getSwitchColor() {
        return null == this.switchColor ? DEFAULT_SWITCH_COLOR : (Paint)this.switchColor.get();
    }

    public final void setSwitchColor(Paint value) {
        this.switchColorProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> switchColorProperty() {
        if (null == this.switchColor) {
            this.switchColor = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SWITCH_COLOR){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SWITCH_COLOR;
                }

                public Object getBean() {
                    return OnOffSwitch.this;
                }

                public String getName() {
                    return "switchColor";
                }
            };
        }
        return this.switchColor;
    }

    public final Paint getTextColorOn() {
        return null == this.textColorOn ? DEFAULT_TEXT_COLOR_ON : (Paint)this.textColorOn.get();
    }

    public final void setTextColorOn(Paint value) {
        this.textColorOnProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> textColorOnProperty() {
        if (null == this.textColorOn) {
            this.textColorOn = new StyleableObjectProperty<Paint>((Paint)DEFAULT_TEXT_COLOR_ON){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.TEXT_COLOR_ON;
                }

                public Object getBean() {
                    return OnOffSwitch.this;
                }

                public String getName() {
                    return "switchColor";
                }
            };
        }
        return this.textColorOn;
    }

    public final Paint getTextColorOff() {
        return null == this.textColorOff ? DEFAULT_TEXT_COLOR_OFF : (Paint)this.textColorOff.get();
    }

    public final void setTextColorOff(Paint value) {
        this.textColorOffProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> textColorOffProperty() {
        if (null == this.textColorOff) {
            this.textColorOff = new StyleableObjectProperty<Paint>((Paint)DEFAULT_TEXT_COLOR_OFF){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.TEXT_COLOR_OFF;
                }

                public Object getBean() {
                    return OnOffSwitch.this;
                }

                public String getName() {
                    return "textColorOff";
                }
            };
        }
        return this.textColorOff;
    }

    public final Paint getThumbColor() {
        return null == this.thumbColor ? DEFAULT_THUMB_COLOR : (Paint)this.thumbColor.get();
    }

    public final void setThumbColor(Paint value) {
        this.thumbColorProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> thumbColorProperty() {
        if (null == this.thumbColor) {
            this.thumbColor = new StyleableObjectProperty<Paint>((Paint)DEFAULT_THUMB_COLOR){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.THUMB_COLOR;
                }

                public Object getBean() {
                    return OnOffSwitch.this;
                }

                public String getName() {
                    return "thumbColor";
                }
            };
        }
        return this.thumbColor;
    }

    protected Skin createDefaultSkin() {
        return new OnOffSwitchSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("onoffswitch.css").toExternalForm();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return OnOffSwitch.getClassCssMetaData();
    }

    public final ObjectProperty<EventHandler<SelectionEvent>> onSelectProperty() {
        return this.onSelect;
    }

    public final void setOnSelect(EventHandler<SelectionEvent> value) {
        this.onSelectProperty().set(value);
    }

    public final EventHandler<SelectionEvent> getOnSelect() {
        return (EventHandler)this.onSelectProperty().get();
    }

    public final ObjectProperty<EventHandler<SelectionEvent>> onDeselectProperty() {
        return this.onDeselect;
    }

    public final void setOnDeselect(EventHandler<SelectionEvent> value) {
        this.onDeselectProperty().set(value);
    }

    public final EventHandler<SelectionEvent> getOnDeselect() {
        return (EventHandler)this.onDeselectProperty().get();
    }

    public void fireSelectionEvent(SelectionEvent EVENT) {
        this.fireEvent(EVENT);
        EventType TYPE = EVENT.getEventType();
        Object HANDLER = SelectionEvent.SELECT == TYPE ? this.getOnSelect() : (SelectionEvent.DESELECT == TYPE ? this.getOnDeselect() : null);
        if (null == HANDLER) {
            return;
        }
        HANDLER.handle((Event)EVENT);
    }

    private static class StyleableProperties {
        private static final CssMetaData<OnOffSwitch, Paint> SWITCH_COLOR = new CssMetaData<OnOffSwitch, Paint>("-switch-color", StyleConverter.getPaintConverter(), (Paint)DEFAULT_SWITCH_COLOR){

            public boolean isSettable(OnOffSwitch onOffSwitch) {
                return null == onOffSwitch.switchColor || !onOffSwitch.switchColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(OnOffSwitch onOffSwitch) {
                return (StyleableProperty)onOffSwitch.switchColorProperty();
            }

            public Color getInitialValue(OnOffSwitch onOffSwitch) {
                return (Color)onOffSwitch.getSwitchColor();
            }
        };
        private static final CssMetaData<OnOffSwitch, Paint> TEXT_COLOR_ON = new CssMetaData<OnOffSwitch, Paint>("-text-color-on", StyleConverter.getPaintConverter(), (Paint)DEFAULT_TEXT_COLOR_ON){

            public boolean isSettable(OnOffSwitch onOffSwitch) {
                return null == onOffSwitch.textColorOn || !onOffSwitch.textColorOn.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(OnOffSwitch onOffSwitch) {
                return (StyleableProperty)onOffSwitch.textColorOnProperty();
            }

            public Color getInitialValue(OnOffSwitch onOffSwitch) {
                return (Color)onOffSwitch.getTextColorOn();
            }
        };
        private static final CssMetaData<OnOffSwitch, Paint> TEXT_COLOR_OFF = new CssMetaData<OnOffSwitch, Paint>("-text-color-off", StyleConverter.getPaintConverter(), (Paint)DEFAULT_TEXT_COLOR_OFF){

            public boolean isSettable(OnOffSwitch onOffSwitch) {
                return null == onOffSwitch.textColorOff || !onOffSwitch.textColorOff.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(OnOffSwitch onOffSwitch) {
                return (StyleableProperty)onOffSwitch.textColorOffProperty();
            }

            public Color getInitialValue(OnOffSwitch onOffSwitch) {
                return (Color)onOffSwitch.getTextColorOff();
            }
        };
        private static final CssMetaData<OnOffSwitch, Paint> THUMB_COLOR = new CssMetaData<OnOffSwitch, Paint>("-thumb-color", StyleConverter.getPaintConverter(), (Paint)DEFAULT_THUMB_COLOR){

            public boolean isSettable(OnOffSwitch onOffSwitch) {
                return null == onOffSwitch.thumbColor || !onOffSwitch.thumbColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(OnOffSwitch onOffSwitch) {
                return (StyleableProperty)onOffSwitch.thumbColorProperty();
            }

            public Color getInitialValue(OnOffSwitch onOffSwitch) {
                return (Color)onOffSwitch.getThumbColor();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, SWITCH_COLOR, TEXT_COLOR_ON, TEXT_COLOR_OFF, THUMB_COLOR);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

