/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.vumeter;

import eu.hansolo.enzo.common.Section;
import eu.hansolo.enzo.vumeter.skin.VuMeterSkin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Orientation;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class VuMeter
extends Control {
    private static final Color DEFAULT_SECTION_FILL_0 = Color.web((String)"#f3622d");
    private static final Color DEFAULT_SECTION_FILL_1 = Color.web((String)"#fba71b");
    private static final Color DEFAULT_SECTION_FILL_2 = Color.web((String)"#57b757");
    private static final Color DEFAULT_SECTION_FILL_3 = Color.web((String)"#f5982b");
    private static final Color DEFAULT_SECTION_FILL_4 = Color.web((String)"#41a9c9");
    private static final Color DEFAULT_SECTION_FILL_5 = Color.web((String)"#4258c9");
    private static final Color DEFAULT_SECTION_FILL_6 = Color.web((String)"#9a42c8");
    private static final Color DEFAULT_SECTION_FILL_7 = Color.web((String)"#c84164");
    private static final Color DEFAULT_SECTION_FILL_8 = Color.web((String)"#888888");
    private static final Color DEFAULT_SECTION_FILL_9 = Color.web((String)"#aaaaaa");
    private ObjectProperty<Paint> sectionFill0;
    private ObjectProperty<Paint> sectionFill1;
    private ObjectProperty<Paint> sectionFill2;
    private ObjectProperty<Paint> sectionFill3;
    private ObjectProperty<Paint> sectionFill4;
    private double _value;
    private DoubleProperty value;
    private double _minValue;
    private DoubleProperty minValue;
    private double _maxValue;
    private DoubleProperty maxValue;
    private Orientation _orientation;
    private ObjectProperty<Orientation> orientation;
    private int _noOfLeds;
    private IntegerProperty noOfLeds;
    private double _ledSpacing;
    private DoubleProperty ledSpacing;
    private boolean _peakValueVisible = false;
    private BooleanProperty peakValueVisible;
    private ObservableList<Section> sections;
    private boolean _interactive;
    private BooleanProperty interactive;

    public VuMeter() {
        this.getStyleClass().add((Object)"vu-meter");
        this._value = 0.0;
        this._minValue = 0.0;
        this._maxValue = 1.0;
        this._orientation = Orientation.HORIZONTAL;
        this._noOfLeds = 15;
        this._ledSpacing = 3.0;
        this.sections = FXCollections.observableArrayList();
        this._interactive = false;
    }

    public final double getValue() {
        return null == this.value ? this._value : this.value.get();
    }

    public final void setValue(double VALUE) {
        if (this.isInteractive()) {
            return;
        }
        if (null == this.value) {
            this._value = this.clamp(this.getMinValue(), this.getMaxValue(), VALUE);
        } else {
            this.value.set(this.clamp(this.getMinValue(), this.getMaxValue(), VALUE));
        }
    }

    public final ReadOnlyDoubleProperty valueProperty() {
        if (null == this.value) {
            this.value = new SimpleDoubleProperty((Object)this, "value", this._value);
        }
        return this.value;
    }

    public final double getMinValue() {
        return null == this.minValue ? this._minValue : this.minValue.get();
    }

    public final void setMinValue(double MIN_VALUE) {
        if (null == this.minValue) {
            this._minValue = this.clamp(-1.7976931348623157E308, this.getMaxValue(), MIN_VALUE);
        } else {
            this.minValue.set(this.clamp(-1.7976931348623157E308, this.getMaxValue(), MIN_VALUE));
        }
    }

    public final ReadOnlyDoubleProperty minValueProperty() {
        if (null == this.minValue) {
            this.minValue = new SimpleDoubleProperty((Object)this, "minValue", this._minValue);
        }
        return this.minValue;
    }

    public final double getMaxValue() {
        return null == this.maxValue ? this._maxValue : this.maxValue.get();
    }

    public final void setMaxValue(double MAX_VALUE) {
        if (null == this.maxValue) {
            this._maxValue = this.clamp(this.getMinValue(), Double.MAX_VALUE, MAX_VALUE);
        } else {
            this.maxValue.set(this.clamp(this.getMinValue(), Double.MAX_VALUE, MAX_VALUE));
        }
    }

    public final ReadOnlyDoubleProperty maxValueProperty() {
        if (null == this.maxValue) {
            this.maxValue = new SimpleDoubleProperty((Object)this, "maxValue", this._maxValue);
        }
        return this.maxValue;
    }

    public final Orientation getOrientation() {
        return null == this.orientation ? this._orientation : (Orientation)this.orientation.get();
    }

    public final void setOrientation(Orientation ORIENTATION) {
        if (null == this.orientation) {
            this._orientation = ORIENTATION;
        } else {
            this.orientation.set((Object)ORIENTATION);
        }
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (null == this.orientation) {
            this.orientation = new SimpleObjectProperty((Object)this, "orientation", (Object)this._orientation);
        }
        return this.orientation;
    }

    public final int getNoOfLeds() {
        return null == this.noOfLeds ? this._noOfLeds : this.noOfLeds.get();
    }

    public final void setNoOfLeds(int NO_OF_LEDS) {
        if (null == this.noOfLeds) {
            this._noOfLeds = this.clamp(2, Integer.MAX_VALUE, NO_OF_LEDS);
        } else {
            this.noOfLeds.set(this.clamp(2, Integer.MAX_VALUE, NO_OF_LEDS));
        }
    }

    public final ReadOnlyIntegerProperty noOfLedsProperty() {
        if (null == this.noOfLeds) {
            this.noOfLeds = new SimpleIntegerProperty((Object)this, "noOfLeds", this._noOfLeds);
        }
        return this.noOfLeds;
    }

    public final double getLedSpacing() {
        return null == this.ledSpacing ? this._ledSpacing : this.ledSpacing.get();
    }

    public final void setLedSpacing(double LED_SPACING) {
        if (null == this.ledSpacing) {
            this._ledSpacing = this.clamp(0.0, Double.MAX_VALUE, LED_SPACING);
        } else {
            this.ledSpacing.set(this.clamp(0.0, Double.MAX_VALUE, LED_SPACING));
        }
    }

    public final ReadOnlyDoubleProperty ledSpacingProperty() {
        if (null == this.ledSpacing) {
            this.ledSpacing = new SimpleDoubleProperty((Object)this, "ledSpacing", this._ledSpacing);
        }
        return this.ledSpacing;
    }

    public final boolean isPeakValueVisible() {
        return null == this.peakValueVisible ? this._peakValueVisible : this.peakValueVisible.get();
    }

    public final void setPeakValueVisible(boolean PEAK_VALUE_VISIBLE) {
        if (null == this.peakValueVisible) {
            this._peakValueVisible = PEAK_VALUE_VISIBLE;
        } else {
            this.peakValueVisible.set(PEAK_VALUE_VISIBLE);
        }
    }

    public final BooleanProperty peakValueVisibleProperty() {
        if (null == this.peakValueVisible) {
            this.peakValueVisible = new SimpleBooleanProperty((Object)this, "peakValueVisible", this._peakValueVisible);
        }
        return this.peakValueVisible;
    }

    public final ObservableList<Section> getSections() {
        return this.sections;
    }

    public final void setSections(List<Section> SECTIONS) {
        this.sections.setAll(SECTIONS);
    }

    public final void setSections(Section ... SECTIONS) {
        this.setSections(Arrays.asList(SECTIONS));
    }

    public final void addSection(Section SECTION) {
        if (!this.sections.contains((Object)SECTION)) {
            this.sections.add((Object)SECTION);
        }
    }

    public final void removeSection(Section SECTION) {
        if (this.sections.contains((Object)SECTION)) {
            this.sections.remove((Object)SECTION);
        }
    }

    public final boolean isInteractive() {
        return null == this.interactive ? this._interactive : this.interactive.get();
    }

    public final void setInteractive(boolean INTERACTIVE) {
        if (null == this.interactive) {
            this._interactive = INTERACTIVE;
        } else {
            this.interactive.set(INTERACTIVE);
        }
    }

    public final BooleanProperty interactiveProperty() {
        if (null == this.interactive) {
            this.interactive = new SimpleBooleanProperty((Object)this, "interactive", this._interactive);
        }
        return this.interactive;
    }

    public final Paint getSectionFill0() {
        return null == this.sectionFill0 ? DEFAULT_SECTION_FILL_0 : (Paint)this.sectionFill0.get();
    }

    public final void setSectionFill0(Paint value) {
        this.sectionFill0Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill0Property() {
        if (null == this.sectionFill0) {
            this.sectionFill0 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_0){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_0;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "sectionFill0";
                }
            };
        }
        return this.sectionFill0;
    }

    public final Paint getSectionFill1() {
        return null == this.sectionFill1 ? DEFAULT_SECTION_FILL_1 : (Paint)this.sectionFill1.get();
    }

    public final void setSectionFill1(Paint value) {
        this.sectionFill1Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill1Property() {
        if (null == this.sectionFill1) {
            this.sectionFill1 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_1){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_1;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "sectionFill1";
                }
            };
        }
        return this.sectionFill1;
    }

    public final Paint getSectionFill2() {
        return null == this.sectionFill2 ? DEFAULT_SECTION_FILL_2 : (Paint)this.sectionFill2.get();
    }

    public final void setSectionFill2(Paint value) {
        this.sectionFill2Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill2Property() {
        if (null == this.sectionFill2) {
            this.sectionFill2 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_2){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_2;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "sectionFill2";
                }
            };
        }
        return this.sectionFill2;
    }

    public final Paint getSectionFill3() {
        return null == this.sectionFill3 ? DEFAULT_SECTION_FILL_3 : (Paint)this.sectionFill3.get();
    }

    public final void setSectionFill3(Paint value) {
        this.sectionFill3Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill3Property() {
        if (null == this.sectionFill3) {
            this.sectionFill3 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_3){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_3;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "sectionFill3";
                }
            };
        }
        return this.sectionFill3;
    }

    public final Paint getSectionFill4() {
        return null == this.sectionFill4 ? DEFAULT_SECTION_FILL_4 : (Paint)this.sectionFill4.get();
    }

    public final void setSectionFill4(Paint value) {
        this.sectionFill4Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill4Property() {
        if (null == this.sectionFill4) {
            this.sectionFill4 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_4){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_4;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "sectionFill4";
                }
            };
        }
        return this.sectionFill4;
    }

    private double clamp(double MIN_VALUE, double MAX_VALUE, double VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    private int clamp(int MIN_VALUE, int MAX_VALUE, int VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    protected Skin createDefaultSkin() {
        return new VuMeterSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("vumeter.css").toExternalForm();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return VuMeter.getClassCssMetaData();
    }

    static /* synthetic */ Color access$500() {
        return DEFAULT_SECTION_FILL_0;
    }

    static /* synthetic */ Color access$700() {
        return DEFAULT_SECTION_FILL_1;
    }

    static /* synthetic */ Color access$900() {
        return DEFAULT_SECTION_FILL_2;
    }

    static /* synthetic */ Color access$1100() {
        return DEFAULT_SECTION_FILL_3;
    }

    static /* synthetic */ Color access$1300() {
        return DEFAULT_SECTION_FILL_4;
    }

    private static class StyleableProperties {
        private static final CssMetaData<VuMeter, Paint> SECTION_FILL_0 = new CssMetaData<VuMeter, Paint>("-section-fill-0", StyleConverter.getPaintConverter(), (Paint)VuMeter.access$500()){

            public boolean isSettable(VuMeter gauge) {
                return null == gauge.sectionFill0 || !gauge.sectionFill0.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(VuMeter gauge) {
                return (StyleableProperty)gauge.sectionFill0Property();
            }

            public Paint getInitialValue(VuMeter gauge) {
                return gauge.getSectionFill0();
            }
        };
        private static final CssMetaData<VuMeter, Paint> SECTION_FILL_1 = new CssMetaData<VuMeter, Paint>("-section-fill-1", StyleConverter.getPaintConverter(), (Paint)VuMeter.access$700()){

            public boolean isSettable(VuMeter gauge) {
                return null == gauge.sectionFill1 || !gauge.sectionFill1.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(VuMeter gauge) {
                return (StyleableProperty)gauge.sectionFill1Property();
            }

            public Paint getInitialValue(VuMeter gauge) {
                return gauge.getSectionFill1();
            }
        };
        private static final CssMetaData<VuMeter, Paint> SECTION_FILL_2 = new CssMetaData<VuMeter, Paint>("-section-fill-2", StyleConverter.getPaintConverter(), (Paint)VuMeter.access$900()){

            public boolean isSettable(VuMeter gauge) {
                return null == gauge.sectionFill2 || !gauge.sectionFill2.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(VuMeter gauge) {
                return (StyleableProperty)gauge.sectionFill2Property();
            }

            public Paint getInitialValue(VuMeter gauge) {
                return gauge.getSectionFill2();
            }
        };
        private static final CssMetaData<VuMeter, Paint> SECTION_FILL_3 = new CssMetaData<VuMeter, Paint>("-section-fill-3", StyleConverter.getPaintConverter(), (Paint)VuMeter.access$1100()){

            public boolean isSettable(VuMeter gauge) {
                return null == gauge.sectionFill3 || !gauge.sectionFill3.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(VuMeter gauge) {
                return (StyleableProperty)gauge.sectionFill3Property();
            }

            public Paint getInitialValue(VuMeter gauge) {
                return gauge.getSectionFill3();
            }
        };
        private static final CssMetaData<VuMeter, Paint> SECTION_FILL_4 = new CssMetaData<VuMeter, Paint>("-section-fill-4", StyleConverter.getPaintConverter(), (Paint)VuMeter.access$1300()){

            public boolean isSettable(VuMeter gauge) {
                return null == gauge.sectionFill4 || !gauge.sectionFill4.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(VuMeter gauge) {
                return (StyleableProperty)gauge.sectionFill4Property();
            }

            public Paint getInitialValue(VuMeter gauge) {
                return gauge.getSectionFill4();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, SECTION_FILL_0, SECTION_FILL_1, SECTION_FILL_2, SECTION_FILL_3, SECTION_FILL_4);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

