# Release notes for version 0.5, 20240307

```
/******************************************************************************
 * This file is part of The Unicode Tools Of Rexx (TUTOR)                     *
 * See https://rexx.epbcn.com/TUTOR/                                          *
 *     and https://github.com/JosepMariaBlasco/TUTOR                          *
 * Copyright © 2023-2025 Josep Maria Blasco <josep.maria.blasco@epbcn.com>    *
 * License: Apache License 2.0 (https://www.apache.org/licenses/LICENSE-2.0)  *
 ******************************************************************************/
```

New and changed features in the 0.5 release are:

* Implementations of NFC normalization (``toNFC`` and ``isNFC`` functions).
* Addition of a new GRAPHEMES string type. TEXT auto-normalizes to NFC at creation time (this includes the results of operations and built-ins),
  while GRAPHEMES does perform any automatical normalization. Both GRAPHEMES and TEXT can be used as targets when opening a Unicode-enabled stream.
* Implement loose matching for property names (UNICODE BIF).
* Implement all tests in NormalizationTest.txt, consistency check on ccc and canonical decomposition.
* InspectTokens: add options to select different dialects, specify default in the help display.
* New ``rxutry.rex`` utility, a modification of ``rexxtry.rex`` with Unicode support.
* ``Options DefaultString`` and ``Options Promote`` can be set by the caller. Make Options DefaultString TEXT the default.
* Added [a new helpfile](using-tutor-from-classic-rexx/) detailing how to use some of the TUTOR-generated data files from Classic Rexx dialects like Regina.

Bugs fixed:

* Fix [bug #6](https://github.com/RexxLA/rexx-repository/issues/6)
* RXU: do not translate BIF names after a twiddle.

Documentation additions and enhancements:

* Document [the Unicode.Normalization class](properties/normalization/).
* Document many of the properties currently implemented by the UNICODE BIF.
* Move notes for old releases to separate files in the ``doc`` subdirectory.
* Improve the docs for the PersistentStringTable class, and move them to [a separate helpfile](./persistent-string-table/).

## \[Cumulative change log since release 0.4b\]

* (February) &mdash; Write two proof-of-concept programs to show how to use TUTOR-generated files from Classic Rexx.
* 20240205 &mdash; rxutry.rex autoloads path. Unicode.cls: Options DefaultString and Promote can be set by the caller; make Options DefaultString TEXT the default.
* 20240204 &mdash; Add rxutry.rex utility (needs previous setenv).
* 20240203 &mdash; Samples: add nfc.rxu. Unicode.cls: Rename TEXT to GRAPHEMES class; add new TEXT subclass GRAPHEMES; TEXT auto-nfc on NEW.
* 20240130 &mdash; InspectTokens: add options to select different dialects, specify default in the help display.
* 20240128 &mdash; RXU: Function names are not translated after a double twiddle. Unicode.cls and RXU: rename !!DS to !DS.
* 20240121 &mdash; Start to document the GRAPHEMES string type.
* 20231020 &mdash; Implement loose matching for property names. Move release notes for old releases to separate files in the ``doc`` directory.
* 20231017-18 &mdash; Document many properties for the UNICODE BIF, prepare for the introduction of the GRAPHEMES STRINGTYPE and class, add new tests, prepare for NFC.
* 20231015 &mdash; Fix [bug #6](https://github.com/RexxLA/rexx-repository/issues/6), implement all tests in NormalizationTest.txt, consistency check on ccc and canonical decomposition. Document
  [the Unicode.Normalization class](properties/normalization/). Improve the docs for the PersistentStringTable class, and move them to
  [a separate helpfile](./persistent-string-table/).
* 20231101 &mdash; First version of isNFC and toNFC, add CHANGESTR BIF, two new samples.
