/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.test.engineTests;

import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.test.BSFEngineTestTmpl;

public class jaclTest
extends BSFEngineTestTmpl {
    private BSFEngine jaclEngine;

    public jaclTest(String string) {
        super(string);
    }

    @Override
    public void setUp() {
        super.setUp();
        try {
            this.jaclEngine = this.bsfManager.loadScriptingEngine("jacl");
        }
        catch (Exception exception) {
            jaclTest.fail((String)this.failMessage("Failure attempting to load jacl", exception));
        }
    }

    public void testExec() {
        try {
            this.jaclEngine.exec("Test.jacl", 0, 0, "puts -nonewline \"PASSED\"");
        }
        catch (Exception exception) {
            jaclTest.fail((String)this.failMessage("exec() test failed", exception));
        }
        jaclTest.assertEquals((String)"PASSED", (String)this.getTmpOutStr());
    }

    public void testEval() {
        Integer n = null;
        try {
            n = (Integer)this.jaclEngine.eval("Test.jacl", 0, 0, "expr 1 + 1");
        }
        catch (Exception exception) {
            jaclTest.fail((String)this.failMessage("eval() test failed", exception));
        }
        jaclTest.assertEquals((Object)new Integer(2), (Object)n);
    }

    public void testCall() {
        Object[] objectArray = new Object[]{new Integer(1)};
        Integer n = null;
        try {
            this.jaclEngine.exec("Test.jacl", 0, 0, "proc addOne {f} {\n return [expr $f + 1]\n}");
            n = (Integer)this.jaclEngine.call(null, "addOne", objectArray);
        }
        catch (Exception exception) {
            jaclTest.fail((String)this.failMessage("call() test failed", exception));
        }
        jaclTest.assertEquals((Object)new Integer(2), n);
    }

    public void testIexec() {
        try {
            this.jaclEngine.iexec("Test.jacl", 0, 0, "puts -nonewline \"PASSED\"");
        }
        catch (Exception exception) {
            jaclTest.fail((String)this.failMessage("iexec() test failed", exception));
        }
        jaclTest.assertEquals((String)"PASSED", (String)this.getTmpOutStr());
    }

    public void testBSFManagerEval() {
        Integer n = null;
        try {
            n = (Integer)this.bsfManager.eval("jacl", "Test.jacl", 0, 0, "expr 1 + 1");
        }
        catch (Exception exception) {
            jaclTest.fail((String)this.failMessage("BSFManager eval() test failed", exception));
        }
        jaclTest.assertEquals((Object)new Integer(2), (Object)n);
    }

    public void testRegisterBean() {
        Integer n = new Integer(1);
        Integer n2 = null;
        try {
            this.bsfManager.registerBean("foo", n);
            n2 = (Integer)this.jaclEngine.eval("Test.jacl", 0, 0, "bsf lookupBean \"foo\"");
        }
        catch (Exception exception) {
            jaclTest.fail((String)this.failMessage("registerBean() test failed", exception));
        }
        jaclTest.assertEquals((Object)n, n2);
    }

    public void testUnregisterBean() {
        Integer n = new Integer(1);
        Integer n2 = null;
        try {
            this.bsfManager.registerBean("foo", n);
            this.bsfManager.unregisterBean("foo");
            n2 = (Integer)this.jaclEngine.eval("Test.jacl", 0, 0, "bsf lookupBean \"foo\"");
        }
        catch (BSFException bSFException) {
        }
        catch (Exception exception) {
            jaclTest.fail((String)this.failMessage("unregisterBean() test failed", exception));
        }
        jaclTest.assertNull(n2);
    }

    public void testDeclareBean() {
        Integer n = new Integer(1);
        Integer n2 = null;
        try {
            this.bsfManager.declareBean("foo", n, Integer.class);
            n2 = (Integer)this.jaclEngine.eval("Test.jacl", 0, 0, "proc ret {} {\n upvar 1 foo lfoo\n return $lfoo\n }\n ret");
        }
        catch (Exception exception) {
            jaclTest.fail((String)this.failMessage("declareBean() test failed", exception));
        }
        jaclTest.assertEquals((Object)n, n2);
    }

    public void testUndeclareBean() {
        Integer n = new Integer(1);
        Integer n2 = null;
        try {
            this.bsfManager.declareBean("foo", n, Integer.class);
            this.bsfManager.undeclareBean("foo");
            n2 = (Integer)this.jaclEngine.eval("Test.jacl", 0, 0, "expr $foo + 1");
        }
        catch (Exception exception) {
            jaclTest.fail((String)this.failMessage("undeclareBean() test failed", exception));
        }
        jaclTest.assertEquals((Object)n, n2);
    }
}

