/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util.type;

import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import org.apache.bsf.util.type.TypeConvertor;

public class TypeConvertorRegistry {
    Hashtable reg = new Hashtable();
    Hashtable keyedReg = new Hashtable();

    public TypeConvertorRegistry() {
        TypeConvertor typeConvertor = new TypeConvertor(){

            @Override
            public Object convert(Class clazz, Class clazz2, Object object) {
                return object;
            }

            @Override
            public String getCodeGenString() {
                return "(Class from, Class to, Object obj) {\nreturn obj;\n}";
            }
        };
        this.register(Boolean.class, Boolean.TYPE, typeConvertor);
        this.register(Boolean.TYPE, Boolean.class, typeConvertor);
        this.register(Byte.class, Byte.TYPE, typeConvertor);
        this.register(Byte.TYPE, Byte.class, typeConvertor);
        this.register(Character.class, Character.TYPE, typeConvertor);
        this.register(Character.TYPE, Character.class, typeConvertor);
        this.register(Short.class, Short.TYPE, typeConvertor);
        this.register(Short.TYPE, Short.class, typeConvertor);
        this.register(Integer.class, Integer.TYPE, typeConvertor);
        this.register(Integer.TYPE, Integer.class, typeConvertor);
        this.register(Long.class, Long.TYPE, typeConvertor);
        this.register(Long.TYPE, Long.class, typeConvertor);
        this.register(Float.class, Float.TYPE, typeConvertor);
        this.register(Float.TYPE, Float.class, typeConvertor);
        this.register(Double.class, Double.TYPE, typeConvertor);
        this.register(Double.TYPE, Double.class, typeConvertor);
        typeConvertor = new TypeConvertor(){

            @Override
            public Object convert(Class clazz, Class clazz2, Object object) {
                return object == null ? "(null)" : object.toString();
            }

            @Override
            public String getCodeGenString() {
                return "(Class from, Class to, Object obj) {\nreturn (obj == null) ? \"(null)\" : obj.toString ();\n}";
            }
        };
        this.register(Object.class, String.class, typeConvertor);
        typeConvertor = new TypeConvertor(){

            @Override
            public Object convert(Class clazz, Class clazz2, Object object) {
                String string = (String)object;
                if (clazz2 == Boolean.class || clazz2 == Boolean.TYPE) {
                    return Boolean.valueOf(string);
                }
                if (clazz2 == Byte.class || clazz2 == Byte.TYPE) {
                    return Byte.valueOf(string);
                }
                if (clazz2 == Character.class || clazz2 == Character.TYPE) {
                    return new Character(string.charAt(0));
                }
                if (clazz2 == Short.class || clazz2 == Short.TYPE) {
                    return Short.valueOf(string);
                }
                if (clazz2 == Integer.class || clazz2 == Integer.TYPE) {
                    return Integer.valueOf(string);
                }
                if (clazz2 == Long.class || clazz2 == Long.TYPE) {
                    return Long.valueOf(string);
                }
                if (clazz2 == Float.class || clazz2 == Float.TYPE) {
                    return Float.valueOf(string);
                }
                if (clazz2 == Double.class || clazz2 == Double.TYPE) {
                    return Double.valueOf(string);
                }
                return null;
            }

            @Override
            public String getCodeGenString() {
                return "(Class from, Class to, Object obj) {\nString str = (String) obj;\nif (to == Boolean.class || to == boolean.class) {\nreturn Boolean.valueOf (str);\n} else if (to == Byte.class || to == byte.class) {\nreturn Byte.valueOf (str);\n} else if (to == Character.class || to == char.class) {\nreturn new Character (str.charAt (0));\n} else if (to == Short.class || to == short.class) {\nreturn Short.valueOf (str);\n} else if (to == Integer.class || to == int.class) {\nreturn Integer.valueOf (str);\n} else if (to == Long.class || to == long.class) {\nreturn Long.valueOf (str);\n} else if (to == Float.class || to == float.class) {\nreturn Float.valueOf (str);\n} else if (to == Double.class || to == double.class) {\nreturn Double.valueOf (str);\n} else {\nreturn null;\n}\n}";
            }
        };
        this.register(String.class, Boolean.TYPE, typeConvertor);
        this.register(String.class, Boolean.class, typeConvertor);
        this.register(String.class, Byte.TYPE, typeConvertor);
        this.register(String.class, Byte.class, typeConvertor);
        this.register(String.class, Character.TYPE, typeConvertor);
        this.register(String.class, Character.class, typeConvertor);
        this.register(String.class, Short.TYPE, typeConvertor);
        this.register(String.class, Short.class, typeConvertor);
        this.register(String.class, Integer.TYPE, typeConvertor);
        this.register(String.class, Integer.class, typeConvertor);
        this.register(String.class, Long.TYPE, typeConvertor);
        this.register(String.class, Long.class, typeConvertor);
        this.register(String.class, Float.TYPE, typeConvertor);
        this.register(String.class, Float.class, typeConvertor);
        this.register(String.class, Double.TYPE, typeConvertor);
        this.register(String.class, Double.class, typeConvertor);
        typeConvertor = new TypeConvertor(){

            @Override
            public Object convert(Class clazz, Class clazz2, Object object) {
                return Font.decode((String)object);
            }

            @Override
            public String getCodeGenString() {
                return "(Class from, Class to, Object obj) {\nreturn Font.decode ((String) obj);\n}";
            }
        };
        this.register(String.class, Font.class, typeConvertor);
        typeConvertor = new TypeConvertor(){

            @Override
            public Object convert(Class clazz, Class clazz2, Object object) {
                return Color.decode((String)object);
            }

            @Override
            public String getCodeGenString() {
                return "(Class from, Class to, Object obj) {\nreturn Color.decode ((String) obj);\n}";
            }
        };
        this.register(String.class, Color.class, typeConvertor);
    }

    public TypeConvertor lookup(Class clazz, Class clazz2) {
        String string = clazz.getName() + " -> " + clazz2.getName();
        TypeConvertor typeConvertor = (TypeConvertor)this.reg.get(string);
        if (typeConvertor == null && clazz != Void.TYPE && clazz != Void.class && clazz2 == String.class) {
            return this.lookup(Object.class, String.class);
        }
        return typeConvertor;
    }

    public TypeConvertor lookupByKey(Object object) {
        return (TypeConvertor)this.keyedReg.get(object);
    }

    public void register(Class clazz, Class clazz2, TypeConvertor typeConvertor) {
        String string = clazz.getName() + " -> " + clazz2.getName();
        this.reg.put(string, typeConvertor);
    }

    public void registerByKey(Object object, TypeConvertor typeConvertor) {
        this.keyedReg.put(object, typeConvertor);
    }
}

