/*
 * Decompiled with CFR 0.152.
 */
package org.oorexx.uno;

import com.sun.star.beans.Property;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.container.XHierarchicalNameAccess;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XTypeProvider;
import com.sun.star.reflection.XCompoundTypeDescription;
import com.sun.star.reflection.XConstantTypeDescription;
import com.sun.star.reflection.XConstantsTypeDescription;
import com.sun.star.reflection.XEnumTypeDescription;
import com.sun.star.reflection.XIdlClass;
import com.sun.star.reflection.XIdlReflection;
import com.sun.star.reflection.XIndirectTypeDescription;
import com.sun.star.reflection.XInterfaceAttributeTypeDescription;
import com.sun.star.reflection.XInterfaceMemberTypeDescription;
import com.sun.star.reflection.XInterfaceMethodTypeDescription;
import com.sun.star.reflection.XInterfaceTypeDescription;
import com.sun.star.reflection.XMethodParameter;
import com.sun.star.reflection.XModuleTypeDescription;
import com.sun.star.reflection.XPropertyTypeDescription;
import com.sun.star.reflection.XServiceTypeDescription;
import com.sun.star.reflection.XSingletonTypeDescription;
import com.sun.star.reflection.XTypeDescription;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XInterface;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;

public class RgfReflectUNO {
    public static String version = "103.20110215";
    public static boolean bDebug = false;
    private static int maxModifierValue = 0;
    static XComponentContext context = null;
    static boolean isContextAvailable = false;
    static XMultiComponentFactory xmcf = null;
    static XIdlReflection theCoreReflection = null;
    static XMultiComponentFactory theServiceManager = null;
    static XHierarchicalNameAccess theTypeDescriptionManager = null;
    static Hashtable ht = new Hashtable();
    static Hashtable ht2j = new Hashtable();
    static Hashtable ht2j_prop = new Hashtable();
    static Hashtable pa = new Hashtable();
    private static final String ENCODE_CONSTANTS_KEYWORD = "UNO_CONSTANTS";
    private static final String ENCODE_ENUM_KEYWORD = "UNO_ENUM";
    private static final String ENCODE_EXCEPTION_KEYWORD = "UNO_EXCEPTION";
    private static final String ENCODE_INTERFACE_KEYWORD = "UNO_INTERFACE";
    private static final String ENCODE_MODULE_KEYWORD = "UNO_MODULE";
    private static final String ENCODE_SERVICE_KEYWORD = "UNO_SERVICE";
    private static final String ENCODE_SINGLETON_KEYWORD = "UNO_SINGLETON";
    private static final String ENCODE_STRUCT_KEYWORD = "UNO_STRUCT";
    private static final String ENCODE_TYPEDEF_KEYWORD = "UNO_TYPEDEF";
    private static final String ENCODE_ATTRIBUTE_KEYWORD = "UNO_ATTRIBUTE";
    private static final String ENCODE_METHOD_KEYWORD = "UNO_METHOD";
    private static final String ENCODE_PROPERTY_KEYWORD = "UNO_PROPERTY";
    static final int QUERY_INTERFACE_OBJECT_BY_NAME = 1;
    static final int QUERY_INTERFACE_NAME = 2;
    static final int USE_VECTOR = 30;
    static final int GET_INTERFACES_AS_STRING = 31;
    static final int GET_INTERFACES_AS_ARRAY = 32;
    static final int SERVICE_NUMBERING = 50;
    static final int GET_SERVICES_AS_STRING = 51;
    static final int GET_SERVICES_AS_ARRAY = 52;

    private RgfReflectUNO() {
    }

    public static XComponentContext getContext() {
        return context;
    }

    public static XComponentContext setContext(XComponentContext xComponentContext) {
        try {
            if (xComponentContext == null && !isContextAvailable) {
                context = Bootstrap.bootstrap();
            } else if (xComponentContext != null) {
                if (UnoRuntime.areSame((Object)context, (Object)xComponentContext)) {
                    return xComponentContext;
                }
                context = xComponentContext;
            }
            isContextAvailable = true;
            xmcf = context.getServiceManager();
            theCoreReflection = (XIdlReflection)UnoRuntime.queryInterface(XIdlReflection.class, (Object)context.getValueByName("/singletons/com.sun.star.reflection.theCoreReflection"));
            theServiceManager = (XMultiComponentFactory)UnoRuntime.queryInterface(XMultiComponentFactory.class, (Object)context.getValueByName("/singletons/com.sun.star.lang.theServiceManager"));
            theTypeDescriptionManager = (XHierarchicalNameAccess)UnoRuntime.queryInterface(XHierarchicalNameAccess.class, (Object)context.getValueByName("/singletons/com.sun.star.reflection.theTypeDescriptionManager"));
        }
        catch (Exception exception) {
            RgfReflectUNO.say(RgfReflectUNO.class + ": sch... UNEXPECTED error, cannot bootstrap and/or retrieve singletons!");
            exception.printStackTrace();
        }
        return context;
    }

    static Object[] determineTypeClass(Object object) {
        Object[] objectArray = new Object[4];
        objectArray[2] = object;
        XIdlClass xIdlClass = null;
        boolean bl = false;
        if (object == null) {
            return objectArray;
        }
        if (object instanceof String) {
            Object object2 = null;
            try {
                object2 = theTypeDescriptionManager.getByHierarchicalName(RgfReflectUNO.check4reflection((String)object));
            }
            catch (Exception exception) {
                return objectArray;
            }
            XTypeDescription xTypeDescription = (XTypeDescription)UnoRuntime.queryInterface(XTypeDescription.class, (Object)object2);
            objectArray[0] = xTypeDescription;
            objectArray[1] = xTypeDescription.getTypeClass();
        } else {
            xIdlClass = theCoreReflection.getType(object);
            objectArray[0] = xIdlClass;
            if (xIdlClass instanceof XInterface) {
                XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)object);
                objectArray[1] = xServiceInfo != null ? TypeClass.SERVICE : xIdlClass.getTypeClass();
            }
        }
        return objectArray;
    }

    public static String getTypeName(Object object) {
        if (!isContextAvailable) {
            RgfReflectUNO.setContext(null);
        }
        if (object == null) {
            return "";
        }
        Object[] objectArray = RgfReflectUNO.determineTypeClass(object);
        if (objectArray[1] == null) {
            return "";
        }
        return (String)ht.get(objectArray[1]);
    }

    public static String getDefinition(Object object) {
        Object[] objectArray;
        if (!isContextAvailable) {
            RgfReflectUNO.setContext(null);
        }
        if ((objectArray = RgfReflectUNO.determineTypeClass(object))[1] == null) {
            return "";
        }
        objectArray[3] = new StringBuffer();
        TypeClass typeClass = (TypeClass)objectArray[1];
        if (typeClass == TypeClass.INTERFACE) {
            RgfReflectUNO.encodeInterface(objectArray);
        } else if (typeClass == TypeClass.SERVICE) {
            RgfReflectUNO.encodeService(objectArray);
        } else if (typeClass == TypeClass.CONSTANTS) {
            RgfReflectUNO.encodeConstants(objectArray);
        } else if (typeClass == TypeClass.ENUM) {
            RgfReflectUNO.encodeEnum(objectArray);
        } else if (typeClass == TypeClass.EXCEPTION) {
            RgfReflectUNO.encodeCompound(objectArray);
        } else if (typeClass == TypeClass.MODULE) {
            RgfReflectUNO.encodeModule(objectArray);
        } else if (typeClass == TypeClass.SINGLETON) {
            RgfReflectUNO.encodeSingleton(objectArray);
        } else if (typeClass == TypeClass.STRUCT) {
            RgfReflectUNO.encodeCompound(objectArray);
        } else if (typeClass == TypeClass.TYPEDEF) {
            RgfReflectUNO.encodeTypedef(objectArray);
        }
        return ((StringBuffer)objectArray[3]).toString();
    }

    static XTypeDescription getXTypeDescription(XIdlClass xIdlClass) {
        if (xIdlClass == null) {
            return null;
        }
        Object object = null;
        try {
            object = theTypeDescriptionManager.getByHierarchicalName(RgfReflectUNO.check4reflection(xIdlClass.getName()));
        }
        catch (Exception exception) {
            return null;
        }
        XTypeDescription xTypeDescription = (XTypeDescription)UnoRuntime.queryInterface(XTypeDescription.class, (Object)object);
        return xTypeDescription;
    }

    private static void encodeCompound(Object[] objectArray) {
        XTypeDescription xTypeDescription;
        XTypeDescription xTypeDescription2 = xTypeDescription = objectArray[0] instanceof XTypeDescription ? (XTypeDescription)objectArray[0] : RgfReflectUNO.getXTypeDescription((XIdlClass)objectArray[0]);
        if (xTypeDescription == null) {
            return;
        }
        StringBuffer stringBuffer = (StringBuffer)objectArray[3];
        char c = ':';
        stringBuffer.append(((TypeClass)objectArray[1] == TypeClass.STRUCT ? ENCODE_STRUCT_KEYWORD : ENCODE_EXCEPTION_KEYWORD) + "|").append(xTypeDescription.getName());
        XCompoundTypeDescription xCompoundTypeDescription = (XCompoundTypeDescription)UnoRuntime.queryInterface(XCompoundTypeDescription.class, (Object)xTypeDescription);
        if (xCompoundTypeDescription == null) {
            return;
        }
        XTypeDescription[] xTypeDescriptionArray = xCompoundTypeDescription.getMemberTypes();
        String[] stringArray = xCompoundTypeDescription.getMemberNames();
        for (int i = 0; i < stringArray.length; ++i) {
            TypeClass typeClass = xTypeDescriptionArray[i].getTypeClass();
            String string = (String)ht2j.get(typeClass);
            if (string == null) {
                string = xTypeDescriptionArray[i].getName();
            }
            stringBuffer.append(" " + stringArray[i] + "|" + string.replace(' ', '_') + c + ht.get(typeClass) + c);
            if (typeClass == TypeClass.TYPEDEF) {
                RgfReflectUNO.encodeTypedefChunk(xTypeDescriptionArray[i], stringBuffer, c);
                continue;
            }
            stringBuffer.append(c);
        }
    }

    private static void encodeConstants(Object[] objectArray) {
        XTypeDescription xTypeDescription;
        XTypeDescription xTypeDescription2 = xTypeDescription = objectArray[0] instanceof XTypeDescription ? (XTypeDescription)objectArray[0] : RgfReflectUNO.getXTypeDescription((XIdlClass)objectArray[0]);
        if (xTypeDescription == null) {
            return;
        }
        StringBuffer stringBuffer = (StringBuffer)objectArray[3];
        stringBuffer.append("UNO_CONSTANTS|").append(xTypeDescription.getName());
        XConstantsTypeDescription xConstantsTypeDescription = (XConstantsTypeDescription)UnoRuntime.queryInterface(XConstantsTypeDescription.class, (Object)xTypeDescription);
        if (xConstantsTypeDescription == null) {
            return;
        }
        XConstantTypeDescription[] xConstantTypeDescriptionArray = xConstantsTypeDescription.getConstants();
        if (xConstantTypeDescriptionArray == null) {
            return;
        }
        int n = 0;
        String string = "";
        String string2 = "";
        for (n = 0; n < xConstantTypeDescriptionArray.length; ++n) {
            RgfReflectUNO.processConstantValue(RgfReflectUNO.getUnqualifiedName(xConstantTypeDescriptionArray[n].getName()), xConstantTypeDescriptionArray[n].getConstantValue(), stringBuffer);
        }
    }

    private static void processConstantValue(String string, Object object, StringBuffer stringBuffer) {
        String string2;
        block15: {
            boolean bl = object instanceof Any;
            TypeClass typeClass = null;
            string2 = "";
            stringBuffer.append(" " + string + "|");
            if (bl) {
                typeClass = ((Any)object).getType().getTypeClass();
                string2 = (String)ht.get(typeClass);
                try {
                    Any any = (Any)object;
                    if (typeClass == TypeClass.BOOLEAN) {
                        stringBuffer.append(AnyConverter.toBoolean((Object)any) + "");
                        break block15;
                    }
                    if (typeClass == TypeClass.BYTE) {
                        stringBuffer.append(AnyConverter.toByte((Object)any) + "");
                        break block15;
                    }
                    if (typeClass == TypeClass.CHAR) {
                        stringBuffer.append(AnyConverter.toChar((Object)any) + "");
                        break block15;
                    }
                    if (typeClass == TypeClass.DOUBLE) {
                        stringBuffer.append(AnyConverter.toDouble((Object)any) + "");
                        break block15;
                    }
                    if (typeClass == TypeClass.FLOAT) {
                        stringBuffer.append(AnyConverter.toFloat((Object)any) + "");
                        break block15;
                    }
                    if (typeClass == TypeClass.LONG) {
                        stringBuffer.append(AnyConverter.toInt((Object)any) + "");
                        break block15;
                    }
                    if (typeClass == TypeClass.HYPER) {
                        stringBuffer.append(AnyConverter.toLong((Object)any) + "");
                        break block15;
                    }
                    if (typeClass == TypeClass.SHORT) {
                        stringBuffer.append(AnyConverter.toShort((Object)any) + "");
                        break block15;
                    }
                    if (typeClass == TypeClass.UNSIGNED_HYPER) {
                        stringBuffer.append(AnyConverter.toUnsignedLong((Object)any) + "");
                        break block15;
                    }
                    if (typeClass == TypeClass.UNSIGNED_LONG) {
                        stringBuffer.append(AnyConverter.toUnsignedInt((Object)any) + "");
                        break block15;
                    }
                    if (typeClass == TypeClass.UNSIGNED_SHORT) {
                        stringBuffer.append(AnyConverter.toUnsignedShort((Object)any) + "");
                        break block15;
                    }
                    stringBuffer.append("UNKNOWN:" + any);
                }
                catch (Exception exception) {
                    stringBuffer.append("EXCEPTION:_" + exception.toString().replaceAll(" ", "_"));
                }
            } else {
                string2 = object.getClass().getName();
                stringBuffer.append(object + "");
            }
        }
        stringBuffer.append("|" + string2);
    }

    private static void encodeConstants_OLD_DEPRECATED(Object[] objectArray) {
        XTypeDescription xTypeDescription;
        XTypeDescription xTypeDescription2 = xTypeDescription = objectArray[0] instanceof XTypeDescription ? (XTypeDescription)objectArray[0] : RgfReflectUNO.getXTypeDescription((XIdlClass)objectArray[0]);
        if (xTypeDescription == null) {
            return;
        }
        StringBuffer stringBuffer = (StringBuffer)objectArray[3];
        stringBuffer.append("UNO_CONSTANTS|").append(xTypeDescription.getName()).append("|");
        XConstantsTypeDescription xConstantsTypeDescription = (XConstantsTypeDescription)UnoRuntime.queryInterface(XConstantsTypeDescription.class, (Object)xTypeDescription);
        if (xConstantsTypeDescription == null) {
            return;
        }
        XConstantTypeDescription[] xConstantTypeDescriptionArray = xConstantsTypeDescription.getConstants();
        if (xConstantTypeDescriptionArray == null) {
            return;
        }
        Object object = xConstantTypeDescriptionArray[0].getConstantValue();
        boolean bl = object instanceof Any;
        TypeClass typeClass = null;
        String string = "";
        if (bl) {
            typeClass = ((Any)object).getType().getTypeClass();
            string = (String)ht.get(typeClass);
        } else {
            string = object.getClass().getName();
        }
        stringBuffer.append(string);
        int n = 0;
        String string2 = "";
        String string3 = "";
        for (n = 0; n < xConstantTypeDescriptionArray.length; ++n) {
            string3 = RgfReflectUNO.getUnqualifiedName(xConstantTypeDescriptionArray[n].getName());
            stringBuffer.append(" " + string3 + "|");
            if (bl) {
                try {
                    Any any = (Any)xConstantTypeDescriptionArray[n].getConstantValue();
                    if (typeClass == TypeClass.BOOLEAN) {
                        stringBuffer.append(AnyConverter.toBoolean((Object)any) + "");
                        continue;
                    }
                    if (typeClass == TypeClass.BYTE) {
                        stringBuffer.append(AnyConverter.toByte((Object)any) + "");
                        continue;
                    }
                    if (typeClass == TypeClass.CHAR) {
                        stringBuffer.append(AnyConverter.toChar((Object)any) + "");
                        continue;
                    }
                    if (typeClass == TypeClass.DOUBLE) {
                        stringBuffer.append(AnyConverter.toDouble((Object)any) + "");
                        continue;
                    }
                    if (typeClass == TypeClass.FLOAT) {
                        stringBuffer.append(AnyConverter.toFloat((Object)any) + "");
                        continue;
                    }
                    if (typeClass == TypeClass.LONG) {
                        stringBuffer.append(AnyConverter.toInt((Object)any) + "");
                        continue;
                    }
                    if (typeClass == TypeClass.HYPER) {
                        stringBuffer.append(AnyConverter.toLong((Object)any) + "");
                        continue;
                    }
                    if (typeClass == TypeClass.SHORT) {
                        stringBuffer.append(AnyConverter.toShort((Object)any) + "");
                        continue;
                    }
                    if (typeClass == TypeClass.UNSIGNED_HYPER) {
                        stringBuffer.append(AnyConverter.toUnsignedLong((Object)any) + "");
                        continue;
                    }
                    if (typeClass == TypeClass.UNSIGNED_LONG) {
                        stringBuffer.append(AnyConverter.toUnsignedInt((Object)any) + "");
                        continue;
                    }
                    if (typeClass == TypeClass.UNSIGNED_SHORT) {
                        stringBuffer.append(AnyConverter.toUnsignedShort((Object)any) + "");
                        continue;
                    }
                    stringBuffer.append("UNKNOWN:" + any);
                }
                catch (Exception exception) {
                    stringBuffer.append("EXCEPTION" + exception.toString());
                }
                continue;
            }
            stringBuffer.append(xConstantTypeDescriptionArray[n].getConstantValue());
        }
    }

    private static void encodeEnum(Object[] objectArray) {
        XTypeDescription xTypeDescription;
        XTypeDescription xTypeDescription2 = xTypeDescription = objectArray[0] instanceof XTypeDescription ? (XTypeDescription)objectArray[0] : RgfReflectUNO.getXTypeDescription((XIdlClass)objectArray[0]);
        if (xTypeDescription == null) {
            return;
        }
        StringBuffer stringBuffer = (StringBuffer)objectArray[3];
        stringBuffer.append("UNO_ENUM|").append(xTypeDescription.getName()).append("|");
        XEnumTypeDescription xEnumTypeDescription = (XEnumTypeDescription)UnoRuntime.queryInterface(XEnumTypeDescription.class, (Object)xTypeDescription);
        if (xEnumTypeDescription == null) {
            return;
        }
        stringBuffer.append(xEnumTypeDescription.getDefaultEnumValue());
        String[] stringArray = xEnumTypeDescription.getEnumNames();
        int[] nArray = xEnumTypeDescription.getEnumValues();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(" " + stringArray[i] + "|" + nArray[i]);
        }
    }

    private static void encodeModule(Object[] objectArray) {
        XTypeDescription xTypeDescription;
        XTypeDescription xTypeDescription2 = xTypeDescription = objectArray[0] instanceof XTypeDescription ? (XTypeDescription)objectArray[0] : RgfReflectUNO.getXTypeDescription((XIdlClass)objectArray[0]);
        if (xTypeDescription == null) {
            return;
        }
        StringBuffer stringBuffer = (StringBuffer)objectArray[3];
        stringBuffer.append("UNO_MODULE|").append(xTypeDescription.getName());
        XModuleTypeDescription xModuleTypeDescription = (XModuleTypeDescription)UnoRuntime.queryInterface(XModuleTypeDescription.class, (Object)xTypeDescription);
        if (xModuleTypeDescription == null) {
            return;
        }
        XTypeDescription[] xTypeDescriptionArray = xModuleTypeDescription.getMembers();
        for (int i = 0; i < xTypeDescriptionArray.length; ++i) {
            TypeClass typeClass = xTypeDescriptionArray[i].getTypeClass();
            String string = (String)ht2j.get(typeClass);
            if (string == null) {
                string = xTypeDescriptionArray[i].getName();
            }
            stringBuffer.append(" " + RgfReflectUNO.getUnqualifiedName(string) + "|" + ht.get(typeClass));
        }
    }

    private static void encodeSingleton(Object[] objectArray) {
        XTypeDescription xTypeDescription;
        XTypeDescription xTypeDescription2 = xTypeDescription = objectArray[0] instanceof XTypeDescription ? (XTypeDescription)objectArray[0] : RgfReflectUNO.getXTypeDescription((XIdlClass)objectArray[0]);
        if (xTypeDescription == null) {
            return;
        }
        StringBuffer stringBuffer = (StringBuffer)objectArray[3];
        stringBuffer.append("UNO_SINGLETON|").append(xTypeDescription.getName()).append("|");
        XSingletonTypeDescription xSingletonTypeDescription = (XSingletonTypeDescription)UnoRuntime.queryInterface(XSingletonTypeDescription.class, (Object)xTypeDescription);
        if (xSingletonTypeDescription == null) {
            return;
        }
        XServiceTypeDescription xServiceTypeDescription = xSingletonTypeDescription.getService();
        if (xServiceTypeDescription != null) {
            stringBuffer.append(xServiceTypeDescription.getName());
        }
    }

    private static void encodeTypedef(Object[] objectArray) {
        XTypeDescription xTypeDescription;
        XTypeDescription xTypeDescription2 = xTypeDescription = objectArray[0] instanceof XTypeDescription ? (XTypeDescription)objectArray[0] : RgfReflectUNO.getXTypeDescription((XIdlClass)objectArray[0]);
        if (xTypeDescription == null) {
            return;
        }
        StringBuffer stringBuffer = (StringBuffer)objectArray[3];
        stringBuffer.append("UNO_TYPEDEF|").append(xTypeDescription.getName() + " ");
        RgfReflectUNO.encodeTypedefChunk(xTypeDescription, stringBuffer, ':');
    }

    private static void encodeTypedefChunk(XTypeDescription xTypeDescription, StringBuffer stringBuffer, char c) {
        XIndirectTypeDescription xIndirectTypeDescription = (XIndirectTypeDescription)UnoRuntime.queryInterface(XIndirectTypeDescription.class, (Object)xTypeDescription);
        if (xIndirectTypeDescription == null) {
            return;
        }
        XTypeDescription xTypeDescription2 = xIndirectTypeDescription.getReferencedType();
        TypeClass typeClass = xTypeDescription2.getTypeClass();
        String string = (String)ht2j.get(typeClass);
        if (string == null) {
            string = xTypeDescription2.getName();
        }
        stringBuffer.append(string.replace(' ', '_') + c + ht.get(typeClass));
    }

    private static void encodeInterface(Object[] objectArray) {
        XTypeDescription xTypeDescription;
        XTypeDescription xTypeDescription2 = xTypeDescription = objectArray[0] instanceof XTypeDescription ? (XTypeDescription)objectArray[0] : RgfReflectUNO.getXTypeDescription((XIdlClass)objectArray[0]);
        if (xTypeDescription == null) {
            return;
        }
        StringBuffer stringBuffer = (StringBuffer)objectArray[3];
        char c = ':';
        stringBuffer.append("UNO_INTERFACE|").append(xTypeDescription.getName());
        XInterfaceTypeDescription xInterfaceTypeDescription = (XInterfaceTypeDescription)UnoRuntime.queryInterface(XInterfaceTypeDescription.class, (Object)xTypeDescription);
        if (xInterfaceTypeDescription == null) {
            return;
        }
        XInterfaceMemberTypeDescription[] xInterfaceMemberTypeDescriptionArray = xInterfaceTypeDescription.getMembers();
        String string = "";
        String string2 = "";
        for (int i = 0; i < xInterfaceMemberTypeDescriptionArray.length; ++i) {
            RgfReflectUNO.encode4InterfaceXIMTD(stringBuffer, xInterfaceMemberTypeDescriptionArray[i], c);
        }
    }

    static void encode4InterfaceXIMTD(StringBuffer stringBuffer, XInterfaceMemberTypeDescription xInterfaceMemberTypeDescription, char c) {
        String string = "";
        String string2 = RgfReflectUNO.getUnqualifiedName(xInterfaceMemberTypeDescription.getMemberName());
        TypeClass typeClass = xInterfaceMemberTypeDescription.getTypeClass();
        string = typeClass == TypeClass.INTERFACE_METHOD ? ENCODE_METHOD_KEYWORD : (typeClass == TypeClass.INTERFACE_ATTRIBUTE ? ENCODE_ATTRIBUTE_KEYWORD : "???" + ht.get(typeClass) + "???");
        stringBuffer.append(" " + string2 + "|" + string);
        if (typeClass == TypeClass.INTERFACE_ATTRIBUTE) {
            XInterfaceAttributeTypeDescription xInterfaceAttributeTypeDescription = (XInterfaceAttributeTypeDescription)UnoRuntime.queryInterface(XInterfaceAttributeTypeDescription.class, (Object)xInterfaceMemberTypeDescription);
            stringBuffer.append("|" + (xInterfaceAttributeTypeDescription.isReadOnly() ? "READONLY" : ""));
            XTypeDescription xTypeDescription = xInterfaceAttributeTypeDescription.getType();
            TypeClass typeClass2 = xTypeDescription.getTypeClass();
            String string3 = (String)ht2j.get(typeClass2);
            if (string3 == null) {
                string3 = xTypeDescription.getName();
            }
            stringBuffer.append("|" + string3.replace(' ', '_') + c + ht.get(typeClass2) + c);
            if (xTypeDescription.getTypeClass() == TypeClass.TYPEDEF) {
                RgfReflectUNO.encodeTypedefChunk(xTypeDescription, stringBuffer, c);
            } else {
                stringBuffer.append(c);
            }
        } else if (typeClass == TypeClass.INTERFACE_METHOD) {
            int n;
            XInterfaceMethodTypeDescription xInterfaceMethodTypeDescription = (XInterfaceMethodTypeDescription)UnoRuntime.queryInterface(XInterfaceMethodTypeDescription.class, (Object)xInterfaceMemberTypeDescription);
            if (xInterfaceMethodTypeDescription == null) {
                return;
            }
            XMethodParameter[] xMethodParameterArray = xInterfaceMethodTypeDescription.getParameters();
            XTypeDescription[] xTypeDescriptionArray = xInterfaceMethodTypeDescription.getExceptions();
            stringBuffer.append("|" + (xInterfaceMethodTypeDescription.isOneway() ? "ONEWAY" : ""));
            XTypeDescription xTypeDescription = xInterfaceMethodTypeDescription.getReturnType();
            TypeClass typeClass3 = xTypeDescription.getTypeClass();
            String string4 = (String)ht2j.get(typeClass3);
            if (string4 == null) {
                string4 = xTypeDescription.getName();
            }
            stringBuffer.append("|" + string4.replace(' ', '_') + c + ht.get(typeClass3) + c);
            if (typeClass3 == TypeClass.TYPEDEF) {
                RgfReflectUNO.encodeTypedefChunk(xTypeDescription, stringBuffer, c);
            } else {
                stringBuffer.append(c);
            }
            stringBuffer.append("|");
            for (n = 0; n < xMethodParameterArray.length; ++n) {
                xTypeDescription = xMethodParameterArray[n].getType();
                typeClass3 = xTypeDescription.getTypeClass();
                string4 = (String)ht2j.get(typeClass3);
                if (string4 == null) {
                    string4 = xTypeDescription.getName();
                }
                stringBuffer.append(string4.replace(' ', '_') + c + ht.get(typeClass3) + c);
                if (typeClass3 == TypeClass.TYPEDEF) {
                    RgfReflectUNO.encodeTypedefChunk(xTypeDescription, stringBuffer, c);
                } else {
                    stringBuffer.append(c);
                }
                if (n + 1 == xMethodParameterArray.length) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append("|");
            for (n = 0; n < xTypeDescriptionArray.length; ++n) {
                stringBuffer.append(xTypeDescriptionArray[n].getName());
                if (n + 1 == xTypeDescriptionArray.length) continue;
                stringBuffer.append(',');
            }
        }
    }

    private static void encodeService(Object[] objectArray) {
        int n;
        XServiceTypeDescription xServiceTypeDescription;
        Object object;
        String string = "";
        String string2 = "";
        String[] stringArray = new String[]{""};
        Object[][] objectArrayArray = new Object[1][];
        if (objectArray[0] instanceof XTypeDescription) {
            stringArray[0] = ((XTypeDescription)objectArray[0]).getName();
            string = stringArray[0];
            objectArrayArray[0] = objectArray;
        } else {
            object = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)objectArray[2]);
            if (object == null) {
                return;
            }
            String[] stringArray2 = object.getSupportedServiceNames();
            string2 = object.getImplementationName();
            stringArray = new String[stringArray2.length];
            objectArrayArray = new Object[stringArray2.length][];
            xServiceTypeDescription = null;
            int n2 = 0;
            n = 0;
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                string = string + (n2 > 0 ? "+" : "") + stringArray2[n2];
                xServiceTypeDescription = RgfReflectUNO.determineTypeClass(stringArray2[n2]);
                if (xServiceTypeDescription[0] != null) {
                    stringArray[n] = stringArray2[n2];
                    objectArrayArray[n] = xServiceTypeDescription;
                    ++n;
                    continue;
                }
                if (!bDebug) continue;
                RgfReflectUNO.say(RgfReflectUNO.class + ": encodeService(): no XTypeDescriptor found for: " + RgfReflectUNO.pp(stringArray[n2]) + "!");
            }
        }
        object = (StringBuffer)objectArray[3];
        ((StringBuffer)object).append("UNO_SERVICE|" + string + "|" + string2);
        for (int i = 0; i < objectArrayArray.length; ++i) {
            if (objectArrayArray[i] == null) continue;
            string = stringArray[i];
            xServiceTypeDescription = (XServiceTypeDescription)UnoRuntime.queryInterface(XServiceTypeDescription.class, (Object)objectArrayArray[i][0]);
            if (xServiceTypeDescription == null) continue;
            RgfReflectUNO.encode4ServiceXTDS((StringBuffer)object, (XTypeDescription[])xServiceTypeDescription.getMandatoryServices(), false, string);
            RgfReflectUNO.encode4ServiceXTDS((StringBuffer)object, (XTypeDescription[])xServiceTypeDescription.getOptionalServices(), true, string);
            RgfReflectUNO.encode4ServiceXTDS((StringBuffer)object, (XTypeDescription[])xServiceTypeDescription.getMandatoryInterfaces(), false, string);
            RgfReflectUNO.encode4ServiceXTDS((StringBuffer)object, (XTypeDescription[])xServiceTypeDescription.getOptionalInterfaces(), true, string);
            XPropertyTypeDescription[] xPropertyTypeDescriptionArray = xServiceTypeDescription.getProperties();
            for (n = 0; n < xPropertyTypeDescriptionArray.length; ++n) {
                ((StringBuffer)object).append(" " + RgfReflectUNO.getUnqualifiedName(xPropertyTypeDescriptionArray[n].getName()) + "|" + ENCODE_PROPERTY_KEYWORD + "|");
                RgfReflectUNO.encodePropModifier((StringBuffer)object, xPropertyTypeDescriptionArray[n].getPropertyFlags());
                XTypeDescription xTypeDescription = xPropertyTypeDescriptionArray[n].getPropertyTypeDescription();
                TypeClass typeClass = xTypeDescription.getTypeClass();
                String string3 = (String)ht2j_prop.get(typeClass);
                if (string3 == null) {
                    string3 = xTypeDescription.getName();
                }
                ((StringBuffer)object).append("|" + string3.replace(' ', '_') + ":" + ht.get(typeClass) + ":");
                if (typeClass == TypeClass.TYPEDEF) {
                    RgfReflectUNO.encodeTypedefChunk(xTypeDescription, (StringBuffer)object, ':');
                } else {
                    ((StringBuffer)object).append(':');
                }
                ((StringBuffer)object).append("|" + string);
            }
        }
    }

    private static void encode4ServiceXTDS(StringBuffer stringBuffer, XTypeDescription[] xTypeDescriptionArray, boolean bl, String string) {
        String string2 = bl ? "OPTIONAL" : "";
        for (int i = 0; i < xTypeDescriptionArray.length; ++i) {
            stringBuffer.append(" " + xTypeDescriptionArray[i].getName() + "|" + ht.get(xTypeDescriptionArray[i].getTypeClass()) + "|" + string2 + "|" + string);
        }
    }

    public static String getXTypeProviderTypeNames(Object object) {
        if (!isContextAvailable) {
            RgfReflectUNO.setContext(null);
        }
        XTypeProvider xTypeProvider = (XTypeProvider)UnoRuntime.queryInterface(XTypeProvider.class, (Object)object);
        StringBuffer stringBuffer = new StringBuffer();
        if (xTypeProvider != null) {
            Type[] typeArray = xTypeProvider.getTypes();
            for (int i = 0; i < typeArray.length; ++i) {
                stringBuffer.append((i > 0 ? " " : "") + typeArray[i].getTypeName());
            }
        }
        return stringBuffer.toString();
    }

    public static Object queryInterfaceObjectByName(Object object, String string, boolean bl) {
        if (!isContextAvailable) {
            RgfReflectUNO.setContext(null);
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            Class<?> clazz = null;
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
            }
            catch (Exception exception) {
                clazz = Class.forName(string);
            }
            return UnoRuntime.queryInterface(clazz, (Object)object);
        }
        catch (Exception exception) {
            XTypeProvider xTypeProvider = (XTypeProvider)UnoRuntime.queryInterface(XTypeProvider.class, (Object)object);
            if (xTypeProvider != null) {
                Type[] typeArray = xTypeProvider.getTypes();
                String string2 = "";
                boolean bl2 = false;
                for (int i = 0; i < typeArray.length; ++i) {
                    if (typeArray[i].getTypeClass() != TypeClass.INTERFACE || !RgfReflectUNO.compareRelaxed(string, typeArray[i].getTypeName())) continue;
                    return UnoRuntime.queryInterface((Type)typeArray[i], (Object)object);
                }
            }
            if (bDebug) {
                RgfReflectUNO.say(RgfReflectUNO.class + ": MEEEEH! queryInterfaceObjectByName() - interface " + RgfReflectUNO.pp(string) + " not found in XTypeProvider! bExtendSearch=" + bl);
            }
            if (bl) {
                return RgfReflectUNO.extendSearch(object, string, 1);
            }
            return null;
        }
    }

    public static String getInterfaceNamesViaReflection(Object object) {
        return (String)RgfReflectUNO.extendSearch(object, null, 31);
    }

    public static String getServiceNamesViaReflection(Object object) {
        return (String)RgfReflectUNO.extendSearch(object, null, 51);
    }

    static Object extendSearch(Object object, String string, int n) {
        Object[] objectArray;
        Object[] objectArray2 = RgfReflectUNO.determineTypeClass(object);
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)objectArray2[2]);
        if (xServiceInfo == null) {
            if (n == 1) {
                return null;
            }
            if (n == 32 || n == 52) {
                return new String[0];
            }
            return "";
        }
        String[] stringArray = xServiceInfo.getSupportedServiceNames();
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            linkedList.add(stringArray[i]);
        }
        Vector<String> vector = null;
        if (n > 30) {
            vector = new Vector<String>();
        }
        String string2 = "";
        String string3 = "";
        HashSet<String> hashSet = new HashSet<String>();
        while (linkedList.size() > 0) {
            int n2;
            int n3;
            string2 = (String)linkedList.removeFirst();
            if (hashSet.contains(string2)) continue;
            hashSet.add(string2);
            if (n > 50) {
                vector.add(string2);
            }
            objectArray = null;
            Object[] objectArray3 = new Object[2];
            XTypeDescription[] xTypeDescriptionArray = null;
            objectArray = RgfReflectUNO.determineTypeClass(string2);
            XServiceTypeDescription xServiceTypeDescription = (XServiceTypeDescription)UnoRuntime.queryInterface(XServiceTypeDescription.class, (Object)objectArray[0]);
            if (xServiceTypeDescription == null) continue;
            if (n < 50) {
                objectArray3[0] = xServiceTypeDescription.getMandatoryInterfaces();
                objectArray3[1] = xServiceTypeDescription.getOptionalInterfaces();
                for (n3 = 0; n3 < objectArray3.length; ++n3) {
                    xTypeDescriptionArray = (XTypeDescription[])objectArray3[n3];
                    for (n2 = 0; n2 < xTypeDescriptionArray.length; ++n2) {
                        string3 = xTypeDescriptionArray[n2].getName();
                        if (n < 30 && RgfReflectUNO.compareRelaxed(string, string3)) {
                            try {
                                if (n == 1) {
                                    String string4 = RgfReflectUNO.check4reflection(string3);
                                    Class<?> clazz = null;
                                    try {
                                        clazz = Thread.currentThread().getContextClassLoader().loadClass(string4);
                                    }
                                    catch (Exception exception) {
                                        clazz = Class.forName(string4);
                                    }
                                    return UnoRuntime.queryInterface(clazz, (Object)object);
                                }
                                if (n != 2) continue;
                                return string3;
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if (n <= 30) continue;
                        vector.add(string3);
                    }
                }
            }
            objectArray3[0] = xServiceTypeDescription.getMandatoryServices();
            objectArray3[1] = xServiceTypeDescription.getOptionalServices();
            for (n3 = 0; n3 < objectArray3.length; ++n3) {
                xTypeDescriptionArray = (XTypeDescription[])objectArray3[n3];
                for (n2 = 0; n2 < xTypeDescriptionArray.length; ++n2) {
                    linkedList.add(xTypeDescriptionArray[n2].getName());
                }
            }
        }
        if (n == 1) {
            return null;
        }
        if (n == 31 || n == 51) {
            objectArray = new StringBuffer();
            boolean bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                if (bl) {
                    objectArray.append(" ");
                } else {
                    bl = true;
                }
                objectArray.append(vector.get(i));
            }
            return objectArray.toString();
        }
        if (n == 32 || n == 52) {
            return vector.toArray(new String[0]);
        }
        return "";
    }

    private static void mistDumpTypes(Object object) {
        XTypeProvider xTypeProvider = (XTypeProvider)UnoRuntime.queryInterface(XTypeProvider.class, (Object)object);
        if (xTypeProvider != null) {
            Type[] typeArray = xTypeProvider.getTypes();
            for (int i = 0; i < typeArray.length; ++i) {
                if (!bDebug) continue;
                RgfReflectUNO.say("\t\t---mistDumpTypes[" + i + "]=" + RgfReflectUNO.pp(typeArray[i]) + " - " + RgfReflectUNO.pp(ht.get(typeArray[i].getTypeClass())));
            }
        }
    }

    private static void encodePropModifier(StringBuffer stringBuffer, short s) {
        int n = 0;
        for (int i = 1; i <= maxModifierValue; i *= 2) {
            if ((i & s) == 0) continue;
            if (n > 0) {
                stringBuffer = stringBuffer.append(",");
            } else {
                ++n;
            }
            stringBuffer.append(pa.get(new Integer(i)));
        }
    }

    public static String getProperties(Object object) {
        XPropertySetInfo xPropertySetInfo;
        if (!isContextAvailable) {
            RgfReflectUNO.setContext(null);
        }
        StringBuffer stringBuffer = new StringBuffer();
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
        if (xPropertySet != null && (xPropertySetInfo = xPropertySet.getPropertySetInfo()) != null) {
            int n = 0;
            Property[] propertyArray = xPropertySetInfo.getProperties();
            for (int i = 0; i < propertyArray.length; ++i) {
                if (n > 0) {
                    stringBuffer.append(" ");
                } else {
                    ++n;
                }
                stringBuffer.append(propertyArray[i].Name + "|" + ENCODE_PROPERTY_KEYWORD + "|");
                RgfReflectUNO.encodePropModifier(stringBuffer, propertyArray[i].Attributes);
                stringBuffer.append("|");
                TypeClass typeClass = propertyArray[i].Type.getTypeClass();
                String string = (String)ht2j_prop.get(typeClass);
                if (string == null) {
                    string = propertyArray[i].Type.getTypeName();
                }
                stringBuffer.append(string.replace(' ', '_') + ":" + ht.get(typeClass) + ":");
                if (typeClass == TypeClass.TYPEDEF) {
                    Object[] objectArray = RgfReflectUNO.determineTypeClass(string);
                    XTypeDescription xTypeDescription = (XTypeDescription)objectArray[0];
                    if (xTypeDescription == null) continue;
                    RgfReflectUNO.encodeTypedefChunk(xTypeDescription, stringBuffer, ':');
                    continue;
                }
                stringBuffer.append(':');
            }
        }
        return stringBuffer.toString();
    }

    public static Object findInterfaceWithMember(Object object, String string, boolean bl, int n, boolean bl2) {
        if (!isContextAvailable) {
            RgfReflectUNO.setContext(null);
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        if (n < 1) {
            n = 65536;
        }
        int n2 = string.length();
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        Object object2 = null;
        if (bl) {
            object2 = "";
        }
        XTypeProvider xTypeProvider = (XTypeProvider)UnoRuntime.queryInterface(XTypeProvider.class, (Object)object);
        Type[] typeArray = null;
        String string2 = "";
        String string3 = "";
        boolean bl3 = false;
        boolean bl4 = false;
        HashSet<String> hashSet = new HashSet<String>();
        if (xTypeProvider != null) {
            typeArray = xTypeProvider.getTypes();
            for (int i = 0; i < typeArray.length && n3 < n; ++i) {
                if (bDebug) {
                    RgfReflectUNO.say("\t**** i=" + i + " countFound=(" + n3 + ") < (" + n + ")=howMany; needle=" + RgfReflectUNO.pp(string));
                }
                if (typeArray[i].getTypeClass() != TypeClass.INTERFACE || hashSet.contains(string3 = typeArray[i].getTypeName())) continue;
                if (bDebug) {
                    RgfReflectUNO.say("\t\t.... findInterfaceWithMembers(): working on " + RgfReflectUNO.pp(string3) + " ...");
                }
                hashSet.add(string3);
                object2 = RgfReflectUNO.fIWM_worker(object, string, string3, bl, stringBuffer, n3, n);
                if (object2 instanceof Integer) {
                    n3 += ((Integer)object2).intValue();
                    continue;
                }
                if (object2 == null) continue;
                return object2;
            }
        }
        if (bl2 && n3 < n) {
            String[] stringArray = (String[])RgfReflectUNO.extendSearch(object, null, 32);
            for (int i = 0; i < stringArray.length && n3 < n; ++i) {
                string3 = stringArray[i];
                if (hashSet.contains(string3)) continue;
                hashSet.add(string3);
                object2 = RgfReflectUNO.fIWM_worker(object, string, string3, bl, stringBuffer, n3, n);
                if (object2 instanceof Integer) {
                    n3 += ((Integer)object2).intValue();
                    continue;
                }
                if (object2 == null) continue;
                return object2;
            }
        }
        if (bl) {
            return stringBuffer.toString();
        }
        return null;
    }

    static Object fIWM_worker(Object object, String string, String string2, boolean bl, StringBuffer stringBuffer, int n, int n2) {
        Object[] objectArray = RgfReflectUNO.determineTypeClass(string2);
        XInterfaceTypeDescription xInterfaceTypeDescription = (XInterfaceTypeDescription)UnoRuntime.queryInterface(XInterfaceTypeDescription.class, (Object)objectArray[0]);
        if (xInterfaceTypeDescription == null) {
            return null;
        }
        Object var9_9 = null;
        boolean bl2 = false;
        int n3 = 0;
        XInterfaceMemberTypeDescription[] xInterfaceMemberTypeDescriptionArray = xInterfaceTypeDescription.getMembers();
        String string3 = "";
        for (int i = 0; i < xInterfaceMemberTypeDescriptionArray.length && n < n2; ++i) {
            if (!RgfReflectUNO.compareRelaxed(string, RgfReflectUNO.getUnqualifiedName(xInterfaceMemberTypeDescriptionArray[i].getMemberName()))) continue;
            if (bl) {
                if (!bl2) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append("UNO_INTERFACE|" + string2 + "|");
                    ++n;
                    ++n3;
                    bl2 = true;
                }
                RgfReflectUNO.encode4InterfaceXIMTD(stringBuffer, xInterfaceMemberTypeDescriptionArray[i], ':');
                continue;
            }
            try {
                Class<?> clazz = null;
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(string2);
                }
                catch (Exception exception) {
                    clazz = Class.forName(string2);
                }
                return UnoRuntime.queryInterface(clazz, (Object)object);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return new Integer(n3);
    }

    public static String queryInterfaceName(Object object, String string, boolean bl) {
        if (!isContextAvailable) {
            RgfReflectUNO.setContext(null);
        }
        if (string == null || string.length() == 0) {
            return "";
        }
        int n = string.length();
        XTypeProvider xTypeProvider = (XTypeProvider)UnoRuntime.queryInterface(XTypeProvider.class, (Object)object);
        if (xTypeProvider != null) {
            String string2 = "";
            boolean bl2 = false;
            Type[] typeArray = xTypeProvider.getTypes();
            for (int i = 0; i < typeArray.length; ++i) {
                if (typeArray[i].getTypeClass() != TypeClass.INTERFACE || !RgfReflectUNO.compareRelaxed(string, string2 = typeArray[i].getTypeName())) continue;
                return string2;
            }
        }
        if (bDebug) {
            RgfReflectUNO.say(RgfReflectUNO.class + ": MEEEEH! queryInterfaceName() - interface " + RgfReflectUNO.pp(string) + " not found in XTypeProvider! bExtendSearch=" + bl);
        }
        if (bl) {
            return (String)RgfReflectUNO.extendSearch(object, string, 2);
        }
        return "";
    }

    public static String queryServiceName(Object object, String string) {
        if (!isContextAvailable) {
            RgfReflectUNO.setContext(null);
        }
        if (string == null || string.length() == 0) {
            return "";
        }
        int n = string.length();
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)object);
        if (xServiceInfo == null) {
            return "";
        }
        String[] stringArray = xServiceInfo.getSupportedServiceNames();
        String string2 = "";
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!RgfReflectUNO.compareRelaxed(string, stringArray[i])) continue;
            return stringArray[i];
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            linkedList.add(stringArray[i]);
        }
        boolean bl2 = false;
        int n2 = 0;
        HashSet<String> hashSet = new HashSet<String>();
        while (linkedList.size() > 0) {
            XServiceTypeDescription xServiceTypeDescription;
            String string3 = (String)linkedList.removeFirst();
            if (hashSet.contains(string3)) continue;
            hashSet.add(string3);
            Object[] objectArray = null;
            Object[] objectArray2 = new Object[2];
            XTypeDescription[] xTypeDescriptionArray = null;
            if (bl2) {
                if (RgfReflectUNO.compareRelaxed(string, string3)) {
                    return string3;
                }
            } else {
                boolean bl3 = bl2 = stringArray.length < ++n2;
            }
            if ((xServiceTypeDescription = (XServiceTypeDescription)UnoRuntime.queryInterface(XServiceTypeDescription.class, (Object)(objectArray = RgfReflectUNO.determineTypeClass(string3))[0])) == null) continue;
            objectArray2[0] = xServiceTypeDescription.getMandatoryServices();
            objectArray2[1] = xServiceTypeDescription.getOptionalServices();
            for (int i = 0; i < objectArray2.length; ++i) {
                xTypeDescriptionArray = (XTypeDescription[])objectArray2[i];
                for (int j = 0; j < xTypeDescriptionArray.length; ++j) {
                    string3 = xTypeDescriptionArray[j].getName();
                    if (RgfReflectUNO.compareRelaxed(string, string3)) {
                        return string3;
                    }
                    linkedList.add(string3);
                }
            }
        }
        return "";
    }

    static boolean compareRelaxed(String string, String string2) {
        int n;
        int n2 = string.length();
        if (n2 > (n = string2.length())) {
            return false;
        }
        if (n2 != n) {
            string2 = string2.substring(n - n2);
        }
        return string.equalsIgnoreCase(string2);
    }

    static void say(String string) {
        System.err.println(string);
    }

    static String pp(Object object) {
        if (object == null) {
            return "<null>";
        }
        return "<" + object + ">";
    }

    static String getUnqualifiedName(String string) {
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(n + 1);
    }

    static String check4reflection(String string) {
        if (string.startsWith("com.sun.star.text.TextField.")) {
            return "com.sun.star.text.textfield." + string.substring(28);
        }
        return string;
    }

    static {
        ht.put(TypeClass.ANY, "UNO_ANY");
        ht.put(TypeClass.ARRAY, "UNO_ARRAY");
        ht.put(TypeClass.BOOLEAN, "UNO_BOOLEAN");
        ht.put(TypeClass.BYTE, "UNO_BYTE");
        ht.put(TypeClass.CHAR, "UNO_CHAR");
        ht.put(TypeClass.CONSTANT, "UNO_CONSTANT");
        ht.put(TypeClass.CONSTANTS, ENCODE_CONSTANTS_KEYWORD);
        ht.put(TypeClass.DOUBLE, "UNO_DOUBLE");
        ht.put(TypeClass.ENUM, ENCODE_ENUM_KEYWORD);
        ht.put(TypeClass.EXCEPTION, ENCODE_EXCEPTION_KEYWORD);
        ht.put(TypeClass.FLOAT, "UNO_FLOAT");
        ht.put(TypeClass.HYPER, "UNO_HYPER");
        ht.put(TypeClass.INTERFACE, ENCODE_INTERFACE_KEYWORD);
        ht.put(TypeClass.INTERFACE_ATTRIBUTE, "UNO_INTERFACE_ATTRIBUTE");
        ht.put(TypeClass.INTERFACE_METHOD, "UNO_INTERFACE_METHOD");
        ht.put(TypeClass.LONG, "UNO_LONG");
        ht.put(TypeClass.MODULE, ENCODE_MODULE_KEYWORD);
        ht.put(TypeClass.PROPERTY, ENCODE_PROPERTY_KEYWORD);
        ht.put(TypeClass.SEQUENCE, "UNO_SEQUENCE");
        ht.put(TypeClass.SERVICE, ENCODE_SERVICE_KEYWORD);
        ht.put(TypeClass.SHORT, "UNO_SHORT");
        ht.put(TypeClass.SINGLETON, ENCODE_SINGLETON_KEYWORD);
        ht.put(TypeClass.STRING, "UNO_STRING");
        ht.put(TypeClass.STRUCT, ENCODE_STRUCT_KEYWORD);
        ht.put(TypeClass.TYPE, "UNO_TYPE");
        ht.put(TypeClass.TYPEDEF, ENCODE_TYPEDEF_KEYWORD);
        ht.put(TypeClass.UNION, "UNO_UNION");
        ht.put(TypeClass.UNKNOWN, "UNO_UNKNOWN");
        ht.put(TypeClass.UNSIGNED_HYPER, "UNO_UNSIGNED_HYPER");
        ht.put(TypeClass.UNSIGNED_LONG, "UNO_UNSIGNED_LONG");
        ht.put(TypeClass.UNSIGNED_SHORT, "UNO_UNSIGNED_SHORT");
        ht.put(TypeClass.VOID, "UNO_VOID");
        ht2j.put(TypeClass.BOOLEAN, "boolean");
        ht2j.put(TypeClass.BYTE, "byte");
        ht2j.put(TypeClass.CHAR, "char");
        ht2j.put(TypeClass.DOUBLE, "double");
        ht2j.put(TypeClass.FLOAT, "float");
        ht2j.put(TypeClass.HYPER, "long");
        ht2j.put(TypeClass.LONG, "int");
        ht2j.put(TypeClass.SHORT, "short");
        ht2j.put(TypeClass.STRING, "java.lang.String");
        ht2j.put(TypeClass.UNSIGNED_HYPER, "long");
        ht2j.put(TypeClass.UNSIGNED_LONG, "int");
        ht2j.put(TypeClass.UNSIGNED_SHORT, "short");
        ht2j.put(TypeClass.VOID, "void");
        ht2j_prop.put(TypeClass.BOOLEAN, "java.lang.Boolean");
        ht2j_prop.put(TypeClass.BYTE, "java.lang.Byte");
        ht2j_prop.put(TypeClass.CHAR, "java.lang.Char");
        ht2j_prop.put(TypeClass.DOUBLE, "java.lang.Double");
        ht2j_prop.put(TypeClass.FLOAT, "java.lang.Float");
        ht2j_prop.put(TypeClass.HYPER, "java.lang.Long");
        ht2j_prop.put(TypeClass.LONG, "java.lang.Integer");
        ht2j_prop.put(TypeClass.SHORT, "java.lang.Short");
        ht2j_prop.put(TypeClass.STRING, "java.lang.String");
        ht2j_prop.put(TypeClass.UNSIGNED_HYPER, "java.lang.Long");
        ht2j_prop.put(TypeClass.UNSIGNED_LONG, "java.lang.Integer");
        ht2j_prop.put(TypeClass.UNSIGNED_SHORT, "java.lang.Short");
        ht2j_prop.put(TypeClass.VOID, "java.lang.Void");
        pa.put(new Integer(1), "MAYBEVOID");
        pa.put(new Integer(2), "BOUND");
        pa.put(new Integer(4), "CONSTRAINED");
        pa.put(new Integer(8), "TRANSIENT");
        pa.put(new Integer(16), "READONLY");
        pa.put(new Integer(32), "MAYBEAMBIGUOUS");
        pa.put(new Integer(64), "MAYBEDEFAULT");
        pa.put(new Integer(128), "REMOVEABLE");
        pa.put(new Integer(256), "OPTIONAL");
        maxModifierValue = 256;
    }
}

