/*
 * Decompiled with CFR 0.152.
 */
package netrexx.lang;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.TreeMap;
import netrexx.lang.NoOtherwiseException;
import netrexx.lang.Rexx;
import netrexx.lang.RexxDate;
import netrexx.lang.RexxIO;
import netrexx.lang.RexxParse;
import netrexx.lang.RexxRexx;
import netrexx.lang.RexxSet;

public class RexxStream {
    private static final Rexx $01 = new Rexx(18);
    private static final Rexx $02 = Rexx.toRexx("stdout");
    private static final Rexx $03 = Rexx.toRexx("stderr");
    private static final Rexx $04 = new Rexx(1);
    private static final Rexx $05 = new Rexx('D');
    private static final Rexx $06 = new Rexx('S');
    private static final Rexx $07 = Rexx.toRexx("");
    private static final Rexx $08 = new Rexx('C');
    private static final Rexx $09 = Rexx.toRexx("OPEN");
    private static final Rexx $010 = Rexx.toRexx("READ");
    private static final Rexx $011 = Rexx.toRexx("WRITE");
    private static final Rexx $012 = Rexx.toRexx("APPEND");
    private static final Rexx $013 = Rexx.toRexx("BOTH");
    private static final Rexx $014 = new Rexx('\"');
    private static final Rexx $015 = Rexx.toRexx("CLOSE");
    private static final Rexx $016 = Rexx.toRexx("SEEK");
    private static final Rexx $017 = Rexx.toRexx("QUERY SIZE");
    private static final Rexx $018 = new Rexx(0);
    private static final Rexx $019 = new Rexx(1000);
    private static final Rexx $020 = new Rexx(86400);
    private static final Rexx $021 = new Rexx(24);
    private static final Rexx $022 = new Rexx(3600);
    private static final Rexx $023 = new Rexx(719162);
    private static final Rexx $024 = new Rexx(60);
    private static final char[] $025 = new char[]{'\u0004', '\u0001', '\u0002', '\u0004', '\u0001', '\u0002', '\n', '\u0001', '\u0000', '\u0004', '\u0001', '\u0002', '\n', '\u0001', '\u0001', '\u0004', '\u0001', '\u0002', '\n', '\u0001', '\u0002', '\u0001', '\n', '\u0001', '\u0003', '\u0000'};
    private static final Rexx $026 = new Rexx('-');
    private static final Rexx $027 = new Rexx(':');
    private static final Rexx $028 = Rexx.toRexx("UTC");
    private static final char[] $029 = new char[]{'\u0004', '\u0001', '\u0004', '\n', '\u0001', '\u0000', '\u0004', '\u0001', '\u0002', '\n', '\u0001', '\u0001', '\u0004', '\u0001', '\u0002', '\n', '\u0001', '\u0002', '\u0001', '\n', '\u0001', '\u0003', '\u0000'};
    private static final String $0 = "RexxStream.nrx";
    private static final Rexx $030 = Rexx.toRexx("rw");
    private static final Rexx $031 = new Rexx('r');
    private static final Rexx $032 = new Rexx(-1);
    private static final Rexx $033 = new Rexx('\n');
    private static final RexxSet $1 = new RexxSet();
    private static TreeMap fileHandles;

    public static Rexx chars(Rexx rexx) {
        FileHandle fileHandle = (FileHandle)fileHandles.get(rexx);
        if (fileHandle == null) {
            fileHandle = new FileHandle(Rexx.toString(rexx), "r");
            if (fileHandle.isReady().OpNot($1)) {
                return new Rexx(0);
            }
            fileHandles.put(rexx, fileHandle);
        }
        return fileHandle.available();
    }

    public static Rexx charin(Rexx rexx) {
        return RexxStream.charin(rexx, -1, 1);
    }

    public static Rexx charin(Rexx rexx, int n) {
        return RexxStream.charin(rexx, n, 1);
    }

    public static Rexx charin(Rexx rexx, int n, int n2) {
        FileHandle fileHandle = (FileHandle)fileHandles.get(rexx);
        if (fileHandle == null) {
            fileHandle = new FileHandle(Rexx.toString(rexx), "r");
            if (fileHandle.isReady().OpNot($1)) {
                return Rexx.toRexx("");
            }
            fileHandles.put(rexx, fileHandle);
        }
        Rexx rexx2 = fileHandle.readChar(n, n2);
        return rexx2;
    }

    public static Rexx charout(Rexx rexx, Rexx rexx2) {
        return RexxStream.charout(rexx, rexx2, -1);
    }

    public static Rexx charout(Rexx rexx, Rexx rexx2, int n) {
        Rexx rexx3 = null;
        if (rexx.OpEq($1, $02)) {
            System.out.print(rexx2);
            return new Rexx(0);
        }
        if (rexx.OpEq($1, $03)) {
            System.err.print(rexx2);
            return new Rexx(0);
        }
        FileHandle fileHandle = (FileHandle)fileHandles.get(rexx);
        if (fileHandle == null) {
            fileHandle = new FileHandle(Rexx.toString(rexx), "rw");
            if (fileHandle.isReady().OpNot($1)) {
                return new Rexx(1);
            }
            fileHandles.put(rexx, fileHandle);
        } else if (fileHandle.isWritable().OpNot($1) && (rexx3 = fileHandle.makeWritable()).OpEq($1, $04)) {
            return new Rexx(1);
        }
        rexx3 = fileHandle.writeChar(rexx2, n);
        return rexx3;
    }

    public static Rexx charout(Rexx rexx) {
        FileHandle fileHandle = (FileHandle)fileHandles.get(rexx);
        if (fileHandle != null) {
            fileHandle.close();
            fileHandles.remove(rexx);
        }
        return new Rexx(0);
    }

    public static Rexx lines(Rexx rexx) {
        FileHandle fileHandle = (FileHandle)fileHandles.get(rexx);
        if (fileHandle == null) {
            fileHandle = new FileHandle(Rexx.toString(rexx), "r");
            if (fileHandle.isReady().OpNot($1)) {
                return new Rexx(0);
            }
            fileHandles.put(rexx, fileHandle);
        }
        return fileHandle.available();
    }

    public static Rexx linein() {
        return RexxIO.Ask();
    }

    public static Rexx linein(Rexx rexx) {
        return RexxStream.linein(rexx, -1, 1);
    }

    public static Rexx linein(Rexx rexx, int n) {
        return RexxStream.linein(rexx, n, 1);
    }

    public static Rexx linein(Rexx rexx, int n, int n2) {
        if (n != -1 && n < 1) {
            return Rexx.toRexx("");
        }
        FileHandle fileHandle = (FileHandle)fileHandles.get(rexx);
        if (fileHandle == null) {
            fileHandle = new FileHandle(Rexx.toString(rexx), "r");
            if (fileHandle.isReady().OpNot($1)) {
                return Rexx.toRexx("");
            }
            fileHandles.put(rexx, fileHandle);
        }
        Rexx rexx2 = fileHandle.readLine(n, n2);
        return rexx2;
    }

    public static Rexx lineout(Rexx rexx) {
        FileHandle fileHandle = (FileHandle)fileHandles.get(rexx);
        if (fileHandle != null) {
            fileHandle.close();
            fileHandles.remove(rexx);
        }
        return new Rexx(0);
    }

    public static Rexx lineout(Rexx rexx, Rexx rexx2) {
        return RexxStream.lineout(rexx, rexx2, -1);
    }

    public static Rexx lineout(Rexx rexx, Rexx rexx2, int n) {
        Rexx rexx3 = null;
        if (n != -1 && n < 1) {
            return new Rexx(1);
        }
        if (rexx.OpEq($1, $02)) {
            System.out.println(rexx2);
            return new Rexx(0);
        }
        if (rexx.OpEq($1, $03)) {
            System.err.println(rexx2);
            return new Rexx(0);
        }
        FileHandle fileHandle = (FileHandle)fileHandles.get(rexx);
        if (fileHandle == null) {
            fileHandle = new FileHandle(Rexx.toString(rexx), "rw");
            if (fileHandle.isReady().OpNot($1)) {
                return new Rexx(1);
            }
            fileHandles.put(rexx, fileHandle);
        } else if (fileHandle.isWritable().OpNot($1) && (rexx3 = fileHandle.makeWritable()).OpEqS($1, $04)) {
            return new Rexx(1);
        }
        rexx3 = fileHandle.writeLine(rexx2, n);
        return rexx3;
    }

    public static Rexx stream(Rexx rexx) {
        return RexxStream.stream(rexx, Rexx.toRexx("STATE"), Rexx.toRexx(""));
    }

    public static Rexx stream(Rexx rexx, Rexx rexx2) {
        return RexxStream.stream(rexx, rexx2, Rexx.toRexx(""));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Rexx stream(Rexx rexx, Rexx rexx2, Rexx rexx3) {
        FileHandle fileHandle = null;
        Rexx rexx4 = null;
        Rexx rexx5 = null;
        Rexx rexx6 = null;
        Rexx rexx7 = null;
        Rexx rexx8 = null;
        Rexx rexx9 = null;
        Rexx rexx10 = null;
        Rexx rexx11 = null;
        Rexx rexx12 = null;
        Rexx rexx13 = null;
        Rexx rexx14 = null;
        Rexx rexx15 = null;
        Rexx rexx16 = null;
        Rexx rexx17 = null;
        rexx2 = rexx2.upper().strip();
        rexx3 = rexx3.upper().strip().changestr(Rexx.toRexx("  "), new Rexx(' '));
        if (rexx2.left(new Rexx(1)).OpEq($1, $05)) {
            fileHandle = (FileHandle)fileHandles.get(rexx);
            if (fileHandle == null) return Rexx.toRexx("UNKNOWN");
            return fileHandle.getState();
        }
        if (rexx2.left(new Rexx(1)).OpEq($1, $06) | rexx2.OpEq($1, $07)) {
            fileHandle = (FileHandle)fileHandles.get(rexx);
            if (fileHandle == null) return Rexx.toRexx("UNKNOWN");
            return fileHandle.getState();
        }
        if (rexx2.left(new Rexx(1)).OpEq($1, $08)) {
            if (rexx3.word(new Rexx(1)).OpEq($1, $09)) {
                if (rexx3.word(new Rexx(2)).OpEq($1, $010)) {
                    fileHandle = (FileHandle)fileHandles.get(rexx);
                    if (fileHandle == null) {
                        fileHandle = new FileHandle(Rexx.toString(rexx), "r");
                    }
                    if (fileHandle == null) {
                        return Rexx.toRexx("ERROR");
                    }
                    fileHandles.put(rexx, fileHandle);
                    return Rexx.toRexx("READY");
                }
                if (rexx3.word(new Rexx(2)).OpEq($1, $011) | rexx3.word(new Rexx(2)).OpEq($1, $012) | rexx3.word(new Rexx(2)).OpEq($1, $013) | rexx3.word(new Rexx(2)).OpEq($1, $07)) {
                    fileHandle = (FileHandle)fileHandles.get(rexx);
                    if (fileHandle == null) {
                        fileHandle = new FileHandle(Rexx.toString(rexx), "rw");
                    }
                    if (fileHandle == null) {
                        return Rexx.toRexx("ERROR");
                    }
                    if (rexx3.word(new Rexx(2)).OpNotEq($1, $012)) {
                        fileHandle.setSeekPosition(new Rexx('w'), new Rexx(0));
                    }
                    fileHandles.put(rexx, fileHandle);
                    return Rexx.toRexx("READY");
                }
                RexxIO.Say(Rexx.toRexx("Incorrect call to routine, STREAM C OPEN must be followed by READ, WRITE, APPEND or BOTH, found \"").OpCc($1, RexxRexx.word(new Rexx(2), rexx3)).OpCc($1, $014));
                System.exit(2);
                return null;
            }
            if (rexx3.OpEq($1, $015)) {
                fileHandle = (FileHandle)fileHandles.get(rexx);
                if (fileHandle == null) return Rexx.toRexx("READY");
                fileHandle.close();
                fileHandles.remove(rexx);
                return Rexx.toRexx("READY");
            }
            if (rexx3.left(new Rexx(4)).OpEq($1, $016)) {
                rexx4 = rexx3.word(new Rexx(2));
                if (rexx4.datatype(new Rexx('D')).OpNotEq($1, $04)) {
                    RexxIO.Say(Rexx.toRexx("Incorrect call to routine, STREAM C SEEK must be followed by offset, found \"").OpCc($1, RexxRexx.word(new Rexx(2), rexx3)).OpCc($1, $014));
                    System.exit(2);
                    return null;
                }
                fileHandle = (FileHandle)fileHandles.get(rexx);
                if (fileHandle == null) return Rexx.toRexx("");
                if (rexx3.word(new Rexx(3)).OpEq($1, $010)) {
                    fileHandle.setSeekPosition(new Rexx('r'), rexx4);
                    return Rexx.toRexx("");
                } else if (rexx3.word(new Rexx(3)).OpEq($1, $011)) {
                    fileHandle.setSeekPosition(new Rexx('w'), rexx4);
                    return Rexx.toRexx("");
                } else if (rexx3.word(new Rexx(3)).OpEq($1, $07)) {
                    fileHandle.setSeekPosition(Rexx.toRexx(""), rexx4);
                    return Rexx.toRexx("");
                } else {
                    RexxIO.Say(Rexx.toRexx("Incorrect call to routine, STREAM C SEEK offset must be followed by READ or WRITE, found \"").OpCc($1, RexxRexx.word(new Rexx(3), rexx3)).OpCc($1, $014));
                    System.exit(2);
                    return null;
                }
            }
            if (rexx3.OpEq($1, Rexx.toRexx("QUERY EXISTS"))) {
                try {
                    if (!new File(Rexx.toString(rexx)).exists()) return Rexx.toRexx("");
                    return Rexx.toRexx(new File(Rexx.toString(rexx)).getCanonicalPath());
                }
                catch (IOException iOException) {
                    return Rexx.toRexx("");
                }
            }
            if (rexx3.OpEq($1, $017)) {
                rexx5 = new Rexx(new File(Rexx.toString(rexx)).length());
                if (!rexx5.OpEqS($1, $018)) return rexx5;
                return Rexx.toRexx("");
            }
            if (rexx3.OpEq($1, Rexx.toRexx("QUERY DATETIME"))) {
                rexx6 = new Rexx(new File(Rexx.toString(rexx)).lastModified());
                if ((rexx6 = rexx6.OpDiv($1, $019)).OpEqS($1, $018)) {
                    return Rexx.toRexx("");
                }
                rexx7 = rexx6.OpDiv($1, $020);
                rexx7 = rexx7.trunc();
                rexx8 = rexx6.OpSub($1, rexx7.OpMult($1, $021).OpMult($1, $022));
                rexx9 = $023.OpAdd($1, rexx7);
                rexx10 = RexxDate.Date(new Rexx('S'), rexx9, new Rexx('B'));
                rexx11 = rexx8.OpDivI($1, $022);
                rexx12 = rexx8.OpSub($1, rexx11.OpMult($1, $022));
                rexx13 = rexx12.OpDivI($1, $024);
                rexx14 = rexx12.OpSub($1, rexx13.OpMult($1, $024));
                Rexx[] rexxArray = new Rexx[4];
                RexxParse.parse(rexx10, $025, rexxArray);
                rexx15 = rexxArray[0];
                rexx16 = rexxArray[1];
                rexx17 = rexxArray[2];
                return rexx17.OpCc($1, $026).OpCc($1, rexx16).OpCc($1, $026).OpCc($1, rexx15).OpCcblank($1, rexx11.right(new Rexx(2), new Rexx('0'))).OpCc($1, $027).OpCc($1, rexx13.right(new Rexx(2), new Rexx('0'))).OpCc($1, $027).OpCc($1, rexx14.trunc().right(new Rexx(2), new Rexx('0'))).OpCcblank($1, $028);
            }
            if (rexx3.OpEq($1, Rexx.toRexx("QUERY TIMESTAMP"))) {
                rexx6 = new Rexx(new File(Rexx.toString(rexx)).lastModified());
                if ((rexx6 = rexx6.OpDiv($1, $019)).OpEqS($1, $018)) {
                    return Rexx.toRexx("");
                }
                rexx7 = rexx6.OpDiv($1, $020);
                rexx7 = rexx7.trunc();
                rexx8 = rexx6.OpSub($1, rexx7.OpMult($1, $021).OpMult($1, $022));
                rexx9 = $023.OpAdd($1, rexx7);
                rexx10 = RexxDate.Date(new Rexx('S'), rexx9, new Rexx('B'));
                rexx11 = rexx8.OpDivI($1, $022);
                rexx12 = rexx8.OpSub($1, rexx11.OpMult($1, $022));
                rexx13 = rexx12.OpDivI($1, $024);
                rexx14 = rexx12.OpSub($1, rexx13.OpMult($1, $024));
                Rexx[] rexxArray = new Rexx[4];
                RexxParse.parse(rexx10, $029, rexxArray);
                rexx15 = rexxArray[0];
                rexx16 = rexxArray[1];
                rexx17 = rexxArray[2];
                return rexx15.OpCc($1, $026).OpCc($1, rexx16).OpCc($1, $026).OpCc($1, rexx17).OpCcblank($1, rexx11.right(new Rexx(2), new Rexx('0'))).OpCc($1, $027).OpCc($1, rexx13.right(new Rexx(2), new Rexx('0'))).OpCc($1, $027).OpCc($1, rexx14.trunc().right(new Rexx(2), new Rexx('0'))).OpCcblank($1, $028);
            }
            RexxIO.Say(Rexx.toRexx("Incorrect call to routine, STREAM C must be followed by OPEN, CLOSE, SEEK or QUERY, found \"").OpCc($1, rexx3).OpCc($1, $014));
            System.exit(2);
            return null;
        }
        RexxIO.Say(Rexx.toRexx("Incorrect call to routine, STREAM must be followed by COMMAND, STATE or DESCRIPTION, found \"").OpCc($1, rexx2).OpCc($1, $014));
        System.exit(2);
        return null;
    }

    public static Rexx pull() {
        return RexxIO.Ask();
    }

    static {
        $1.setDigits($01);
        fileHandles = new TreeMap();
    }

    static class FileHandle {
        private final transient String $0 = "RexxStream.nrx";
        protected static final char ERROR = 'E';
        protected static final char READY = 'R';
        protected static final char NOTREADY = 'N';
        protected static final char UNKNOWN = 'U';
        private FileChannel readChannel;
        private FileChannel writeChannel;
        private Path tpath;
        private Rexx mode;
        private boolean isWritable;
        private char state;
        private Rexx readpos;
        private Rexx charread;
        private Rexx lineread;
        private Rexx writepos;
        private Rexx charwrite;
        private Rexx linewrite;

        public FileHandle(String string, String string2) {
            this.mode = Rexx.toRexx(string2);
            this.state = (char)85;
            try {
                this.tpath = Paths.get(string, "");
                if (this.mode.OpEq(null, $030)) {
                    this.writeChannel = FileChannel.open(this.tpath, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                    this.charwrite = new Rexx(-1);
                    this.linewrite = new Rexx(-1);
                    this.isWritable = true;
                    this.writepos = new Rexx(this.writeChannel.size());
                    this.writeChannel.position(this.writepos.tolong());
                }
                this.readChannel = FileChannel.open(this.tpath, StandardOpenOption.READ);
                this.readpos = new Rexx(0);
                this.charread = new Rexx(0);
                this.lineread = new Rexx(0);
                this.state = (char)82;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.state = (char)69;
            }
            catch (IOException iOException) {
                this.state = (char)69;
            }
        }

        public Rexx getState() {
            if (this.state == 'R') {
                return Rexx.toRexx("READY");
            }
            if (this.state == 'N') {
                return Rexx.toRexx("NOTREADY");
            }
            if (this.state == 'U') {
                return Rexx.toRexx("UNKNOWN");
            }
            if (this.state == 'E') {
                return Rexx.toRexx("ERROR");
            }
            throw new NoOtherwiseException();
        }

        public Rexx isReady() {
            if (this.state == 'R') {
                return new Rexx(1);
            }
            return new Rexx(0);
        }

        public Rexx isWritable() {
            return new Rexx(this.isWritable);
        }

        public Rexx makeWritable() {
            this.mode = Rexx.toRexx("rw");
            try {
                this.writeChannel = FileChannel.open(this.tpath, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                this.charwrite = new Rexx(-1);
                this.linewrite = new Rexx(-1);
                this.isWritable = true;
                this.writepos = new Rexx(this.writeChannel.position());
            }
            catch (IOException iOException) {
                this.state = (char)69;
                return new Rexx(1);
            }
            this.state = (char)82;
            return new Rexx(0);
        }

        public void setSeekPosition(Rexx rexx, Rexx rexx2) {
            if (rexx.OpEq(null, $031)) {
                this.readpos = rexx2;
            } else if (rexx.OpEq(null, $031)) {
                this.writepos = rexx2;
            } else {
                this.readpos = rexx2;
                this.writepos = rexx2;
            }
        }

        public Rexx available() {
            long l = 0L;
            try {
                l = this.readChannel.size() - this.readChannel.position();
                if (l > 0L) {
                    return new Rexx(1);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new Rexx(0);
        }

        public Rexx readUTF8Char() {
            CharsetDecoder charsetDecoder = null;
            ByteBuffer byteBuffer = null;
            int n = 0;
            byte[] byArray = null;
            byte by = 0;
            int n2 = 0;
            ByteBuffer byteBuffer2 = null;
            int n3 = 0;
            ByteBuffer byteBuffer3 = null;
            CharBuffer charBuffer = null;
            String string = "";
            try {
                charsetDecoder = StandardCharsets.UTF_8.newDecoder();
                charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
                charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                byteBuffer = ByteBuffer.allocate(1);
                n = 1;
                byArray = new byte[4];
                byteBuffer.clear();
                if (this.readChannel.read(byteBuffer) < 0) {
                    return new Rexx(-1);
                }
                byteBuffer.flip();
                byArray[0] = by = byteBuffer.get();
                n2 = by & 0xFF;
                if (n2 < 128) {
                    n = 1;
                } else if (n2 >= 192 & n2 < 224) {
                    n = 2;
                } else if (n2 >= 224 & n2 < 240) {
                    n = 3;
                } else if (n2 >= 240 & n2 < 248) {
                    n = 4;
                } else {
                    return null;
                }
                if (n > 1 && (n3 = this.readChannel.read(byteBuffer2 = ByteBuffer.wrap(byArray, 1, n - 1))) < n - 1) {
                    this.state = (char)78;
                    return new Rexx(-1);
                }
                byteBuffer3 = ByteBuffer.wrap(byArray, 0, n);
                charBuffer = CharBuffer.allocate(1);
                charsetDecoder.decode(byteBuffer3, charBuffer, false);
                charBuffer.flip();
                string = charBuffer.toString();
            }
            catch (IOException iOException) {
                this.state = (char)69;
                return null;
            }
            return Rexx.toRexx(string);
        }

        public Rexx readChar() {
            return this.readChar(-1, 1);
        }

        public Rexx readChar(int n) {
            return this.readChar(n, 1);
        }

        public Rexx readChar(int n, int n2) {
            String string = null;
            if (n == 1) {
                this.lineread = new Rexx(0);
                this.charread = new Rexx(0);
                this.readpos = new Rexx(0);
            } else if (n > 1) {
                if (this.charread.OpGt(null, new Rexx(n))) {
                    this.lineread = new Rexx(0);
                    this.charread = new Rexx(1);
                    this.readpos = new Rexx(0);
                }
                try {
                    string = "";
                    this.readChannel.position(this.readpos.tolong());
                    while (this.charread.OpLt(null, new Rexx(n - 1)) && (string = Rexx.toString(this.readUTF8Char())) != null && !Rexx.toRexx(string).OpEq(null, $032)) {
                        this.charread = this.charread.OpAdd(null, $04);
                        if (!Rexx.toRexx(string).OpEq(null, $033)) continue;
                        this.lineread = this.lineread.OpAdd(null, $04);
                    }
                    this.readpos = new Rexx(this.readChannel.position());
                    if (string == null) {
                        this.state = (char)85;
                        return Rexx.toRexx("");
                    }
                    if (Rexx.toRexx(string).OpEq(null, $032)) {
                        this.state = (char)78;
                        return Rexx.toRexx("");
                    }
                }
                catch (IOException iOException) {
                    this.state = (char)69;
                }
            }
            String string2 = "";
            string = "";
            int n3 = 0;
            try {
                while (n3 < n2) {
                    this.readChannel.position(this.readpos.tolong());
                    string = Rexx.toString(this.readUTF8Char());
                    this.readpos = new Rexx(this.readChannel.position());
                    if (string == null) continue;
                    if (Rexx.toRexx(string).OpEq(null, $032)) {
                        this.state = (char)78;
                        return Rexx.toRexx("");
                    }
                    this.charread = this.charread.OpAdd(null, $04);
                    if (Rexx.toRexx(string).OpEq(null, $033)) {
                        this.lineread = this.lineread.OpAdd(null, $04);
                    }
                    string2 = string2 + "" + string;
                    ++n3;
                }
            }
            catch (IOException iOException) {
                this.state = (char)69;
                return new Rexx(-1);
            }
            return Rexx.toRexx(string2);
        }

        public Rexx readLine() {
            return this.readLine(-1, 1);
        }

        public Rexx readLine(int n) {
            return this.readLine(n, 1);
        }

        public Rexx readLine(int n, int n2) {
            String string = null;
            if (n == 1) {
                this.lineread = new Rexx(0);
                this.charread = new Rexx(0);
                this.readpos = new Rexx(0);
            } else if (n > 1) {
                if (this.lineread.OpGt(null, new Rexx(n))) {
                    this.lineread = new Rexx(0);
                    this.charread = new Rexx(0);
                    this.readpos = new Rexx(0);
                }
                try {
                    string = "";
                    this.readChannel.position(this.readpos.tolong());
                    while (this.lineread.OpLt(null, new Rexx(n - 1)) && !Rexx.toRexx(string = Rexx.toString(this.readUTF8Char())).OpEq(null, $032)) {
                        this.charread = this.charread.OpAdd(null, $04);
                        if (!Rexx.toRexx(string).OpEq(null, $033)) continue;
                        this.lineread = this.lineread.OpAdd(null, $04);
                    }
                    this.readpos = new Rexx(this.readChannel.position());
                    if (Rexx.toRexx(string).OpEq(null, $032)) {
                        this.state = (char)78;
                        return Rexx.toRexx("");
                    }
                }
                catch (IOException iOException) {
                    this.state = (char)69;
                }
            }
            if (n2 == 0) {
                return Rexx.toRexx("");
            }
            String string2 = "";
            try {
                this.readChannel.position(this.readpos.tolong());
                while (true) {
                    if ((string = Rexx.toString(this.readUTF8Char())) == null) {
                        continue;
                    }
                    if (Rexx.toRexx(string).OpEq(null, $032)) break;
                    this.charread = this.charread.OpAdd(null, $04);
                    if (Rexx.toRexx(string).OpEq(null, $033)) {
                        this.lineread = this.lineread.OpAdd(null, $04);
                        break;
                    }
                    string2 = string2 + "" + string;
                }
                this.readpos = new Rexx(this.readChannel.position());
            }
            catch (IOException iOException) {
                this.state = (char)69;
                return Rexx.toRexx("");
            }
            return Rexx.toRexx(string2);
        }

        public Rexx writeChar(Rexx rexx) {
            return this.writeChar(rexx, -1);
        }

        public Rexx writeChar(Rexx rexx, int n) {
            String string = null;
            CharsetEncoder charsetEncoder = null;
            CharBuffer charBuffer = null;
            ByteBuffer byteBuffer = null;
            if (n == 1) {
                this.linewrite = new Rexx(0);
                this.charwrite = new Rexx(0);
                this.writepos = new Rexx(0);
            } else if (n > 1) {
                if (this.charwrite.OpGt(null, new Rexx(n))) {
                    this.linewrite = new Rexx(0);
                    this.charwrite = new Rexx(1);
                    this.writepos = new Rexx(0);
                }
                try {
                    string = "";
                    this.readChannel.position(this.readpos.tolong());
                    while (this.charwrite.OpLt(null, new Rexx(n)) && !Rexx.toRexx(string = Rexx.toString(this.readUTF8Char())).OpEq(null, $032)) {
                        this.charwrite = this.charwrite.OpAdd(null, $04);
                        if (!Rexx.toRexx(string).OpEq(null, $033)) continue;
                        this.linewrite = this.linewrite.OpAdd(null, $04);
                    }
                    this.readChannel.position(this.readpos.tolong());
                    this.writepos = new Rexx(this.readChannel.position());
                    if (Rexx.toRexx(string).OpEq(null, $032)) {
                        this.state = (char)78;
                        return new Rexx(1);
                    }
                }
                catch (IOException iOException) {
                    this.state = (char)69;
                }
            }
            try {
                this.writeChannel.position(this.writepos.tolong());
                charsetEncoder = StandardCharsets.UTF_8.newEncoder();
                charBuffer = CharBuffer.wrap(Rexx.tochararray(rexx));
                byteBuffer = charsetEncoder.encode(charBuffer);
                while (byteBuffer.hasRemaining()) {
                    this.writeChannel.write(byteBuffer);
                }
                this.writepos = new Rexx(this.writeChannel.position());
                this.charwrite = this.charwrite.OpAdd(null, rexx.length());
                this.writeChannel.force(true);
                this.state = (char)82;
            }
            catch (CharacterCodingException characterCodingException) {
                this.state = (char)69;
                return new Rexx(1);
            }
            catch (IOException iOException) {
                this.state = (char)69;
                return new Rexx(1);
            }
            return new Rexx(0);
        }

        public Rexx writeLine(Rexx rexx) {
            return this.writeLine(rexx, -1);
        }

        public Rexx writeLine(Rexx rexx, int n) {
            String string = null;
            if (n == 1) {
                this.linewrite = new Rexx(0);
                this.charwrite = new Rexx(0);
                this.writepos = new Rexx(0);
            } else if (n > 1) {
                if (this.linewrite.OpGt(null, new Rexx(n))) {
                    this.linewrite = new Rexx(0);
                    this.charwrite = new Rexx(0);
                    this.writepos = new Rexx(0);
                }
                try {
                    string = "";
                    this.writeChannel.position(this.writepos.tolong());
                    while (this.linewrite.OpLt(null, new Rexx(n)) && !Rexx.toRexx(string = Rexx.toString(this.readUTF8Char())).OpEq(null, $032)) {
                        this.charwrite = this.charwrite.OpAdd(null, $04);
                        if (!Rexx.toRexx(string).OpEq(null, $033)) continue;
                        this.linewrite = this.linewrite.OpAdd(null, $04);
                    }
                    this.writepos = new Rexx(this.readChannel.position());
                    if (Rexx.toRexx(string).OpEq(null, $032)) {
                        this.state = (char)78;
                        return new Rexx(1);
                    }
                }
                catch (IOException iOException) {
                    this.state = (char)69;
                }
            }
            Rexx rexx2 = this.writeChar(rexx.OpCc(null, $033));
            return rexx2;
        }

        public void close() {
            try {
                if (this.readChannel != null) {
                    this.readChannel.close();
                }
                if (this.writeChannel != null) {
                    this.writeChannel.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

