/*
 * Decompiled with CFR 0.152.
 */
package netrexx.lang;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import netrexx.lang.BadArgumentException;
import netrexx.lang.Rexx;
import netrexx.lang.RexxDate;
import netrexx.lang.RexxIO;

public class Sysutils {
    private static final Rexx $01 = new Rexx(1000);
    private static final Rexx $02 = Rexx.toRexx("ECHO");
    private static final Rexx $03 = new Rexx(0);
    private static final Rexx $04 = new Rexx('C');
    private static final Rexx $05 = new Rexx('N');
    private static final Rexx $06 = Rexx.toRexx("");
    private static final Rexx $07 = new Rexx('/');
    private static final Rexx $08 = new Rexx(1);
    private static final Rexx $09 = new Rexx(2);
    private static final Rexx $010 = new Rexx('B');
    private static final Rexx $011 = new Rexx('F');
    private static final Rexx $012 = new Rexx('D');
    private static final Rexx $013 = new Rexx('-');
    private static final Rexx $014 = new Rexx('H');
    private static final Rexx $015 = new Rexx('R');
    private static final Rexx $016 = new Rexx('.');
    private static final Rexx $017 = Rexx.toRexx("*****");
    private static final Rexx $018 = new Rexx('+');
    private static final Rexx $019 = new Rexx(' ');
    private static final Rexx $020 = new Rexx(-1);
    private static final Rexx $021 = new Rexx('0');
    private static final String $0 = "Sysutils.nrx";
    private Rexx os;
    private Rexx osVersion;
    private Rexx envSeparator;
    private Vector semMutexVector;
    private Vector semEventVector;
    private String[] rxExec = new String[3];
    private Rexx rxRc;
    private String[] rxStdout;
    private String[] rxStderr;

    public Sysutils() {
        this.determineOS();
        this.semMutexVector = new Vector(10);
        this.semEventVector = new Vector(10);
    }

    public void SysSleep(Rexx rexx) throws InterruptedException {
        Thread.currentThread();
        Thread.sleep(rexx.OpMult(null, $01).tolong());
    }

    public Rexx SysFileRead(Rexx rexx, Rexx rexx2) throws IOException, FileNotFoundException {
        String string = null;
        File file = new File(Rexx.toString(rexx));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        int n = 0;
        rexx2 = Rexx.toRexx("");
        while ((string = bufferedReader.readLine()) != null) {
            rexx2.getnode((Rexx)new Rexx((int)(++n))).leaf = Rexx.toRexx(string);
        }
        rexx2.getnode((Rexx)new Rexx((byte)0)).leaf = new Rexx(n);
        bufferedReader.close();
        return rexx2;
    }

    public void SysFileWrite(Rexx rexx, Rexx rexx2) throws IOException, FileNotFoundException {
        int n = 0;
        File file = new File(Rexx.toString(rexx));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
        int n2 = rexx2.getnode((Rexx)new Rexx((byte)0)).leaf.toint();
        for (n = 1; n <= n2; ++n) {
            bufferedWriter.write(Rexx.toString(rexx2.getnode((Rexx)new Rexx((int)n)).leaf), 0, rexx2.getnode((Rexx)new Rexx((int)n)).leaf.length().toint());
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
    }

    public Rexx SysGetKey() {
        return this.SysGetKey("ECHO");
    }

    public Rexx SysGetKey(String string) {
        if (Rexx.toRexx(string).OpEq(null, $02)) {
            return RexxIO.Ask();
        }
        return RexxIO.AskDark();
    }

    public Rexx SysFileDelete(Rexx rexx) {
        return new Rexx(!new File(Rexx.toString(rexx)).delete());
    }

    public Rexx SysFileExists(Rexx rexx) {
        return new Rexx(new File(Rexx.toString(rexx)).exists());
    }

    public Rexx SysGetFileDateTime(Rexx rexx) {
        return this.SysGetFileDateTime(rexx, new Rexx('W'));
    }

    public Rexx SysGetFileDateTime(Rexx rexx, Rexx rexx2) {
        long l = 0L;
        SimpleDateFormat simpleDateFormat = null;
        String string = null;
        File file = new File(Rexx.toString(rexx));
        l = 0L;
        if (Rexx.toRexx("WRITE").abbrev(rexx2.upper(), new Rexx(1)).toboolean()) {
            l = file.lastModified();
        } else if (!Rexx.toRexx("CREATE").abbrev(rexx2.upper(), new Rexx(1)).toboolean() && !Rexx.toRexx("ACCESS").abbrev(rexx2.upper(), new Rexx(1)).toboolean()) {
            throw new BadArgumentException();
        }
        if (l > 0L) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            string = simpleDateFormat.format(RexxDate.Date(new Rexx(l)));
        } else {
            string = String.valueOf(-1);
        }
        return Rexx.toRexx(string);
    }

    public Rexx SysFileSearch(Rexx rexx, Rexx rexx2, Rexx rexx3) {
        return this.SysFileSearch(rexx, rexx2, rexx3, new Rexx(""));
    }

    public Rexx SysFileSearch(Rexx rexx, Rexx rexx2, Rexx rexx3, Rexx rexx4) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Rexx rexx5 = null;
        rexx3 = new Rexx("");
        Rexx rexx6 = new Rexx("");
        try {
            rexx6 = this.SysFileRead(rexx2, rexx6);
            if (rexx4.upper().pos(new Rexx('C')).OpGt(null, $03)) {
                n = 0;
            } else {
                rexx = rexx.upper();
                n = 1;
            }
            n2 = rexx4.upper().pos(new Rexx('N')).OpGt(null, $03) ? 1 : 0;
            n3 = 0;
            int n5 = rexx6.getnode((Rexx)new Rexx((byte)0)).leaf.toint();
            for (n4 = 1; n4 <= n5; ++n4) {
                rexx5 = new Rexx(n).toboolean() ? rexx6.getnode((Rexx)new Rexx((int)n4)).leaf.upper().pos(rexx) : rexx6.getnode((Rexx)new Rexx((int)n4)).leaf.pos(rexx);
                if (!rexx5.OpGt(null, $03)) continue;
                ++n3;
                rexx3.getnode((Rexx)new Rexx((int)n3)).leaf = new Rexx(n2).toboolean() ? new Rexx(n4) : rexx6.getnode((Rexx)new Rexx((int)n4)).leaf;
            }
            rexx3.getnode((Rexx)new Rexx((byte)0)).leaf = new Rexx(n3);
        }
        catch (IOException iOException) {
            rexx3 = Rexx.toRexx("");
            rexx3.getnode((Rexx)new Rexx((byte)0)).leaf = new Rexx(0);
        }
        return rexx3;
    }

    public Rexx SysSearchPath(Rexx rexx, Rexx rexx2, Rexx rexx3) {
        File file = null;
        int n = 0;
        Rexx rexx4 = null;
        Rexx rexx5 = null;
        if (rexx3.upper().OpEqS(null, $04) && (file = new File(Rexx.toString(rexx2))).exists()) {
            return Rexx.toRexx(file.getAbsolutePath());
        }
        if ((rexx = Rexx.toRexx(System.getenv(Rexx.toString(rexx)))) != null & (rexx3.upper().OpEqS(null, $05) | rexx3.upper().OpEqS(null, $04))) {
            n = 1;
            rexx4 = rexx.pos(this.envSeparator, new Rexx(n));
            while (rexx4.OpGt(null, $03)) {
                rexx4 = rexx.pos(this.envSeparator, new Rexx(n));
                rexx5 = rexx.substr(new Rexx(n), rexx4.OpSub(null, new Rexx(n)));
                if (rexx5.OpNotEq(null, $06) && (file = new File(Rexx.toString(rexx5.OpCc(null, $07).OpCc(null, rexx2)))).exists()) {
                    return Rexx.toRexx(file.getAbsolutePath());
                }
                n = rexx4.OpAdd(null, $08).toint();
                rexx4 = rexx.pos(this.envSeparator, new Rexx(n));
            }
            rexx5 = rexx.substr(new Rexx(n));
            if (rexx5.OpNotEq(null, $06) && (file = new File(Rexx.toString(rexx5.OpCc(null, $07).OpCc(null, rexx2)))).exists()) {
                return Rexx.toRexx(file.getAbsolutePath());
            }
        }
        return Rexx.toRexx("");
    }

    public Rexx SysIsFile(Rexx rexx) {
        File file = new File(Rexx.toString(rexx));
        if (file.exists() & !file.isDirectory()) {
            return new Rexx(1);
        }
        return new Rexx(0);
    }

    public Rexx SysIsFileDirectory(Rexx rexx) {
        File file = new File(Rexx.toString(rexx));
        if (file.exists() & file.isDirectory()) {
            return new Rexx(1);
        }
        return new Rexx(0);
    }

    public Rexx SysMkDir(Rexx rexx) {
        File file = new File(Rexx.toString(rexx));
        boolean bl = file.mkdir();
        if (bl) {
            return new Rexx(0);
        }
        return new Rexx(1);
    }

    public Rexx SysRmDir(Rexx rexx) {
        File file = null;
        boolean bl = false;
        if (this.SysIsFileDirectory(rexx).toboolean() && (bl = (file = new File(Rexx.toString(rexx))).delete())) {
            return new Rexx(0);
        }
        return new Rexx(1);
    }

    public Rexx SysFileTree(Rexx rexx, Rexx rexx2) {
        return this.SysFileTree(rexx, rexx2, new Rexx("BL"), "*****", "*****");
    }

    public Rexx SysFileTree(Rexx rexx, Rexx rexx2, Rexx rexx3) {
        return this.SysFileTree(rexx, rexx2, rexx3, "*****", "*****");
    }

    public Rexx SysFileTree(Rexx rexx, Rexx rexx2, Rexx rexx3, String string) {
        return this.SysFileTree(rexx, rexx2, rexx3, string, "*****");
    }

    public Rexx SysFileTree(Rexx rexx, Rexx rexx2, Rexx rexx3, String string, String string2) {
        Rexx rexx4 = null;
        Rexx rexx5 = null;
        Rexx rexx6 = null;
        char[] cArray = null;
        int n = 0;
        Rexx rexx7 = null;
        int n2 = 0;
        String string3 = null;
        SimpleDateFormat simpleDateFormat = null;
        int n3 = 0;
        rexx2 = Rexx.toRexx("");
        rexx2.getnode((Rexx)new Rexx((byte)0)).leaf = new Rexx(0);
        try {
            rexx4 = rexx.substr(new Rexx(1), rexx.lastpos(new Rexx('/')));
            rexx6 = rexx5 = rexx.substr(rexx.lastpos(new Rexx('/')).OpAdd(null, $08));
            cArray = "\\+()^$.{}[]|".toCharArray();
            int n4 = cArray.length - 1;
            for (n = 0; n <= n4; ++n) {
                rexx7 = rexx6.pos(new Rexx(cArray[n]), new Rexx(1));
                while (rexx7.OpGt(null, $03)) {
                    rexx6 = rexx6.insert(new Rexx('\\'), rexx7.OpSub(null, $08));
                    rexx7 = rexx6.pos(new Rexx(cArray[n]), rexx7.OpAdd(null, $09));
                }
            }
            rexx7 = rexx6.pos(new Rexx('*'), new Rexx(1));
            while (rexx7.OpGt(null, $03)) {
                rexx6 = rexx6.insert(new Rexx('.'), rexx7.OpSub(null, $08));
                rexx7 = rexx6.pos(new Rexx('*'), rexx7.OpAdd(null, $09));
            }
            rexx6 = rexx6.translate(new Rexx('.'), new Rexx('?'));
            n2 = 0;
            if (rexx3.upper().pos(new Rexx('S')).OpGt(null, $03)) {
                n2 = 1;
            }
            if (rexx3.upper().pos(new Rexx('I')).OpGt(null, $03)) {
                rexx6 = rexx6.insert(Rexx.toRexx("(?i)"));
            }
            string3 = "B";
            if (rexx3.upper().pos(new Rexx('F')).OpGt(null, $03)) {
                string3 = "F";
            }
            if (rexx3.upper().pos(new Rexx('D')).OpGt(null, $03)) {
                string3 = "D";
            }
            simpleDateFormat = rexx3.upper().pos(new Rexx('T')).OpGt(null, $03) ? new SimpleDateFormat("yy/MM/dd/HH/mm") : (rexx3.upper().pos(new Rexx('L')).OpGt(null, $03) ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : new SimpleDateFormat());
            n3 = 0;
            if (rexx3.upper().pos(new Rexx('O')).OpGt(null, $03)) {
                n3 = 1;
            }
            rexx2 = this.FileTree(rexx2, rexx4, rexx6, new Rexx(n2), Rexx.toRexx(string3), simpleDateFormat, new Rexx(n3), Rexx.toRexx(string));
        }
        catch (IOException iOException) {
            rexx2 = Rexx.toRexx("");
            rexx2.getnode((Rexx)new Rexx((byte)0)).leaf = new Rexx(0);
        }
        return rexx2;
    }

    private Rexx FileTree(Rexx rexx, Rexx rexx2, Rexx rexx3, Rexx rexx4, Rexx rexx5, SimpleDateFormat simpleDateFormat, Rexx rexx6, Rexx rexx7) throws IOException {
        int n = 0;
        Rexx rexx8 = null;
        boolean bl = false;
        int n2 = 0;
        long l = 0L;
        Calendar calendar = null;
        Rexx rexx9 = null;
        Rexx rexx10 = null;
        File file = new File(Rexx.toString(rexx2));
        Rexx rexx11 = Rexx.toRexx("0");
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n3 = fileArray.length - 1;
            for (n = 0; n <= n3; ++n) {
                rexx8 = Rexx.toRexx(fileArray[n].toString());
                rexx8 = rexx8.substr(rexx8.lastpos(new Rexx('/')).OpAdd(null, $08));
                bl = fileArray[n].isDirectory();
                if (rexx8.toString().matches(Rexx.toString(rexx3))) {
                    n2 = 0;
                    if (rexx5.OpEqS(null, $010)) {
                        n2 = 1;
                    }
                    if (rexx5.OpEqS(null, $011) && !bl) {
                        n2 = 1;
                    }
                    if (rexx5.OpEqS(null, $012) && bl) {
                        n2 = 1;
                    }
                    if (new Rexx(n2).toboolean()) {
                        if (rexx6.toboolean()) {
                            rexx.getnode((Rexx)new Rexx((byte)0)).leaf = rexx.getnode((Rexx)new Rexx((byte)0)).leaf.OpAdd(null, $08);
                            rexx.getnode((Rexx)rexx.getnode((Rexx)new Rexx((byte)0)).leaf).leaf = Rexx.toRexx(fileArray[n].toString());
                        } else {
                            l = fileArray[n].lastModified();
                            calendar = Calendar.getInstance();
                            calendar.setTimeInMillis(l);
                            rexx9 = Rexx.toRexx(simpleDateFormat.format(calendar.getTime()));
                            rexx11 = bl ? new Rexx('0') : new Rexx(fileArray[n].length());
                            rexx10 = new Rexx('.');
                            rexx10 = bl ? rexx10.OpCc(null, $012) : rexx10.OpCc(null, $013);
                            rexx10 = fileArray[n].isHidden() ? rexx10.OpCc(null, $014) : rexx10.OpCc(null, $013);
                            rexx10 = fileArray[n].canWrite() ? rexx10.OpCc(null, $013) : rexx10.OpCc(null, $015);
                            rexx10 = rexx10.OpCc(null, $016);
                            if (rexx7.OpNotEq(null, $017)) {
                                if (rexx7.substr(new Rexx(2), new Rexx(1)).OpEqS(null, $018) & rexx10.substr(new Rexx(2), new Rexx(1)).OpNotEq(null, $012)) {
                                    n2 = 0;
                                } else if (rexx7.substr(new Rexx(2), new Rexx(1)).OpEqS(null, $013) & rexx10.substr(new Rexx(2), new Rexx(1)).OpNotEq(null, $013)) {
                                    n2 = 0;
                                }
                                if (rexx7.substr(new Rexx(3), new Rexx(1)).OpEqS(null, $018) & rexx10.substr(new Rexx(3), new Rexx(1)).OpNotEq(null, $014)) {
                                    n2 = 0;
                                } else if (rexx7.substr(new Rexx(3), new Rexx(1)).OpEqS(null, $013) & rexx10.substr(new Rexx(3), new Rexx(1)).OpNotEq(null, $013)) {
                                    n2 = 0;
                                }
                                if (rexx7.substr(new Rexx(4), new Rexx(1)).OpEqS(null, $018) & rexx10.substr(new Rexx(4), new Rexx(1)).OpNotEq(null, $015)) {
                                    n2 = 0;
                                } else if (rexx7.substr(new Rexx(4), new Rexx(1)).OpEqS(null, $013) & rexx10.substr(new Rexx(4), new Rexx(1)).OpNotEq(null, $013)) {
                                    n2 = 0;
                                }
                            }
                            if (new Rexx(n2).toboolean()) {
                                rexx.getnode((Rexx)new Rexx((byte)0)).leaf = rexx.getnode((Rexx)new Rexx((byte)0)).leaf.OpAdd(null, $08);
                                rexx.getnode((Rexx)rexx.getnode((Rexx)new Rexx((byte)0)).leaf).leaf = rexx9.left(new Rexx(24)).OpCc(null, $019).OpCc(null, rexx11.right(new Rexx(14))).OpCc(null, $019).OpCc(null, rexx10).OpCc(null, $019).OpCc(null, Rexx.toRexx(fileArray[n].toString()));
                            }
                        }
                    }
                }
                if (!new Rexx(bl).OpAnd(null, rexx4) || !fileArray[n].getAbsolutePath().equals(fileArray[n].getCanonicalPath())) continue;
                rexx = this.FileTree(rexx, new Rexx(String.valueOf(fileArray[n])), rexx3, rexx4, rexx5, simpleDateFormat, rexx6, rexx7);
            }
        }
        return rexx;
    }

    public Rexx SysStemDelete(Rexx rexx, Rexx rexx2) {
        return this.SysStemDelete(rexx, rexx2, 1);
    }

    public Rexx SysStemDelete(Rexx rexx, Rexx rexx2, int n) {
        Rexx rexx3 = null;
        if (rexx2.OpAdd(null, new Rexx(n)).OpSub(null, $08).OpGt(null, rexx.getnode((Rexx)new Rexx((byte)0)).leaf) | rexx2.OpEqS(null, $03)) {
            return new Rexx(-1);
        }
        Rexx rexx4 = rexx2.OpAdd(null, new Rexx(n));
        Rexx rexx5 = rexx.getnode((Rexx)new Rexx((byte)0)).leaf.OpSub(null, new Rexx(n));
        rexx3 = rexx2.OpPlus(null);
        while (rexx3.OpLtEq(null, rexx5)) {
            rexx.getnode((Rexx)rexx3).leaf = rexx.getnode((Rexx)rexx4).leaf;
            rexx4 = rexx4.OpAdd(null, $08);
            rexx3 = rexx3.OpAdd(null, new Rexx(1));
        }
        rexx.getnode((Rexx)new Rexx((byte)0)).leaf = rexx.getnode((Rexx)new Rexx((byte)0)).leaf.OpSub(null, new Rexx(n));
        return rexx;
    }

    public Rexx SysStemInsert(Rexx rexx, Rexx rexx2, Rexx rexx3) {
        Rexx rexx4 = null;
        if (rexx2.OpGt(null, rexx.getnode((Rexx)new Rexx((byte)0)).leaf.OpAdd(null, $08)) | rexx2.OpEqS(null, $03)) {
            return new Rexx(-1);
        }
        Rexx rexx5 = rexx2;
        rexx4 = rexx.getnode((Rexx)new Rexx((byte)0)).leaf.OpAdd(null, $08).OpPlus(null);
        while (rexx4.OpGtEq(null, rexx5)) {
            rexx.getnode((Rexx)rexx4).leaf = rexx.getnode((Rexx)rexx4.OpSub(null, (Rexx)Sysutils.$08)).leaf;
            rexx4 = rexx4.OpSub(null, new Rexx(1));
        }
        rexx.getnode((Rexx)rexx2).leaf = rexx3;
        rexx.getnode((Rexx)new Rexx((byte)0)).leaf = rexx.getnode((Rexx)new Rexx((byte)0)).leaf.OpAdd(null, $08);
        return rexx;
    }

    public Rexx SysStemCopy(Rexx rexx, Rexx rexx2) {
        return this.SysStemCopy(rexx, rexx2, 1, 1, rexx.getnode((Rexx)new Rexx((byte)0)).leaf, "O");
    }

    public Rexx SysStemCopy(Rexx rexx, Rexx rexx2, int n) {
        return this.SysStemCopy(rexx, rexx2, n, 1, rexx.getnode((Rexx)new Rexx((byte)0)).leaf, "O");
    }

    public Rexx SysStemCopy(Rexx rexx, Rexx rexx2, int n, int n2) {
        return this.SysStemCopy(rexx, rexx2, n, n2, rexx.getnode((Rexx)new Rexx((byte)0)).leaf, "O");
    }

    public Rexx SysStemCopy(Rexx rexx, Rexx rexx2, int n, int n2, Rexx rexx3) {
        return this.SysStemCopy(rexx, rexx2, n, n2, rexx3, "O");
    }

    public Rexx SysStemCopy(Rexx rexx, Rexx rexx2, int n, int n2, Rexx rexx3, String string) {
        Rexx rexx4 = null;
        int n3 = 0;
        if (new Rexx(n2).OpGt(null, rexx2.getnode((Rexx)new Rexx((byte)0)).leaf.OpAdd(null, $08)) | n2 == 0 | rexx3.OpGt(null, rexx.getnode((Rexx)new Rexx((byte)0)).leaf.OpSub(null, new Rexx(n)).OpAdd(null, $08))) {
            return new Rexx(-1);
        }
        if (new Rexx(n).OpGt(null, rexx.getnode((Rexx)new Rexx((byte)0)).leaf) | n == 0 | rexx3.OpGt(null, rexx.getnode((Rexx)new Rexx((byte)0)).leaf)) {
            return new Rexx(-1);
        }
        if (string.equals("I")) {
            Rexx rexx5 = new Rexx(n2);
            rexx4 = rexx2.getnode((Rexx)new Rexx((byte)0)).leaf.OpPlus(null);
            while (rexx4.OpGtEq(null, rexx5)) {
                rexx2.getnode((Rexx)rexx4.OpAdd(null, (Rexx)rexx3)).leaf = rexx2.getnode((Rexx)rexx4).leaf;
                rexx4 = rexx4.OpSub(null, new Rexx(1));
            }
            n3 = n2;
            int n4 = rexx3.OpPlus(null).toint();
            rexx4 = new Rexx(n);
            while (n4 > 0) {
                rexx2.getnode((Rexx)new Rexx((int)n3)).leaf = rexx.getnode((Rexx)rexx4).leaf;
                ++n3;
                --n4;
                rexx4 = rexx4.OpAdd(null, new Rexx(1));
            }
            rexx2.getnode((Rexx)new Rexx((byte)0)).leaf = rexx2.getnode((Rexx)new Rexx((byte)0)).leaf.OpAdd(null, rexx3);
        } else {
            n3 = n2;
            int n5 = rexx3.OpPlus(null).toint();
            rexx4 = new Rexx(n);
            while (n5 > 0) {
                rexx2.getnode((Rexx)new Rexx((int)n3)).leaf = rexx.getnode((Rexx)rexx4).leaf;
                ++n3;
                --n5;
                rexx4 = rexx4.OpAdd(null, new Rexx(1));
            }
            if (new Rexx(n2).OpAdd(null, rexx3).OpSub(null, $08).OpGt(null, rexx2.getnode((Rexx)new Rexx((byte)0)).leaf)) {
                rexx2.getnode((Rexx)new Rexx((byte)0)).leaf = new Rexx(n2).OpAdd(null, rexx3).OpSub(null, $08);
            }
        }
        return rexx2;
    }

    private Rexx rxExecArray(String[] stringArray) {
        Process process = null;
        BufferedReader bufferedReader = null;
        Rexx rexx = null;
        String string = null;
        try {
            process = Runtime.getRuntime().exec(stringArray);
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            rexx = Rexx.toRexx("0");
            while ((string = bufferedReader.readLine()) != null) {
                rexx = rexx.OpAdd(null, $08);
                this.rxStdout[rexx.toint()] = string;
            }
            this.rxStdout[Sysutils.$021.toint()] = Rexx.toString(rexx);
            bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            rexx = new Rexx(0);
            while ((string = bufferedReader.readLine()) != null) {
                rexx = rexx.OpAdd(null, $08);
                this.rxStderr[rexx.toint()] = string;
            }
            this.rxStderr[Sysutils.$021.toint()] = Rexx.toString(rexx);
            process.waitFor();
            this.rxRc = new Rexx(process.exitValue());
            process.getInputStream().close();
            process.getErrorStream().close();
            process.getOutputStream().close();
        }
        catch (InterruptedException interruptedException) {
            this.rxStdout[Sysutils.$021.toint()] = String.valueOf(0);
            this.rxStderr[Sysutils.$021.toint()] = String.valueOf(0);
            this.rxRc = new Rexx(-9);
        }
        catch (IOException iOException) {
            this.rxStdout[Sysutils.$021.toint()] = String.valueOf(0);
            this.rxStderr[Sysutils.$021.toint()] = String.valueOf(0);
            this.rxRc = new Rexx(-9);
        }
        return this.rxRc;
    }

    public Rexx rxCmd(Rexx rexx) {
        return this.rxCmd(rexx, 0);
    }

    public Rexx rxCmd(Rexx rexx, int n) {
        this.rxExec[2] = Rexx.toString(rexx);
        Rexx rexx2 = this.rxExecArray(this.rxExec);
        return rexx2;
    }

    public Rexx rxExec(Rexx rexx) {
        return this.rxExec(rexx, 0);
    }

    public Rexx rxExec(Rexx rexx, int n) {
        String[] stringArray = new String[]{Rexx.toString(rexx)};
        Rexx rexx2 = this.rxExecArray(stringArray);
        return rexx2;
    }

    public String[] rxGetstdout() {
        return this.rxStdout;
    }

    public String[] rxGetStderr() {
        return this.rxStderr;
    }

    public Rexx SysVersion() {
        return this.os.OpCc(null, $019).OpCc(null, this.osVersion);
    }

    private void determineOS() {
        this.os = Rexx.toRexx(System.getProperty("os.name"));
        if (this.os.pos(Rexx.toRexx("Win")).OpGt(null, $03)) {
            this.os = Rexx.toRexx("Windows");
            this.envSeparator = new Rexx(';');
            this.rxExec[0] = "CMD.EXE";
            this.rxExec[1] = "/C";
        } else {
            this.envSeparator = new Rexx(':');
            this.rxExec[0] = "bash";
            this.rxExec[1] = "-c";
        }
        this.osVersion = Rexx.toRexx(System.getProperty("os.version"));
    }

    public Rexx SysCreateMutexSem() {
        return this.SysCreateMutexSem("");
    }

    public Rexx SysCreateMutexSem(String string) {
        Semaphore semaphore = null;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String string2 = "";
        try {
            Thread.currentThread();
            Thread.sleep(1L);
            if (string.equals("")) {
                string = String.valueOf(System.currentTimeMillis());
            }
            semaphore = new Semaphore(1);
            string2 = String.valueOf(System.currentTimeMillis());
            hashtable.put("name", string);
            hashtable.put("sem", semaphore);
            hashtable.put("handle", string2);
            this.semMutexVector.add(hashtable);
            return Rexx.toRexx(string2);
        }
        catch (InterruptedException interruptedException) {
            return new Rexx(0);
        }
    }

    public Rexx SysOpenMutexSem(Rexx rexx) {
        Hashtable hashtable = null;
        int n = 0;
        int n2 = this.semMutexVector.size() - 1;
        for (n = 0; n <= n2; ++n) {
            hashtable = (Hashtable)this.semMutexVector.get(n);
            if (!((Rexx)hashtable.get("name")).OpEqS(null, rexx)) continue;
            return (Rexx)hashtable.get("handle");
        }
        return new Rexx(0);
    }

    public Rexx SysCloseMutexSem(Rexx rexx) {
        Hashtable hashtable = null;
        int n = 0;
        int n2 = this.semMutexVector.size() - 1;
        for (n = 0; n <= n2; ++n) {
            hashtable = (Hashtable)this.semMutexVector.get(n);
            if (hashtable.get("handle") != rexx) continue;
            hashtable.clear();
            this.semMutexVector.remove(hashtable);
            return new Rexx(0);
        }
        return new Rexx(1);
    }

    public Rexx SysRequestMutexSem(Rexx rexx) {
        return this.SysRequestMutexSem(rexx, -1);
    }

    public Rexx SysRequestMutexSem(Rexx rexx, int n) {
        int n2 = 0;
        Hashtable hashtable = null;
        Semaphore semaphore = null;
        try {
            int n3 = this.semMutexVector.size() - 1;
            for (n2 = 0; n2 <= n3; ++n2) {
                hashtable = (Hashtable)this.semMutexVector.get(n2);
                if (hashtable.get("handle") != rexx) continue;
                semaphore = (Semaphore)hashtable.get("sem");
                if (n == -1) {
                    semaphore.acquire(1);
                    return new Rexx(0);
                }
                if (semaphore.tryAcquire(1, n, TimeUnit.MILLISECONDS)) {
                    return new Rexx(0);
                }
                return new Rexx(2);
            }
            return new Rexx(1);
        }
        catch (InterruptedException interruptedException) {
            return new Rexx(3);
        }
    }

    public Rexx SysReleaseMutexSem(Rexx rexx) {
        int n = 0;
        Hashtable hashtable = null;
        Semaphore semaphore = null;
        int n2 = this.semMutexVector.size() - 1;
        for (n = 0; n <= n2; ++n) {
            hashtable = (Hashtable)this.semMutexVector.get(n);
            if (hashtable.get("handle") != rexx) continue;
            semaphore = (Semaphore)hashtable.get("sem");
            semaphore.release(1);
            return new Rexx(0);
        }
        return new Rexx(1);
    }

    public Rexx SysCreateEventSem() {
        return this.SysCreateEventSem("");
    }

    public Rexx SysCreateEventSem(String string) {
        CountDownLatch countDownLatch = null;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String string2 = "";
        try {
            Thread.currentThread();
            Thread.sleep(1L);
            if (string.equals("")) {
                string = String.valueOf(System.currentTimeMillis());
            }
            countDownLatch = new CountDownLatch(1);
            string2 = String.valueOf(System.currentTimeMillis());
            hashtable.put("name", string);
            hashtable.put("sem", countDownLatch);
            hashtable.put("handle", string2);
            this.semEventVector.add(hashtable);
            return Rexx.toRexx(string2);
        }
        catch (InterruptedException interruptedException) {
            return new Rexx(0);
        }
    }

    public Rexx SysOpenEventSem(Rexx rexx) {
        Hashtable hashtable = null;
        int n = 0;
        int n2 = this.semEventVector.size() - 1;
        for (n = 0; n <= n2; ++n) {
            hashtable = (Hashtable)this.semEventVector.get(n);
            if (!((Rexx)hashtable.get("name")).OpEqS(null, rexx)) continue;
            return (Rexx)hashtable.get("handle");
        }
        return new Rexx(0);
    }

    public Rexx SysCloseEventSem(Rexx rexx) {
        Hashtable hashtable = null;
        int n = 0;
        CountDownLatch countDownLatch = null;
        int n2 = this.semEventVector.size() - 1;
        for (n = 0; n <= n2; ++n) {
            hashtable = (Hashtable)this.semEventVector.get(n);
            if (hashtable.get("handle") != rexx) continue;
            countDownLatch = (CountDownLatch)hashtable.get("sem");
            countDownLatch.countDown();
            this.semEventVector.remove(hashtable);
            return new Rexx(0);
        }
        return new Rexx(1);
    }

    public Rexx SysRequestEventSem(Rexx rexx) {
        return this.SysRequestEventSem(rexx, -1);
    }

    public Rexx SysRequestEventSem(Rexx rexx, int n) {
        int n2 = 0;
        Hashtable hashtable = null;
        CountDownLatch countDownLatch = null;
        try {
            int n3 = this.semEventVector.size() - 1;
            for (n2 = 0; n2 <= n3; ++n2) {
                hashtable = (Hashtable)this.semEventVector.get(n2);
                if (hashtable.get("handle") != rexx) continue;
                countDownLatch = (CountDownLatch)hashtable.get("sem");
                if (n == -1) {
                    countDownLatch.await();
                    return new Rexx(0);
                }
                if (countDownLatch.await(n, TimeUnit.MILLISECONDS)) {
                    return new Rexx(0);
                }
                return new Rexx(2);
            }
            return new Rexx(1);
        }
        catch (InterruptedException interruptedException) {
            return new Rexx(3);
        }
    }

    public Rexx SysReleaseEventSem(Rexx rexx) {
        int n = 0;
        Hashtable hashtable = null;
        CountDownLatch countDownLatch = null;
        int n2 = this.semEventVector.size() - 1;
        for (n = 0; n <= n2; ++n) {
            hashtable = (Hashtable)this.semEventVector.get(n);
            if (hashtable.get("handle") != rexx) continue;
            countDownLatch = (CountDownLatch)hashtable.get("sem");
            countDownLatch.countDown();
            countDownLatch = new CountDownLatch(1);
            hashtable.put("sem", countDownLatch);
            return new Rexx(0);
        }
        return new Rexx(1);
    }
}

