/*
 * Decompiled with CFR 0.152.
 */
package netrexx.lang;

import java.io.Serializable;
import netrexx.lang.BadArgumentException;
import netrexx.lang.ExponentOverflowException;
import netrexx.lang.Rexx;
import netrexx.lang.RexxSet;
import netrexx.lang.RexxWords;

public final class RexxUtil
extends Rexx
implements Serializable {
    private static final Rexx $01 = Rexx.toRexx("Too big");
    private static final String $0 = "RexxUtil.nrx";
    private static final long serialVersionUID = -5010053587776693628L;
    private static final Rexx zero = new Rexx(0);
    private static final Rexx one = new Rexx(1);
    private static final Rexx sixteen = new Rexx(16);

    public static final char[] translate(char[] cArray, char[] cArray2, char[] cArray3, char c) {
        int n = 0;
        char c2 = '\u0000';
        char c3 = '\u0000';
        if (cArray3.length == 0) {
            return cArray;
        }
        int n2 = -1;
        int n3 = cArray3.length - 1;
        for (n = 0; n <= n3; ++n) {
            if (cArray3[n] <= n2) continue;
            n2 = cArray3[n];
        }
        char[] cArray4 = new char[n2 + 1];
        n3 = n2;
        for (n = 0; n <= n3; ++n) {
            cArray4[n] = (char)n;
        }
        for (n = cArray3.length - 1; n >= 0; --n) {
            c2 = n < cArray2.length ? cArray2[n] : c;
            cArray4[cArray3[n]] = c2;
        }
        char[] cArray5 = new char[cArray.length];
        n3 = cArray.length - 1;
        for (n = 0; n <= n3; ++n) {
            c3 = cArray[n];
            cArray5[n] = c3 > n2 ? (char)c3 : cArray4[c3];
        }
        return cArray5;
    }

    public static final char[] d2x(Rexx rexx, int n) {
        RexxSet rexxSet = null;
        Rexx rexx2 = null;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        char[] cArray = null;
        if (rexx.ind == -2) {
            throw new NumberFormatException(Rexx.toString(rexx));
        }
        rexxSet = rexx.mant.length > 9 ? new RexxSet(rexx.mant.length) : (RexxSet)null;
        if (rexx.ind == -1) {
            if (n < 0) {
                throw new BadArgumentException(Rexx.toString(rexx));
            }
            rexx2 = rexx.OpMinus(rexxSet).OpSub(rexxSet, one);
            bl = true;
            n2 = 70;
        } else {
            rexx2 = rexx;
            bl = false;
            n2 = 48;
        }
        n3 = n < 0 ? rexx2.mant.length : n;
        char[] cArray2 = new char[n3];
        for (n4 = cArray2.length - 1; n4 >= 0; --n4) {
            n5 = rexx2.OpRem(rexxSet, sixteen).toint();
            rexx2 = rexx2.OpDivI(rexxSet, sixteen);
            cArray2[n4] = bl ? Rexx.Hexes[15 - n5] : Rexx.Hexes[n5];
            if (rexx2.ind != 0) continue;
            if (n >= 0) {
                for (n6 = n4 - 1; n6 >= 0; --n6) {
                    cArray2[n6] = n2;
                }
                break;
            }
            if (n4 == 0) {
                return cArray2;
            }
            n7 = cArray2.length - n4;
            cArray = new char[n7];
            System.arraycopy(cArray2, n4, cArray, 0, n7);
            return cArray;
        }
        return cArray2;
    }

    public static final char[] x2b(Rexx rexx) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        char[] cArray = new char[rexx.chars.length * 4];
        int n4 = rexx.chars.length;
        n = 0;
        while (n4 > 0) {
            n2 = RexxUtil.hexint(rexx.chars[n]);
            if (n2 < 0) {
                throw new BadArgumentException(Rexx.toString(Rexx.toRexx("Bad hexadecimal").OpCcblank(null, rexx)));
            }
            n3 = n * 4;
            cArray[n3] = n2 > 7 ? 49 : 48;
            cArray[n3 + 1] = (n2 & 4) != 0 ? 49 : 48;
            cArray[n3 + 2] = (n2 & 2) != 0 ? 49 : 48;
            cArray[n3 + 3] = (n2 & 1) != 0 ? 49 : 48;
            --n4;
            ++n;
        }
        return cArray;
    }

    public static final char x2c(Rexx rexx) {
        int n = 0;
        int n2 = 0;
        int n3 = rexx.chars.length - 2;
        for (n = 0; n <= n3 && rexx.chars[n] == '0'; ++n) {
        }
        int n4 = 0;
        n3 = rexx.chars.length - 1;
        while (n <= n3) {
            n2 = RexxUtil.hexint(rexx.chars[n]);
            if (n2 < 0) {
                throw new BadArgumentException(Rexx.toString(Rexx.toRexx("Bad hexadecimal").OpCcblank(null, rexx)));
            }
            if ((n4 = n4 * 16 + n2) > 65535) {
                throw new BadArgumentException(Rexx.toString($01.OpCcblank(null, rexx)));
            }
            ++n;
        }
        return (char)n4;
    }

    public static final char[] x2d(Rexx rexx, int n) {
        int n2 = 0;
        RexxSet rexxSet = null;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        if (n == 0 | rexx.chars.length == 0) {
            return "0".toCharArray();
        }
        if (n < 0) {
            n2 = 0;
        } else if (n > rexx.chars.length) {
            n2 = 0;
        } else {
            n2 = rexx.chars.length - n;
            if (rexx.chars[n2] > '7' | rexx.chars[n2] < '0') {
                bl = true;
            }
        }
        int n5 = rexx.chars.length * 5 / 4 + 1;
        rexxSet = n5 > 9 ? new RexxSet(n5) : (RexxSet)null;
        Rexx rexx2 = new Rexx(0);
        int n6 = rexx.chars.length - 1;
        for (n3 = n2; n3 <= n6; ++n3) {
            n4 = RexxUtil.hexint(rexx.chars[n3]);
            if (n4 < 0) {
                throw new BadArgumentException(Rexx.toString(Rexx.toRexx("Bad hexadecimal").OpCcblank(null, rexx)));
            }
            if (bl) {
                n4 = 15 - n4;
            }
            rexx2 = rexx2.OpMult(rexxSet, sixteen).OpAdd(rexxSet, new Rexx(n4));
        }
        if (bl) {
            rexx2 = rexx2.OpAdd(rexxSet, one).OpMinus(rexxSet);
        }
        return Rexx.tochararray(rexx2);
    }

    public static final double doublePow(double d, int n) {
        boolean bl = false;
        int n2 = 0;
        if (n == 0) {
            return 1.0;
        }
        if (n > 0) {
            bl = false;
        } else {
            n = -n;
            bl = true;
        }
        double d2 = 1.0;
        n2 = 1;
        while (true) {
            if ((n += n) < 0) {
                d2 *= d;
            }
            if (n2 == 31) break;
            d2 *= d2;
            ++n2;
        }
        if (Double.isInfinite(d2)) {
            throw new NumberFormatException("Overflow");
        }
        if (bl) {
            return 1.0 / d2;
        }
        return d2;
    }

    public static final float floatPow(double d, int n) {
        float f = (float)RexxUtil.doublePow(d, n);
        if (Float.isInfinite(f)) {
            throw new NumberFormatException("Overflow");
        }
        return f;
    }

    public static final Rexx doubleToRexx(double d, int n) {
        boolean bl = false;
        Rexx rexx = null;
        long l2 = Double.doubleToLongBits(d);
        if (l2 >= 0L) {
            bl = false;
        } else {
            bl = true;
            l2 &= Long.MAX_VALUE;
        }
        if (l2 == 0L) {
            return new Rexx(0);
        }
        long l3 = l2 % 0x10000000000000L;
        long l4 = l3 | 0x10000000000000L;
        long l5 = l2 / 0x10000000000000L;
        if (l5 == 2047L) {
            if (l3 == 0L) {
                return Rexx.toRexx("Infinity");
            }
            return Rexx.toRexx("NaN");
        }
        RexxSet rexxSet = new RexxSet(n + 2);
        Rexx rexx2 = new Rexx(l4).OpDiv(rexxSet, new Rexx("4503599627370496"));
        if (l5 != 0L) {
            rexx = new Rexx(2).OpPow(rexxSet, new Rexx(l5 - 1023L));
            rexx2 = rexx2.OpMult(rexxSet, rexx);
        }
        rexxSet.digits = n;
        if (bl && rexx2.ind == 1) {
            rexx2.ind = (byte)-1;
        }
        return rexx2.OpDiv(rexxSet, one);
    }

    public static final char[] trunc(Rexx rexx, int n) {
        RexxSet rexxSet = null;
        char[] cArray = null;
        int n2 = 0;
        rexxSet = rexx.mant.length > 9 ? new RexxSet(rexx.mant.length) : (RexxSet)null;
        rexx = rexx.OpPlus(rexxSet);
        int n3 = rexx.mant.length + n;
        if (rexx.exp > 0) {
            n3 += rexx.exp;
        }
        rexxSet = n3 > 9 ? new RexxSet(n3) : (RexxSet)null;
        rexx.exp += n;
        rexx = rexx.OpDivI(rexxSet, one);
        if (rexx.ind == 0) {
            rexx.exp = n;
        }
        if (rexx.exp > 0) {
            cArray = new char[rexx.mant.length + rexx.exp];
            System.arraycopy(rexx.mant, 0, cArray, 0, rexx.mant.length);
            int n4 = cArray.length - 1;
            for (n2 = rexx.mant.length; n2 <= n4; ++n2) {
                cArray[n2] = 48;
            }
            rexx.mant = cArray;
            rexx.exp = 0;
        }
        rexx.exp -= n;
        return rexx.layoutnum();
    }

    public static final char[] format(Rexx rexx, int n, int n2, int n3, int n4, char c) {
        RexxSet rexxSet = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        char[] cArray = null;
        int n8 = 0;
        int n9 = 0;
        boolean bl = false;
        Rexx rexx2 = null;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        rexxSet = rexx.mant.length > 9 ? new RexxSet(rexx.mant.length) : (RexxSet)null;
        rexx = rexx.OpPlus(rexxSet);
        if (n4 == -1) {
            c = (char)80;
        } else if (rexx.ind == 0) {
            c = (char)80;
        } else {
            n5 = rexx.exp + rexx.mant.length;
            if (n5 <= n4 && n5 >= -5) {
                c = (char)80;
            }
        }
        if (n2 >= 0) {
            while (true) {
                if (c == 'P') {
                    n6 = -rexx.exp;
                } else if (c == 'S') {
                    n6 = rexx.mant.length - 1;
                } else {
                    n7 = (rexx.exp + rexx.mant.length - 1) % 3;
                    if (n7 < 0) {
                        n7 = 3 + n7;
                    }
                    n6 = ++n7 >= rexx.mant.length ? 0 : rexx.mant.length - n7;
                }
                if (n6 == n2) break;
                if (n6 < n2) {
                    cArray = new char[rexx.mant.length + n2 - n6];
                    System.arraycopy(rexx.mant, 0, cArray, 0, rexx.mant.length);
                    int n13 = cArray.length - 1;
                    for (n8 = rexx.mant.length; n8 <= n13; ++n8) {
                        cArray[n8] = 48;
                    }
                    rexx.mant = cArray;
                    rexx.exp -= n2 - n6;
                    if (rexx.exp >= -999999999) break;
                    throw new ExponentOverflowException();
                }
                n9 = rexx.mant.length - (n6 - n2);
                if (n9 < 0) {
                    rexx.mant = RexxUtil.zero.mant;
                    rexx.ind = RexxUtil.zero.ind;
                    rexx.exp = RexxUtil.zero.exp;
                    continue;
                }
                boolean bl2 = bl = rexx.mant[n9] >= '5';
                if (n9 == 0 && !bl) {
                    rexx.mant = RexxUtil.zero.mant;
                    rexx.ind = RexxUtil.zero.ind;
                    rexx.exp = RexxUtil.zero.exp;
                    continue;
                }
                cArray = new char[n9];
                System.arraycopy(rexx.mant, 0, cArray, 0, n9);
                rexx.mant = cArray;
                rexx.exp += n6 - n2;
                if (rexx.exp > 999999999) {
                    throw new ExponentOverflowException();
                }
                if (!bl) break;
                rexx2 = new Rexx(1);
                rexx2.ind = rexx.ind;
                rexx2.exp = rexx.exp;
                rexx = rexx.OpAdd(rexxSet, rexx2);
            }
        }
        rexx.form = c == 'S' ? (byte)0 : (c == 'E' ? (byte)1 : (byte)2);
        rexx.dig = n4 == -1 ? 0 : n4;
        char[] cArray2 = rexx.layoutnum();
        if (n > 0) {
            n10 = RexxWords.pos('.', cArray2, 1);
            n10 = n10 > 0 ? --n10 : (n4 == -1 ? cArray2.length : ((n10 = RexxWords.pos('E', cArray2, 1)) > 0 ? --n10 : cArray2.length));
            if (n10 > n) {
                throw new BadArgumentException(String.valueOf(n));
            }
            if (n10 < n) {
                cArray2 = new Rexx(cArray2, true).right(new Rexx(cArray2.length + n - n10)).toCharArray();
            }
        }
        if (n3 > 0) {
            n11 = RexxWords.pos('E', cArray2, 1);
            if (n11 == 0) {
                cArray2 = new Rexx(cArray2, true).left(new Rexx(cArray2.length + n3 + 2)).toCharArray();
            } else {
                n12 = cArray2.length - n11 - 1;
                if (n12 > n3) {
                    throw new BadArgumentException(String.valueOf(n3));
                }
                if (n12 < n3) {
                    cArray2 = new Rexx(cArray2, true).insert(Rexx.toRexx(""), new Rexx(n11 + 1), new Rexx(n3 - n12), new Rexx('0')).toCharArray();
                }
            }
        }
        return cArray2;
    }

    private static int hexint(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return -1;
    }

    private RexxUtil() {
    }
}

