/*
 * Decompiled with CFR 0.152.
 */
package japa.parser.ast.expr;

import japa.parser.ast.expr.Expression;
import japa.parser.ast.visitor.GenericVisitor;
import japa.parser.ast.visitor.VoidVisitor;

public final class BinaryExpr
extends Expression {
    private Expression left;
    private Expression right;
    private Operator op;

    public BinaryExpr() {
    }

    public BinaryExpr(Expression left, Expression right, Operator op) {
        this.left = left;
        this.right = right;
        this.op = op;
    }

    public BinaryExpr(int beginLine, int beginColumn, int endLine, int endColumn, Expression left, Expression right, Operator op) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.left = left;
        this.right = right;
        this.op = op;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Expression getLeft() {
        return this.left;
    }

    public Operator getOperator() {
        return this.op;
    }

    public Expression getRight() {
        return this.right;
    }

    public void setLeft(Expression left) {
        this.left = left;
    }

    public void setOperator(Operator op) {
        this.op = op;
    }

    public void setRight(Expression right) {
        this.right = right;
    }

    public static enum Operator {
        or,
        and,
        binOr,
        binAnd,
        xor,
        equals,
        notEquals,
        less,
        greater,
        lessEquals,
        greaterEquals,
        lShift,
        rSignedShift,
        rUnsignedShift,
        plus,
        minus,
        times,
        divide,
        remainder;

    }
}

