/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.charts;

import eu.hansolo.enzo.charts.SimplePieChart;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.PieChart;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class DemoSimplePieChart
extends Application {
    private static int noOfNodes = 0;
    private SimplePieChart chart;

    public void init() {
        this.chart = new SimplePieChart();
        this.chart.setData(new PieChart.Data("IE", 25.0), new PieChart.Data("Firefox", 45.0), new PieChart.Data("Chrome", 30.0));
        this.chart.setTitle("User");
    }

    public void start(Stage stage) throws Exception {
        StackPane pane = new StackPane();
        pane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        pane.getChildren().addAll((Object[])new Node[]{this.chart});
        Scene scene = new Scene((Parent)pane);
        stage.setTitle("Demo SimplePieChart");
        stage.setScene(scene);
        stage.show();
        DemoSimplePieChart.calcNoOfNodes((Node)scene.getRoot());
        System.out.println(noOfNodes + " Nodes in SceneGraph");
    }

    public void stop() {
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                DemoSimplePieChart.calcNoOfNodes(n);
            }
        }
    }
}

