/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.charts;

import eu.hansolo.enzo.charts.SimpleLineChart;
import eu.hansolo.enzo.common.Section;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Dimension2D;
import javafx.scene.chart.XYChart;

public class SimpleLineChartBuilder<B extends SimpleLineChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected SimpleLineChartBuilder() {
    }

    public static final SimpleLineChartBuilder create() {
        return new SimpleLineChartBuilder();
    }

    public final SimpleLineChartBuilder styleClass(String STYLE_CLASS) {
        this.properties.put("styleClass", (Property)new SimpleStringProperty(STYLE_CLASS));
        return this;
    }

    public final SimpleLineChartBuilder series(XYChart.Series Series2) {
        this.properties.put("series", (Property)new SimpleObjectProperty((Object)Series2));
        return this;
    }

    public final SimpleLineChartBuilder sectionRangeVisible(boolean SECTION_RANGE_VISIBLE) {
        this.properties.put("sectionRangeVisible", (Property)new SimpleBooleanProperty(SECTION_RANGE_VISIBLE));
        return this;
    }

    public final SimpleLineChartBuilder unit(String UNIT) {
        this.properties.put("unit", (Property)new SimpleStringProperty(UNIT));
        return this;
    }

    public final SimpleLineChartBuilder sections(Section ... SECTIONS) {
        this.properties.put("sectionsArray", (Property)new SimpleObjectProperty((Object)SECTIONS));
        return this;
    }

    public final SimpleLineChartBuilder sections(List<Section> SECTIONS) {
        this.properties.put("secionsList", (Property)new SimpleObjectProperty(SECTIONS));
        return this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final SimpleLineChart build() {
        SimpleLineChart CONTROL = new SimpleLineChart();
        for (String key : this.properties.keySet()) {
            Dimension2D dim;
            if ("prefSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("minSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("maxSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("prefWidth".equals(key)) {
                CONTROL.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                CONTROL.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minWidth".equals(key)) {
                CONTROL.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minHeight".equals(key)) {
                CONTROL.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxWidth".equals(key)) {
                CONTROL.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxHeight".equals(key)) {
                CONTROL.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleX".equals(key)) {
                CONTROL.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleY".equals(key)) {
                CONTROL.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                CONTROL.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutY".equals(key)) {
                CONTROL.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateX".equals(key)) {
                CONTROL.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateY".equals(key)) {
                CONTROL.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("styleClass".equals(key)) {
                CONTROL.getStyleClass().setAll((Object[])new String[]{"simple-line-chart", (String)((StringProperty)this.properties.get(key)).get()});
                continue;
            }
            if ("series".equals(key)) {
                CONTROL.setSeries((XYChart.Series)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sectionRangeVisible".equals(key)) {
                CONTROL.setSectionRangeVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sectionsArray".equals(key)) {
                CONTROL.setSections((Section[])((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"sectionsList".equals(key)) continue;
            CONTROL.setSections((List)((ObjectProperty)this.properties.get(key)).get());
        }
        return CONTROL;
    }
}

