/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.common;

import eu.hansolo.enzo.common.ConicalGradient;
import eu.hansolo.enzo.common.Util;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Shape;

public class AngleConicalGradient {
    private ConicalGradient gradient;

    public AngleConicalGradient(Map<Double, Color> ANGLE_STOP_MAP) {
        this(null, ANGLE_STOP_MAP);
    }

    public AngleConicalGradient(Point2D CENTER, Map<Double, Color> ANGLE_STOP_MAP) {
        this(CENTER, 0.0, ANGLE_STOP_MAP);
    }

    public AngleConicalGradient(Point2D CENTER, double OFFSET_ANGLE, Map<Double, Color> ANGLE_STOP_MAP) {
        double ANGLE_FACTOR = 0.002777777777777778;
        double offset = Util.clamp(0.0, 1.0, OFFSET_ANGLE % 360.0 * 0.002777777777777778);
        LinkedList<Stop> stops = new LinkedList<Stop>();
        for (Double fraction : ANGLE_STOP_MAP.keySet()) {
            stops.add(new Stop(Util.clamp(0.0, 1.0, fraction % 360.0 * 0.002777777777777778), ANGLE_STOP_MAP.get(fraction)));
        }
        this.gradient = new ConicalGradient(CENTER, offset, stops);
    }

    public void recalculateWithAngle(double ANGLE) {
        this.gradient.recalculateWithAngle(ANGLE);
    }

    public List<Stop> getStops() {
        return this.gradient.getStops();
    }

    public Point2D getCenter() {
        return this.gradient.getCenter();
    }

    public Image getImage(double WIDTH, double HEIGHT) {
        return this.gradient.getImage(WIDTH, HEIGHT);
    }

    public ImagePattern apply(Shape SHAPE) {
        return this.gradient.apply(SHAPE);
    }
}

