/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javafx.scene.paint.Color;
import javafx.scene.paint.Stop;

public class GradientLookup {
    private Map<Double, Stop> stops = new TreeMap<Double, Stop>();

    public GradientLookup() {
        this(new Stop[0]);
    }

    public GradientLookup(Stop ... STOPS) {
        Arrays.asList(STOPS).forEach(stop -> this.stops.put(stop.getOffset(), (Stop)stop));
        this.init();
    }

    private void init() {
        if (this.stops.isEmpty()) {
            return;
        }
        double minFraction = this.stops.keySet().stream().mapToDouble(offset -> offset).min().getAsDouble();
        double maxFraction = this.stops.keySet().stream().mapToDouble(offset -> offset).max().getAsDouble();
        if (Double.compare(minFraction, 0.0) > 0) {
            this.stops.put(0.0, new Stop(0.0, this.stops.get(minFraction).getColor()));
        }
        if (Double.compare(maxFraction, 1.0) < 0) {
            this.stops.put(1.0, new Stop(1.0, this.stops.get(maxFraction).getColor()));
        }
    }

    public Color getColorAt(double POSITION_OF_COLOR) {
        Color COLOR;
        double POSITION;
        if (this.stops.isEmpty()) {
            return Color.BLACK;
        }
        double d = POSITION_OF_COLOR < 0.0 ? 0.0 : (POSITION = POSITION_OF_COLOR > 1.0 ? 1.0 : POSITION_OF_COLOR);
        if (this.stops.size() == 1) {
            Map ONE_ENTRY = (Map)((Object)this.stops.entrySet().iterator().next());
            COLOR = this.stops.get(ONE_ENTRY.keySet().iterator().next()).getColor();
        } else {
            Stop lowerBound = this.stops.get(0.0);
            Stop upperBound = this.stops.get(1.0);
            for (Double fraction : this.stops.keySet()) {
                if (Double.compare(fraction, POSITION) < 0) {
                    lowerBound = this.stops.get(fraction);
                }
                if (Double.compare(fraction, POSITION) <= 0) continue;
                upperBound = this.stops.get(fraction);
                break;
            }
            COLOR = this.interpolateColor(lowerBound, upperBound, POSITION);
        }
        return COLOR;
    }

    public List<Stop> getStops() {
        return new ArrayList<Stop>(this.stops.values());
    }

    public void setStops(Stop ... STOPS) {
        this.setStops(Arrays.asList(STOPS));
    }

    public void setStops(List<Stop> STOPS) {
        this.stops.clear();
        STOPS.forEach(stop -> this.stops.put(stop.getOffset(), (Stop)stop));
        this.init();
    }

    private Color interpolateColor(Stop LOWER_BOUND, Stop UPPER_BOUND, double POSITION) {
        double POS = (POSITION - LOWER_BOUND.getOffset()) / (UPPER_BOUND.getOffset() - LOWER_BOUND.getOffset());
        double DELTA_RED = (UPPER_BOUND.getColor().getRed() - LOWER_BOUND.getColor().getRed()) * POS;
        double DELTA_GREEN = (UPPER_BOUND.getColor().getGreen() - LOWER_BOUND.getColor().getGreen()) * POS;
        double DELTA_BLUE = (UPPER_BOUND.getColor().getBlue() - LOWER_BOUND.getColor().getBlue()) * POS;
        double DELTA_OPACITY = (UPPER_BOUND.getColor().getOpacity() - LOWER_BOUND.getColor().getOpacity()) * POS;
        double red = LOWER_BOUND.getColor().getRed() + DELTA_RED;
        double green = LOWER_BOUND.getColor().getGreen() + DELTA_GREEN;
        double blue = LOWER_BOUND.getColor().getBlue() + DELTA_BLUE;
        double opacity = LOWER_BOUND.getColor().getOpacity() + DELTA_OPACITY;
        double d = red < 0.0 ? 0.0 : (red = red > 1.0 ? 1.0 : red);
        double d2 = green < 0.0 ? 0.0 : (green = green > 1.0 ? 1.0 : green);
        double d3 = blue < 0.0 ? 0.0 : (blue = blue > 1.0 ? 1.0 : blue);
        opacity = opacity < 0.0 ? 0.0 : (opacity > 1.0 ? 1.0 : opacity);
        return Color.color((double)red, (double)green, (double)blue, (double)opacity);
    }
}

