/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.common;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.layout.Region;

public class Marker
extends Region {
    private double _value;
    private DoubleProperty value;
    private String _text;
    private StringProperty text;
    private boolean exceeded;
    private ObjectProperty<EventHandler<MarkerEvent>> onMarkerExceeded = new ObjectPropertyBase<EventHandler<MarkerEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onMarkerExceeded";
        }
    };
    private ObjectProperty<EventHandler<MarkerEvent>> onMarkerUnderrun = new ObjectPropertyBase<EventHandler<MarkerEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onMarkerUnderrun";
        }
    };

    public Marker() {
        this(0.0, "Marker");
    }

    public Marker(double VALUE) {
        this(VALUE, "Marker");
    }

    public Marker(double VALUE, String TEXT) {
        this._value = VALUE;
        this._text = TEXT;
        this.exceeded = false;
    }

    public final double getValue() {
        return null == this.value ? this._value : this.value.get();
    }

    public final void setValue(double VALUE) {
        if (null == this.value) {
            this._value = VALUE;
        } else {
            this.value.set(VALUE);
        }
    }

    public final DoubleProperty valueProperty() {
        if (null == this.value) {
            this.value = new SimpleDoubleProperty((Object)this, "value", this._value);
        }
        return this.value;
    }

    public final String getText() {
        return null == this.text ? this._text : (String)this.text.get();
    }

    public final void setText(String TEXT) {
        if (null == this.text) {
            this._text = TEXT;
        } else {
            this.text.set((Object)TEXT);
        }
    }

    public final StringProperty textProperty() {
        if (null == this.text) {
            this.text = new SimpleStringProperty((Object)this, "text", this._text);
        }
        return this.text;
    }

    public final boolean isExceeded() {
        return this.exceeded;
    }

    public final void setExceeded(boolean EXCEEDED) {
        this.exceeded = EXCEEDED;
    }

    public final ObjectProperty<EventHandler<MarkerEvent>> onMarkerExceededProperty() {
        return this.onMarkerExceeded;
    }

    public final void setOnMarkerExceeded(EventHandler<MarkerEvent> value) {
        this.onMarkerExceededProperty().set(value);
    }

    public final EventHandler<MarkerEvent> getOnMarkerExceeded() {
        return (EventHandler)this.onMarkerExceededProperty().get();
    }

    public final ObjectProperty<EventHandler<MarkerEvent>> onMarkerUnderrunProperty() {
        return this.onMarkerUnderrun;
    }

    public final void setOnMarkerUnderrun(EventHandler<MarkerEvent> value) {
        this.onMarkerUnderrunProperty().set(value);
    }

    public final EventHandler<MarkerEvent> getOnMarkerUnderrun() {
        return (EventHandler)this.onMarkerUnderrunProperty().get();
    }

    public void fireMarkerEvent(MarkerEvent EVENT) {
        EventType TYPE = EVENT.getEventType();
        Object HANDLER = MarkerEvent.MARKER_EXCEEDED == TYPE ? this.getOnMarkerExceeded() : (MarkerEvent.MARKER_UNDERRUN == TYPE ? this.getOnMarkerUnderrun() : null);
        if (null == HANDLER) {
            return;
        }
        HANDLER.handle((Event)EVENT);
    }

    public boolean equals(Marker MARKER) {
        return Double.compare(MARKER.getValue(), this.getValue()) == 0 && MARKER.getText().equals(this.getText());
    }

    public String toString() {
        StringBuilder NAME = new StringBuilder();
        NAME.append("Marker: ").append("\n");
        NAME.append("text   : ").append((String)this.text.get()).append("\n");
        NAME.append("value  : ").append(this.value.get()).append("\n");
        return NAME.toString();
    }

    public static class MarkerEvent
    extends Event {
        public static final EventType<MarkerEvent> MARKER_EXCEEDED = new EventType(ANY, "markerExceeded");
        public static final EventType<MarkerEvent> MARKER_UNDERRUN = new EventType(ANY, "markerUnderrun");

        public MarkerEvent(Object SOURCE, EventTarget TARGET, EventType<MarkerEvent> TYPE) {
            super(SOURCE, TARGET, TYPE);
        }
    }
}

